/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.scene;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.model.IntAnimationController;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.gltf.scene3d.animation.AnimationControllerHack;
import gaiasky.util.gdx.model.gltf.scene3d.animation.AnimationsPlayer;
import gaiasky.util.gdx.model.gltf.scene3d.lights.DirectionalLightEx;
import gaiasky.util.gdx.model.gltf.scene3d.lights.PointLightEx;
import gaiasky.util.gdx.model.gltf.scene3d.lights.SpotLightEx;
import gaiasky.util.gdx.model.gltf.scene3d.model.ModelInstanceHack;
import gaiasky.util.gdx.model.gltf.scene3d.scene.SceneModel;
import gaiasky.util.gdx.model.gltf.scene3d.scene.Updatable;

public class Scene
implements IntRenderableProvider,
Updatable {
    public IntModelInstance modelInstance;
    public IntAnimationController animationController;
    public final ObjectMap<IntNode, BaseLight> lights = new ObjectMap();
    public final ObjectMap<IntNode, Camera> cameras = new ObjectMap();
    public final AnimationsPlayer animations;
    private static final Matrix4 transform = new Matrix4();

    public Scene(SceneModel sceneModel) {
        this((IntModelInstance)new ModelInstanceHack(sceneModel.model), sceneModel);
    }

    public Scene(SceneModel sceneModel, String ... rootNodeIds) {
        this((IntModelInstance)new ModelInstanceHack(sceneModel.model, rootNodeIds), sceneModel);
    }

    private Scene(IntModelInstance modelInstance, SceneModel sceneModel) {
        this(modelInstance);
        IntNode node;
        for (ObjectMap.Entry entry : sceneModel.cameras) {
            node = modelInstance.getNode(((IntNode)entry.key).id, true);
            if (node == null) continue;
            this.cameras.put((Object)node, (Object)this.createCamera((Camera)entry.value));
        }
        for (ObjectMap.Entry entry : sceneModel.lights) {
            node = modelInstance.getNode(((IntNode)entry.key).id, true);
            if (node == null) continue;
            this.lights.put((Object)node, (Object)this.createLight((BaseLight)entry.value));
        }
        this.syncCameras();
        this.syncLights();
    }

    public Camera createCamera(Camera from) {
        PerspectiveCamera copy;
        if (from instanceof PerspectiveCamera) {
            PerspectiveCamera camera = new PerspectiveCamera();
            camera.fieldOfView = ((PerspectiveCamera)from).fieldOfView;
            copy = camera;
        } else if (from instanceof OrthographicCamera) {
            OrthographicCamera camera = new OrthographicCamera();
            camera.zoom = ((OrthographicCamera)from).zoom;
            copy = camera;
        } else {
            throw new GdxRuntimeException("unknown camera type " + from.getClass().getName());
        }
        copy.position.set(from.position);
        copy.direction.set(from.direction);
        copy.up.set(from.up);
        copy.near = from.near;
        copy.far = from.far;
        copy.viewportWidth = from.viewportWidth;
        copy.viewportHeight = from.viewportHeight;
        return copy;
    }

    protected BaseLight createLight(BaseLight from) {
        if (from instanceof DirectionalLight) {
            return new DirectionalLightEx().set((DirectionalLight)from);
        }
        if (from instanceof PointLight) {
            return new PointLightEx().set((PointLight)from);
        }
        if (from instanceof SpotLight) {
            return new SpotLightEx().set((SpotLight)from);
        }
        throw new GdxRuntimeException("unknown light type " + from.getClass().getName());
    }

    public Scene(IntModel model) {
        this(new ModelInstanceHack(model));
    }

    public Scene(IntModelInstance modelInstance) {
        this(modelInstance, modelInstance.animations.size > 0);
    }

    public Scene(IntModelInstance modelInstance, boolean animated) {
        this.modelInstance = modelInstance;
        if (animated) {
            this.animationController = new AnimationControllerHack(modelInstance);
        }
        this.animations = new AnimationsPlayer(this);
    }

    public Scene(IntModel model, boolean animated) {
        this((IntModelInstance)new ModelInstanceHack(model), animated);
    }

    @Override
    public void update(Camera camera, float delta) {
        this.animations.update(delta);
        this.syncCameras();
        this.syncLights();
    }

    private void syncCameras() {
        for (ObjectMap.Entry e : this.cameras) {
            IntNode node = (IntNode)e.key;
            Camera camera = (Camera)e.value;
            transform.set(this.modelInstance.transform).mul(node.globalTransform);
            camera.position.setZero().mul(transform);
            camera.direction.set(0.0f, 0.0f, -1.0f).rot(transform);
            camera.up.set(Vector3.Y).rot(transform);
            camera.update();
        }
    }

    private void syncLights() {
        for (ObjectMap.Entry e : this.lights) {
            IntNode node = (IntNode)e.key;
            BaseLight light = (BaseLight)e.value;
            transform.set(this.modelInstance.transform).mul(node.globalTransform);
            if (light instanceof DirectionalLight) {
                ((DirectionalLight)light).direction.set(0.0f, 0.0f, -1.0f).rot(transform);
                continue;
            }
            if (light instanceof PointLight) {
                ((PointLight)light).position.setZero().mul(transform);
                continue;
            }
            if (!(light instanceof SpotLight)) continue;
            ((SpotLight)light).position.setZero().mul(transform);
            ((SpotLight)light).direction.set(0.0f, 0.0f, -1.0f).rot(transform);
        }
    }

    public Camera getCamera(String name) {
        for (ObjectMap.Entry e : this.cameras) {
            if (!name.equals(((IntNode)e.key).id)) continue;
            return (Camera)e.value;
        }
        return null;
    }

    public BaseLight getLight(String name) {
        for (ObjectMap.Entry e : this.lights) {
            if (!name.equals(((IntNode)e.key).id)) continue;
            return (BaseLight)e.value;
        }
        return null;
    }

    public int getDirectionalLightCount() {
        int count = 0;
        for (ObjectMap.Entry entry : this.lights) {
            if (!(entry.value instanceof DirectionalLight)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void getRenderables(Array<IntRenderable> renderables, Pool<IntRenderable> pool) {
        this.modelInstance.getRenderables(renderables, pool);
    }
}

