/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.scene;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.IntRenderableSorter;
import gaiasky.util.gdx.model.gltf.scene3d.lights.DirectionalShadowLight;
import gaiasky.util.gdx.model.gltf.scene3d.lights.PointLightEx;
import gaiasky.util.gdx.model.gltf.scene3d.lights.SpotLightEx;
import gaiasky.util.gdx.model.gltf.scene3d.scene.CascadeShadowMap;
import gaiasky.util.gdx.model.gltf.scene3d.scene.MirrorSource;
import gaiasky.util.gdx.model.gltf.scene3d.scene.Scene;
import gaiasky.util.gdx.model.gltf.scene3d.scene.SceneRenderableSorter;
import gaiasky.util.gdx.model.gltf.scene3d.scene.SceneSkybox;
import gaiasky.util.gdx.model.gltf.scene3d.scene.TransmissionSource;
import gaiasky.util.gdx.model.gltf.scene3d.scene.Updatable;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRCommon;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRShaderProvider;
import gaiasky.util.gdx.model.gltf.scene3d.utils.EnvironmentCache;
import gaiasky.util.gdx.model.gltf.scene3d.utils.EnvironmentUtil;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.DirectionalLightsAttribute;
import gaiasky.util.gdx.shader.attribute.Matrix4Attribute;
import gaiasky.util.gdx.shader.attribute.PointLightsAttribute;
import gaiasky.util.gdx.shader.attribute.SpotLightsAttribute;
import gaiasky.util.gdx.shader.provider.DepthIntShaderProvider;
import gaiasky.util.gdx.shader.provider.IntShaderProvider;

public class SceneManager
implements Disposable {
    private final Array<IntRenderableProvider> renderableProviders = new Array();
    private IntModelBatch batch;
    private IntModelBatch depthBatch;
    private SceneSkybox skyBox;
    private TransmissionSource transmissionSource;
    private MirrorSource mirrorSource;
    private CascadeShadowMap cascadeShadowMap;
    public Environment environment = new Environment();
    protected final EnvironmentCache computedEnvironement = new EnvironmentCache();
    public Camera camera;
    private final IntRenderableSorter renderableSorter;
    private final PointLightsAttribute pointLights = new PointLightsAttribute();
    private final SpotLightsAttribute spotLights = new SpotLightsAttribute();

    public SceneManager() {
        this(24);
    }

    public SceneManager(int maxBones) {
        this(PBRShaderProvider.createDefault(maxBones), PBRShaderProvider.createDefaultDepth(maxBones));
    }

    public SceneManager(IntShaderProvider shaderProvider, DepthIntShaderProvider depthShaderProvider) {
        this(shaderProvider, depthShaderProvider, new SceneRenderableSorter());
    }

    public SceneManager(IntShaderProvider shaderProvider, DepthIntShaderProvider depthShaderProvider, IntRenderableSorter renderableSorter) {
        this.renderableSorter = renderableSorter;
        this.batch = new IntModelBatch(shaderProvider, renderableSorter);
        this.depthBatch = new IntModelBatch(depthShaderProvider);
        float lum = 1.0f;
        this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, lum, lum, lum, 1.0f));
    }

    public void setEnvironmentRotation(float azymuthAngleDegree) {
        Matrix4Attribute attribute = this.environment.get(Matrix4Attribute.class, Matrix4Attribute.EnvRotation);
        if (attribute != null) {
            attribute.set(azymuthAngleDegree);
        } else {
            this.environment.set((Attribute)Matrix4Attribute.createEnvRotation(azymuthAngleDegree));
        }
    }

    public void removeEnvironmentRotation() {
        this.environment.remove(Matrix4Attribute.EnvRotation);
    }

    public IntModelBatch getBatch() {
        return this.batch;
    }

    public void setBatch(IntModelBatch batch) {
        this.batch = batch;
    }

    public void setDepthBatch(IntModelBatch depthBatch) {
        this.depthBatch = depthBatch;
    }

    public IntModelBatch getDepthBatch() {
        return this.depthBatch;
    }

    public void setShaderProvider(IntShaderProvider shaderProvider) {
        this.batch.dispose();
        this.batch = new IntModelBatch(shaderProvider, this.renderableSorter);
    }

    public void setDepthShaderProvider(DepthIntShaderProvider depthShaderProvider) {
        this.depthBatch.dispose();
        this.depthBatch = new IntModelBatch(depthShaderProvider);
    }

    public void setTransmissionSource(TransmissionSource transmissionSource) {
        if (this.transmissionSource != transmissionSource) {
            if (this.transmissionSource != null) {
                this.transmissionSource.dispose();
            }
            this.transmissionSource = transmissionSource;
        }
    }

    public void setMirrorSource(MirrorSource mirrorSource) {
        if (this.mirrorSource != mirrorSource) {
            if (this.mirrorSource != null) {
                this.mirrorSource.dispose();
            }
            this.mirrorSource = mirrorSource;
        }
    }

    public void setCascadeShadowMap(CascadeShadowMap cascadeShadowMap) {
        if (this.cascadeShadowMap != cascadeShadowMap) {
            if (this.cascadeShadowMap != null) {
                this.cascadeShadowMap.dispose();
            }
            this.cascadeShadowMap = cascadeShadowMap;
        }
    }

    public void addScene(Scene scene) {
        this.addScene(scene, true);
    }

    public void addScene(Scene scene, boolean appendLights) {
        this.renderableProviders.add((Object)scene);
        if (appendLights) {
            for (ObjectMap.Entry e : scene.lights) {
                this.environment.add((BaseLight)e.value);
            }
        }
    }

    public void update(float delta) {
        if (this.camera != null) {
            this.updateEnvironment();
            for (IntRenderableProvider r : this.renderableProviders) {
                if (!(r instanceof Updatable)) continue;
                ((Updatable)((Object)r)).update(this.camera, delta);
            }
            if (this.skyBox != null) {
                this.skyBox.update(this.camera, delta);
            }
        }
    }

    protected void updateSkyboxRotation() {
        Matrix4Attribute rotationAttribute;
        if (this.skyBox != null && (rotationAttribute = this.environment.get(Matrix4Attribute.class, Matrix4Attribute.EnvRotation)) != null) {
            this.skyBox.setRotation(rotationAttribute.value);
        }
    }

    protected void updateEnvironment() {
        this.updateSkyboxRotation();
        this.computedEnvironement.setCache(this.environment);
        this.pointLights.lights.clear();
        this.spotLights.lights.clear();
        if (this.environment != null) {
            for (Attribute a : this.environment) {
                if (a instanceof PointLightsAttribute) {
                    this.pointLights.lights.addAll(((PointLightsAttribute)a).lights);
                    this.computedEnvironement.replaceCache(this.pointLights);
                    continue;
                }
                if (a instanceof SpotLightsAttribute) {
                    this.spotLights.lights.addAll(((SpotLightsAttribute)a).lights);
                    this.computedEnvironement.replaceCache(this.spotLights);
                    continue;
                }
                this.computedEnvironement.set(a);
            }
        }
        this.cullLights();
    }

    protected void cullLights() {
        SpotLightsAttribute sla;
        PointLightsAttribute pla = this.environment.get(PointLightsAttribute.class, PointLightsAttribute.Type);
        if (pla != null) {
            for (PointLight light : pla.lights) {
                if (!(light instanceof PointLightEx)) continue;
                PointLightEx l = (PointLightEx)light;
                if (l.range == null || this.camera.frustum.sphereInFrustum(l.position, l.range.floatValue())) continue;
                this.pointLights.lights.removeValue((Object)l, true);
            }
        }
        if ((sla = this.environment.get(SpotLightsAttribute.class, SpotLightsAttribute.Type)) != null) {
            for (SpotLight light : sla.lights) {
                if (!(light instanceof SpotLightEx)) continue;
                SpotLightEx l = (SpotLightEx)light;
                if (l.range == null || this.camera.frustum.sphereInFrustum(l.position, l.range.floatValue())) continue;
                this.spotLights.lights.removeValue((Object)l, true);
            }
        }
    }

    public void render() {
        if (this.camera == null) {
            return;
        }
        PBRCommon.enableSeamlessCubemaps();
        this.renderShadows();
        this.renderMirror();
        this.renderTransmission();
        this.renderColors();
    }

    public void renderMirror() {
        if (this.mirrorSource != null) {
            this.mirrorSource.begin(this.camera, this.computedEnvironement, this.skyBox);
            this.renderColors();
            this.mirrorSource.end();
        }
    }

    public void renderTransmission() {
        if (this.transmissionSource != null) {
            this.transmissionSource.begin(this.camera);
            this.transmissionSource.render((Iterable<IntRenderableProvider>)this.renderableProviders, this.environment);
            if (this.skyBox != null) {
                this.transmissionSource.render(this.skyBox);
            }
            this.transmissionSource.end();
            this.computedEnvironement.set((Attribute)this.transmissionSource.attribute);
        }
    }

    public void renderShadows() {
        DirectionalShadowLight shadowLight = this.getFirstDirectionalShadowLight();
        if (shadowLight != null) {
            shadowLight.begin();
            this.renderDepth(shadowLight.getCamera());
            shadowLight.end();
            this.environment.shadowMap = shadowLight;
        } else {
            this.environment.shadowMap = null;
        }
        this.computedEnvironement.shadowMap = this.environment.shadowMap;
        if (this.cascadeShadowMap != null) {
            for (DirectionalShadowLight light : this.cascadeShadowMap.lights) {
                light.begin();
                this.renderDepth(light.getCamera());
                light.end();
            }
            this.computedEnvironement.set((Attribute)this.cascadeShadowMap.attribute);
        }
    }

    public void renderDepth() {
        this.renderDepth(this.camera);
    }

    public void renderDepth(Camera camera) {
        this.depthBatch.begin(camera);
        this.depthBatch.render(this.renderableProviders);
        this.depthBatch.end();
    }

    public void renderColors() {
        this.batch.begin(this.camera);
        this.batch.render(this.renderableProviders, (Environment)this.computedEnvironement);
        if (this.skyBox != null) {
            this.batch.render(this.skyBox);
        }
        this.batch.end();
    }

    public DirectionalLight getFirstDirectionalLight() {
        DirectionalLightsAttribute dla = this.environment.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        if (dla != null) {
            for (DirectionalLight dl : dla.lights) {
                if (!(dl instanceof DirectionalLight)) continue;
                return dl;
            }
        }
        return null;
    }

    public DirectionalShadowLight getFirstDirectionalShadowLight() {
        DirectionalLightsAttribute dla = this.environment.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        if (dla != null) {
            for (DirectionalLight dl : dla.lights) {
                if (!(dl instanceof DirectionalShadowLight)) continue;
                return (DirectionalShadowLight)dl;
            }
        }
        return null;
    }

    public void setSkyBox(SceneSkybox skyBox) {
        this.skyBox = skyBox;
    }

    public SceneSkybox getSkyBox() {
        return this.skyBox;
    }

    public void setAmbientLight(float lum) {
        this.environment.get(ColorAttribute.class, (int)ColorAttribute.AmbientLight).color.set(lum, lum, lum, 1.0f);
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void removeScene(Scene scene) {
        this.renderableProviders.removeValue((Object)scene, true);
        for (ObjectMap.Entry e : scene.lights) {
            this.environment.remove((BaseLight)e.value);
        }
    }

    public Array<IntRenderableProvider> getRenderableProviders() {
        return this.renderableProviders;
    }

    public void updateViewport(float width, float height) {
        if (this.camera != null) {
            this.camera.viewportWidth = width;
            this.camera.viewportHeight = height;
            this.camera.update(true);
        }
    }

    public int getActiveLightsCount() {
        return EnvironmentUtil.getLightCount(this.computedEnvironement);
    }

    public int getTotalLightsCount() {
        return EnvironmentUtil.getLightCount(this.environment);
    }

    public void dispose() {
        this.batch.dispose();
        this.depthBatch.dispose();
        if (this.transmissionSource != null) {
            this.transmissionSource.dispose();
        }
        if (this.mirrorSource != null) {
            this.mirrorSource.dispose();
        }
        if (this.cascadeShadowMap != null) {
            this.cascadeShadowMap.dispose();
        }
    }
}

