/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.scene;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.OwnCubemap;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.gltf.scene3d.scene.Updatable;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRShader;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRShaderConfig;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.CubemapAttribute;
import gaiasky.util.gdx.shader.attribute.Matrix4Attribute;
import gaiasky.util.gdx.shader.provider.DefaultIntShaderProvider;
import gaiasky.util.gdx.shader.provider.IntShaderProvider;
import net.jafama.FastMath;

public class SceneSkybox
implements IntRenderableProvider,
Updatable,
Disposable {
    private IntShaderProvider shaderProvider;
    private boolean ownShaderProvider;
    private IntModel boxModel;
    private IntRenderable box;

    public SceneSkybox(OwnCubemap cubemap) {
        this(cubemap, null);
    }

    public SceneSkybox(OwnCubemap cubemap, PBRShaderConfig.SRGB manualSRGB, Float gammaCorrection) {
        this.createShaderProvider(manualSRGB, gammaCorrection);
    }

    public SceneSkybox(OwnCubemap cubemap, PBRShaderConfig.SRGB manualSRGB, boolean gammaCorrection) {
        this.createShaderProvider(manualSRGB, gammaCorrection ? Float.valueOf(2.2f) : null);
    }

    public SceneSkybox(OwnCubemap cubemap, IntShaderProvider shaderProvider) {
        if (shaderProvider == null) {
            this.createShaderProvider(PBRShaderConfig.SRGB.NONE, null);
        } else {
            this.shaderProvider = shaderProvider;
        }
    }

    private void createShaderProvider(PBRShaderConfig.SRGB manualSRGB, Float gammaCorrection) {
    }

    public SceneSkybox set(OwnCubemap cubemap) {
        this.box.environment.set((Attribute)new CubemapAttribute(CubemapAttribute.ReflectionCubemap, cubemap));
        return this;
    }

    public Color getColor() {
        return this.box.material.get(ColorAttribute.class, (int)ColorAttribute.Diffuse).color;
    }

    @Override
    public void update(Camera camera, float delta) {
        float s = camera.far * (float)FastMath.sqrt((double)2.0);
        this.box.worldTransform.setToScaling(s, s, s);
        this.box.worldTransform.setTranslation(camera.position);
    }

    @Override
    public void getRenderables(Array<IntRenderable> renderables, Pool<IntRenderable> pool) {
        this.box.shader = this.shaderProvider.getShader(this.box);
        renderables.add((Object)this.box);
    }

    public void dispose() {
        if (this.shaderProvider != null && this.ownShaderProvider) {
            this.shaderProvider.dispose();
        }
        this.boxModel.dispose();
    }

    public void setRotation(float azymuthAngleDegree) {
        Matrix4Attribute attribute = this.box.environment.get(Matrix4Attribute.class, Matrix4Attribute.EnvRotation);
        if (attribute != null) {
            attribute.set(azymuthAngleDegree);
        } else {
            this.box.environment.set((Attribute)Matrix4Attribute.createEnvRotation(azymuthAngleDegree));
        }
    }

    public void setRotation(Matrix4 envRotation) {
        Matrix4Attribute attribute = this.box.environment.get(Matrix4Attribute.class, Matrix4Attribute.EnvRotation);
        if (envRotation != null) {
            if (attribute != null) {
                attribute.value.set(envRotation);
            } else {
                this.box.environment.set((Attribute)Matrix4Attribute.createEnvRotation(envRotation));
            }
        } else if (attribute != null) {
            this.box.environment.remove(Matrix4Attribute.EnvRotation);
        }
    }

    private static class SkyboxShaderProvider
    extends DefaultIntShaderProvider {
        public SkyboxShaderProvider(DefaultIntShader.Config config) {
            super(config);
        }

        @Override
        protected IntShader createShader(IntRenderable renderable) {
            return new SkyboxShader(renderable, this.config);
        }
    }

    private static class SkyboxShader
    extends DefaultIntShader {
        public SkyboxShader(IntRenderable renderable, DefaultIntShader.Config config) {
            super(renderable, config, SkyboxShader.createPrefix(renderable, config) + SkyboxShader.createSkyBoxPrefix(renderable));
            this.register(PBRShader.envRotationUniform, PBRShader.envRotationSetter);
        }

        private static String createSkyBoxPrefix(IntRenderable renderable) {
            Object prefix = "";
            if (renderable.environment.has(Matrix4Attribute.EnvRotation)) {
                prefix = (String)prefix + "#define ENV_ROTATION\n";
            }
            return prefix;
        }
    }
}

