/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FlushablePool;
import com.badlogic.gdx.utils.Pool;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.IntRenderableSorter;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRFloatAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRTextureAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.scene.SceneRenderableSorter;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.provider.IntShaderProvider;

public class TransmissionSource
implements Disposable {
    private final IntModelBatch batch;
    private FrameBuffer fbo;
    private int width;
    private int height;
    private boolean hasTransmission;
    private Camera camera;
    public final PBRTextureAttribute attribute = new PBRTextureAttribute(PBRTextureAttribute.TransmissionSourceTexture);
    private final Array<IntRenderable> allRenderables = new Array();
    private final Array<IntRenderable> selectedRenderables = new Array();
    private final FlushablePool<IntRenderable> renderablePool = new FlushablePool<IntRenderable>(this){

        protected IntRenderable newObject() {
            return new IntRenderable();
        }

        public IntRenderable obtain() {
            IntRenderable renderable = (IntRenderable)super.obtain();
            renderable.environment = null;
            renderable.material = null;
            renderable.meshPart.set("", null, 0, 0, 0);
            renderable.shader = null;
            renderable.userData = null;
            return renderable;
        }
    };

    public TransmissionSource(IntShaderProvider shaderProvider) {
        this(shaderProvider, new SceneRenderableSorter());
    }

    public TransmissionSource(IntShaderProvider shaderProvider, IntRenderableSorter sorter) {
        this.batch = new IntModelBatch(shaderProvider, sorter);
        this.attribute.textureDescription.minFilter = Texture.TextureFilter.MipMap;
        this.attribute.textureDescription.magFilter = Texture.TextureFilter.Linear;
    }

    protected FrameBuffer createFrameBuffer(int width, int height) {
        return new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void begin(Camera camera) {
        this.camera = camera;
        this.ensureFrameBufferSize(this.width, this.height);
        this.hasTransmission = false;
    }

    private void ensureFrameBufferSize(int width, int height) {
        if (width <= 0) {
            width = Gdx.graphics.getBackBufferWidth();
        }
        if (height <= 0) {
            height = Gdx.graphics.getBackBufferHeight();
        }
        if (this.fbo == null || this.fbo.getWidth() != width || this.fbo.getHeight() != height) {
            if (this.fbo != null) {
                this.fbo.dispose();
            }
            this.fbo = this.createFrameBuffer(width, height);
        }
    }

    public void render(Iterable<IntRenderableProvider> providers, Environment environment) {
        for (IntRenderableProvider provider : providers) {
            this.render(provider, environment);
        }
    }

    public void render(IntRenderableProvider provider, Environment environment) {
        int start = this.allRenderables.size;
        provider.getRenderables(this.allRenderables, (Pool<IntRenderable>)this.renderablePool);
        for (int i = start; i < this.allRenderables.size; ++i) {
            IntRenderable renderable = (IntRenderable)this.allRenderables.get(i);
            if (!this.shouldBeRendered(renderable)) continue;
            renderable.environment = environment;
            this.selectedRenderables.add((Object)renderable);
        }
    }

    public void render(IntRenderableProvider provider) {
        int start = this.allRenderables.size;
        provider.getRenderables(this.allRenderables, (Pool<IntRenderable>)this.renderablePool);
        for (int i = start; i < this.allRenderables.size; ++i) {
            IntRenderable renderable = (IntRenderable)this.allRenderables.get(i);
            if (!this.shouldBeRendered(renderable)) continue;
            this.selectedRenderables.add((Object)renderable);
        }
    }

    public void end() {
        if (this.hasTransmission) {
            this.fbo.begin();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gdx.gl.glClear(16640);
            this.batch.begin(this.camera);
            for (IntRenderable renderable : this.selectedRenderables) {
                this.batch.render(renderable);
            }
            this.batch.end();
            this.fbo.end();
            Texture texture = (Texture)this.fbo.getColorBufferTexture();
            texture.bind();
            Gdx.gl.glGenerateMipmap(3553);
        }
        this.attribute.textureDescription.texture = this.fbo.getColorBufferTexture();
        this.renderablePool.flush();
        this.selectedRenderables.clear();
        this.allRenderables.clear();
    }

    private boolean shouldBeRendered(IntRenderable renderable) {
        boolean hasTransmission = renderable.material.has(PBRTextureAttribute.TransmissionTexture) || renderable.material.has(PBRFloatAttribute.TransmissionFactor) && renderable.material.get(PBRFloatAttribute.class, (int)PBRFloatAttribute.TransmissionFactor).value > 0.0f;
        this.hasTransmission |= hasTransmission;
        return !hasTransmission;
    }

    public void dispose() {
        if (this.fbo != null) {
            this.fbo.dispose();
        }
        this.batch.dispose();
    }
}

