/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.shaders;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.gdx.IntRenderable;
import java.nio.IntBuffer;

public class PBRCommon {
    public static final int MAX_MORPH_TARGETS = 8;
    private static final IntBuffer intBuffer = BufferUtils.newIntBuffer((int)16);
    private static Boolean seamlessCubemapsShouldBeEnabled = null;

    public static int getCapability(int pname) {
        intBuffer.clear();
        Gdx.gl.glGetIntegerv(pname, intBuffer);
        return intBuffer.get();
    }

    public static void checkVertexAttributes(IntRenderable renderable) {
        int maxVertexAttribs;
        int numVertexAttributes = renderable.meshPart.mesh.getVertexAttributes().size();
        if (numVertexAttributes > (maxVertexAttribs = PBRCommon.getCapability(34921))) {
            throw new GdxRuntimeException("too many vertex attributes : " + numVertexAttributes + " > " + maxVertexAttribs);
        }
    }

    public static void enableSeamlessCubemaps() {
        if (seamlessCubemapsShouldBeEnabled == null) {
            boolean seamlessCubemapsSupported;
            if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
                seamlessCubemapsSupported = Gdx.graphics.getGLVersion().isVersionEqualToOrHigher(3, 2) || Gdx.graphics.supportsExtension("GL_ARB_seamless_cube_map");
                seamlessCubemapsShouldBeEnabled = seamlessCubemapsSupported;
            } else {
                seamlessCubemapsSupported = Gdx.gl30 != null;
                seamlessCubemapsShouldBeEnabled = false;
            }
            if (!seamlessCubemapsSupported) {
                Gdx.app.error("PBR", "Warning seamless CubeMap is not supported by this platform and may cause filtering artifacts");
            }
        }
        if (seamlessCubemapsShouldBeEnabled.booleanValue()) {
            int GL_TEXTURE_CUBE_MAP_SEAMLESS = 34895;
            Gdx.gl.glEnable(34895);
        }
    }
}

