/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.shaders;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.model.gltf.scene3d.model.WeightVector;
import gaiasky.util.gdx.shader.DepthIntShader;
import gaiasky.util.gdx.shader.attribute.Attributes;

public class PBRDepthShader
extends DepthIntShader {
    public final long morphTargetsMask;
    private int u_morphTargets1;
    private int u_morphTargets2;

    public PBRDepthShader(IntRenderable renderable, DepthIntShader.Config config, String prefix) {
        super(renderable, config, prefix);
        this.morphTargetsMask = this.computeMorphTargetsMask(renderable);
    }

    protected long computeMorphTargetsMask(IntRenderable renderable) {
        int morphTargetsFlag = 0;
        VertexAttributes vertexAttributes = renderable.meshPart.mesh.getVertexAttributes();
        int n = vertexAttributes.size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = vertexAttributes.get(i);
            if (attr.usage != 512) continue;
            morphTargetsFlag |= 1 << attr.unit;
        }
        return morphTargetsFlag;
    }

    @Override
    public boolean canRender(IntRenderable renderable) {
        if (this.morphTargetsMask != this.computeMorphTargetsMask(renderable)) {
            return false;
        }
        return super.canRender(renderable);
    }

    @Override
    public void init() {
        super.init();
        this.u_morphTargets1 = this.program.fetchUniformLocation("u_morphTargets1", false);
        this.u_morphTargets2 = this.program.fetchUniformLocation("u_morphTargets2", false);
    }

    @Override
    public void render(IntRenderable renderable, Attributes combinedAttributes) {
        WeightVector weightVector;
        if (this.u_morphTargets1 >= 0) {
            if (renderable.userData instanceof WeightVector) {
                weightVector = (WeightVector)renderable.userData;
                this.program.setUniformf(this.u_morphTargets1, weightVector.get(0), weightVector.get(1), weightVector.get(2), weightVector.get(3));
            } else {
                this.program.setUniformf(this.u_morphTargets1, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        if (this.u_morphTargets2 >= 0) {
            if (renderable.userData instanceof WeightVector) {
                weightVector = (WeightVector)renderable.userData;
                this.program.setUniformf(this.u_morphTargets2, weightVector.get(4), weightVector.get(5), weightVector.get(6), weightVector.get(7));
            } else {
                this.program.setUniformf(this.u_morphTargets2, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        super.render(renderable, combinedAttributes);
    }
}

