/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.VertexAttribute;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRCommon;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRDepthShader;
import gaiasky.util.gdx.shader.DepthIntShader;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.provider.DepthIntShaderProvider;

public class PBRDepthShaderProvider
extends DepthIntShaderProvider {
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("net/mgsx/gltf/shaders/depth.vs.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("net/mgsx/gltf/shaders/depth.fs.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static DepthIntShader.Config createDefaultConfig() {
        DepthIntShader.Config config = new DepthIntShader.Config();
        config.vertexShaderCode = PBRDepthShaderProvider.getDefaultVertexShader();
        config.fragmentShaderCode = PBRDepthShaderProvider.getDefaultFragmentShader();
        return config;
    }

    public PBRDepthShaderProvider(DepthIntShader.Config config) {
        super(config == null ? new DepthIntShader.Config() : config);
        if (config.vertexShaderCode == null) {
            config.vertexShaderCode = PBRDepthShaderProvider.getDefaultVertexShader();
        }
        if (config.fragmentShaderCode == null) {
            config.fragmentShaderCode = PBRDepthShaderProvider.getDefaultFragmentShader();
        }
    }

    protected String morphTargetsPrefix(IntRenderable renderable) {
        Object prefix = "";
        for (VertexAttribute att : renderable.meshPart.mesh.getVertexAttributes()) {
            for (int i = 0; i < 8; ++i) {
                if (att.usage != 512 || att.unit != i) continue;
                prefix = (String)prefix + "#define position" + i + "Flag\n";
            }
        }
        return prefix;
    }

    @Override
    protected IntShader createShader(IntRenderable renderable) {
        PBRCommon.checkVertexAttributes(renderable);
        return new PBRDepthShader(renderable, this.config, DepthIntShader.createPrefix(renderable, this.config) + this.morphTargetsPrefix(renderable));
    }
}

