/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.shaders;

import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRColorAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRShader;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRShaderConfig;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRShaderProvider;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import net.jafama.FastMath;

public class PBREmissiveShaderProvider
extends PBRShaderProvider {
    public PBREmissiveShaderProvider(PBRShaderConfig config) {
        super(config);
    }

    @Override
    protected IntShader createShader(IntRenderable renderable) {
        PBRShaderConfig config = (PBRShaderConfig)this.config;
        boolean hasAlpha = renderable.material.has(BlendingAttribute.Type) || renderable.material.has(FloatAttribute.AlphaTest);
        Object prefix = this.createPrefixBase(renderable, config);
        prefix = (String)prefix + PBREmissiveShaderProvider.morphTargetsPrefix(renderable);
        prefix = (String)prefix + this.createPrefixSRGB(renderable, config);
        if (renderable.material.has(PBRColorAttribute.BaseColorFactor)) {
            prefix = (String)prefix + "#define baseColorFactorFlag\n";
        }
        int maxUVIndex = 0;
        TextureAttribute attribute = renderable.material.get(TextureAttribute.class, TextureAttribute.Emissive);
        if (attribute != null) {
            prefix = (String)prefix + "#define v_emissiveUV v_texCoord" + attribute.uvIndex + "\n";
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)attribute.uvIndex);
        }
        if (hasAlpha && (attribute = renderable.material.get(TextureAttribute.class, TextureAttribute.Diffuse)) != null) {
            prefix = (String)prefix + "#define v_diffuseUV v_texCoord" + attribute.uvIndex + "\n";
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)attribute.uvIndex);
        }
        if (maxUVIndex >= 0) {
            prefix = (String)prefix + "#define textureFlag\n";
        }
        if (maxUVIndex == 1) {
            prefix = (String)prefix + "#define textureCoord1Flag\n";
        } else if (maxUVIndex > 1) {
            throw new GdxRuntimeException("more than 2 texture coordinates attribute not supported");
        }
        PBRShader shader = new PBRShader(renderable, (DefaultIntShader.Config)config, (String)prefix);
        this.checkShaderCompilation(shader.program);
        if (!shader.canRender(renderable)) {
            throw new GdxRuntimeException("cannot render with this shader");
        }
        return shader;
    }

    public static PBRShaderConfig createConfig(int maxBones) {
        return null;
    }
}

