/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.shaders;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.OwnCubemap;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.CascadeShadowMapAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.ClippingPlaneAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.FogAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.MirrorSourceAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRColorAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRCubemapAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRFloatAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRHDRColorAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRIridescenceAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRTextureAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRVolumeAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.lights.DirectionalLightEx;
import gaiasky.util.gdx.model.gltf.scene3d.lights.DirectionalShadowLight;
import gaiasky.util.gdx.model.gltf.scene3d.model.WeightVector;
import gaiasky.util.gdx.shader.BaseIntShader;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.attribute.Attributes;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.DirectionalLightsAttribute;
import gaiasky.util.gdx.shader.attribute.Matrix4Attribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import net.jafama.FastMath;

public class PBRShader
extends DefaultIntShader {
    private static final Vector2 v2 = new Vector2();
    public static final BaseIntShader.Uniform baseColorTextureUniform = new BaseIntShader.Uniform("u_diffuseTexture", PBRTextureAttribute.BaseColorTexture);
    public static final BaseIntShader.Setter baseColorTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.BaseColorTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform baseColorFactorUniform = new BaseIntShader.Uniform("u_BaseColorFactor", PBRColorAttribute.BaseColorFactor);
    public static final BaseIntShader.Setter baseColorFactorSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            ColorAttribute attribute = combinedAttributes.get(ColorAttribute.class, PBRColorAttribute.BaseColorFactor);
            Color color = attribute == null ? Color.WHITE : attribute.color;
            shader.set(inputID, color);
        }
    };
    public static final BaseIntShader.Uniform emissiveTextureUniform = new BaseIntShader.Uniform("u_emissiveTexture", PBRTextureAttribute.EmissiveTexture);
    public static final BaseIntShader.Setter emissiveTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.EmissiveTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform normalTextureUniform = new BaseIntShader.Uniform("u_normalTexture", PBRTextureAttribute.NormalTexture);
    public static final BaseIntShader.Setter normalTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.NormalTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform metallicRoughnessTextureUniform = new BaseIntShader.Uniform("u_MetallicRoughnessSampler", PBRTextureAttribute.MetallicRoughnessTexture);
    public static final BaseIntShader.Setter metallicRoughnessTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.MetallicRoughnessTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform metallicRoughnessUniform = new BaseIntShader.Uniform("u_MetallicRoughnessValues");
    public static final BaseIntShader.Setter metallicRoughnessSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute metallicAttribute = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.Metallic);
            PBRFloatAttribute roughnessAttribute = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.Roughness);
            float metallic = metallicAttribute == null ? 1.0f : metallicAttribute.value;
            float roughness = roughnessAttribute == null ? 1.0f : roughnessAttribute.value;
            shader.set(inputID, v2.set(metallic, roughness));
        }
    };
    public static final BaseIntShader.Uniform normalScaleUniform = new BaseIntShader.Uniform("u_NormalScale");
    public static final BaseIntShader.Setter normalScaleSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute normalScaleAttribute = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.NormalScale);
            float normalScale = normalScaleAttribute == null ? 1.0f : normalScaleAttribute.value;
            shader.set(inputID, normalScale);
        }
    };
    public static final BaseIntShader.Uniform occlusionStrengthUniform = new BaseIntShader.Uniform("u_OcclusionStrength");
    public static final BaseIntShader.Setter occlusionStrengthSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute occlusionStrengthAttribute = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.OcclusionStrength);
            float occlusionStrength = occlusionStrengthAttribute == null ? 1.0f : occlusionStrengthAttribute.value;
            shader.set(inputID, occlusionStrength);
        }
    };
    public static final BaseIntShader.Uniform occlusionTextureUniform = new BaseIntShader.Uniform("u_OcclusionSampler", PBRTextureAttribute.OcclusionTexture);
    public static final BaseIntShader.Setter occlusionTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.OcclusionTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform diffuseEnvTextureUniform = new BaseIntShader.Uniform("u_DiffuseEnvSampler", PBRCubemapAttribute.DiffuseEnv);
    public static final BaseIntShader.Setter diffuseEnvTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRCubemapAttribute diffuseEnvAttribute = combinedAttributes.get(PBRCubemapAttribute.class, PBRCubemapAttribute.DiffuseEnv);
            int unit = shader.context.textureBinder.bind(diffuseEnvAttribute.textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform specularEnvTextureUniform = new BaseIntShader.Uniform("u_SpecularEnvSampler", PBRCubemapAttribute.SpecularEnv);
    public static final BaseIntShader.Setter specularEnvTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRCubemapAttribute specularEnvAttribute = combinedAttributes.get(PBRCubemapAttribute.class, PBRCubemapAttribute.SpecularEnv);
            int unit = shader.context.textureBinder.bind(specularEnvAttribute.textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform envRotationUniform = new BaseIntShader.Uniform("u_envRotation", Matrix4Attribute.EnvRotation);
    public static final BaseIntShader.Setter envRotationSetter = new BaseIntShader.LocalSetter(){
        private final Matrix3 mat3 = new Matrix3();

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            Matrix4Attribute attribute = combinedAttributes.get(Matrix4Attribute.class, Matrix4Attribute.EnvRotation);
            shader.set(inputID, this.mat3.set(attribute.value));
        }
    };
    public static final BaseIntShader.Uniform brdfLUTTextureUniform = new BaseIntShader.Uniform("u_brdfLUT");
    public static final BaseIntShader.Setter brdfLUTTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRTextureAttribute attribute = combinedAttributes.get(PBRTextureAttribute.class, PBRTextureAttribute.BRDFLUTTexture);
            if (attribute != null) {
                int unit = shader.context.textureBinder.bind(attribute.textureDescription);
                shader.set(inputID, unit);
            }
        }
    };
    public static final BaseIntShader.Uniform shadowBiasUniform = new BaseIntShader.Uniform("u_shadowBias");
    public static final BaseIntShader.Setter shadowBiasSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute attribute = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.ShadowBias);
            float value = attribute == null ? 0.0f : attribute.value;
            shader.set(inputID, value);
        }
    };
    public static final BaseIntShader.Uniform fogEquationUniform = new BaseIntShader.Uniform("u_fogEquation");
    public static final BaseIntShader.Setter fogEquationSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            FogAttribute attribute = combinedAttributes.get(FogAttribute.class, FogAttribute.FogEquation);
            Vector3 value = attribute == null ? Vector3.Zero : attribute.value;
            shader.set(inputID, value);
        }
    };
    public static final BaseIntShader.Setter emissiveScaledColor = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            ColorAttribute emissive = combinedAttributes.get(ColorAttribute.class, ColorAttribute.Emissive);
            PBRFloatAttribute emissiveIntensity = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.EmissiveIntensity);
            if (emissiveIntensity != null) {
                shader.set(inputID, emissive.color.r * emissiveIntensity.value, emissive.color.g * emissiveIntensity.value, emissive.color.b * emissiveIntensity.value, emissive.color.a * emissiveIntensity.value);
            } else {
                shader.set(inputID, emissive.color);
            }
        }
    };
    public static final BaseIntShader.Uniform transmissionFactorUniform = new BaseIntShader.Uniform("u_transmissionFactor");
    public static final BaseIntShader.Setter transmissionFactorSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute a = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.TransmissionFactor);
            float value = a == null ? 0.0f : a.value;
            shader.set(inputID, value);
        }
    };
    public static final BaseIntShader.Uniform transmissionTextureUniform = new BaseIntShader.Uniform("u_transmissionSampler", PBRTextureAttribute.TransmissionTexture);
    public static final BaseIntShader.Setter transmissionTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.TransmissionTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform iorUniform = new BaseIntShader.Uniform("u_ior");
    public static final BaseIntShader.Setter iorSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute a = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.IOR);
            shader.set(inputID, a.value);
        }
    };
    public static final BaseIntShader.Uniform thicknessFactorUniform = new BaseIntShader.Uniform("u_thicknessFactor");
    public static final BaseIntShader.Setter thicknessFactorSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRVolumeAttribute a = combinedAttributes.get(PBRVolumeAttribute.class, PBRVolumeAttribute.Type);
            shader.set(inputID, a.thicknessFactor);
        }
    };
    public static final BaseIntShader.Uniform volumeDistanceUniform = new BaseIntShader.Uniform("u_attenuationDistance");
    public static final BaseIntShader.Setter volumeDistanceSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRVolumeAttribute a = combinedAttributes.get(PBRVolumeAttribute.class, PBRVolumeAttribute.Type);
            shader.set(inputID, a.attenuationDistance);
        }
    };
    public static final BaseIntShader.Uniform volumeColorUniform = new BaseIntShader.Uniform("u_attenuationColor");
    public static final BaseIntShader.Setter volumeColorSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRVolumeAttribute a = combinedAttributes.get(PBRVolumeAttribute.class, PBRVolumeAttribute.Type);
            shader.set(inputID, a.attenuationColor.r, a.attenuationColor.g, a.attenuationColor.b);
        }
    };
    public static final BaseIntShader.Uniform thicknessTextureUniform = new BaseIntShader.Uniform("u_thicknessSampler", PBRTextureAttribute.ThicknessTexture);
    public static final BaseIntShader.Setter thicknessTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.ThicknessTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform specularFactorUniform = new BaseIntShader.Uniform("u_specularFactor");
    public static final BaseIntShader.Setter specularFactorSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute a = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.SpecularFactor);
            shader.set(inputID, a.value);
        }
    };
    public static final BaseIntShader.Uniform specularColorFactorUniform = new BaseIntShader.Uniform("u_specularColorFactor");
    public static final BaseIntShader.Setter specularColorFactorSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRHDRColorAttribute a = combinedAttributes.get(PBRHDRColorAttribute.class, PBRHDRColorAttribute.Specular);
            shader.set(inputID, a.r, a.g, a.b);
        }
    };
    public static final BaseIntShader.Uniform specularFactorTextureUniform = new BaseIntShader.Uniform("u_specularFactorSampler", PBRTextureAttribute.SpecularFactorTexture);
    public static final BaseIntShader.Setter specularFactorTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.SpecularFactorTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform specularColorTextureUniform = new BaseIntShader.Uniform("u_specularColorSampler", PBRTextureAttribute.Specular);
    public static final BaseIntShader.Setter specularColorTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.Specular)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform iridescenceFactorUniform = new BaseIntShader.Uniform("u_iridescenceFactor");
    public static final BaseIntShader.Setter iridescenceFactorSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRIridescenceAttribute a = combinedAttributes.get(PBRIridescenceAttribute.class, PBRIridescenceAttribute.Type);
            shader.set(inputID, a.factor);
        }
    };
    public static final BaseIntShader.Uniform iridescenceIORUniform = new BaseIntShader.Uniform("u_iridescenceIOR");
    public static final BaseIntShader.Setter iridescenceIORSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRIridescenceAttribute a = combinedAttributes.get(PBRIridescenceAttribute.class, PBRIridescenceAttribute.Type);
            shader.set(inputID, a.ior);
        }
    };
    public static final BaseIntShader.Uniform iridescenceThicknessMinUniform = new BaseIntShader.Uniform("u_iridescenceThicknessMin");
    public static final BaseIntShader.Setter iridescenceThicknessMinSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRIridescenceAttribute a = combinedAttributes.get(PBRIridescenceAttribute.class, PBRIridescenceAttribute.Type);
            shader.set(inputID, a.thicknessMin);
        }
    };
    public static final BaseIntShader.Uniform iridescenceThicknessMaxUniform = new BaseIntShader.Uniform("u_iridescenceThicknessMax");
    public static final BaseIntShader.Setter iridescenceThicknessMaxSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            PBRIridescenceAttribute a = combinedAttributes.get(PBRIridescenceAttribute.class, PBRIridescenceAttribute.Type);
            shader.set(inputID, a.thicknessMax);
        }
    };
    public static final BaseIntShader.Uniform iridescenceTextureUniform = new BaseIntShader.Uniform("u_iridescenceSampler", PBRTextureAttribute.IridescenceTexture);
    public static final BaseIntShader.Setter iridescenceTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.IridescenceTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform iridescenceThicknessTextureUniform = new BaseIntShader.Uniform("u_iridescenceThicknessSampler", PBRTextureAttribute.IridescenceThicknessTexture);
    public static final BaseIntShader.Setter iridescenceThicknessTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.IridescenceThicknessTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform transmissionSourceTextureUniform = new BaseIntShader.Uniform("u_transmissionSourceSampler", PBRTextureAttribute.TransmissionSourceTexture);
    public static final BaseIntShader.Setter transmissionSourceTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((int)PBRTextureAttribute.TransmissionSourceTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform transmissionSourceMipmapUniform = new BaseIntShader.Uniform("u_transmissionSourceMipmapScale");
    public static final BaseIntShader.Setter transmissionSourceMipmapSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            TextureAttribute a = combinedAttributes.get(PBRTextureAttribute.class, PBRTextureAttribute.TransmissionSourceTexture);
            float mipmapFactor = a != null ? (float)(Math.log(((Texture)a.textureDescription.texture).getWidth()) / FastMath.log((double)2.0)) : 1.0f;
            shader.set(inputID, mipmapFactor);
        }
    };
    public static final BaseIntShader.Uniform specularMirrorTextureUniform = new BaseIntShader.Uniform("u_mirrorSpecularSampler", MirrorSourceAttribute.Type);
    public static final BaseIntShader.Setter specularMirrorTextureSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((MirrorSourceAttribute)combinedAttributes.get((int)MirrorSourceAttribute.Type)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseIntShader.Uniform specularMirrorMipmapUniform = new BaseIntShader.Uniform("u_mirrorMipmapScale");
    public static final BaseIntShader.Setter specularMirrorMipmapSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            MirrorSourceAttribute a = combinedAttributes.get(MirrorSourceAttribute.class, MirrorSourceAttribute.Type);
            float mipmapFactor = a != null ? (float)(Math.log(((Texture)a.textureDescription.texture).getWidth()) / FastMath.log((double)2.0)) + 0.0f : 1.0f;
            shader.set(inputID, mipmapFactor);
        }
    };
    public static final BaseIntShader.Uniform mirrorNormal = new BaseIntShader.Uniform("u_mirrorNormal");
    public static final BaseIntShader.Setter mirrorNormalSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            MirrorSourceAttribute a = combinedAttributes.get(MirrorSourceAttribute.class, MirrorSourceAttribute.Type);
            shader.set(inputID, a.normal);
        }
    };
    public static final BaseIntShader.Uniform projViewTransUniform = new BaseIntShader.Uniform("u_projViewTrans");
    public static final BaseIntShader.Setter projViewTransSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            shader.set(inputID, shader.camera.combined);
        }
    };
    public static final BaseIntShader.Uniform viewportInvUniform = new BaseIntShader.Uniform("u_viewportInv");
    public static final BaseIntShader.Setter viewportInvSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            shader.set(inputID, 1.0f / shader.camera.viewportWidth, 1.0f / shader.camera.viewportHeight);
        }
    };
    public static final BaseIntShader.Uniform clippingPlaneUniform = new BaseIntShader.Uniform("u_clippingPlane");
    public static final BaseIntShader.Setter clippingPlaneSetter = new BaseIntShader.LocalSetter(){

        @Override
        public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
            ClippingPlaneAttribute a = combinedAttributes.get(ClippingPlaneAttribute.class, ClippingPlaneAttribute.Type);
            shader.set(inputID, a.plane.normal.x, a.plane.normal.y, a.plane.normal.z, a.plane.d);
        }
    };
    private static final PBRTextureAttribute[] transformTexture = new PBRTextureAttribute[]{null, null};
    public final int u_metallicRoughness;
    public final int u_occlusionStrength;
    public final int u_metallicRoughnessTexture;
    public final int u_occlusionTexture;
    public final int u_DiffuseEnvSampler;
    public final int u_SpecularEnvSampler;
    public final int u_envRotation;
    public final int u_brdfLUTTexture;
    public final int u_NormalScale;
    public final int u_BaseColorTexture;
    public final int u_NormalTexture;
    public final int u_EmissiveTexture;
    public final int u_BaseColorFactor;
    public final int u_FogEquation;
    public final int u_ShadowBias;
    private int u_morphTargets1;
    private int u_morphTargets2;
    private int u_mipmapScale;
    private int u_texCoord0Transform;
    private int u_texCoord1Transform;
    private int u_ambientLight;
    private long textureCoordinateMapMask;
    private long morphTargetsMask;
    private int vertexColorLayers;
    public int u_emissive;
    public int u_transmissionFactor;
    public int u_transmissionTexture;
    public int u_ior;
    public int u_thicknessTexture;
    public int u_thicknessFactor;
    public int u_volumeDistance;
    public int u_volumeColor;
    public int u_specularFactor;
    public int u_specularColorFactor;
    public int u_specularFactorTexture;
    public int u_specularColorTexture;
    public int u_iridescenceFactor;
    public int u_iridescenceIOR;
    public int u_iridescenceThicknessMin;
    public int u_iridescenceThicknessMax;
    public int u_iridescenceTexture;
    public int u_iridescenceThicknessTexture;
    public int u_transmissionSourceTexture;
    public int u_transmissionSourceMipmap;
    public int u_specularMirrorSampler;
    public int u_specularMirrorMipmapScale;
    public int u_specularMirrorNormal;
    public int u_viewportInv;
    public int u_clippingPlane;
    public int u_csmSamplers;
    public int u_csmPCFClip;
    public int u_csmTransforms;
    private static final Matrix3 textureTransform = new Matrix3();
    private static int[] allTextureTypes = new int[]{PBRTextureAttribute.BaseColorTexture, PBRTextureAttribute.EmissiveTexture, PBRTextureAttribute.NormalTexture, PBRTextureAttribute.MetallicRoughnessTexture, PBRTextureAttribute.OcclusionTexture, PBRTextureAttribute.TransmissionTexture, PBRTextureAttribute.ThicknessTexture, PBRTextureAttribute.IridescenceTexture, PBRTextureAttribute.IridescenceThicknessTexture};

    public PBRShader(IntRenderable renderable, DefaultIntShader.Config config, String prefix) {
        super(renderable, config, prefix);
        this.textureCoordinateMapMask = PBRShader.getTextureCoordinateMapMask(renderable.material);
        this.morphTargetsMask = this.computeMorphTargetsMask(renderable);
        this.vertexColorLayers = this.computeVertexColorLayers(renderable);
        this.u_BaseColorTexture = this.register(baseColorTextureUniform, baseColorTextureSetter);
        this.u_BaseColorFactor = this.register(baseColorFactorUniform, baseColorFactorSetter);
        this.u_EmissiveTexture = this.register(emissiveTextureUniform, emissiveTextureSetter);
        this.u_DiffuseEnvSampler = this.register(diffuseEnvTextureUniform, diffuseEnvTextureSetter);
        this.u_SpecularEnvSampler = this.register(specularEnvTextureUniform, specularEnvTextureSetter);
        this.u_envRotation = this.register(envRotationUniform, envRotationSetter);
        this.u_metallicRoughness = this.register(metallicRoughnessUniform, metallicRoughnessSetter);
        this.u_metallicRoughnessTexture = this.register(metallicRoughnessTextureUniform, metallicRoughnessTextureSetter);
        this.u_occlusionTexture = this.register(occlusionTextureUniform, occlusionTextureSetter);
        this.u_occlusionStrength = this.register(occlusionStrengthUniform, occlusionStrengthSetter);
        this.u_brdfLUTTexture = this.register(brdfLUTTextureUniform, brdfLUTTextureSetter);
        this.u_NormalTexture = this.register(normalTextureUniform, normalTextureSetter);
        this.u_NormalScale = this.register(normalScaleUniform, normalScaleSetter);
        this.u_ShadowBias = this.register(shadowBiasUniform, shadowBiasSetter);
        this.u_FogEquation = this.register(fogEquationUniform, fogEquationSetter);
        this.u_emissive = this.register(DefaultIntShader.Inputs.emissiveColor, emissiveScaledColor);
        this.u_transmissionFactor = this.register(transmissionFactorUniform, transmissionFactorSetter);
        this.u_transmissionTexture = this.register(transmissionTextureUniform, transmissionTextureSetter);
        this.u_ior = this.register(iorUniform, iorSetter);
        this.u_thicknessFactor = this.register(thicknessFactorUniform, thicknessFactorSetter);
        this.u_volumeDistance = this.register(volumeDistanceUniform, volumeDistanceSetter);
        this.u_volumeColor = this.register(volumeColorUniform, volumeColorSetter);
        this.u_thicknessTexture = this.register(thicknessTextureUniform, thicknessTextureSetter);
        this.u_transmissionSourceTexture = this.register(transmissionSourceTextureUniform, transmissionSourceTextureSetter);
        this.u_transmissionSourceMipmap = this.register(transmissionSourceMipmapUniform, transmissionSourceMipmapSetter);
        this.u_specularFactor = this.register(specularFactorUniform, specularFactorSetter);
        this.u_specularColorFactor = this.register(specularColorFactorUniform, specularColorFactorSetter);
        this.u_specularFactorTexture = this.register(specularFactorTextureUniform, specularFactorTextureSetter);
        this.u_specularColorTexture = this.register(specularColorTextureUniform, specularColorTextureSetter);
        this.u_iridescenceFactor = this.register(iridescenceFactorUniform, iridescenceFactorSetter);
        this.u_iridescenceIOR = this.register(iridescenceIORUniform, iridescenceIORSetter);
        this.u_iridescenceThicknessMin = this.register(iridescenceThicknessMinUniform, iridescenceThicknessMinSetter);
        this.u_iridescenceThicknessMax = this.register(iridescenceThicknessMaxUniform, iridescenceThicknessMaxSetter);
        this.u_iridescenceTexture = this.register(iridescenceTextureUniform, iridescenceTextureSetter);
        this.u_iridescenceThicknessTexture = this.register(iridescenceThicknessTextureUniform, iridescenceThicknessTextureSetter);
        this.u_specularMirrorSampler = this.register(specularMirrorTextureUniform, specularMirrorTextureSetter);
        this.u_specularMirrorMipmapScale = this.register(specularMirrorMipmapUniform, specularMirrorMipmapSetter);
        this.u_specularMirrorNormal = this.register(mirrorNormal, mirrorNormalSetter);
        this.u_viewportInv = this.register(viewportInvUniform, viewportInvSetter);
        this.u_clippingPlane = this.register(clippingPlaneUniform, clippingPlaneSetter);
    }

    private int computeVertexColorLayers(IntRenderable renderable) {
        int num = 0;
        VertexAttributes vertexAttributes = renderable.meshPart.mesh.getVertexAttributes();
        int n = vertexAttributes.size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = vertexAttributes.get(i);
            if (attr.usage != 2) continue;
            ++num;
        }
        return num;
    }

    @Override
    public boolean canRender(IntRenderable renderable) {
        long textureCoordinateMapMask = PBRShader.getTextureCoordinateMapMask(renderable.material);
        if (textureCoordinateMapMask != this.textureCoordinateMapMask) {
            return false;
        }
        if (this.morphTargetsMask != this.computeMorphTargetsMask(renderable)) {
            return false;
        }
        if (this.vertexColorLayers != this.computeVertexColorLayers(renderable)) {
            return false;
        }
        return super.canRender(renderable);
    }

    public long computeMorphTargetsMask(IntRenderable renderable) {
        int morphTargetsFlag = 0;
        VertexAttributes vertexAttributes = renderable.meshPart.mesh.getVertexAttributes();
        int n = vertexAttributes.size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = vertexAttributes.get(i);
            if (attr.usage == 512) {
                morphTargetsFlag |= 1 << attr.unit;
            }
            if (attr.usage == 1024) {
                morphTargetsFlag |= 1 << attr.unit + 8;
            }
            if (attr.usage != 2048) continue;
            morphTargetsFlag |= 1 << attr.unit + 16;
        }
        return morphTargetsFlag;
    }

    private static long getTextureCoordinateMapMask(Attributes attributes) {
        long mask = 0L;
        int maskShift = 0;
        for (int textureType : allTextureTypes) {
            PBRTextureAttribute attribute = attributes.get(PBRTextureAttribute.class, textureType);
            if (attribute != null) {
                mask |= (long)((attribute.index & 1) << maskShift);
            }
            ++maskShift;
        }
        return mask;
    }

    @Override
    public void init(ExtShaderProgram program, IntRenderable renderable) {
        super.init(program, renderable);
        this.u_mipmapScale = program.fetchUniformLocation("u_mipmapScale", false);
        this.u_texCoord0Transform = program.fetchUniformLocation("u_texCoord0Transform", false);
        this.u_texCoord1Transform = program.fetchUniformLocation("u_texCoord1Transform", false);
        this.u_morphTargets1 = program.fetchUniformLocation("u_morphTargets1", false);
        this.u_morphTargets2 = program.fetchUniformLocation("u_morphTargets2", false);
        this.u_ambientLight = program.fetchUniformLocation("u_ambientLight", false);
        this.u_csmSamplers = program.fetchUniformLocation("u_csmSamplers", false);
        this.u_csmPCFClip = program.fetchUniformLocation("u_csmPCFClip", false);
        this.u_csmTransforms = program.fetchUniformLocation("u_csmTransforms", false);
    }

    @Override
    protected void bindMaterial(Attributes attributes) {
        PBRTextureAttribute attribute;
        super.bindMaterial(attributes);
        PBRShader.transformTexture[0] = null;
        PBRShader.transformTexture[1] = null;
        for (int textureType : allTextureTypes) {
            PBRTextureAttribute attribute2 = attributes.get(PBRTextureAttribute.class, textureType);
            if (attribute2 == null) continue;
            PBRShader.transformTexture[attribute2.uvIndex] = attribute2;
        }
        if (this.u_texCoord0Transform >= 0) {
            if (transformTexture[0] != null) {
                attribute = transformTexture[0];
                textureTransform.idt();
                textureTransform.translate(attribute.offsetU, attribute.offsetV);
                textureTransform.rotateRad(-attribute.rotationUV);
                textureTransform.scale(attribute.scaleU, attribute.scaleV);
            } else {
                textureTransform.idt();
            }
            this.program.setUniformMatrix(this.u_texCoord0Transform, textureTransform);
        }
        if (this.u_texCoord1Transform >= 0) {
            if (transformTexture[1] != null) {
                attribute = transformTexture[1];
                textureTransform.setToTranslation(attribute.offsetU, attribute.offsetV);
                textureTransform.rotateRad(-attribute.rotationUV);
                textureTransform.scale(attribute.scaleU, attribute.scaleV);
            } else {
                textureTransform.idt();
            }
            this.program.setUniformMatrix(this.u_texCoord1Transform, textureTransform);
        }
    }

    @Override
    public void render(IntRenderable renderable, Attributes combinedAttributes) {
        WeightVector weightVector;
        if (this.u_mipmapScale >= 0) {
            PBRCubemapAttribute specularEnv = combinedAttributes.get(PBRCubemapAttribute.class, PBRCubemapAttribute.SpecularEnv);
            float mipmapFactor = specularEnv != null ? (float)(Math.log(((OwnCubemap)specularEnv.textureDescription.texture).getWidth()) / FastMath.log((double)2.0)) : 1.0f;
            this.program.setUniformf(this.u_mipmapScale, mipmapFactor);
        }
        if (this.u_morphTargets1 >= 0) {
            if (renderable.userData instanceof WeightVector) {
                weightVector = (WeightVector)renderable.userData;
                this.program.setUniformf(this.u_morphTargets1, weightVector.get(0), weightVector.get(1), weightVector.get(2), weightVector.get(3));
            } else {
                this.program.setUniformf(this.u_morphTargets1, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        if (this.u_morphTargets2 >= 0) {
            if (renderable.userData instanceof WeightVector) {
                weightVector = (WeightVector)renderable.userData;
                this.program.setUniformf(this.u_morphTargets2, weightVector.get(4), weightVector.get(5), weightVector.get(6), weightVector.get(7));
            } else {
                this.program.setUniformf(this.u_morphTargets2, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        super.render(renderable, combinedAttributes);
    }

    @Override
    protected void bindLights(IntRenderable renderable, Attributes attributes) {
        CascadeShadowMapAttribute csmAttrib;
        DirectionalLightsAttribute dla = attributes.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        if (dla != null) {
            for (DirectionalLight light : dla.lights) {
                if (!(light instanceof DirectionalLightEx)) continue;
                ((DirectionalLightEx)light).updateColor();
            }
        }
        super.bindLights(renderable, attributes);
        ColorAttribute ambientLight = attributes.get(ColorAttribute.class, ColorAttribute.AmbientLight);
        if (ambientLight != null) {
            this.program.setUniformf(this.u_ambientLight, ambientLight.color.r, ambientLight.color.g, ambientLight.color.b);
        }
        if ((csmAttrib = attributes.get(CascadeShadowMapAttribute.class, CascadeShadowMapAttribute.Type)) != null && this.u_csmSamplers >= 0) {
            Array<DirectionalShadowLight> lights = csmAttrib.cascadeShadowMap.lights;
            for (int i = 0; i < lights.size; ++i) {
                DirectionalShadowLight light = (DirectionalShadowLight)((Object)lights.get(i));
                float mapSize = light.getDepthMap().texture.getWidth();
                float pcf = 1.0f / (2.0f * mapSize);
                float clip = 3.0f / (2.0f * mapSize);
                int unit = this.context.textureBinder.bind(light.getDepthMap());
                this.program.setUniformi(this.u_csmSamplers + i, unit);
                this.program.setUniformMatrix(this.u_csmTransforms + i, light.getProjViewTrans());
                this.program.setUniformf(this.u_csmPCFClip + i, pcf, clip);
            }
        }
    }
}

