/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.shaders;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.OwnCubemap;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.CascadeShadowMapAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.ClippingPlaneAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.FogAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.MirrorAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.MirrorSourceAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRColorAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRCubemapAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRFlagAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRFloatAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRHDRColorAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRIridescenceAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRTextureAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRVolumeAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRCommon;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRDepthShaderProvider;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRShader;
import gaiasky.util.gdx.model.gltf.scene3d.shaders.PBRShaderConfig;
import gaiasky.util.gdx.model.gltf.scene3d.utils.LightUtils;
import gaiasky.util.gdx.model.gltf.scene3d.utils.ShaderParser;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.DepthIntShader;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.Matrix4Attribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.gdx.shader.provider.DefaultIntShaderProvider;
import gaiasky.util.gdx.shader.provider.DepthIntShaderProvider;
import net.jafama.FastMath;

public class PBRShaderProvider
extends DefaultIntShaderProvider {
    public static final String TAG = "PBRShader";
    private static final LightUtils.LightsInfo lightsInfo = new LightUtils.LightsInfo();
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = ShaderParser.parse(Gdx.files.classpath("net/mgsx/gltf/shaders/pbr/pbr.vs.glsl"));
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = ShaderParser.parse(Gdx.files.classpath("net/mgsx/gltf/shaders/pbr/pbr.fs.glsl"));
        }
        return defaultFragmentShader;
    }

    public static PBRShaderConfig createDefaultConfig() {
        PBRShaderConfig config = new PBRShaderConfig();
        config.vertexShaderCode = PBRShaderProvider.getDefaultVertexShader();
        config.fragmentShaderCode = PBRShaderProvider.getDefaultFragmentShader();
        return config;
    }

    public static DepthIntShader.Config createDefaultDepthConfig() {
        return PBRDepthShaderProvider.createDefaultConfig();
    }

    public static PBRShaderProvider createDefault(int maxBones) {
        PBRShaderConfig config = PBRShaderProvider.createDefaultConfig();
        config.numBones = maxBones;
        return PBRShaderProvider.createDefault(config);
    }

    public static PBRShaderProvider createDefault(PBRShaderConfig config) {
        return new PBRShaderProvider(config);
    }

    public static DepthIntShaderProvider createDefaultDepth(int maxBones) {
        DepthIntShader.Config config = PBRShaderProvider.createDefaultDepthConfig();
        config.numBones = maxBones;
        return PBRShaderProvider.createDefaultDepth(config);
    }

    public static DepthIntShaderProvider createDefaultDepth(DepthIntShader.Config config) {
        return new PBRDepthShaderProvider(config);
    }

    public PBRShaderProvider(PBRShaderConfig config) {
        super(config == null ? PBRShaderProvider.createDefaultConfig() : config);
        if (this.config.vertexShaderCode == null) {
            this.config.vertexShaderCode = PBRShaderProvider.getDefaultVertexShader();
        }
        if (this.config.fragmentShaderCode == null) {
            this.config.fragmentShaderCode = PBRShaderProvider.getDefaultFragmentShader();
        }
    }

    public int getShaderCount() {
        return this.shaders.size;
    }

    public static String morphTargetsPrefix(IntRenderable renderable) {
        StringBuilder prefix = new StringBuilder();
        for (VertexAttribute att : renderable.meshPart.mesh.getVertexAttributes()) {
            for (int i = 0; i < 8; ++i) {
                if (att.usage == 512 && att.unit == i) {
                    prefix.append("#define position").append(i).append("Flag\n");
                    continue;
                }
                if (att.usage == 1024 && att.unit == i) {
                    prefix.append("#define normal").append(i).append("Flag\n");
                    continue;
                }
                if (att.usage != 2048 || att.unit != i) continue;
                prefix.append("#define tangent").append(i).append("Flag\n");
            }
        }
        return prefix.toString();
    }

    protected boolean isGL3() {
        return Gdx.graphics.getGLVersion().isVersionEqualToOrHigher(3, 0);
    }

    public String createPrefixBase(IntRenderable renderable, PBRShaderConfig config) {
        String defaultPrefix = DefaultIntShader.createPrefix(renderable, config);
        String version = config.glslVersion;
        if (this.isGL3()) {
            if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
                if (version == null) {
                    version = "#version 130\n#define GLSL3\n";
                }
            } else if ((Gdx.app.getType() == Application.ApplicationType.Android || Gdx.app.getType() == Application.ApplicationType.iOS || Gdx.app.getType() == Application.ApplicationType.WebGL) && version == null) {
                version = "#version 300 es\n#define GLSL3\n";
            }
        }
        Object prefix = "";
        if (version != null) {
            prefix = (String)prefix + version;
        }
        if (config.prefix != null) {
            prefix = (String)prefix + config.prefix;
        }
        prefix = (String)prefix + defaultPrefix;
        return prefix;
    }

    public String createPrefixSRGB(IntRenderable renderable, PBRShaderConfig config) {
        Object prefix = "";
        if (config.manualSRGB != PBRShaderConfig.SRGB.NONE) {
            prefix = (String)prefix + "#define MANUAL_SRGB\n";
            if (config.manualSRGB == PBRShaderConfig.SRGB.FAST) {
                prefix = (String)prefix + "#define SRGB_FAST_APPROXIMATION\n";
            }
        }
        if (config.manualGammaCorrection) {
            prefix = (String)prefix + "#define GAMMA_CORRECTION " + config.gamma + "\n";
        }
        if (config.transmissionSRGB != PBRShaderConfig.SRGB.NONE) {
            prefix = (String)prefix + "#define TS_MANUAL_SRGB\n";
            if (config.transmissionSRGB == PBRShaderConfig.SRGB.FAST) {
                prefix = (String)prefix + "#define TS_SRGB_FAST_APPROXIMATION\n";
            }
        }
        if (config.mirrorSRGB != PBRShaderConfig.SRGB.NONE) {
            prefix = (String)prefix + "#define MS_MANUAL_SRGB\n";
            if (config.mirrorSRGB == PBRShaderConfig.SRGB.FAST) {
                prefix = (String)prefix + "#define MS_SRGB_FAST_APPROXIMATION\n";
            }
        }
        return prefix;
    }

    @Override
    protected IntShader createShader(IntRenderable renderable) {
        boolean unlit;
        int primitiveType;
        PBRShaderConfig config = (PBRShaderConfig)this.config;
        StringBuilder prefix = new StringBuilder(this.createPrefixBase(renderable, config));
        prefix.append(PBRShaderProvider.morphTargetsPrefix(renderable));
        if (renderable.material.has(PBRColorAttribute.BaseColorFactor)) {
            prefix.append("#define baseColorFactorFlag\n");
        }
        boolean isLineOrPoint = (primitiveType = renderable.meshPart.primitiveType) == 0 || primitiveType == 1 || primitiveType == 2 || primitiveType == 3;
        boolean bl = unlit = isLineOrPoint || renderable.material.has(PBRFlagAttribute.Unlit) || renderable.meshPart.mesh.getVertexAttribute(8) == null;
        if (unlit) {
            prefix.append("#define unlitFlag\n");
        } else {
            CascadeShadowMapAttribute csm;
            if (renderable.material.has(PBRTextureAttribute.MetallicRoughnessTexture)) {
                prefix.append("#define metallicRoughnessTextureFlag\n");
            }
            if (renderable.material.has(PBRTextureAttribute.OcclusionTexture)) {
                prefix.append("#define occlusionTextureFlag\n");
            }
            if (renderable.material.has(PBRFloatAttribute.TransmissionFactor)) {
                prefix.append("#define transmissionFlag\n");
            }
            if (renderable.material.has(PBRTextureAttribute.TransmissionTexture)) {
                prefix.append("#define transmissionTextureFlag\n");
            }
            if (renderable.material.has(PBRVolumeAttribute.Type)) {
                prefix.append("#define volumeFlag\n");
            }
            if (renderable.material.has(PBRTextureAttribute.ThicknessTexture)) {
                prefix.append("#define thicknessTextureFlag\n");
            }
            if (renderable.material.has(PBRFloatAttribute.IOR)) {
                prefix.append("#define iorFlag\n");
            }
            boolean hasSpecular = false;
            if (renderable.material.has(PBRFloatAttribute.SpecularFactor)) {
                prefix.append("#define specularFactorFlag\n");
                hasSpecular = true;
            }
            if (renderable.material.has(PBRHDRColorAttribute.Specular)) {
                hasSpecular = true;
                prefix.append("#define specularColorFlag\n");
            }
            if (renderable.material.has(PBRTextureAttribute.SpecularFactorTexture)) {
                prefix.append("#define specularFactorTextureFlag\n");
                hasSpecular = true;
            }
            if (renderable.material.has(PBRTextureAttribute.SpecularColorTexture)) {
                prefix.append("#define specularColorTextureFlag\n");
                hasSpecular = true;
            }
            if (hasSpecular) {
                prefix.append("#define specularFlag\n");
            }
            if (renderable.material.has(PBRIridescenceAttribute.Type)) {
                prefix.append("#define iridescenceFlag\n");
            }
            if (renderable.material.has(PBRTextureAttribute.IridescenceTexture)) {
                prefix.append("#define iridescenceTextureFlag\n");
            }
            if (renderable.material.has(PBRTextureAttribute.IridescenceThicknessTexture)) {
                prefix.append("#define iridescenceThicknessTextureFlag\n");
            }
            if (renderable.environment.has(ClippingPlaneAttribute.Type)) {
                prefix.append("#define clippingPlaneFlag\n");
            }
            if ((csm = renderable.environment.get(CascadeShadowMapAttribute.class, CascadeShadowMapAttribute.Type)) != null) {
                prefix.append("#define numCSM ").append(csm.cascadeShadowMap.lights.size).append("\n");
            }
            PBRCubemapAttribute specualarCubemapAttribute = null;
            MirrorAttribute specularMirrorAttribute = null;
            if (renderable.environment != null) {
                if (renderable.environment.has(PBRTextureAttribute.TransmissionSourceTexture)) {
                    prefix.append("#define transmissionSourceFlag\n");
                }
                if (renderable.environment.has(PBRCubemapAttribute.SpecularEnv)) {
                    prefix.append("#define diffuseSpecularEnvSeparateFlag\n");
                    specualarCubemapAttribute = renderable.environment.get(PBRCubemapAttribute.class, PBRCubemapAttribute.SpecularEnv);
                } else if (renderable.environment.has(PBRCubemapAttribute.DiffuseEnv)) {
                    specualarCubemapAttribute = renderable.environment.get(PBRCubemapAttribute.class, PBRCubemapAttribute.DiffuseEnv);
                } else if (renderable.environment.has(PBRCubemapAttribute.ReflectionCubemap)) {
                    specualarCubemapAttribute = renderable.environment.get(PBRCubemapAttribute.class, PBRCubemapAttribute.ReflectionCubemap);
                }
                if (renderable.environment.has(MirrorSourceAttribute.Type) && renderable.material.has(MirrorAttribute.Specular)) {
                    specularMirrorAttribute = renderable.environment.get(MirrorAttribute.class, MirrorAttribute.Specular);
                    prefix.append("#define mirrorSpecularFlag\n");
                }
                if (specualarCubemapAttribute != null || specularMirrorAttribute != null) {
                    boolean textureLodSupported;
                    prefix.append("#define USE_IBL\n");
                    if (this.isGL3()) {
                        textureLodSupported = true;
                    } else if (Gdx.graphics.supportsExtension("EXT_shader_texture_lod")) {
                        prefix.append("#define USE_TEXTURE_LOD_EXT\n");
                        textureLodSupported = true;
                    } else {
                        textureLodSupported = false;
                    }
                    if (specualarCubemapAttribute != null) {
                        Texture.TextureFilter textureFilter;
                        Texture.TextureFilter textureFilter2 = textureFilter = specualarCubemapAttribute.textureDescription.minFilter != null ? specualarCubemapAttribute.textureDescription.minFilter : ((OwnCubemap)specualarCubemapAttribute.textureDescription.texture).getMinFilter();
                        if (textureLodSupported && textureFilter.equals((Object)Texture.TextureFilter.MipMap)) {
                            prefix.append("#define USE_TEX_LOD\n");
                        }
                    }
                    if (renderable.environment.has(PBRTextureAttribute.BRDFLUTTexture)) {
                        prefix.append("#define brdfLUTTexture\n");
                    }
                }
                if (renderable.environment.has(ColorAttribute.AmbientLight)) {
                    prefix.append("#define ambientLightFlag\n");
                }
                if (renderable.environment.has(Matrix4Attribute.EnvRotation)) {
                    prefix.append("#define ENV_ROTATION\n");
                }
            }
        }
        prefix.append(this.createPrefixSRGB(renderable, config));
        int maxUVIndex = -1;
        Object attribute = renderable.material.get(TextureAttribute.class, TextureAttribute.Diffuse);
        if (attribute != null) {
            prefix.append("#define v_diffuseUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, TextureAttribute.Emissive)) != null) {
            prefix.append("#define v_emissiveUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, TextureAttribute.Normal)) != null) {
            prefix.append("#define v_normalUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, PBRTextureAttribute.MetallicRoughnessTexture)) != null) {
            prefix.append("#define v_metallicRoughnessUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, TextureAttribute.AO)) != null) {
            prefix.append("#define v_occlusionUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, PBRTextureAttribute.TransmissionTexture)) != null) {
            prefix.append("#define v_transmissionUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, PBRTextureAttribute.ThicknessTexture)) != null) {
            prefix.append("#define v_thicknessUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, PBRTextureAttribute.SpecularFactorTexture)) != null) {
            prefix.append("#define v_specularFactorUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, TextureAttribute.Specular)) != null) {
            prefix.append("#define v_specularColorUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, PBRTextureAttribute.IridescenceTexture)) != null) {
            prefix.append("#define v_iridescenceUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = renderable.material.get(TextureAttribute.class, PBRTextureAttribute.IridescenceThicknessTexture)) != null) {
            prefix.append("#define v_iridescenceThicknessUV v_texCoord").append(((TextureAttribute)attribute).uvIndex).append("\n");
            maxUVIndex = FastMath.max((int)maxUVIndex, (int)((TextureAttribute)attribute).uvIndex);
        }
        if (maxUVIndex >= 0) {
            prefix.append("#define textureFlag\n");
        }
        if (maxUVIndex == 1) {
            prefix.append("#define textureCoord1Flag\n");
        } else if (maxUVIndex > 1) {
            throw new GdxRuntimeException("more than 2 texture coordinates attribute not supported");
        }
        if (renderable.environment != null && renderable.environment.has(FogAttribute.FogEquation)) {
            prefix.append("#define fogEquationFlag\n");
        }
        for (VertexAttribute attribute2 : renderable.meshPart.mesh.getVertexAttributes()) {
            if (attribute2.usage != 2) continue;
            prefix.append("#define color").append(attribute2.unit).append("Flag\n");
        }
        int numBoneInfluence = 0;
        int numMorphTarget = 0;
        int numColor = 0;
        for (VertexAttribute attribute3 : renderable.meshPart.mesh.getVertexAttributes()) {
            if (attribute3.usage == 4) {
                throw new GdxRuntimeException("color packed attribute not supported");
            }
            if (attribute3.usage == 2) {
                numColor = FastMath.max((int)numColor, (int)(attribute3.unit + 1));
                continue;
            }
            if (attribute3.usage == 512 && attribute3.unit >= 8 || attribute3.usage == 1024 && attribute3.unit >= 8 || attribute3.usage == 2048 && attribute3.unit >= 8) {
                numMorphTarget = FastMath.max((int)numMorphTarget, (int)(attribute3.unit + 1));
                continue;
            }
            if (attribute3.usage != 64) continue;
            numBoneInfluence = FastMath.max((int)numBoneInfluence, (int)(attribute3.unit + 1));
        }
        PBRCommon.checkVertexAttributes(renderable);
        if (numBoneInfluence > 8) {
            Gdx.app.error(TAG, "more than 8 bones influence attributes not supported: " + numBoneInfluence + " found.");
        }
        if (numMorphTarget > 8) {
            Gdx.app.error(TAG, "more than 8 morph target attributes not supported: " + numMorphTarget + " found.");
        }
        if (numColor > config.numVertexColors) {
            Gdx.app.error(TAG, "more than " + config.numVertexColors + " color attributes not supported: " + numColor + " found.");
        }
        if (renderable.environment != null) {
            LightUtils.getLightsInfo(lightsInfo, renderable.environment);
            if (PBRShaderProvider.lightsInfo.dirLights > config.numDirectionalLights) {
                Gdx.app.error(TAG, "too many directional lights detected: " + PBRShaderProvider.lightsInfo.dirLights + "/" + config.numDirectionalLights);
            }
            if (PBRShaderProvider.lightsInfo.pointLights > config.numPointLights) {
                Gdx.app.error(TAG, "too many point lights detected: " + PBRShaderProvider.lightsInfo.pointLights + "/" + config.numPointLights);
            }
            if (PBRShaderProvider.lightsInfo.spotLights > config.numSpotLights) {
                Gdx.app.error(TAG, "too many spot lights detected: " + PBRShaderProvider.lightsInfo.spotLights + "/" + config.numSpotLights);
            }
            if (PBRShaderProvider.lightsInfo.miscLights > 0) {
                Gdx.app.error(TAG, "unknown type lights not supported.");
            }
        }
        PBRShader shader = this.createShader(renderable, config, prefix.toString());
        this.checkShaderCompilation(shader.program);
        if (!shader.canRender(renderable)) {
            throw new GdxRuntimeException("cannot render with this shader");
        }
        return shader;
    }

    protected PBRShader createShader(IntRenderable renderable, PBRShaderConfig config, String prefix) {
        return new PBRShader(renderable, (DefaultIntShader.Config)config, prefix);
    }

    protected void checkShaderCompilation(ExtShaderProgram program) {
        String shaderLog = program.getLog();
        if (program.isCompiled()) {
            if (shaderLog.isEmpty()) {
                Gdx.app.debug(TAG, "Shader compilation success");
            } else {
                Gdx.app.error(TAG, "Shader compilation warnings:\n" + shaderLog);
            }
        } else {
            throw new GdxRuntimeException("Shader compilation failed:\n" + shaderLog);
        }
    }
}

