/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.utils;

import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.attribute.DirectionalLightsAttribute;
import gaiasky.util.gdx.shader.attribute.PointLightsAttribute;
import gaiasky.util.gdx.shader.attribute.SpotLightsAttribute;

public class LightUtils {
    public static LightsInfo getLightsInfo(LightsInfo info, Environment environment) {
        SpotLightsAttribute sla;
        PointLightsAttribute pla;
        info.reset();
        DirectionalLightsAttribute dla = environment.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        if (dla != null) {
            info.dirLights = dla.lights.size;
        }
        if ((pla = environment.get(PointLightsAttribute.class, PointLightsAttribute.Type)) != null) {
            info.pointLights = pla.lights.size;
        }
        if ((sla = environment.get(SpotLightsAttribute.class, SpotLightsAttribute.Type)) != null) {
            info.spotLights = sla.lights.size;
        }
        return info;
    }

    public static LightsInfo getLightsInfo(LightsInfo info, Iterable<BaseLight> lights) {
        info.reset();
        for (BaseLight light : lights) {
            if (light instanceof DirectionalLight) {
                ++info.dirLights;
                continue;
            }
            if (light instanceof PointLight) {
                ++info.pointLights;
                continue;
            }
            if (light instanceof SpotLight) {
                ++info.spotLights;
                continue;
            }
            ++info.miscLights;
        }
        return info;
    }

    public static class LightsInfo {
        public int dirLights = 0;
        public int pointLights = 0;
        public int spotLights = 0;
        public int miscLights = 0;

        public void reset() {
            this.dirLights = 0;
            this.pointLights = 0;
            this.spotLights = 0;
            this.miscLights = 0;
        }
    }
}

