/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.Bits;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.shader.BaseIntShader;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.AtmosphereAttribute;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.Attributes;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.DepthTestAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.IntAttribute;
import gaiasky.util.gdx.shader.attribute.Matrix3Attribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.gdx.shader.attribute.Vector3Attribute;
import gaiasky.util.gdx.shader.attribute.Vector4Attribute;
import gaiasky.util.gdx.shader.provider.ShaderProgramProvider;
import java.util.Objects;

public class AtmosphereShader
extends BaseIntShader {
    private static final Bits optionalAttributes = Bits.indices(IntAttribute.CullFace, DepthTestAttribute.Type);
    private static final Attributes tmpAttributes = new Attributes();
    protected static Bits implementedFlags = Bits.indices(BlendingAttribute.Type, TextureAttribute.Diffuse, ColorAttribute.Diffuse, ColorAttribute.Specular, FloatAttribute.Shininess);
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;
    public final int u_projTrans;
    public final int u_viewTrans;
    public final int u_projViewTrans;
    public final int u_cameraPosition;
    public final int u_cameraDirection;
    public final int u_cameraUp;
    public final int u_cameraNearFar;
    public final int u_cameraK;
    public final int u_worldTrans;
    public final int u_viewWorldTrans;
    public final int u_projViewWorldTrans;
    public final int u_normalMatrix;
    public final int fAlpha;
    public final int fCameraHeight;
    public final int fOuterRadius;
    public final int fInnerRadius;
    public final int fKrESun;
    public final int fKmESun;
    public final int fKr4PI;
    public final int fKm4PI;
    public final int fScale;
    public final int fScaleDepth;
    public final int fScaleOverScaleDepth;
    public final int nSamples;
    public final int g;
    public final int v3PlanetPos;
    public final int v3LightPos;
    public final int v3CameraPos;
    public final int v3InvWavelength;
    public final int u_eclipsingBodyPos;
    public final int u_eclipsingBodyRadius;
    public final int u_vc;
    public final int u_velDir;
    public final int u_hterms;
    public final int u_gw;
    public final int u_gwmat3;
    public final int u_ts;
    public final int u_omgw;
    protected final Bits attributesMask;
    protected final Config config;
    private final long vertexMask;
    Material currentMaterial;
    private IntRenderable renderable;

    public AtmosphereShader(IntRenderable renderable, Config config) {
        this(renderable, config, AtmosphereShader.createPrefix(renderable));
    }

    public AtmosphereShader(IntRenderable renderable, Config config, String prefix) {
        this(renderable, config, prefix, config.vertexShader != null ? config.vertexShader : AtmosphereShader.getDefaultVertexShader(), config.fragmentShader != null ? config.fragmentShader : AtmosphereShader.getDefaultFragmentShader());
    }

    public AtmosphereShader(IntRenderable renderable, Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ExtShaderProgram(ShaderProgramProvider.getShaderCode(prefix, vertexShader), ShaderProgramProvider.getShaderCode(prefix, fragmentShader)));
    }

    public AtmosphereShader(IntRenderable renderable, Config config, ExtShaderProgram shaderProgram) {
        Attributes attributes = AtmosphereShader.combineAttributes(renderable);
        this.config = config;
        this.program = shaderProgram;
        this.renderable = renderable;
        this.attributesMask = attributes.getMask().copy().or(optionalAttributes);
        this.vertexMask = renderable.meshPart.mesh.getVertexAttributes().getMaskWithSizePacked();
        if (!config.ignoreUnimplemented && !implementedFlags.copy().or(this.attributesMask).equals(this.attributesMask)) {
            throw new GdxRuntimeException("Some attributes not implemented yet (" + String.valueOf(this.attributesMask) + ")");
        }
        this.u_projTrans = this.register(Inputs.projTrans, Setters.projTrans);
        this.u_viewTrans = this.register(Inputs.viewTrans, Setters.viewTrans);
        this.u_projViewTrans = this.register(Inputs.projViewTrans, Setters.projViewTrans);
        this.u_cameraPosition = this.register(Inputs.cameraPosition, Setters.cameraPosition);
        this.u_cameraDirection = this.register(Inputs.cameraDirection, Setters.cameraDirection);
        this.u_cameraUp = this.register(Inputs.cameraUp, Setters.cameraUp);
        this.u_cameraNearFar = this.register(DefaultIntShader.Inputs.cameraNearFar, DefaultIntShader.Setters.cameraNearFar);
        this.u_cameraK = this.register(DefaultIntShader.Inputs.cameraK, DefaultIntShader.Setters.cameraK);
        this.u_worldTrans = this.register(Inputs.worldTrans, Setters.worldTrans);
        this.u_viewWorldTrans = this.register(Inputs.viewWorldTrans, Setters.viewWorldTrans);
        this.u_projViewWorldTrans = this.register(Inputs.projViewWorldTrans, Setters.projViewWorldTrans);
        this.u_normalMatrix = this.register(Inputs.normalMatrix, Setters.normalMatrix);
        this.fAlpha = this.register(Inputs.alpha, Setters.alpha);
        this.fCameraHeight = this.register(Inputs.cameraHeight, Setters.cameraHeight);
        this.fOuterRadius = this.register(Inputs.outerRadius, Setters.outerRadius);
        this.fInnerRadius = this.register(Inputs.innerRadius, Setters.innerRadius);
        this.fKrESun = this.register(Inputs.krESun, Setters.krESun);
        this.fKmESun = this.register(Inputs.kmESun, Setters.kmESun);
        this.fKr4PI = this.register(Inputs.kr4PI, Setters.kr4PI);
        this.fKm4PI = this.register(Inputs.km4PI, Setters.km4PI);
        this.fScale = this.register(Inputs.scale, Setters.scale);
        this.fScaleDepth = this.register(Inputs.scaleDepth, Setters.scaleDepth);
        this.fScaleOverScaleDepth = this.register(Inputs.scaleOverScaleDepth, Setters.scaleOverScaleDepth);
        this.nSamples = this.register(Inputs.nSamples, Setters.nSamples);
        this.g = this.register(Inputs.g, Setters.g);
        this.v3PlanetPos = this.register(Inputs.planetPos, Setters.planetPos);
        this.v3CameraPos = this.register(Inputs.cameraPos, Setters.cameraPos);
        this.v3LightPos = this.register(Inputs.lightPos, Setters.lightPos);
        this.v3InvWavelength = this.register(Inputs.invWavelength, Setters.invWavelength);
        this.u_eclipsingBodyPos = this.register(Inputs.eclipsingBodyPos, Setters.eclipsingBodyPos);
        this.u_eclipsingBodyRadius = this.register(Inputs.eclipsingBodyRadius, Setters.eclipsingBodyRadius);
        this.u_vc = this.register(Inputs.vc, Setters.vc);
        this.u_velDir = this.register(Inputs.velDir, Setters.velDir);
        this.u_hterms = this.register(Inputs.hterms, Setters.hterms);
        this.u_gw = this.register(Inputs.gw, Setters.gw);
        this.u_gwmat3 = this.register(Inputs.gwmat3, Setters.gwmat3);
        this.u_ts = this.register(Inputs.ts, Setters.ts);
        this.u_omgw = this.register(Inputs.omgw, Setters.omgw);
    }

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.internal("shader/atm.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.internal("shader/atm.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    private static Attributes combineAttributes(IntRenderable renderable) {
        tmpAttributes.clear();
        if (renderable.environment != null) {
            tmpAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            tmpAttributes.set(renderable.material);
        }
        return tmpAttributes;
    }

    private static Bits combineAttributeMasks(IntRenderable renderable) {
        Bits mask = Bits.empty();
        if (renderable.environment != null) {
            mask.or(renderable.environment.getMask());
        }
        if (renderable.material != null) {
            mask.or(renderable.material.getMask());
        }
        return mask;
    }

    public static String createPrefix(IntRenderable renderable) {
        Attributes attributes = AtmosphereShader.combineAttributes(renderable);
        StringBuilder prefix = new StringBuilder();
        if (attributes.has(AtmosphereAttribute.KmESun)) {
            prefix.append("#define atmosphericScattering\n");
        }
        if (attributes.has(FloatAttribute.Vc)) {
            prefix.append("#define relativisticEffects\n");
        }
        if (attributes.has(FloatAttribute.Omgw)) {
            prefix.append("#define gravitationalWaves\n");
        }
        if (attributes.has(Vector3Attribute.EclipsingBodyPos)) {
            prefix.append("#define eclipsingBodyFlag\n");
        }
        if (Settings.settings.postprocess.ssr.active) {
            prefix.append("#define ssrFlag\n");
        }
        return prefix.toString();
    }

    @Override
    public void init() {
        ExtShaderProgram program = this.program;
        this.program = null;
        this.init(program, this.renderable);
        this.renderable = null;
    }

    @Override
    public boolean canRender(IntRenderable renderable) {
        Bits renderableMask = AtmosphereShader.combineAttributeMasks(renderable);
        return this.attributesMask.equals(renderableMask.or(optionalAttributes)) && this.vertexMask == renderable.meshPart.mesh.getVertexAttributes().getMaskWithSizePacked();
    }

    @Override
    public int compareTo(IntShader other) {
        if (other == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof AtmosphereShader && this.equals((AtmosphereShader)obj);
    }

    public boolean equals(AtmosphereShader obj) {
        return obj == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void begin(Camera camera, RenderContext context) {
        super.begin(camera, context);
    }

    @Override
    public void render(IntRenderable renderable) {
        if (!renderable.material.has(BlendingAttribute.Type)) {
            this.context.setBlending(false, 770, 771);
        }
        this.bindMaterial(renderable);
        super.render(renderable);
    }

    @Override
    public void end() {
        this.currentMaterial = null;
        super.end();
    }

    protected void bindMaterial(IntRenderable renderable) {
        if (this.currentMaterial == renderable.material) {
            return;
        }
        int cullFace = this.config.defaultCullFace;
        int depthFunc = this.config.defaultDepthFunc;
        float depthRangeNear = 0.0f;
        float depthRangeFar = 1.0f;
        boolean depthMask = true;
        this.currentMaterial = renderable.material;
        for (Attribute attr : this.currentMaterial) {
            int t = attr.index;
            if (BlendingAttribute.is(t)) {
                this.context.setBlending(true, ((BlendingAttribute)attr).sourceFunction, ((BlendingAttribute)attr).destFunction);
                continue;
            }
            if (attr.has(IntAttribute.CullFace)) {
                cullFace = ((IntAttribute)attr).value;
                continue;
            }
            if (attr.has(DepthTestAttribute.Type)) {
                DepthTestAttribute dta = (DepthTestAttribute)attr;
                depthFunc = dta.depthFunc;
                depthRangeNear = dta.depthRangeNear;
                depthRangeFar = dta.depthRangeFar;
                depthMask = dta.depthMask;
                continue;
            }
            if (this.config.ignoreUnimplemented) continue;
            throw new GdxRuntimeException("Unknown material attribute: " + String.valueOf(attr));
        }
        this.context.setCullFace(cullFace);
        this.context.setDepthTest(depthFunc, depthRangeNear, depthRangeFar);
        this.context.setDepthMask(depthMask);
    }

    @Override
    public void dispose() {
        this.program.dispose();
        super.dispose();
    }

    public int getDefaultCullFace() {
        return this.config.defaultCullFace;
    }

    public void setDefaultCullFace(int cullFace) {
        this.config.defaultCullFace = cullFace;
    }

    public int getDefaultDepthFunc() {
        return this.config.defaultDepthFunc;
    }

    public void setDefaultDepthFunc(int depthFunc) {
        this.config.defaultDepthFunc = depthFunc;
    }

    public static class Config {
        public String vertexShader = null;
        public String fragmentShader = null;
        public boolean ignoreUnimplemented = true;
        public int defaultCullFace = 1029;
        public int defaultDepthFunc = 515;

        public Config() {
        }

        public Config(String vertexShader, String fragmentShader) {
            this.vertexShader = vertexShader;
            this.fragmentShader = fragmentShader;
        }
    }

    public static class Inputs {
        public static final BaseIntShader.Uniform projTrans = new BaseIntShader.Uniform("u_projTrans");
        public static final BaseIntShader.Uniform viewTrans = new BaseIntShader.Uniform("u_viewTrans");
        public static final BaseIntShader.Uniform projViewTrans = new BaseIntShader.Uniform("u_projViewTrans");
        public static final BaseIntShader.Uniform cameraPosition = new BaseIntShader.Uniform("u_cameraPosition");
        public static final BaseIntShader.Uniform cameraDirection = new BaseIntShader.Uniform("u_cameraDirection");
        public static final BaseIntShader.Uniform cameraUp = new BaseIntShader.Uniform("u_cameraUp");
        public static final BaseIntShader.Uniform cameraNearFar = new BaseIntShader.Uniform("u_cameraNearFar");
        public static final BaseIntShader.Uniform cameraK = new BaseIntShader.Uniform("u_cameraK");
        public static final BaseIntShader.Uniform worldTrans = new BaseIntShader.Uniform("u_worldTrans");
        public static final BaseIntShader.Uniform viewWorldTrans = new BaseIntShader.Uniform("u_viewWorldTrans");
        public static final BaseIntShader.Uniform projViewWorldTrans = new BaseIntShader.Uniform("u_projViewWorldTrans");
        public static final BaseIntShader.Uniform normalMatrix = new BaseIntShader.Uniform("u_normalMatrix");
        public static final BaseIntShader.Uniform alpha = new BaseIntShader.Uniform("fAlpha");
        public static final BaseIntShader.Uniform cameraHeight = new BaseIntShader.Uniform("fCameraHeight");
        public static final BaseIntShader.Uniform outerRadius = new BaseIntShader.Uniform("fOuterRadius");
        public static final BaseIntShader.Uniform innerRadius = new BaseIntShader.Uniform("fInnerRadius");
        public static final BaseIntShader.Uniform innerRadius2 = new BaseIntShader.Uniform("fInnerRadius2");
        public static final BaseIntShader.Uniform krESun = new BaseIntShader.Uniform("fKrESun");
        public static final BaseIntShader.Uniform kmESun = new BaseIntShader.Uniform("fKmESun");
        public static final BaseIntShader.Uniform kr4PI = new BaseIntShader.Uniform("fKr4PI");
        public static final BaseIntShader.Uniform km4PI = new BaseIntShader.Uniform("fKm4PI");
        public static final BaseIntShader.Uniform scale = new BaseIntShader.Uniform("fScale");
        public static final BaseIntShader.Uniform scaleDepth = new BaseIntShader.Uniform("fScaleDepth");
        public static final BaseIntShader.Uniform scaleOverScaleDepth = new BaseIntShader.Uniform("fScaleOverScaleDepth");
        public static final BaseIntShader.Uniform nSamples = new BaseIntShader.Uniform("nSamples");
        public static final BaseIntShader.Uniform g = new BaseIntShader.Uniform("g");
        public static final BaseIntShader.Uniform planetPos = new BaseIntShader.Uniform("v3PlanetPos");
        public static final BaseIntShader.Uniform lightPos = new BaseIntShader.Uniform("v3LightPos");
        public static final BaseIntShader.Uniform cameraPos = new BaseIntShader.Uniform("v3CameraPos");
        public static final BaseIntShader.Uniform invWavelength = new BaseIntShader.Uniform("v3InvWavelength");
        public static final BaseIntShader.Uniform eclipsingBodyPos = new BaseIntShader.Uniform("u_eclipsingBodyPos", Vector3Attribute.EclipsingBodyPos);
        public static final BaseIntShader.Uniform eclipsingBodyRadius = new BaseIntShader.Uniform("u_eclipsingBodyRadius", FloatAttribute.EclipsingBodyRadius);
        public static final BaseIntShader.Uniform vc = new BaseIntShader.Uniform("u_vc");
        public static final BaseIntShader.Uniform velDir = new BaseIntShader.Uniform("u_velDir");
        public static final BaseIntShader.Uniform hterms = new BaseIntShader.Uniform("u_hterms");
        public static final BaseIntShader.Uniform gw = new BaseIntShader.Uniform("u_gw");
        public static final BaseIntShader.Uniform gwmat3 = new BaseIntShader.Uniform("u_gwmat3");
        public static final BaseIntShader.Uniform ts = new BaseIntShader.Uniform("u_ts");
        public static final BaseIntShader.Uniform omgw = new BaseIntShader.Uniform("u_omgw");
    }

    public static class Setters {
        public static final BaseIntShader.Setter projTrans = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return true;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.projection);
            }
        };
        public static final BaseIntShader.Setter viewTrans = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return true;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.view);
            }
        };
        public static final BaseIntShader.Setter projViewTrans = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return true;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.combined);
            }
        };
        public static final BaseIntShader.Setter cameraPosition = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return true;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.position.x, shader.camera.position.y, shader.camera.position.z, 1.1881f / (shader.camera.far * shader.camera.far));
            }
        };
        public static final BaseIntShader.Setter cameraDirection = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return true;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.direction);
            }
        };
        public static final BaseIntShader.Setter cameraUp = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return true;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.up);
            }
        };
        public static final BaseIntShader.Setter cameraNearFar = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.near, shader.camera.far);
            }
        };
        public static final BaseIntShader.Setter cameraK = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, Constants.getCameraK());
            }
        };
        public static final BaseIntShader.Setter worldTrans = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, renderable.worldTransform);
            }
        };
        public static final BaseIntShader.Setter viewWorldTrans = new BaseIntShader.Setter(){
            final Matrix4 temp = new Matrix4();

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, this.temp.set(shader.camera.view).mul(renderable.worldTransform));
            }
        };
        public static final BaseIntShader.Setter projViewWorldTrans = new BaseIntShader.Setter(){
            final Matrix4 temp = new Matrix4();

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, this.temp.set(shader.camera.combined).mul(renderable.worldTransform));
            }
        };
        public static final BaseIntShader.Setter normalMatrix = new BaseIntShader.Setter(){
            private final Matrix3 tmpM = new Matrix3();

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, this.tmpM.set(renderable.worldTransform).inv().transpose());
            }
        };
        public static final BaseIntShader.Setter alpha = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.Alpha))).value);
            }
        };
        public static final BaseIntShader.Setter cameraHeight = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.CameraHeight))).value);
            }
        };
        public static final BaseIntShader.Setter outerRadius = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.OuterRadius))).value);
            }
        };
        public static final BaseIntShader.Setter innerRadius = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.InnerRadius))).value);
            }
        };
        public static final BaseIntShader.Setter krESun = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.KrESun))).value);
            }
        };
        public static final BaseIntShader.Setter kmESun = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.KmESun))).value);
            }
        };
        public static final BaseIntShader.Setter kr4PI = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.Kr4PI))).value);
            }
        };
        public static final BaseIntShader.Setter km4PI = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.Km4PI))).value);
            }
        };
        public static final BaseIntShader.Setter scale = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.Scale))).value);
            }
        };
        public static final BaseIntShader.Setter scaleDepth = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.ScaleDepth))).value);
            }
        };
        public static final BaseIntShader.Setter scaleOverScaleDepth = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.ScaleOverScaleDepth))).value);
            }
        };
        public static final BaseIntShader.Setter nSamples = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, (int)((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.nSamples))).value);
            }
        };
        public static final BaseIntShader.Setter g = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.G))).value);
            }
        };
        public static final BaseIntShader.Setter planetPos = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.PlanetPos))).value);
            }
        };
        public static final BaseIntShader.Setter cameraPos = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.CameraPos))).value);
            }
        };
        public static final BaseIntShader.Setter lightPos = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.LightPos))).value);
            }
        };
        public static final BaseIntShader.Setter invWavelength = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.InvWavelength))).value);
            }
        };
        public static final BaseIntShader.Setter eclipsingBodyPos = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.EclipsingBodyPos)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.EclipsingBodyPos))).value);
                }
            }
        };
        public static final BaseIntShader.Setter eclipsingBodyRadius = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.EclipsingBodyRadius)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.EclipsingBodyRadius))).value);
                }
            }
        };
        public static final BaseIntShader.Setter vc = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.Vc)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.Vc))).value);
                }
            }
        };
        public static final BaseIntShader.Setter velDir = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.VelDir)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.VelDir))).value);
                }
            }
        };
        public static final BaseIntShader.Setter hterms = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector4Attribute.Hterms)) {
                    float[] val = ((Vector4Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector4Attribute.Hterms))).value;
                    shader.set(inputID, val[0], val[1], val[2], val[3]);
                }
            }
        };
        public static final BaseIntShader.Setter gw = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.Gw)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.Gw))).value);
                }
            }
        };
        public static final BaseIntShader.Setter gwmat3 = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Matrix3Attribute.Gwmat3)) {
                    shader.set(inputID, ((Matrix3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Matrix3Attribute.Gwmat3))).value);
                }
            }
        };
        public static final BaseIntShader.Setter ts = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.Ts)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.Ts))).value);
                }
            }
        };
        public static final BaseIntShader.Setter omgw = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.Omgw)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.Omgw))).value);
                }
            }
        };
    }
}

