/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.environment.AmbientCubemap;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.ShadowMap;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.render.ShadowMapImpl;
import gaiasky.util.Bits;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.CascadeShadowMapAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRFloatAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRIridescenceAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRTextureAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRVolumeAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.lights.DirectionalShadowLight;
import gaiasky.util.gdx.shader.BaseIntShader;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.Attributes;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.CubemapAttribute;
import gaiasky.util.gdx.shader.attribute.DepthTestAttribute;
import gaiasky.util.gdx.shader.attribute.DirectionalLightsAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.IntAttribute;
import gaiasky.util.gdx.shader.attribute.OcclusionCloudsAttribute;
import gaiasky.util.gdx.shader.attribute.PointLightsAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.gdx.shader.attribute.Vector2Attribute;
import gaiasky.util.gdx.shader.attribute.Vector3Attribute;
import gaiasky.util.gdx.shader.loader.ShaderTemplatingLoader;
import gaiasky.util.gdx.shader.provider.ShaderProgramProvider;
import java.util.Objects;

public class DefaultIntShader
extends BaseIntShader {
    private static final Bits optionalAttributes = Bits.indices(IntAttribute.CullFace, DepthTestAttribute.Type);
    private static final Attributes tmpAttributes = new Attributes();
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;
    public final int u_projTrans;
    public final int u_projViewTrans;
    public final int u_cameraPosition;
    public final int u_cameraDirection;
    public final int u_cameraUp;
    public final int u_cameraNearFar;
    public final int u_cameraK;
    public final int u_time;
    public final int u_simuTime;
    public final int u_cameraPos;
    public final int u_vrScale;
    public final int u_vrOffset;
    public final int u_eclipseOutlines;
    public final int u_eclipsingBodyPos;
    public final int u_eclipsingBodyRadius;
    public final int u_worldTrans;
    public final int u_normalMatrix;
    public final int u_bones;
    public final int u_aoTexture;
    public final int u_opacity;
    public final int u_diffuseColor;
    public final int u_diffuseTexture;
    public final int u_specularColor;
    public final int u_specularTexture;
    public final int u_emissiveColor;
    public final int u_emissiveTexture;
    public final int u_metallicColor;
    public final int u_metallicTexture;
    public final int u_shininess;
    public final int u_roughnessColor;
    public final int u_roughnessTexture;
    public final int u_diffuseScatteringColor;
    public final int u_occlusionMetallicRoughnessTexture;
    public final int u_normalTexture;
    public final int u_heightTexture;
    public final int u_heightScale;
    public final int u_elevationMultiplier;
    public final int u_heightNoiseSize;
    public final int u_heightSize;
    public final int u_tessQuality;
    public final int u_bodySize;
    public final int u_alphaTest;
    public int u_ior;
    public int u_iridescenceFactor;
    public int u_iridescenceIOR;
    public int u_iridescenceThicknessMin;
    public int u_iridescenceThicknessMax;
    public int u_iridescenceTexture;
    public int u_iridescenceThicknessTexture;
    public int u_thicknessTexture;
    public int u_thicknessFactor;
    public int u_volumeDistance;
    public int u_volumeColor;
    protected final int u_reflectionCubemap;
    protected final int u_diffuseCubemap;
    protected final int u_normalCubemap;
    protected final int u_specularCubemap;
    protected final int u_emissiveCubemap;
    protected final int u_heightCubemap;
    protected final int u_roughnessCubemap;
    protected final int u_metallicCubemap;
    protected final int u_aoCubemap;
    protected final int u_svtTileSize;
    protected final int u_svtResolution;
    protected final int u_svtDepth;
    protected final int u_svtId;
    protected final int u_svtDetectionFactor;
    protected final int u_svtBufferTexture;
    protected final int u_svtIndirectionDiffuseTexture;
    protected final int u_svtIndirectionSpecularTexture;
    protected final int u_svtIndirectionNormalTexture;
    protected final int u_svtIndirectionHeightTexture;
    protected final int u_svtIndirectionEmissiveTexture;
    protected final int u_svtIndirectionMetallicTexture;
    protected final int u_svtIndirectionRoughnessTexture;
    protected final int u_svtIndirectionAoTexture;
    protected final int u_kmToU;
    protected final int u_generic1;
    protected final int u_generic2;
    protected final int u_texture0;
    protected final int u_texture1;
    public int[] u_csmTransforms = new int[10];
    public int[] u_csmSamplers = new int[10];
    public int[] u_csmClip = new int[10];
    public int u_csmPCF;
    protected final int u_ambientCubemap;
    protected final int u_dirLights0color;
    protected final int u_dirLights0direction;
    protected final int u_dirLights1color;
    protected final int u_pointLights0color;
    protected final int u_pointLights0position;
    protected final int u_pointLights0intensity;
    protected final int u_pointLights1color;
    protected final int u_fogColor;
    protected final int u_shadowMapProjViewTrans;
    protected final int u_shadowMapProjViewTransGlobal;
    protected final int u_shadowTexture;
    protected final int u_shadowTextureGlobal;
    protected final int u_shadowPCFOffset;
    protected final boolean lighting;
    protected final boolean shadowMap;
    protected final DirectionalLight[] directionalLights;
    protected final PointLight[] pointLights;
    protected final Bits attributesMask;
    protected final Config config;
    private final long vertexMask;
    protected int dirLightsLoc;
    protected int dirLightsColorOffset;
    protected int dirLightsDirectionOffset;
    protected int dirLightsSize;
    protected int pointLightsLoc;
    protected int pointLightsColorOffset;
    protected int pointLightsPositionOffset;
    protected int pointLightsIntensityOffset;
    protected int pointLightsSize;
    private IntRenderable renderable;
    private boolean lightsSet;

    public DefaultIntShader(IntRenderable renderable) {
        this(renderable, new Config());
    }

    public DefaultIntShader(IntRenderable renderable, Config config) {
        this(renderable, config, DefaultIntShader.createPrefix(renderable, config));
    }

    public DefaultIntShader(IntRenderable renderable, Config config, String prefix) {
        this(renderable, config, prefix, config.vertexShaderCode != null ? config.vertexShaderCode : DefaultIntShader.getDefaultVertexShader(), config.fragmentShaderCode != null ? config.fragmentShaderCode : DefaultIntShader.getDefaultFragmentShader());
    }

    public DefaultIntShader(IntRenderable renderable, Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ExtShaderProgram(ShaderProgramProvider.getShaderCode(prefix, vertexShader), ShaderProgramProvider.getShaderCode(prefix, fragmentShader)));
    }

    public DefaultIntShader(IntRenderable renderable, Config config, ExtShaderProgram shaderProgram) {
        int i;
        Attributes attributes = DefaultIntShader.combineAttributes(renderable);
        this.config = config;
        this.program = shaderProgram;
        this.lighting = renderable.environment != null;
        this.shadowMap = this.lighting && renderable.environment.shadowMap != null;
        this.renderable = renderable;
        this.attributesMask = attributes.getMask().copy().or(optionalAttributes);
        this.vertexMask = renderable.meshPart.mesh.getVertexAttributes().getMaskWithSizePacked();
        this.directionalLights = new DirectionalLight[this.lighting && config.numDirectionalLights > 0 ? config.numDirectionalLights : 0];
        for (i = 0; i < this.directionalLights.length; ++i) {
            this.directionalLights[i] = new DirectionalLight();
        }
        this.pointLights = new PointLight[this.lighting && config.numPointLights > 0 ? config.numPointLights : 0];
        for (i = 0; i < this.pointLights.length; ++i) {
            this.pointLights[i] = new PointLight();
        }
        this.u_dirLights0color = this.register(new BaseIntShader.Uniform("u_dirLights[0].color"));
        this.u_dirLights0direction = this.register(new BaseIntShader.Uniform("u_dirLights[0].direction"));
        this.u_dirLights1color = this.register(new BaseIntShader.Uniform("u_dirLights[1].color"));
        this.u_pointLights0color = this.register(new BaseIntShader.Uniform("u_pointLights[0].color"));
        this.u_pointLights0position = this.register(new BaseIntShader.Uniform("u_pointLights[0].position"));
        this.u_pointLights0intensity = this.register(new BaseIntShader.Uniform("u_pointLights[0].intensity"));
        this.u_pointLights1color = this.register(new BaseIntShader.Uniform("u_pointLights[1].color"));
        this.u_fogColor = this.register(new BaseIntShader.Uniform("u_fogColor"));
        this.u_shadowMapProjViewTrans = this.register(new BaseIntShader.Uniform("u_shadowMapProjViewTrans"));
        this.u_shadowTexture = this.register(new BaseIntShader.Uniform("u_shadowTexture"));
        this.u_shadowMapProjViewTransGlobal = this.register(new BaseIntShader.Uniform("u_shadowMapProjViewTransGlobal"));
        this.u_shadowTextureGlobal = this.register(new BaseIntShader.Uniform("u_shadowTextureGlobal"));
        this.u_shadowPCFOffset = this.register(new BaseIntShader.Uniform("u_shadowPCFOffset"));
        for (i = 0; i < 10; ++i) {
            this.u_csmTransforms[i] = this.register(new BaseIntShader.Uniform("u_csmTransforms[" + i + "]"));
        }
        for (i = 0; i < 10; ++i) {
            this.u_csmSamplers[i] = this.register(new BaseIntShader.Uniform("u_csmSamplers[" + i + "]"));
        }
        for (i = 0; i < 10; ++i) {
            this.u_csmClip[i] = this.register(new BaseIntShader.Uniform("u_csmClip[" + i + "]"));
        }
        this.u_csmPCF = this.register(new BaseIntShader.Uniform("u_csmPCF"));
        this.u_projTrans = this.register(Inputs.projTrans, Setters.projTrans);
        this.u_projViewTrans = this.register(Inputs.projViewTrans, Setters.projViewTrans);
        this.u_cameraPosition = this.register(Inputs.cameraPosition, Setters.cameraPosition);
        this.u_cameraDirection = this.register(Inputs.cameraDirection, Setters.cameraDirection);
        this.u_cameraUp = this.register(Inputs.cameraUp, Setters.cameraUp);
        this.u_cameraNearFar = this.register(Inputs.cameraNearFar, Setters.cameraNearFar);
        this.u_cameraK = this.register(Inputs.cameraK, Setters.cameraK);
        this.u_time = this.register(Inputs.time, Setters.time);
        this.u_simuTime = this.register(Inputs.simuTime, Setters.simuTime);
        this.u_vrScale = this.register(Inputs.vrScale, Setters.vrScale);
        this.u_vrOffset = this.register(Inputs.vrOffset, Setters.vrOffset);
        this.u_cameraPos = this.register(Inputs.cameraPos, Setters.cameraPos);
        this.u_eclipseOutlines = this.register(Inputs.eclipseOutlines, Setters.eclipseOutlines);
        this.u_eclipsingBodyPos = this.register(Inputs.eclipsingBodyPos, Setters.eclipsingBodyPos);
        this.u_eclipsingBodyRadius = this.register(Inputs.eclipsingBodyRadius, Setters.eclipsingBodyRadius);
        this.u_worldTrans = this.register(Inputs.worldTrans, Setters.worldTrans);
        this.u_normalMatrix = this.register(Inputs.normalMatrix, Setters.normalMatrix);
        this.u_bones = renderable.bones != null && config.numBones > 0 ? this.register(Inputs.bones, (BaseIntShader.Setter)new Setters.Bones(config.numBones)) : -1;
        this.u_aoTexture = this.register(Inputs.aoTexture, Setters.aoTexture);
        this.u_opacity = this.register(Inputs.opacity);
        this.u_diffuseColor = this.register(Inputs.diffuseColor, Setters.diffuseColor);
        this.u_diffuseTexture = this.register(Inputs.diffuseTexture, Setters.diffuseTexture);
        this.u_specularColor = this.register(Inputs.specularColor, Setters.specularColor);
        this.u_specularTexture = this.register(Inputs.specularTexture, Setters.specularTexture);
        this.u_emissiveColor = this.register(Inputs.emissiveColor, Setters.emissiveColor);
        this.u_emissiveTexture = this.register(Inputs.emissiveTexture, Setters.emissiveTexture);
        this.u_metallicColor = this.register(Inputs.metallicColor, Setters.metallicColor);
        this.u_metallicTexture = this.register(Inputs.metallicTexture, Setters.metallicTexture);
        this.u_shininess = this.register(Inputs.shininess, Setters.shininess);
        this.u_roughnessColor = this.register(Inputs.roughnessColor, Setters.roughnessColor);
        this.u_roughnessTexture = this.register(Inputs.roughnessTexture, Setters.roughnessTexture);
        this.u_diffuseScatteringColor = this.register(Inputs.diffuseScatteringColor, Setters.diffuseScatteringColor);
        this.u_occlusionMetallicRoughnessTexture = this.register(Inputs.occlusionMetallicRoughnessTexture, Setters.occlusionMetallicRoughnessTexture);
        this.u_normalTexture = this.register(Inputs.normalTexture, Setters.normalTexture);
        this.u_heightTexture = this.register(Inputs.heightTexture, Setters.heightTexture);
        this.u_heightScale = this.register(Inputs.heightScale, Setters.heightScale);
        this.u_elevationMultiplier = this.register(Inputs.elevationMultiplier, Setters.elevationMultiplier);
        this.u_heightNoiseSize = this.register(Inputs.heightNoiseSize, Setters.heightNoiseSize);
        this.u_heightSize = this.register(Inputs.heightSize, Setters.heightSize);
        this.u_tessQuality = this.register(Inputs.tessQuality, Setters.tessQuality);
        this.u_bodySize = this.register(Inputs.bodySize, Setters.bodySize);
        this.u_alphaTest = this.register(Inputs.alphaTest);
        this.u_ambientCubemap = this.lighting ? this.register(Inputs.ambientCube, (BaseIntShader.Setter)new Setters.ACubemap(config.numDirectionalLights, config.numPointLights)) : -1;
        this.u_reflectionCubemap = this.register(Inputs.reflectionCubemap, Setters.reflectionCubemap);
        this.u_diffuseCubemap = this.register(Inputs.diffuseCubemap, Setters.diffuseCubemap);
        this.u_normalCubemap = this.register(Inputs.normalCubemap, Setters.normalCubemap);
        this.u_specularCubemap = this.register(Inputs.specularCubemap, Setters.specularCubemap);
        this.u_emissiveCubemap = this.register(Inputs.emissiveCubemap, Setters.emissiveCubemap);
        this.u_heightCubemap = this.register(Inputs.heightCubemap, Setters.heightCubemap);
        this.u_roughnessCubemap = this.register(Inputs.roughnessCubemap, Setters.roughnessCubemap);
        this.u_metallicCubemap = this.register(Inputs.metallicCubemap, Setters.metallicCubemap);
        this.u_aoCubemap = this.register(Inputs.aoCubemap, Setters.aoCubemap);
        this.u_svtTileSize = this.register(Inputs.svtTileSize, Setters.svtTileSize);
        this.u_svtResolution = this.register(Inputs.svtResolution, Setters.svtResolution);
        this.u_svtDepth = this.register(Inputs.svtDepth, Setters.svtDepth);
        this.u_iridescenceFactor = this.register(Inputs.iridescenceFactorUniform, Setters.iridescenceFactorSetter);
        this.u_iridescenceIOR = this.register(Inputs.iridescenceIORUniform, Setters.iridescenceIORSetter);
        this.u_iridescenceThicknessMin = this.register(Inputs.iridescenceThicknessMinUniform, Setters.iridescenceThicknessMinSetter);
        this.u_iridescenceThicknessMax = this.register(Inputs.iridescenceThicknessMaxUniform, Setters.iridescenceThicknessMaxSetter);
        this.u_iridescenceTexture = this.register(Inputs.iridescenceTextureUniform, Setters.iridescenceTextureSetter);
        this.u_iridescenceThicknessTexture = this.register(Inputs.iridescenceThicknessTextureUniform, Setters.iridescenceThicknessTextureSetter);
        this.u_ior = this.register(Inputs.iorUniform, Setters.iorSetter);
        this.u_thicknessFactor = this.register(Inputs.thicknessFactorUniform, Setters.thicknessFactorSetter);
        this.u_volumeDistance = this.register(Inputs.volumeDistanceUniform, Setters.volumeDistanceSetter);
        this.u_volumeColor = this.register(Inputs.volumeColorUniform, Setters.volumeColorSetter);
        this.u_thicknessTexture = this.register(Inputs.thicknessTextureUniform, Setters.thicknessTextureSetter);
        this.u_svtId = this.register(Inputs.svtId, Setters.svtId);
        this.u_svtDetectionFactor = this.register(Inputs.svtDetectionFactor, Setters.svtDetectionFactor);
        this.u_svtBufferTexture = this.register(Inputs.svtCacheTexture, Setters.svtBufferTexture);
        this.u_svtIndirectionDiffuseTexture = this.register(Inputs.svtIndirectionDiffuseTexture, Setters.svtIndirectionDiffuseTexture);
        this.u_svtIndirectionNormalTexture = this.register(Inputs.svtIndirectionNormalTexture, Setters.svtIndirectionNormalTexture);
        this.u_svtIndirectionSpecularTexture = this.register(Inputs.svtIndirectionSpecularTexture, Setters.svtIndirectionSpecularTexture);
        this.u_svtIndirectionHeightTexture = this.register(Inputs.svtIndirectionHeightTexture, Setters.svtIndirectionHeightTexture);
        this.u_svtIndirectionMetallicTexture = this.register(Inputs.svtIndirectionMetallicTexture, Setters.svtIndirectionMetallicTexture);
        this.u_svtIndirectionEmissiveTexture = this.register(Inputs.svtIndirectionEmissiveTexture, Setters.svtIndirectionEmissiveTexture);
        this.u_svtIndirectionRoughnessTexture = this.register(Inputs.svtIndirectionRoughnessTexture, Setters.svtIndirectionRoughnessTexture);
        this.u_svtIndirectionAoTexture = this.register(Inputs.svtIndirectionAoTexture, Setters.svtIndirectionAoTexture);
        this.u_kmToU = this.register(Inputs.kmToU, Setters.kmToU);
        this.u_generic1 = this.register(Inputs.generic1, Setters.generic1);
        this.u_generic2 = this.register(Inputs.generic2, Setters.generic2);
        this.u_texture0 = this.register(Inputs.texture0, Setters.texture0);
        this.u_texture1 = this.register(Inputs.texture1, Setters.texture1);
    }

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = ShaderTemplatingLoader.load(Gdx.files.internal("shader/pbr.vertex.glsl"));
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = ShaderTemplatingLoader.load(Gdx.files.internal("shader/pbr.fragment.glsl"));
        }
        return defaultFragmentShader;
    }

    private static boolean and(long mask, long flag) {
        return (mask & flag) == flag;
    }

    private static boolean or(long mask, long flag) {
        return (mask & flag) != 0L;
    }

    private static Attributes combineAttributes(IntRenderable renderable) {
        tmpAttributes.clear();
        if (renderable.environment != null) {
            tmpAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            tmpAttributes.set(renderable.material);
        }
        return tmpAttributes;
    }

    private static Bits combineAttributeMasks(IntRenderable renderable) {
        Bits mask = Bits.empty();
        if (renderable.environment != null) {
            mask.or(renderable.environment.getMask());
        }
        if (renderable.material != null) {
            mask.or(renderable.material.getMask());
        }
        return mask;
    }

    public static String createPrefix(IntRenderable renderable, Config config) {
        Attributes attributes = DefaultIntShader.combineAttributes(renderable);
        StringBuilder prefix = new StringBuilder();
        long vertexMask = renderable.meshPart.mesh.getVertexAttributes().getMask();
        if (DefaultIntShader.and(vertexMask, 1L)) {
            prefix.append("#define positionFlag\n");
        }
        if (DefaultIntShader.or(vertexMask, 6L)) {
            prefix.append("#define colorFlag\n");
        }
        if (DefaultIntShader.and(vertexMask, 256L)) {
            prefix.append("#define binormalFlag\n");
        }
        if (DefaultIntShader.and(vertexMask, 128L)) {
            prefix.append("#define tangentFlag\n");
        }
        if (DefaultIntShader.and(vertexMask, 8L)) {
            prefix.append("#define normalFlag\n");
        }
        if ((DefaultIntShader.and(vertexMask, 8L) || DefaultIntShader.and(vertexMask, 384L)) && renderable.environment != null) {
            prefix.append("#define lightingFlag\n");
            prefix.append("#define ambientCubemapFlag\n");
            prefix.append("#define numDirectionalLights ").append(config.numDirectionalLights).append("\n");
            prefix.append("#define numPointLights ").append(config.numPointLights).append("\n");
            prefix.append("#define numSpotLights ").append(config.numSpotLights).append("\n");
            if (attributes.has(ColorAttribute.Fog)) {
                prefix.append("#define fogFlag\n");
            }
            if (renderable.environment.shadowMap != null) {
                ShadowMapImpl smi;
                prefix.append("#define shadowMapFlag\n");
                ShadowMap shadowMap = renderable.environment.shadowMap;
                if (shadowMap instanceof ShadowMapImpl && (smi = (ShadowMapImpl)shadowMap).getProjViewTransGlobal() != null) {
                    prefix.append("#define shadowMapGlobalFlag\n");
                }
            }
            if (renderable.environment.has(CascadeShadowMapAttribute.Type)) {
                CascadeShadowMapAttribute csm = renderable.environment.get(CascadeShadowMapAttribute.class, CascadeShadowMapAttribute.Type);
                prefix.append("#define numCSM ").append(csm.cascadeShadowMap.lights.size).append("\n");
            }
        }
        if (attributes.has(Vector3Attribute.EclipsingBodyPos)) {
            prefix.append("#define eclipsingBodyFlag\n");
            if (attributes.has(IntAttribute.EclipseOutlines)) {
                prefix.append("#define eclipseOutlines\n");
            }
        }
        int n = renderable.meshPart.mesh.getVertexAttributes().size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = renderable.meshPart.mesh.getVertexAttributes().get(i);
            if (attr.usage == 64) {
                prefix.append("#define boneWeight").append(attr.unit).append("Flag\n");
                continue;
            }
            if (attr.usage != 16) continue;
            prefix.append("#define texCoord").append(attr.unit).append("Flag\n");
        }
        if (attributes.has(BlendingAttribute.Type)) {
            prefix.append("#define blendedFlag\n");
        }
        if (attributes.has(TextureAttribute.Diffuse)) {
            prefix.append("#define diffuseTextureFlag\n");
        }
        if (attributes.has(TextureAttribute.Specular)) {
            prefix.append("#define specularTextureFlag\n");
        }
        if (attributes.has(TextureAttribute.Normal)) {
            prefix.append("#define normalTextureFlag\n");
        }
        if (attributes.has(TextureAttribute.Emissive)) {
            prefix.append("#define emissiveTextureFlag\n");
        }
        if (attributes.has(TextureAttribute.Metallic)) {
            prefix.append("#define metallicTextureFlag\n");
        }
        if (attributes.has(TextureAttribute.Height)) {
            prefix.append("#define heightTextureFlag\n");
        }
        if (attributes.has(TextureAttribute.AO)) {
            prefix.append("#define AOTextureFlag\n");
        }
        if (attributes.has(TextureAttribute.Roughness)) {
            prefix.append("#define roughnessTextureFlag\n");
        }
        if (attributes.has(TextureAttribute.OcclusionMetallicRoughness)) {
            prefix.append("#define occlusionMetallicRoughnessTextureFlag\n");
        }
        if (attributes.has(FloatAttribute.Time)) {
            prefix.append("#define timeFlag\n");
        }
        if (attributes.has(FloatAttribute.SimuTime)) {
            prefix.append("#define simuTimeFlag\n");
        }
        if (attributes.has(FloatAttribute.HeightNoiseSize)) {
            prefix.append("#define heightFlag\n");
        }
        if (Settings.settings.scene.renderer.elevation.type.isParallaxMapping()) {
            prefix.append("#define parallaxMappingFlag\n");
        } else if (Settings.settings.scene.renderer.elevation.type.isNone()) {
            prefix.append("#define noHeightFlag\n");
        }
        if (attributes.has(TextureAttribute.Ambient)) {
            prefix.append("#define ambientTextureFlag\n");
        }
        if (attributes.has(ColorAttribute.Diffuse)) {
            prefix.append("#define diffuseColorFlag\n");
        }
        if (attributes.has(ColorAttribute.Specular)) {
            prefix.append("#define specularColorFlag\n");
        }
        if (attributes.has(ColorAttribute.Emissive)) {
            prefix.append("#define emissiveColorFlag\n");
        }
        if (attributes.has(ColorAttribute.Metallic)) {
            prefix.append("#define metallicColorFlag\n");
        }
        if (attributes.has(ColorAttribute.Roughness)) {
            prefix.append("#define roughnessColorFlag\n");
        }
        if (attributes.has(ColorAttribute.DiffuseScattering)) {
            prefix.append("#define diffuseScatteringColorFlag\n");
        }
        if (attributes.has(FloatAttribute.AlphaTest)) {
            prefix.append("#define alphaTestFlag\n");
        }
        if (attributes.has(FloatAttribute.Shininess)) {
            prefix.append("#define shininessFlag\n");
        }
        if (attributes.has(ColorAttribute.Metallic) || attributes.has(TextureAttribute.Metallic)) {
            prefix.append("#define metallicFlag\n");
            if (attributes.has(CubemapAttribute.ReflectionCubemap)) {
                prefix.append("#define reflectionCubemapFlag\n");
            }
        }
        if (attributes.has(PBRIridescenceAttribute.Type)) {
            prefix.append("#define iridescenceFlag\n");
        }
        if (attributes.has(PBRTextureAttribute.IridescenceTexture)) {
            prefix.append("#define iridescenceTextureFlag\n");
        }
        if (attributes.has(PBRTextureAttribute.IridescenceThicknessTexture)) {
            prefix.append("#define iridescenceThicknessTextureFlag\n");
        }
        if (attributes.has(PBRVolumeAttribute.Type)) {
            prefix.append("#define volumeFlag\n");
        }
        if (attributes.has(PBRTextureAttribute.ThicknessTexture)) {
            prefix.append("#define thicknessTextureFlag\n");
        }
        if (attributes.has(PBRFloatAttribute.IOR)) {
            prefix.append("#define iorFlag\n");
        }
        if (Settings.settings.postprocess.ssr.active) {
            prefix.append("#define ssrFlag\n");
        }
        boolean cubemap = false;
        if (attributes.has(CubemapAttribute.DiffuseCubemap)) {
            prefix.append("#define diffuseCubemapFlag\n");
            cubemap = true;
        }
        if (attributes.has(CubemapAttribute.NormalCubemap)) {
            prefix.append("#define normalCubemapFlag\n");
            cubemap = true;
        }
        if (attributes.has(CubemapAttribute.SpecularCubemap)) {
            prefix.append("#define specularCubemapFlag\n");
            cubemap = true;
        }
        if (attributes.has(CubemapAttribute.EmissiveCubemap)) {
            prefix.append("#define emissiveCubemapFlag\n");
            cubemap = true;
        }
        if (attributes.has(CubemapAttribute.MetallicCubemap)) {
            prefix.append("#define metallicCubemapFlag\n");
            cubemap = true;
        }
        if (attributes.has(CubemapAttribute.AmbientOcclusionCubemap)) {
            prefix.append("#define aoCubemapFlag\n");
            cubemap = true;
        }
        if (attributes.has(CubemapAttribute.RoughnessCubemap)) {
            prefix.append("#define roughnessCubemapFlag\n");
            cubemap = true;
        }
        if (attributes.has(CubemapAttribute.HeightCubemap)) {
            prefix.append("#define heightCubemapFlag\n");
            cubemap = true;
        }
        if (cubemap) {
            prefix.append("#define cubemapFlag\n");
        }
        if (attributes.has(OcclusionCloudsAttribute.Type)) {
            prefix.append("#define occlusionCloudsFlag\n");
        }
        boolean svtCache = false;
        boolean svtIndirection = false;
        if (attributes.has(TextureAttribute.SvtCache)) {
            prefix.append("#define svtCacheTextureFlag\n");
            svtCache = true;
        }
        if (attributes.has(TextureAttribute.SvtIndirectionDiffuse)) {
            prefix.append("#define svtIndirectionDiffuseTextureFlag\n");
            svtIndirection = true;
        }
        if (attributes.has(TextureAttribute.SvtIndirectionNormal)) {
            prefix.append("#define svtIndirectionNormalTextureFlag\n");
            svtIndirection = true;
        }
        if (attributes.has(TextureAttribute.SvtIndirectionSpecular)) {
            prefix.append("#define svtIndirectionSpecularTextureFlag\n");
            svtIndirection = true;
        }
        if (attributes.has(TextureAttribute.SvtIndirectionHeight)) {
            prefix.append("#define svtIndirectionHeightTextureFlag\n");
            svtIndirection = true;
        }
        if (attributes.has(TextureAttribute.SvtIndirectionEmissive)) {
            prefix.append("#define svtIndirectionEmissiveTextureFlag\n");
            svtIndirection = true;
        }
        if (attributes.has(TextureAttribute.SvtIndirectionMetallic)) {
            prefix.append("#define svtIndirectionMetallicTextureFlag\n");
            svtIndirection = true;
        }
        if (attributes.has(TextureAttribute.SvtIndirectionRoughness)) {
            prefix.append("#define svtIndirectionRoughnessTextureFlag\n");
            svtIndirection = true;
        }
        if (attributes.has(TextureAttribute.SvtIndirectionAmbientOcclusion)) {
            prefix.append("#define svtIndirectionAoTextureFlag\n");
            svtIndirection = true;
        }
        if (svtCache && svtIndirection && attributes.has(FloatAttribute.SvtId) && attributes.has(FloatAttribute.SvtDepth) && attributes.has(FloatAttribute.SvtTileSize) && attributes.has(Vector2Attribute.SvtResolution)) {
            prefix.append("#define svtFlag\n");
        }
        if (renderable.bones != null && config.numBones > 0) {
            prefix.append("#define numBones ").append(config.numBones).append("\n");
        }
        return prefix.toString();
    }

    @Override
    public void init() {
        ExtShaderProgram program = this.program;
        this.program = null;
        this.init(program, this.renderable);
        this.renderable = null;
        this.dirLightsLoc = this.loc(this.u_dirLights0color);
        this.dirLightsColorOffset = this.loc(this.u_dirLights0color) - this.dirLightsLoc;
        this.dirLightsDirectionOffset = this.loc(this.u_dirLights0direction) - this.dirLightsLoc;
        this.dirLightsSize = this.loc(this.u_dirLights1color) - this.dirLightsLoc;
        if (this.dirLightsSize < 0) {
            this.dirLightsSize = 0;
        }
        this.pointLightsLoc = this.loc(this.u_pointLights0color);
        this.pointLightsColorOffset = this.loc(this.u_pointLights0color) - this.pointLightsLoc;
        this.pointLightsPositionOffset = this.loc(this.u_pointLights0position) - this.pointLightsLoc;
        this.pointLightsIntensityOffset = this.has(this.u_pointLights0intensity) ? this.loc(this.u_pointLights0intensity) - this.pointLightsLoc : -1;
        this.pointLightsSize = this.loc(this.u_pointLights1color) - this.pointLightsLoc;
        if (this.pointLightsSize < 0) {
            this.pointLightsSize = 0;
        }
    }

    @Override
    public boolean canRender(IntRenderable renderable) {
        Bits renderableMask = DefaultIntShader.combineAttributeMasks(renderable);
        return this.attributesMask.equals(renderableMask.or(optionalAttributes)) && this.vertexMask == renderable.meshPart.mesh.getVertexAttributes().getMaskWithSizePacked() && renderable.environment != null == this.lighting;
    }

    @Override
    public int compareTo(IntShader other) {
        if (other == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultIntShader && this.equals((DefaultIntShader)obj);
    }

    public boolean equals(DefaultIntShader obj) {
        return obj == this;
    }

    @Override
    public void begin(Camera camera, RenderContext context) {
        super.begin(camera, context);
        for (DirectionalLight directionalLight : this.directionalLights) {
            directionalLight.set(0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        }
        for (DirectionalLight directionalLight : this.pointLights) {
            directionalLight.set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.lightsSet = false;
        if (this.has(this.u_time)) {
            float time = (float)GaiaSky.instance.getT();
            this.set(this.u_time, time);
        }
        if (this.has(this.u_simuTime)) {
            float time = (float)(GaiaSky.instance.time.getTimeSeconds() % 10000.0);
            this.set(this.u_simuTime, time);
        }
    }

    @Override
    public void render(IntRenderable renderable, Attributes combinedAttributes) {
        if (!combinedAttributes.has(BlendingAttribute.Type)) {
            this.context.setBlending(false, 770, 771);
        }
        this.bindMaterial(combinedAttributes);
        if (this.lighting) {
            this.bindLights(renderable, combinedAttributes);
        }
        super.render(renderable, combinedAttributes);
    }

    @Override
    public void end() {
        super.end();
    }

    protected void bindMaterial(Attributes attributes) {
        int cullFace = this.config.defaultCullFace;
        int depthFunc = this.config.defaultDepthFunc;
        float depthRangeNear = 0.0f;
        float depthRangeFar = 1.0f;
        boolean depthMask = true;
        for (Attribute attr : attributes) {
            if (BlendingAttribute.is(attr.index)) {
                this.context.setBlending(true, ((BlendingAttribute)attr).sourceFunction, ((BlendingAttribute)attr).destFunction);
                this.set(this.u_opacity, ((BlendingAttribute)attr).opacity);
                continue;
            }
            if (attr.has(IntAttribute.CullFace)) {
                cullFace = ((IntAttribute)attr).value;
                continue;
            }
            if (attr.has(FloatAttribute.AlphaTest)) {
                this.set(this.u_alphaTest, ((FloatAttribute)attr).value);
                continue;
            }
            if (!attr.has(DepthTestAttribute.Type)) continue;
            DepthTestAttribute dta = (DepthTestAttribute)attr;
            depthFunc = dta.depthFunc;
            depthRangeNear = dta.depthRangeNear;
            depthRangeFar = dta.depthRangeFar;
            depthMask = dta.depthMask;
        }
        this.context.setCullFace(cullFace);
        this.context.setDepthTest(depthFunc, depthRangeNear, depthRangeFar);
        this.context.setDepthMask(depthMask);
    }

    private void cull(int face) {
        if (face == 1028 || face == 1029 || face == 1032) {
            Gdx.gl.glEnable(2884);
            Gdx.gl.glCullFace(face);
        } else {
            Gdx.gl.glDisable(2884);
        }
    }

    protected void bindLights(IntRenderable renderable, Attributes attributes) {
        CascadeShadowMapAttribute csmAttrib;
        int idx;
        int i;
        Array<PointLight> points;
        Environment lights = renderable.environment;
        DirectionalLightsAttribute dla = attributes.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        Array<DirectionalLight> dirs = dla == null ? null : dla.lights;
        PointLightsAttribute pla = attributes.get(PointLightsAttribute.class, PointLightsAttribute.Type);
        Array<PointLight> array = points = pla == null ? null : pla.lights;
        if (this.dirLightsLoc >= 0) {
            for (i = 0; i < this.directionalLights.length; ++i) {
                if (dirs == null || i >= dirs.size) {
                    if (this.lightsSet && this.directionalLights[i].color.r == 0.0f && this.directionalLights[i].color.g == 0.0f && this.directionalLights[i].color.b == 0.0f) continue;
                    this.directionalLights[i].color.set(0.0f, 0.0f, 0.0f, 1.0f);
                } else {
                    if (this.lightsSet && this.directionalLights[i].equals((DirectionalLight)dirs.get(i))) continue;
                    this.directionalLights[i].set((DirectionalLight)dirs.get(i));
                }
                idx = this.dirLightsLoc + i * this.dirLightsSize;
                this.program.setUniformf(idx + this.dirLightsColorOffset, this.directionalLights[i].color.r, this.directionalLights[i].color.g, this.directionalLights[i].color.b);
                this.program.setUniformf(idx + this.dirLightsDirectionOffset, this.directionalLights[i].direction.x, this.directionalLights[i].direction.y, this.directionalLights[i].direction.z);
                if (this.dirLightsSize <= 0) break;
            }
        }
        if (this.pointLightsLoc >= 0) {
            for (i = 0; i < this.pointLights.length; ++i) {
                if (points == null || i >= points.size) {
                    if (this.lightsSet && this.pointLights[i].intensity == 0.0f) continue;
                    this.pointLights[i].intensity = 0.0f;
                } else {
                    if (this.lightsSet && this.pointLights[i].equals((PointLight)points.get(i))) continue;
                    this.pointLights[i].set((PointLight)points.get(i));
                }
                idx = this.pointLightsLoc + i * this.pointLightsSize;
                this.program.setUniformf(idx + this.pointLightsColorOffset, this.pointLights[i].color.r * this.pointLights[i].intensity, this.pointLights[i].color.g * this.pointLights[i].intensity, this.pointLights[i].color.b * this.pointLights[i].intensity);
                this.program.setUniformf(idx + this.pointLightsPositionOffset, this.pointLights[i].position.x, this.pointLights[i].position.y, this.pointLights[i].position.z);
                if (this.pointLightsIntensityOffset >= 0) {
                    this.program.setUniformf(idx + this.pointLightsIntensityOffset, this.pointLights[i].intensity);
                }
                if (this.pointLightsSize <= 0) break;
            }
        }
        if (attributes.has(ColorAttribute.Fog)) {
            this.set(this.u_fogColor, ((ColorAttribute)Objects.requireNonNull(attributes.get((int)ColorAttribute.Fog))).color);
        }
        if (lights != null && lights.shadowMap != null) {
            ShadowMapImpl smi;
            ShadowMap sm = lights.shadowMap;
            this.set(this.u_shadowMapProjViewTrans, sm.getProjViewTrans());
            this.set(this.u_shadowTexture, sm.getDepthMap());
            if (sm instanceof ShadowMapImpl && (smi = (ShadowMapImpl)sm).getProjViewTransGlobal() != null) {
                this.set(this.u_shadowMapProjViewTransGlobal, smi.getProjViewTransGlobal());
                this.set(this.u_shadowTextureGlobal, smi.getDepthMapGlobal());
            }
            this.set(this.u_shadowPCFOffset, 1.0f / (2.0f * (float)lights.shadowMap.getDepthMap().texture.getWidth()));
        }
        if ((csmAttrib = attributes.get(CascadeShadowMapAttribute.class, CascadeShadowMapAttribute.Type)) != null) {
            double near = csmAttrib.cascadeShadowMap.CAM_NEAR_CSM;
            double far = csmAttrib.cascadeShadowMap.CAM_FAR_CSM;
            double farNear = far - near;
            if (this.u_csmSamplers[0] >= 0) {
                Array<DirectionalShadowLight> csmLights = csmAttrib.cascadeShadowMap.lights;
                for (int i2 = 0; i2 < csmLights.size; ++i2) {
                    DirectionalShadowLight light = (DirectionalShadowLight)((Object)csmLights.get(i2));
                    double splitDistCam = near + farNear * csmAttrib.cascadeShadowMap.getSplitDistance(i2);
                    int unit = this.context.textureBinder.bind(light.getDepthMap());
                    this.set(this.u_csmTransforms[i2], light.getProjViewTrans());
                    this.set(this.u_csmSamplers[i2], unit);
                    this.set(this.u_csmClip[i2], (float)splitDistCam);
                }
                float pcf = 1.0f / (2.0f * (float)((DirectionalShadowLight)((Object)csmLights.get((int)0))).getDepthMap().texture.getWidth());
                this.set(this.u_csmPCF, pcf);
            }
        }
        this.lightsSet = true;
    }

    @Override
    public void dispose() {
        this.program.dispose();
        super.dispose();
    }

    public int getDefaultCullFace() {
        return this.config.defaultCullFace;
    }

    public void setDefaultCullFace(int cullFace) {
        this.config.defaultCullFace = cullFace;
    }

    public int getDefaultDepthFunc() {
        return this.config.defaultDepthFunc;
    }

    public void setDefaultDepthFunc(int depthFunc) {
        this.config.defaultDepthFunc = depthFunc;
    }

    public static class Config {
        public String vertexShaderFile = null;
        public String fragmentShaderFile = null;
        public String vertexShaderCode = null;
        public String fragmentShaderCode = null;
        public int numDirectionalLights = 3;
        public int numPointLights = 3;
        public int numSpotLights = 0;
        public int numBones = 0;
        public int defaultCullFace = 1029;
        public int defaultDepthFunc = 515;

        public Config() {
        }

        public Config(String vertexShaderFile, String fragmentShaderFile, String vertexShaderCode, String fragmentShaderCode) {
            this.vertexShaderFile = vertexShaderFile;
            this.fragmentShaderFile = fragmentShaderFile;
            this.vertexShaderCode = vertexShaderCode;
            this.fragmentShaderCode = fragmentShaderCode;
        }

        public Config(String vertexShaderCode, String fragmentShaderCode) {
            this(null, null, vertexShaderCode, fragmentShaderCode);
        }
    }

    public static class Inputs {
        public static final BaseIntShader.Uniform projTrans = new BaseIntShader.Uniform("u_projTrans");
        public static final BaseIntShader.Uniform viewTrans = new BaseIntShader.Uniform("u_viewTrans");
        public static final BaseIntShader.Uniform projViewTrans = new BaseIntShader.Uniform("u_projViewTrans");
        public static final BaseIntShader.Uniform cameraPosition = new BaseIntShader.Uniform("u_cameraPosition");
        public static final BaseIntShader.Uniform cameraDirection = new BaseIntShader.Uniform("u_cameraDirection");
        public static final BaseIntShader.Uniform cameraUp = new BaseIntShader.Uniform("u_cameraUp");
        public static final BaseIntShader.Uniform cameraNearFar = new BaseIntShader.Uniform("u_cameraNearFar");
        public static final BaseIntShader.Uniform cameraK = new BaseIntShader.Uniform("u_cameraK");
        public static final BaseIntShader.Uniform vrScale = new BaseIntShader.Uniform("u_vrScale");
        public static final BaseIntShader.Uniform vrOffset = new BaseIntShader.Uniform("u_vrOffset");
        public static final BaseIntShader.Uniform worldTrans = new BaseIntShader.Uniform("u_worldTrans");
        public static final BaseIntShader.Uniform normalMatrix = new BaseIntShader.Uniform("u_normalMatrix");
        public static final BaseIntShader.Uniform bones = new BaseIntShader.Uniform("u_bones");
        public static final BaseIntShader.Uniform cameraPos = new BaseIntShader.Uniform("u_cameraPos", Vector3Attribute.CameraPos);
        public static final BaseIntShader.Uniform eclipseOutlines = new BaseIntShader.Uniform("u_eclipseOutlines", IntAttribute.EclipseOutlines);
        public static final BaseIntShader.Uniform eclipsingBodyPos = new BaseIntShader.Uniform("u_eclipsingBodyPos", Vector3Attribute.EclipsingBodyPos);
        public static final BaseIntShader.Uniform eclipsingBodyRadius = new BaseIntShader.Uniform("u_eclipsingBodyRadius", FloatAttribute.EclipsingBodyRadius);
        public static final BaseIntShader.Uniform opacity = new BaseIntShader.Uniform("u_opacity", BlendingAttribute.Type);
        public static final BaseIntShader.Uniform aoTexture = new BaseIntShader.Uniform("u_aoTexture", TextureAttribute.AO);
        public static final BaseIntShader.Uniform diffuseColor = new BaseIntShader.Uniform("u_diffuseColor", ColorAttribute.Diffuse);
        public static final BaseIntShader.Uniform diffuseTexture = new BaseIntShader.Uniform("u_diffuseTexture", TextureAttribute.Diffuse);
        public static final BaseIntShader.Uniform specularColor = new BaseIntShader.Uniform("u_specularColor", ColorAttribute.Specular);
        public static final BaseIntShader.Uniform specularTexture = new BaseIntShader.Uniform("u_specularTexture", TextureAttribute.Specular);
        public static final BaseIntShader.Uniform emissiveColor = new BaseIntShader.Uniform("u_emissiveColor", ColorAttribute.Emissive);
        public static final BaseIntShader.Uniform emissiveTexture = new BaseIntShader.Uniform("u_emissiveTexture", TextureAttribute.Emissive);
        public static final BaseIntShader.Uniform metallicColor = new BaseIntShader.Uniform("u_metallicColor", ColorAttribute.Metallic);
        public static final BaseIntShader.Uniform metallicTexture = new BaseIntShader.Uniform("u_metallicTexture", TextureAttribute.Metallic);
        public static final BaseIntShader.Uniform shininess = new BaseIntShader.Uniform("u_shininess", FloatAttribute.Shininess);
        public static final BaseIntShader.Uniform roughnessColor = new BaseIntShader.Uniform("u_roughnessColor", ColorAttribute.Roughness);
        public static final BaseIntShader.Uniform roughnessTexture = new BaseIntShader.Uniform("u_roughnessTexture", TextureAttribute.Roughness);
        public static final BaseIntShader.Uniform diffuseScatteringColor = new BaseIntShader.Uniform("u_diffuseScatteringColor", ColorAttribute.DiffuseScattering);
        public static final BaseIntShader.Uniform occlusionMetallicRoughnessTexture = new BaseIntShader.Uniform("u_occlusionMetallicRoughnessTexture", TextureAttribute.OcclusionMetallicRoughness);
        public static final BaseIntShader.Uniform texture0 = new BaseIntShader.Uniform("u_texture0", TextureAttribute.Texture0);
        public static final BaseIntShader.Uniform texture1 = new BaseIntShader.Uniform("u_texture1", TextureAttribute.Texture1);
        public static final BaseIntShader.Uniform normalTexture = new BaseIntShader.Uniform("u_normalTexture", TextureAttribute.Normal);
        public static final BaseIntShader.Uniform heightTexture = new BaseIntShader.Uniform("u_heightTexture", TextureAttribute.Height);
        public static final BaseIntShader.Uniform heightScale = new BaseIntShader.Uniform("u_heightScale", FloatAttribute.HeightScale);
        public static final BaseIntShader.Uniform elevationMultiplier = new BaseIntShader.Uniform("u_elevationMultiplier", FloatAttribute.ElevationMultiplier);
        public static final BaseIntShader.Uniform heightNoiseSize = new BaseIntShader.Uniform("u_heightNoiseSize", FloatAttribute.HeightNoiseSize);
        public static final BaseIntShader.Uniform heightSize = new BaseIntShader.Uniform("u_heightSize", Vector2Attribute.HeightSize);
        public static final BaseIntShader.Uniform tessQuality = new BaseIntShader.Uniform("u_tessQuality", FloatAttribute.TessQuality);
        public static final BaseIntShader.Uniform bodySize = new BaseIntShader.Uniform("u_bodySize", FloatAttribute.BodySize);
        public static final BaseIntShader.Uniform alphaTest = new BaseIntShader.Uniform("u_alphaTest");
        public static final BaseIntShader.Uniform time = new BaseIntShader.Uniform("u_time", FloatAttribute.Time);
        public static final BaseIntShader.Uniform simuTime = new BaseIntShader.Uniform("u_simuTime", FloatAttribute.SimuTime);
        public static final BaseIntShader.Uniform ambientCube = new BaseIntShader.Uniform("u_ambientCubemap");
        public static final BaseIntShader.Uniform reflectionCubemap = new BaseIntShader.Uniform("u_reflectionCubemap");
        public static final BaseIntShader.Uniform diffuseCubemap = new BaseIntShader.Uniform("u_diffuseCubemap");
        public static final BaseIntShader.Uniform normalCubemap = new BaseIntShader.Uniform("u_normalCubemap");
        public static final BaseIntShader.Uniform specularCubemap = new BaseIntShader.Uniform("u_specularCubemap");
        public static final BaseIntShader.Uniform emissiveCubemap = new BaseIntShader.Uniform("u_emissiveCubemap");
        public static final BaseIntShader.Uniform heightCubemap = new BaseIntShader.Uniform("u_heightCubemap");
        public static final BaseIntShader.Uniform metallicCubemap = new BaseIntShader.Uniform("u_metallicCubemap");
        public static final BaseIntShader.Uniform aoCubemap = new BaseIntShader.Uniform("u_aoCubemap");
        public static final BaseIntShader.Uniform roughnessCubemap = new BaseIntShader.Uniform("u_roughnessCubemap");
        public static final BaseIntShader.Uniform iridescenceFactorUniform = new BaseIntShader.Uniform("u_iridescenceFactor");
        public static final BaseIntShader.Uniform iridescenceIORUniform = new BaseIntShader.Uniform("u_iridescenceIOR");
        public static final BaseIntShader.Uniform iridescenceThicknessMinUniform = new BaseIntShader.Uniform("u_iridescenceThicknessMin");
        public static final BaseIntShader.Uniform iridescenceThicknessMaxUniform = new BaseIntShader.Uniform("u_iridescenceThicknessMax");
        public static final BaseIntShader.Uniform iridescenceTextureUniform = new BaseIntShader.Uniform("u_iridescenceSampler", PBRTextureAttribute.IridescenceTexture);
        public static final BaseIntShader.Uniform iridescenceThicknessTextureUniform = new BaseIntShader.Uniform("u_iridescenceThicknessSampler", PBRTextureAttribute.IridescenceThicknessTexture);
        public static final BaseIntShader.Uniform iorUniform = new BaseIntShader.Uniform("u_ior");
        public static final BaseIntShader.Uniform thicknessFactorUniform = new BaseIntShader.Uniform("u_thicknessFactor");
        public static final BaseIntShader.Uniform volumeDistanceUniform = new BaseIntShader.Uniform("u_attenuationDistance");
        public static final BaseIntShader.Uniform volumeColorUniform = new BaseIntShader.Uniform("u_attenuationColor");
        public static final BaseIntShader.Uniform thicknessTextureUniform = new BaseIntShader.Uniform("u_thicknessSampler", PBRTextureAttribute.ThicknessTexture);
        public static final BaseIntShader.Uniform svtTileSize = new BaseIntShader.Uniform("u_svtTileSize", FloatAttribute.SvtTileSize);
        public static final BaseIntShader.Uniform svtResolution = new BaseIntShader.Uniform("u_svtResolution", Vector2Attribute.SvtResolution);
        public static final BaseIntShader.Uniform svtDepth = new BaseIntShader.Uniform("u_svtDepth", FloatAttribute.SvtDepth);
        public static final BaseIntShader.Uniform svtId = new BaseIntShader.Uniform("u_svtId", FloatAttribute.SvtId);
        public static final BaseIntShader.Uniform svtDetectionFactor = new BaseIntShader.Uniform("u_svtDetectionFactor", FloatAttribute.SvtDetectionFactor);
        public static final BaseIntShader.Uniform svtCacheTexture = new BaseIntShader.Uniform("u_svtCacheTexture");
        public static final BaseIntShader.Uniform svtIndirectionDiffuseTexture = new BaseIntShader.Uniform("u_svtIndirectionDiffuseTexture");
        public static final BaseIntShader.Uniform svtIndirectionSpecularTexture = new BaseIntShader.Uniform("u_svtIndirectionSpecularTexture");
        public static final BaseIntShader.Uniform svtIndirectionNormalTexture = new BaseIntShader.Uniform("u_svtIndirectionNormalTexture");
        public static final BaseIntShader.Uniform svtIndirectionHeightTexture = new BaseIntShader.Uniform("u_svtIndirectionHeightTexture");
        public static final BaseIntShader.Uniform svtIndirectionEmissiveTexture = new BaseIntShader.Uniform("u_svtIndirectionEmissiveTexture");
        public static final BaseIntShader.Uniform svtIndirectionMetallicTexture = new BaseIntShader.Uniform("u_svtIndirectionMetallicTexture");
        public static final BaseIntShader.Uniform svtIndirectionRoughnessTexture = new BaseIntShader.Uniform("u_svtIndirectionRoughnessTexture");
        public static final BaseIntShader.Uniform svtIndirectionAoTexture = new BaseIntShader.Uniform("u_svtIndirectionAoTexture");
        public static final BaseIntShader.Uniform kmToU = new BaseIntShader.Uniform("u_kmToU", FloatAttribute.KmToU);
        public static final BaseIntShader.Uniform generic1 = new BaseIntShader.Uniform("u_generic1", FloatAttribute.Generic1);
        public static final BaseIntShader.Uniform generic2 = new BaseIntShader.Uniform("u_generic2", FloatAttribute.Generic2);
    }

    public static class Setters {
        public static final BaseIntShader.Setter projTrans = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.projection);
            }
        };
        public static final BaseIntShader.Setter viewTrans = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.view);
            }
        };
        public static final BaseIntShader.Setter projViewTrans = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.combined);
            }
        };
        public static final BaseIntShader.Setter cameraPosition = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.position.x, shader.camera.position.y, shader.camera.position.z, 1.1881f / (shader.camera.far * shader.camera.far));
            }
        };
        public static final BaseIntShader.Setter cameraDirection = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.direction);
            }
        };
        public static final BaseIntShader.Setter cameraUp = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.up);
            }
        };
        public static final BaseIntShader.Setter cameraNearFar = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, shader.camera.near, shader.camera.far);
            }
        };
        public static final BaseIntShader.Setter cameraK = new BaseIntShader.GlobalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, Constants.getCameraK());
            }
        };
        public static final BaseIntShader.Setter worldTrans = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, renderable.worldTransform);
            }
        };
        public static final BaseIntShader.Setter normalMatrix = new BaseIntShader.LocalSetter(){
            private final Matrix3 tmpM = new Matrix3();

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, this.tmpM.set(renderable.worldTransform).inv().transpose());
            }
        };
        public static final BaseIntShader.Setter cameraPos = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.CameraPos)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.CameraPos))).value);
                }
            }
        };
        public static final BaseIntShader.Setter eclipseOutlines = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(IntAttribute.EclipseOutlines)) {
                    shader.set(inputID, ((IntAttribute)Objects.requireNonNull(combinedAttributes.get((int)IntAttribute.EclipseOutlines))).value);
                }
            }
        };
        public static final BaseIntShader.Setter eclipsingBodyPos = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.EclipsingBodyPos)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.EclipsingBodyPos))).value);
                }
            }
        };
        public static final BaseIntShader.Setter eclipsingBodyRadius = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.EclipsingBodyRadius)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.EclipsingBodyRadius))).value);
                }
            }
        };
        public static final BaseIntShader.Setter vrScale = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, (float)Constants.DISTANCE_SCALE_FACTOR);
            }
        };
        public static final BaseIntShader.Setter vrOffset = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.VrOffset)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.VrOffset))).value);
                }
            }
        };
        public static final BaseIntShader.Setter aoTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.AO))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter time = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.Time))).value);
            }
        };
        public static final BaseIntShader.Setter simuTime = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.SimuTime))).value);
            }
        };
        public static final BaseIntShader.Setter diffuseColor = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((ColorAttribute)Objects.requireNonNull(combinedAttributes.get((int)ColorAttribute.Diffuse))).color);
            }
        };
        public static final BaseIntShader.Setter diffuseTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Diffuse))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter specularColor = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((ColorAttribute)Objects.requireNonNull(combinedAttributes.get((int)ColorAttribute.Specular))).color);
            }
        };
        public static final BaseIntShader.Setter specularTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Specular))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter emissiveColor = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((ColorAttribute)Objects.requireNonNull(combinedAttributes.get((int)ColorAttribute.Emissive))).color);
            }
        };
        public static final BaseIntShader.Setter emissiveTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Emissive))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter metallicColor = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((ColorAttribute)Objects.requireNonNull(combinedAttributes.get((int)ColorAttribute.Metallic))).color);
            }
        };
        public static final BaseIntShader.Setter metallicTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Metallic))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter shininess = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.Shininess))).value);
            }
        };
        public static final BaseIntShader.Setter roughnessColor = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((ColorAttribute)Objects.requireNonNull(combinedAttributes.get((int)ColorAttribute.Roughness))).color);
            }
        };
        public static final BaseIntShader.Setter roughnessTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Roughness))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter diffuseScatteringColor = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((ColorAttribute)Objects.requireNonNull(combinedAttributes.get((int)ColorAttribute.DiffuseScattering))).color);
            }
        };
        public static final BaseIntShader.Setter occlusionMetallicRoughnessTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.OcclusionMetallicRoughness))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter normalTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Normal))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter heightTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Height))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter heightScale = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.HeightScale)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.HeightScale))).value);
                }
            }
        };
        public static final BaseIntShader.Setter elevationMultiplier = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.ElevationMultiplier)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.ElevationMultiplier))).value);
                }
            }
        };
        public static final BaseIntShader.Setter heightNoiseSize = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.HeightNoiseSize)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.HeightNoiseSize))).value);
                }
            }
        };
        public static final BaseIntShader.Setter heightSize = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector2Attribute.HeightSize)) {
                    shader.set(inputID, ((Vector2Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector2Attribute.HeightSize))).value);
                }
            }
        };
        public static final BaseIntShader.Setter tessQuality = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.TessQuality)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.TessQuality))).value);
                }
            }
        };
        public static final BaseIntShader.Setter bodySize = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.BodySize)) {
                    shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.BodySize))).value);
                }
            }
        };
        public static final BaseIntShader.Setter reflectionCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.ReflectionCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.ReflectionCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter diffuseCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.DiffuseCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.DiffuseCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter normalCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.NormalCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.NormalCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter emissiveCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.EmissiveCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.EmissiveCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter specularCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.SpecularCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.SpecularCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter heightCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.HeightCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.HeightCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter metallicCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.MetallicCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.MetallicCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter aoCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.AmbientOcclusionCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.AmbientOcclusionCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter roughnessCubemap = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(CubemapAttribute.RoughnessCubemap)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((CubemapAttribute)Objects.requireNonNull(combinedAttributes.get((int)CubemapAttribute.RoughnessCubemap))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter iridescenceFactorSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                PBRIridescenceAttribute a = combinedAttributes.get(PBRIridescenceAttribute.class, PBRIridescenceAttribute.Type);
                shader.set(inputID, a.factor);
            }
        };
        public static final BaseIntShader.Setter iridescenceIORSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                PBRIridescenceAttribute a = combinedAttributes.get(PBRIridescenceAttribute.class, PBRIridescenceAttribute.Type);
                shader.set(inputID, a.ior);
            }
        };
        public static final BaseIntShader.Setter iridescenceThicknessMinSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                PBRIridescenceAttribute a = combinedAttributes.get(PBRIridescenceAttribute.class, PBRIridescenceAttribute.Type);
                shader.set(inputID, a.thicknessMin);
            }
        };
        public static final BaseIntShader.Setter iridescenceThicknessMaxSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                PBRIridescenceAttribute a = combinedAttributes.get(PBRIridescenceAttribute.class, PBRIridescenceAttribute.Type);
                shader.set(inputID, a.thicknessMax);
            }
        };
        public static final BaseIntShader.Setter iridescenceTextureSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)PBRTextureAttribute.IridescenceTexture))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter iridescenceThicknessTextureSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)PBRTextureAttribute.IridescenceThicknessTexture))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter iorSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                PBRFloatAttribute a = combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.IOR);
                shader.set(inputID, a.value);
            }
        };
        public static final BaseIntShader.Setter thicknessFactorSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                PBRVolumeAttribute a = combinedAttributes.get(PBRVolumeAttribute.class, PBRVolumeAttribute.Type);
                shader.set(inputID, a.thicknessFactor);
            }
        };
        public static final BaseIntShader.Setter volumeDistanceSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                PBRVolumeAttribute a = combinedAttributes.get(PBRVolumeAttribute.class, PBRVolumeAttribute.Type);
                shader.set(inputID, a.attenuationDistance);
            }
        };
        public static final BaseIntShader.Setter volumeColorSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                PBRVolumeAttribute a = combinedAttributes.get(PBRVolumeAttribute.class, PBRVolumeAttribute.Type);
                shader.set(inputID, a.attenuationColor.r, a.attenuationColor.g, a.attenuationColor.b);
            }
        };
        public static final BaseIntShader.Setter thicknessTextureSetter = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)PBRTextureAttribute.ThicknessTexture))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter svtTileSize = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.SvtTileSize))).value);
            }
        };
        public static final BaseIntShader.Setter svtResolution = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((Vector2Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector2Attribute.SvtResolution))).value);
            }
        };
        public static final BaseIntShader.Setter svtDepth = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.SvtDepth))).value);
            }
        };
        public static final BaseIntShader.Setter svtId = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.SvtId))).value);
            }
        };
        public static final BaseIntShader.Setter svtDetectionFactor = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.SvtDetectionFactor))).value);
            }
        };
        public static final BaseIntShader.Setter svtBufferTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtCache)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtCache))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter svtIndirectionDiffuseTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtIndirectionDiffuse)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtIndirectionDiffuse))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter svtIndirectionSpecularTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtIndirectionSpecular)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtIndirectionSpecular))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter svtIndirectionNormalTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtIndirectionNormal)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtIndirectionNormal))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter svtIndirectionHeightTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtIndirectionHeight)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtIndirectionHeight))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter svtIndirectionEmissiveTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtIndirectionEmissive)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtIndirectionEmissive))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter svtIndirectionMetallicTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtIndirectionMetallic)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtIndirectionMetallic))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter svtIndirectionRoughnessTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtIndirectionRoughness)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtIndirectionRoughness))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter svtIndirectionAoTexture = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(TextureAttribute.SvtIndirectionAmbientOcclusion)) {
                    shader.set(inputID, shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.SvtIndirectionAmbientOcclusion))).textureDescription));
                }
            }
        };
        public static final BaseIntShader.Setter kmToU = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.KmToU))).value);
            }
        };
        public static final BaseIntShader.Setter generic1 = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.Generic1))).value);
            }
        };
        public static final BaseIntShader.Setter generic2 = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.Generic2))).value);
            }
        };
        public static final BaseIntShader.Setter texture0 = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Texture0))).textureDescription);
                shader.set(inputID, unit);
            }
        };
        public static final BaseIntShader.Setter texture1 = new BaseIntShader.LocalSetter(){

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                int unit = shader.context.textureBinder.bind(((TextureAttribute)Objects.requireNonNull(combinedAttributes.get((int)TextureAttribute.Texture1))).textureDescription);
                shader.set(inputID, unit);
            }
        };

        public static class ACubemap
        extends BaseIntShader.LocalSetter {
            private static final float[] ones = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            private static final Vector3 tmpV1 = new Vector3();
            public final int dirLightsOffset;
            public final int pointLightsOffset;
            private final AmbientCubemap cacheAmbientCubemap = new AmbientCubemap();

            public ACubemap(int dirLightsOffset, int pointLightsOffset) {
                this.dirLightsOffset = dirLightsOffset;
                this.pointLightsOffset = pointLightsOffset;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (renderable.environment == null) {
                    shader.program.setUniform3fv(shader.loc(inputID), ones, 0, ones.length);
                } else {
                    int i;
                    Array<DirectionalLight> lights;
                    renderable.worldTransform.getTranslation(tmpV1);
                    if (combinedAttributes.has(ColorAttribute.AmbientLight)) {
                        this.cacheAmbientCubemap.set(((ColorAttribute)Objects.requireNonNull(combinedAttributes.get((int)ColorAttribute.AmbientLight))).color);
                    }
                    if (combinedAttributes.has(DirectionalLightsAttribute.Type)) {
                        lights = ((DirectionalLightsAttribute)Objects.requireNonNull(combinedAttributes.get((int)DirectionalLightsAttribute.Type))).lights;
                        for (i = this.dirLightsOffset; i < lights.size; ++i) {
                            this.cacheAmbientCubemap.add(((DirectionalLight)lights.get((int)i)).color, ((DirectionalLight)lights.get((int)i)).direction);
                        }
                    }
                    if (combinedAttributes.has(PointLightsAttribute.Type)) {
                        lights = ((PointLightsAttribute)Objects.requireNonNull(combinedAttributes.get((int)PointLightsAttribute.Type))).lights;
                        for (i = this.pointLightsOffset; i < lights.size; ++i) {
                            this.cacheAmbientCubemap.add(((PointLight)lights.get((int)i)).color, ((PointLight)lights.get((int)i)).position, tmpV1, ((PointLight)lights.get((int)i)).intensity);
                        }
                    }
                    this.cacheAmbientCubemap.clamp();
                    shader.program.setUniform3fv(shader.loc(inputID), this.cacheAmbientCubemap.data, 0, this.cacheAmbientCubemap.data.length);
                }
            }
        }

        public static class Bones
        extends BaseIntShader.LocalSetter {
            private static final Matrix4 idtMatrix = new Matrix4();
            public final float[] bones;

            public Bones(int numBones) {
                this.bones = new float[numBones * 16];
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                for (int i = 0; i < this.bones.length; ++i) {
                    int idx = i / 16;
                    this.bones[i] = renderable.bones == null || idx >= renderable.bones.length || renderable.bones[idx] == null ? Bones.idtMatrix.val[i % 16] : renderable.bones[idx].val[i % 16];
                }
                shader.program.setUniformMatrix4fv(shader.loc(inputID), this.bones, 0, this.bones.length);
            }
        }
    }
}

