/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.VertexAttribute;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.Attributes;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import java.util.Objects;

public class DepthIntShader
extends DefaultIntShader {
    private static final Attributes tmpAttributes = new Attributes();
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;
    public final int numBones;
    public final int weights;
    private final FloatAttribute alphaTestAttribute;

    public DepthIntShader(IntRenderable renderable) {
        this(renderable, new Config());
    }

    public DepthIntShader(IntRenderable renderable, Config config) {
        this(renderable, config, DepthIntShader.createPrefix(renderable, config));
    }

    public DepthIntShader(IntRenderable renderable, Config config, String prefix) {
        this(renderable, config, prefix, config.vertexShaderCode != null ? config.vertexShaderCode : DepthIntShader.getDefaultVertexShader(), config.fragmentShaderCode != null ? config.fragmentShaderCode : DepthIntShader.getDefaultFragmentShader());
    }

    public DepthIntShader(IntRenderable renderable, Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ExtShaderProgram(prefix + vertexShader, prefix + fragmentShader));
    }

    public DepthIntShader(IntRenderable renderable, Config config, ExtShaderProgram shaderProgram) {
        super(renderable, (DefaultIntShader.Config)config, shaderProgram);
        Attributes attributes = DepthIntShader.combineAttributes(renderable);
        this.numBones = renderable.bones == null ? 0 : config.numBones;
        int w = 0;
        int n = renderable.meshPart.mesh.getVertexAttributes().size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = renderable.meshPart.mesh.getVertexAttributes().get(i);
            if (attr.usage != 64) continue;
            w |= 1 << attr.unit;
        }
        this.weights = w;
        this.alphaTestAttribute = new FloatAttribute(FloatAttribute.AlphaTest, config.defaultAlphaTest);
    }

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/depth.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/depth.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static String createPrefix(IntRenderable renderable, Config config) {
        Object prefix = DefaultIntShader.createPrefix(renderable, config);
        if (!config.depthBufferOnly) {
            prefix = (String)prefix + "#define PackedDepthFlag\n";
        }
        return prefix;
    }

    private static Attributes combineAttributes(IntRenderable renderable) {
        tmpAttributes.clear();
        if (renderable.environment != null) {
            tmpAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            tmpAttributes.set(renderable.material);
        }
        return tmpAttributes;
    }

    @Override
    public boolean canRender(IntRenderable renderable) {
        Attributes attributes = DepthIntShader.combineAttributes(renderable);
        if (attributes.has(BlendingAttribute.Type) && !attributes.has(TextureAttribute.Diffuse)) {
            return false;
        }
        boolean skinned = (renderable.meshPart.mesh.getVertexAttributes().getMask() & 0x40L) == 64L;
        if (skinned != this.numBones > 0) {
            return false;
        }
        if (!skinned) {
            return true;
        }
        int w = 0;
        int n = renderable.meshPart.mesh.getVertexAttributes().size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = renderable.meshPart.mesh.getVertexAttributes().get(i);
            if (attr.usage != 64) continue;
            w |= 1 << attr.unit;
        }
        return w == this.weights;
    }

    @Override
    public void render(IntRenderable renderable, Attributes combinedAttributes) {
        if (combinedAttributes.has(BlendingAttribute.Type)) {
            BlendingAttribute blending = (BlendingAttribute)combinedAttributes.get(BlendingAttribute.Type);
            combinedAttributes.remove(BlendingAttribute.Type);
            boolean hasAlphaTest = combinedAttributes.has(FloatAttribute.AlphaTest);
            if (!hasAlphaTest) {
                combinedAttributes.set((Attribute)this.alphaTestAttribute);
            }
            assert (blending != null);
            if (blending.opacity >= ((FloatAttribute)Objects.requireNonNull(combinedAttributes.get((int)FloatAttribute.AlphaTest))).value) {
                super.render(renderable, combinedAttributes);
            }
            if (!hasAlphaTest) {
                combinedAttributes.remove(FloatAttribute.AlphaTest);
            }
            combinedAttributes.set((Attribute)blending);
        } else {
            super.render(renderable, combinedAttributes);
        }
    }

    public static class Config
    extends DefaultIntShader.Config {
        public boolean depthBufferOnly = false;
        public float defaultAlphaTest = 0.5f;

        public Config() {
            this.defaultCullFace = 1028;
        }

        public Config(String vertexShader, String fragmentShader) {
            super(vertexShader, fragmentShader);
        }
    }
}

