/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.ShadowMap;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.Attributes;
import gaiasky.util.gdx.shader.attribute.DirectionalLightsAttribute;
import gaiasky.util.gdx.shader.attribute.PointLightsAttribute;
import gaiasky.util.gdx.shader.attribute.SpotLightsAttribute;
import java.util.Objects;

public class Environment
extends Attributes {
    public ShadowMap shadowMap;

    public Environment add(BaseLight ... lights) {
        for (BaseLight light : lights) {
            this.add(light);
        }
        return this;
    }

    public Environment add(Array<BaseLight> lights) {
        for (BaseLight light : lights) {
            this.add(light);
        }
        return this;
    }

    public Environment add(BaseLight light) {
        if (light instanceof DirectionalLight) {
            this.add((DirectionalLight)light);
        } else if (light instanceof PointLight) {
            this.add((PointLight)light);
        } else if (light instanceof SpotLight) {
            this.add((SpotLight)light);
        } else {
            throw new GdxRuntimeException("Unknown light type");
        }
        return this;
    }

    public Environment add(DirectionalLight light) {
        DirectionalLightsAttribute dirLights = (DirectionalLightsAttribute)this.get(DirectionalLightsAttribute.Type);
        if (dirLights == null) {
            dirLights = new DirectionalLightsAttribute();
            this.set((Attribute)dirLights);
        }
        dirLights.lights.add((Object)light);
        return this;
    }

    public Environment add(PointLight light) {
        PointLightsAttribute pointLights = (PointLightsAttribute)this.get(PointLightsAttribute.Type);
        if (pointLights == null) {
            pointLights = new PointLightsAttribute();
            this.set((Attribute)pointLights);
        }
        pointLights.lights.add((Object)light);
        return this;
    }

    public Environment add(SpotLight light) {
        SpotLightsAttribute spotLights = (SpotLightsAttribute)this.get(SpotLightsAttribute.Type);
        if (spotLights == null) {
            spotLights = new SpotLightsAttribute();
            this.set((Attribute)spotLights);
        }
        spotLights.lights.add((Object)light);
        return this;
    }

    public Environment remove(BaseLight ... lights) {
        for (BaseLight light : lights) {
            this.remove(light);
        }
        return this;
    }

    public Environment remove(Array<BaseLight> lights) {
        for (BaseLight light : lights) {
            this.remove(light);
        }
        return this;
    }

    public Environment remove(BaseLight light) {
        if (light instanceof DirectionalLight) {
            this.remove((DirectionalLight)light);
        } else if (light instanceof PointLight) {
            this.remove((PointLight)light);
        } else if (light instanceof SpotLight) {
            this.remove((SpotLight)light);
        } else {
            throw new GdxRuntimeException("Unknown light type");
        }
        return this;
    }

    public Environment remove(DirectionalLight light) {
        if (this.has(DirectionalLightsAttribute.Type)) {
            DirectionalLightsAttribute dirLights = (DirectionalLightsAttribute)this.get(DirectionalLightsAttribute.Type);
            Objects.requireNonNull(dirLights).lights.removeValue((Object)light, false);
            if (dirLights.lights.size == 0) {
                this.remove(DirectionalLightsAttribute.Type);
            }
        }
        return this;
    }

    public Environment remove(PointLight light) {
        if (this.has(PointLightsAttribute.Type)) {
            PointLightsAttribute pointLights = (PointLightsAttribute)this.get(PointLightsAttribute.Type);
            Objects.requireNonNull(pointLights).lights.removeValue((Object)light, false);
            if (pointLights.lights.size == 0) {
                this.remove(PointLightsAttribute.Type);
            }
        }
        return this;
    }

    public Environment remove(SpotLight light) {
        if (this.has(SpotLightsAttribute.Type)) {
            SpotLightsAttribute spotLights = (SpotLightsAttribute)this.get(SpotLightsAttribute.Type);
            Objects.requireNonNull(spotLights).lights.removeValue((Object)light, false);
            if (spotLights.lights.size == 0) {
                this.remove(SpotLightsAttribute.Type);
            }
        }
        return this;
    }
}

