/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.render.GaiaSkyShaderCompileException;
import gaiasky.util.Logger;
import gaiasky.util.SysUtils;
import gaiasky.util.gdx.shader.ShaderCache;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.lwjgl.opengl.GL33;

public class ExtShaderProgram
implements Disposable {
    private static final Logger.Log logger = Logger.getLogger(ExtShaderProgram.class);
    public static final String POSITION_ATTRIBUTE = "a_position";
    public static final String COLOR_ATTRIBUTE = "a_color";
    public static final String NORMAL_ATTRIBUTE = "a_normal";
    public static final String TEXCOORD_ATTRIBUTE = "a_texCoord";
    private static final ObjectMap<Application, Array<ExtShaderProgram>> shaders = new ObjectMap();
    public static boolean pedantic = true;
    public static String prependVertexCode = "";
    public static String prependGeometryCode = "";
    public static String prependFragmentCode = "";
    protected IntBuffer params = BufferUtils.newIntBuffer((int)1);
    protected IntBuffer type = BufferUtils.newIntBuffer((int)1);
    protected IntBuffer len = BufferUtils.newIntBuffer((int)1);
    protected IntBuffer format = BufferUtils.newIntBuffer((int)1);
    protected IntBuffer intBuffer = BufferUtils.newIntBuffer((int)1);
    protected ByteBuffer byteBuffer = ByteBuffer.allocateDirect(50000);
    protected String log = "";
    protected String name;
    protected boolean isCompiled;
    protected boolean isLazy;
    protected boolean isDisposed;
    protected ObjectIntMap<String> uniforms;
    protected ObjectIntMap<String> uniformTypes;
    protected ObjectIntMap<String> uniformSizes;
    protected String[] uniformNames;
    protected ObjectIntMap<String> attributes;
    protected ObjectIntMap<String> attributeTypes;
    protected ObjectIntMap<String> attributeSizes;
    protected String[] attributeNames;
    protected int program;
    protected int vertexShaderHandle;
    private int geometryShaderHandle;
    protected int fragmentShaderHandle;
    protected String vertexShaderSource;
    protected String geometryShaderSource;
    protected String fragmentShaderSource;
    protected String vertexShaderFile;
    protected String geometryShaderFile;
    protected String fragmentShaderFile;
    protected boolean invalidated;

    public ExtShaderProgram() {
    }

    public ExtShaderProgram(String vertexFile, String fragmentFile, String vertexShaderCode, String fragmentShaderCode) {
        this(null, vertexFile, fragmentFile, vertexShaderCode, fragmentShaderCode, false);
    }

    public ExtShaderProgram(String vertexFile, String geometryFile, String fragmentFile, String vertexShaderCode, String geometryShaderCode, String fragmentShaderCode) {
        this(null, vertexFile, geometryFile, fragmentFile, vertexShaderCode, geometryShaderCode, fragmentShaderCode, false);
    }

    public ExtShaderProgram(String name, String vertexFile, String geometryFile, String fragmentFile, String vertexShaderCode, String geometryShaderCode, String fragmentShaderCode) {
        this(name, vertexFile, geometryFile, fragmentFile, vertexShaderCode, geometryShaderCode, fragmentShaderCode, false);
    }

    public ExtShaderProgram(String name, String vertexFile, String fragmentFile, String vertexShaderCode, String fragmentShaderCode) {
        this(name, vertexFile, fragmentFile, vertexShaderCode, fragmentShaderCode, false);
    }

    public ExtShaderProgram(String name, String vertexFile, String fragmentFile, String vertexShaderCode, String fragmentShaderCode, boolean lazyLoading) {
        this(name, vertexFile, null, fragmentFile, vertexShaderCode, null, fragmentShaderCode, lazyLoading);
    }

    public ExtShaderProgram(String name, String vertexFile, String geometryFile, String fragmentFile, String vertexShaderCode, String geometryShaderCode, String fragmentShaderCode, boolean lazyLoading) {
        if (vertexShaderCode == null) {
            throw new IllegalArgumentException("vertex shader must not be null");
        }
        if (fragmentShaderCode == null) {
            throw new IllegalArgumentException("fragment shader must not be null");
        }
        if (prependVertexCode != null && !prependVertexCode.isEmpty()) {
            vertexShaderCode = prependVertexCode + (String)vertexShaderCode;
        }
        if (geometryShaderCode != null && prependGeometryCode != null && !prependGeometryCode.isEmpty()) {
            geometryShaderCode = prependGeometryCode + (String)geometryShaderCode;
        }
        if (prependFragmentCode != null && !prependFragmentCode.isEmpty()) {
            fragmentShaderCode = prependFragmentCode + (String)fragmentShaderCode;
        }
        this.isLazy = lazyLoading;
        this.name = name;
        this.vertexShaderSource = vertexShaderCode;
        this.geometryShaderSource = geometryShaderCode;
        this.fragmentShaderSource = fragmentShaderCode;
        this.vertexShaderFile = vertexFile;
        this.geometryShaderFile = geometryFile;
        this.fragmentShaderFile = fragmentFile;
        if (!lazyLoading) {
            this.compile(name);
        }
    }

    public ExtShaderProgram(String vertexShader, String fragmentShader) {
        this(null, null, vertexShader, fragmentShader);
    }

    public ExtShaderProgram(FileHandle vertexShader, FileHandle fragmentShader) {
        this(vertexShader.readString(), fragmentShader.readString());
    }

    public ExtShaderProgram(String name, FileHandle vertexShader, FileHandle fragmentShader) {
        this(name, null, null, vertexShader.readString(), fragmentShader.readString());
    }

    public static void invalidateAllShaderPrograms(Application app) {
        if (Gdx.gl20 == null) {
            return;
        }
        Array shaderArray = (Array)shaders.get((Object)app);
        if (shaderArray == null) {
            return;
        }
        for (int i = 0; i < shaderArray.size; ++i) {
            ((ExtShaderProgram)shaderArray.get((int)i)).invalidated = true;
            ((ExtShaderProgram)shaderArray.get(i)).checkManaged();
        }
    }

    public static void clearAllShaderPrograms(Application app) {
        shaders.remove((Object)app);
    }

    public static String getManagedStatus() {
        StringBuilder builder = new StringBuilder();
        builder.append("Managed shaders/app: { ");
        for (Application app : shaders.keys()) {
            builder.append(((Array)ExtShaderProgram.shaders.get((Object)app)).size);
            builder.append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    public static int getNumManagedShaderPrograms() {
        return ((Array)ExtShaderProgram.shaders.get((Object)Gdx.app)).size;
    }

    protected void initializeLocalAssets() {
        this.uniforms = new ObjectIntMap();
        this.uniformTypes = new ObjectIntMap();
        this.uniformSizes = new ObjectIntMap();
        this.attributes = new ObjectIntMap();
        this.attributeTypes = new ObjectIntMap();
        this.attributeSizes = new ObjectIntMap();
    }

    public String getName() {
        return this.name;
    }

    public void compile(String name) {
        if (!this.isCompiled) {
            this.initializeLocalAssets();
            if (this.vertexShaderFile != null || this.fragmentShaderFile != null) {
                if (this.geometryShaderFile != null) {
                    logger.debug(I18n.msg("notif.shader.load.geom", this.vertexShaderFile, this.geometryShaderFile, this.fragmentShaderFile));
                } else {
                    logger.debug(I18n.msg("notif.shader.load", this.vertexShaderFile, this.fragmentShaderFile));
                }
            }
            if (this.geometryShaderSource != null) {
                this.compileShaders(name, this.vertexShaderSource, this.geometryShaderSource, this.fragmentShaderSource);
            } else {
                this.compileShaders(name, this.vertexShaderSource, this.fragmentShaderSource);
            }
            if (this.isCompiled()) {
                this.fetchAttributes();
                this.fetchUniforms();
                this.addManagedShader(Gdx.app, this);
            } else {
                throw new GaiaSkyShaderCompileException(this);
            }
        }
    }

    private void compileShaders(String name, String vertexShader, String geometryShader, String fragmentShader) {
        ShaderCache cache = ShaderCache.instance();
        int[] handles = cache.compileShaders(name, vertexShader, geometryShader, fragmentShader);
        this.program = handles[0];
        this.vertexShaderHandle = handles[1];
        this.geometryShaderHandle = handles[2];
        this.fragmentShaderHandle = handles[3];
        this.isCompiled = cache.isCompiled();
        this.log = cache.getLog();
    }

    private void compileShaders(String name, String vertexShader, String fragmentShader) {
        ShaderCache cache = ShaderCache.instance();
        int[] handles = cache.compileShaders(name, vertexShader, fragmentShader);
        this.program = handles[0];
        this.vertexShaderHandle = handles[1];
        this.fragmentShaderHandle = handles[2];
        this.isCompiled = cache.isCompiled();
        this.log = cache.getLog();
    }

    public String getLog() {
        if (this.isCompiled) {
            this.log = Gdx.gl20.glGetProgramInfoLog(this.program);
        }
        return this.log;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    protected int fetchAttributeLocation(String name) {
        GL20 gl = Gdx.gl20;
        int location = this.attributes.get((Object)name, -2);
        if (location == -2) {
            location = gl.glGetAttribLocation(this.program, name);
            this.attributes.put((Object)name, location);
        }
        return location;
    }

    protected int fetchUniformLocation(String name) {
        return this.fetchUniformLocation(name, pedantic);
    }

    public int fetchUniformLocation(String name, boolean pedantic) {
        GL20 gl = Gdx.gl20;
        int location = this.uniforms.get((Object)name, -2);
        if (location == -2) {
            location = gl.glGetUniformLocation(this.program, name);
            if (location == -1 && pedantic) {
                throw new IllegalArgumentException("no uniform with name '" + name + "' in shader");
            }
            this.uniforms.put((Object)name, location);
        }
        return location;
    }

    public void setUniformi(String name, int value) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform1i(location, value);
    }

    public void setUniformi(int location, int value) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform1i(location, value);
    }

    public void setUniformi(String name, int value1, int value2) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform2i(location, value1, value2);
    }

    public void setUniformi(int location, int value1, int value2) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform2i(location, value1, value2);
    }

    public void setUniformi(String name, int value1, int value2, int value3) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform3i(location, value1, value2, value3);
    }

    public void setUniformi(int location, int value1, int value2, int value3) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform3i(location, value1, value2, value3);
    }

    public void setUniformi(String name, int value1, int value2, int value3, int value4) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform4i(location, value1, value2, value3, value4);
    }

    public void setUniformi(int location, int value1, int value2, int value3, int value4) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform4i(location, value1, value2, value3, value4);
    }

    public void setUniformf(String name, float value) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform1f(location, value);
    }

    public void setUniformf(int location, float value) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform1f(location, value);
    }

    public void setUniformf(String name, float value1, float value2) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform2f(location, value1, value2);
    }

    public void setUniformf(int location, float value1, float value2) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform2f(location, value1, value2);
    }

    public void setUniformf(String name, float value1, float value2, float value3) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform3f(location, value1, value2, value3);
    }

    public void setUniformf(int location, float value1, float value2, float value3) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform3f(location, value1, value2, value3);
    }

    public void setUniformf(String name, float value1, float value2, float value3, float value4) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform4f(location, value1, value2, value3, value4);
    }

    public void setUniformf(int location, float value1, float value2, float value3, float value4) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform4f(location, value1, value2, value3, value4);
    }

    public void setUniform1fv(String name, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform1fv(location, length, values, offset);
    }

    public void setUniform1fv(int location, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform1fv(location, length, values, offset);
    }

    public void setUniform2fv(String name, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform2fv(location, length / 2, values, offset);
    }

    public void setUniform2fv(int location, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform2fv(location, length / 2, values, offset);
    }

    public void setUniform3fv(String name, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform3fv(location, length / 3, values, offset);
    }

    public void setUniform3fv(int location, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform3fv(location, length / 3, values, offset);
    }

    public void setUniform4fv(String name, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform4fv(location, length / 4, values, offset);
    }

    public void setUniform4fv(int location, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniform4fv(location, length / 4, values, offset);
    }

    public void setUniformMatrix(String name, Matrix4 matrix) {
        this.setUniformMatrix(name, matrix, false);
    }

    public void setUniformMatrix(String name, Matrix4 matrix, boolean transpose) {
        this.setUniformMatrix(this.fetchUniformLocation(name), matrix, transpose);
    }

    public void setUniformMatrix(int location, Matrix4 matrix) {
        this.setUniformMatrix(location, matrix, false);
    }

    public void setUniformMatrix(int location, Matrix4 matrix, boolean transpose) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniformMatrix4fv(location, 1, transpose, matrix.val, 0);
    }

    public void setUniformMatrix(String name, Matrix3 matrix) {
        this.setUniformMatrix(name, matrix, false);
    }

    public void setUniformMatrix(String name, Matrix3 matrix, boolean transpose) {
        this.setUniformMatrix(this.fetchUniformLocation(name), matrix, transpose);
    }

    public void setUniformMatrix(int location, Matrix3 matrix) {
        this.setUniformMatrix(location, matrix, false);
    }

    public void setUniformMatrix(int location, Matrix3 matrix, boolean transpose) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniformMatrix3fv(location, 1, transpose, matrix.val, 0);
    }

    public void setUniformMatrix3fv(String name, FloatBuffer buffer, int count, boolean transpose) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        buffer.position(0);
        int location = this.fetchUniformLocation(name);
        gl.glUniformMatrix3fv(location, count, transpose, buffer);
    }

    public void setUniformMatrix4fv(String name, FloatBuffer buffer, int count, boolean transpose) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        buffer.position(0);
        int location = this.fetchUniformLocation(name);
        gl.glUniformMatrix4fv(location, count, transpose, buffer);
    }

    public void setUniformMatrix4fv(int location, float[] values, int offset, int length) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniformMatrix4fv(location, length / 16, false, values, offset);
    }

    public void setUniformMatrix4fv(String name, float[] values, int offset, int length) {
        this.setUniformMatrix4fv(this.fetchUniformLocation(name), values, offset, length);
    }

    public void setUniformf(String name, Vector2 values) {
        this.setUniformf(name, values.x, values.y);
    }

    public void setUniformf(int location, Vector2 values) {
        this.setUniformf(location, values.x, values.y);
    }

    public void setUniformf(String name, Vector3 values) {
        this.setUniformf(name, values.x, values.y, values.z);
    }

    public void setUniformf(String name, Vector3D values) {
        this.setUniformf(name, (float)values.x, (float)values.y, (float)values.z);
    }

    public void setUniformf(String name, Vector3Q values) {
        this.setUniformf(name, values.x.floatValue(), values.y.floatValue(), values.z.floatValue());
    }

    public void setUniformf(int location, Vector3 values) {
        this.setUniformf(location, values.x, values.y, values.z);
    }

    public void setUniformf(String name, Color values) {
        this.setUniformf(name, values.r, values.g, values.b, values.a);
    }

    public void setUniformf(int location, Color values) {
        this.setUniformf(location, values.r, values.g, values.b, values.a);
    }

    public void setVertexAttribute(String name, int size, int type, boolean normalize, int stride, Buffer buffer) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchAttributeLocation(name);
        if (location == -1) {
            return;
        }
        gl.glVertexAttribPointer(location, size, type, normalize, stride, buffer);
    }

    public void setVertexAttribute(int location, int size, int type, boolean normalize, int stride, Buffer buffer) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glVertexAttribPointer(location, size, type, normalize, stride, buffer);
    }

    public void setVertexAttribute(String name, int size, int type, boolean normalize, int stride, int offset) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchAttributeLocation(name);
        if (location == -1) {
            return;
        }
        gl.glVertexAttribPointer(location, size, type, normalize, stride, offset);
    }

    public void setVertexAttribute(int location, int size, int type, boolean normalize, int stride, int offset) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glVertexAttribPointer(location, size, type, normalize, stride, offset);
    }

    public void begin() {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUseProgram(this.program);
    }

    public void end() {
        GL20 gl = Gdx.gl20;
        gl.glUseProgram(0);
    }

    public void disableVertexAttribute(String name) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchAttributeLocation(name);
        if (location == -1) {
            return;
        }
        gl.glDisableVertexAttribArray(location);
    }

    public void disableVertexAttribute(int location) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glDisableVertexAttribArray(location);
    }

    public void enableVertexAttribute(String name) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchAttributeLocation(name);
        if (location == -1) {
            return;
        }
        gl.glEnableVertexAttribArray(location);
    }

    public void enableVertexAttribute(int location) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glEnableVertexAttribArray(location);
    }

    private void checkManaged() {
        if (this.invalidated) {
            if (this.geometryShaderSource != null) {
                this.compileShaders(this.getName(), this.vertexShaderSource, this.geometryShaderSource, this.fragmentShaderSource);
            } else {
                this.compileShaders(this.getName(), this.vertexShaderSource, this.fragmentShaderSource);
            }
            this.invalidated = false;
        }
    }

    private void addManagedShader(Application app, ExtShaderProgram shaderProgram) {
        Array managedResources = (Array)shaders.get((Object)app);
        if (managedResources == null) {
            managedResources = new Array();
        }
        managedResources.add((Object)shaderProgram);
        shaders.put((Object)app, (Object)managedResources);
    }

    public void setAttributef(String name, float value1, float value2, float value3, float value4) {
        GL20 gl = Gdx.gl20;
        int location = this.fetchAttributeLocation(name);
        gl.glVertexAttrib4f(location, value1, value2, value3, value4);
    }

    protected void fetchUniforms() {
        this.params.clear();
        Gdx.gl20.glGetProgramiv(this.program, 35718, this.params);
        int numUniforms = this.params.get(0);
        this.uniformNames = new String[numUniforms];
        for (int i = 0; i < numUniforms; ++i) {
            this.params.clear();
            this.params.put(0, 1);
            this.type.clear();
            String name = Gdx.gl20.glGetActiveUniform(this.program, i, this.params, this.type);
            int location = Gdx.gl20.glGetUniformLocation(this.program, name);
            this.uniforms.put((Object)name, location);
            this.uniformTypes.put((Object)name, this.type.get(0));
            this.uniformSizes.put((Object)name, this.params.get(0));
            this.uniformNames[i] = name;
        }
    }

    protected void fetchAttributes() {
        this.params.clear();
        Gdx.gl20.glGetProgramiv(this.program, 35721, this.params);
        int numAttributes = this.params.get(0);
        this.attributeNames = new String[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            this.params.clear();
            this.params.put(0, 1);
            this.type.clear();
            String name = Gdx.gl20.glGetActiveAttrib(this.program, i, this.params, this.type);
            int location = Gdx.gl20.glGetAttribLocation(this.program, name);
            this.attributes.put((Object)name, location);
            this.attributeTypes.put((Object)name, this.type.get(0));
            this.attributeSizes.put((Object)name, this.params.get(0));
            this.attributeNames[i] = name;
        }
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey((Object)name);
    }

    public int getAttributeType(String name) {
        return this.attributeTypes.get((Object)name, 0);
    }

    public int getAttributeLocation(String name) {
        return this.attributes.get((Object)name, -1);
    }

    public int getAttributeSize(String name) {
        return this.attributeSizes.get((Object)name, 0);
    }

    public boolean hasUniform(String name) {
        return this.uniforms.containsKey((Object)name);
    }

    public int getUniformType(String name) {
        return this.uniformTypes.get((Object)name, 0);
    }

    public int getUniformLocation(String name) {
        return this.uniforms.get((Object)name, -1);
    }

    public int getUniformSize(String name) {
        return this.uniformSizes.get((Object)name, 0);
    }

    public String[] getAttributes() {
        return this.attributeNames;
    }

    public String[] getUniforms() {
        return this.uniformNames;
    }

    public String getVertexShaderSource() {
        return this.vertexShaderSource;
    }

    public String getVertexShaderFileName() {
        return this.vertexShaderFile;
    }

    public String getGeometryShaderSource() {
        return this.geometryShaderSource;
    }

    public String getGeometryShaderFileName() {
        return this.geometryShaderFile;
    }

    public String getFragmentShaderSource() {
        return this.fragmentShaderSource;
    }

    public String getFragmentShaderFileName() {
        return this.fragmentShaderFile;
    }

    public void dispose() {
        if (this.isCompiled && !this.isDisposed) {
            GL33.glUseProgram((int)0);
            if (this.vertexShaderHandle != 0) {
                GL33.glDeleteShader((int)this.vertexShaderHandle);
            }
            if (this.geometryShaderHandle != 0) {
                GL33.glDeleteShader((int)this.geometryShaderHandle);
            }
            if (this.fragmentShaderHandle != 0) {
                GL33.glDeleteShader((int)this.fragmentShaderHandle);
            }
            GL33.glDeleteProgram((int)this.program);
            if (shaders.get((Object)Gdx.app) != null) {
                ((Array)shaders.get((Object)Gdx.app)).removeValue((Object)this, true);
            }
            this.isDisposed = true;
        }
    }

    public void writeShaders() {
        ExtShaderProgram.writeShader(this.getVertexShaderFileName(), this.getVertexShaderSource());
        ExtShaderProgram.writeShader(this.getGeometryShaderFileName(), this.getGeometryShaderSource());
        ExtShaderProgram.writeShader(this.getFragmentShaderFileName(), this.getFragmentShaderSource());
    }

    public static void writeShader(String name, String code) {
        if (name == null || name.isEmpty() || code == null || code.isEmpty()) {
            return;
        }
        Path dir = SysUtils.getCrashShadersDir();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Creating " + String.valueOf(dir) + " directory crashed (inception level 1 achieved!)");
        }
        name = name.substring(name.lastIndexOf(File.separatorChar) + 1);
        Path crashReportFile = dir.resolve(name);
        try (PrintWriter out = new PrintWriter(crashReportFile.toFile());){
            out.println(code);
        }
        catch (Exception e) {
            logger.error("Writing crashed shader crashed (inception level 1 achieved!)");
        }
    }
}

