/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import gaiasky.util.Bits;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.shader.BaseIntShader;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.RelativisticShader;
import gaiasky.util.gdx.shader.attribute.AtmosphereAttribute;
import gaiasky.util.gdx.shader.attribute.Attributes;
import gaiasky.util.gdx.shader.attribute.Vector3Attribute;
import gaiasky.util.gdx.shader.provider.ShaderProgramProvider;
import java.util.Objects;

public class GroundShader
extends RelativisticShader {
    public final int fAlpha = this.register(Inputs.alpha, Setters.alpha);
    public final int fCameraHeight = this.register(Inputs.cameraHeight, Setters.cameraHeight);
    public final int fOuterRadius = this.register(Inputs.outerRadius, Setters.outerRadius);
    public final int fInnerRadius = this.register(Inputs.innerRadius, Setters.innerRadius);
    public final int fKrESun = this.register(Inputs.krESun, Setters.krESun);
    public final int fKmESun = this.register(Inputs.kmESun, Setters.kmESun);
    public final int fKr4PI = this.register(Inputs.kr4PI, Setters.kr4PI);
    public final int fKm4PI = this.register(Inputs.km4PI, Setters.km4PI);
    public final int fScale = this.register(Inputs.scale, Setters.scale);
    public final int fScaleDepth = this.register(Inputs.scaleDepth, Setters.scaleDepth);
    public final int fScaleOverScaleDepth = this.register(Inputs.scaleOverScaleDepth, Setters.scaleOverScaleDepth);
    public final int nSamples = this.register(Inputs.nSamples, Setters.nSamples);
    public final int fogDensity = this.register(Inputs.fogDensity, Setters.fogDensity);
    public final int fogColor = this.register(Inputs.fogColor, Setters.fogColor);
    public final int g = this.register(Inputs.g, Setters.g);
    public final int v3PlanetPos = this.register(Inputs.planetPos, Setters.planetPos);
    public final int v3LightPos;
    public final int v3CameraPos = this.register(Inputs.cameraPos, Setters.cameraPos);
    public final int v3InvWavelength;

    public GroundShader(IntRenderable renderable, DefaultIntShader.Config config) {
        this(renderable, config, GroundShader.createPrefix(renderable, config));
    }

    public GroundShader(IntRenderable renderable, DefaultIntShader.Config config, String prefix) {
        this(renderable, config, prefix, config.vertexShaderCode != null ? config.vertexShaderCode : GroundShader.getDefaultVertexShader(), config.fragmentShaderCode != null ? config.fragmentShaderCode : GroundShader.getDefaultFragmentShader());
    }

    public GroundShader(IntRenderable renderable, DefaultIntShader.Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ExtShaderProgram(config.vertexShaderFile, config.fragmentShaderFile, ShaderProgramProvider.getShaderCode(prefix, vertexShader), ShaderProgramProvider.getShaderCode(prefix, fragmentShader)));
    }

    public GroundShader(IntRenderable renderable, DefaultIntShader.Config config, ExtShaderProgram shaderProgram) {
        super(renderable, config, shaderProgram);
        this.v3LightPos = this.register(Inputs.lightPos, Setters.lightPos);
        this.v3InvWavelength = this.register(Inputs.invWavelength, Setters.invWavelength);
    }

    public static String createPrefix(IntRenderable renderable, DefaultIntShader.Config config) {
        Object prefix = RelativisticShader.createPrefix(renderable, config);
        Bits mask = renderable.material.getMask();
        if (mask.has(AtmosphereAttribute.CameraHeight)) {
            prefix = (String)prefix + "#define atmosphereGround\n";
        }
        if (mask.has(AtmosphereAttribute.KrESun)) {
            prefix = (String)prefix + "#define atmosphereObject\n";
        }
        return prefix;
    }

    @Override
    public boolean canRender(IntRenderable renderable) {
        return super.canRender(renderable) && this.shadowMap == (renderable.environment.shadowMap != null);
    }

    public static class Inputs
    extends RelativisticShader.Inputs {
        public static final BaseIntShader.Uniform alpha = new BaseIntShader.Uniform("fAlpha");
        public static final BaseIntShader.Uniform cameraHeight = new BaseIntShader.Uniform("fCameraHeight");
        public static final BaseIntShader.Uniform outerRadius = new BaseIntShader.Uniform("fOuterRadius");
        public static final BaseIntShader.Uniform innerRadius = new BaseIntShader.Uniform("fInnerRadius");
        public static final BaseIntShader.Uniform krESun = new BaseIntShader.Uniform("fKrESun");
        public static final BaseIntShader.Uniform kmESun = new BaseIntShader.Uniform("fKmESun");
        public static final BaseIntShader.Uniform kr4PI = new BaseIntShader.Uniform("fKr4PI");
        public static final BaseIntShader.Uniform km4PI = new BaseIntShader.Uniform("fKm4PI");
        public static final BaseIntShader.Uniform scale = new BaseIntShader.Uniform("fScale");
        public static final BaseIntShader.Uniform scaleDepth = new BaseIntShader.Uniform("fScaleDepth");
        public static final BaseIntShader.Uniform scaleOverScaleDepth = new BaseIntShader.Uniform("fScaleOverScaleDepth");
        public static final BaseIntShader.Uniform nSamples = new BaseIntShader.Uniform("nSamples");
        public static final BaseIntShader.Uniform g = new BaseIntShader.Uniform("g");
        public static final BaseIntShader.Uniform fogDensity = new BaseIntShader.Uniform("u_fogDensity");
        public static final BaseIntShader.Uniform fogColor = new BaseIntShader.Uniform("u_fogCol");
        public static final BaseIntShader.Uniform planetPos = new BaseIntShader.Uniform("v3PlanetPos");
        public static final BaseIntShader.Uniform lightPos = new BaseIntShader.Uniform("v3LightPos");
        public static final BaseIntShader.Uniform cameraPos = new BaseIntShader.Uniform("v3CameraPos");
        public static final BaseIntShader.Uniform invWavelength = new BaseIntShader.Uniform("v3InvWavelength");
    }

    public static class Setters
    extends RelativisticShader.Setters {
        public static final BaseIntShader.Setter alpha = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.Alpha)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.Alpha))).value);
                }
            }
        };
        public static final BaseIntShader.Setter cameraHeight = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.CameraHeight)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.CameraHeight))).value);
                }
            }
        };
        public static final BaseIntShader.Setter outerRadius = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.OuterRadius)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.OuterRadius))).value);
                }
            }
        };
        public static final BaseIntShader.Setter innerRadius = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.InnerRadius)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.InnerRadius))).value);
                }
            }
        };
        public static final BaseIntShader.Setter krESun = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.KrESun)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.KrESun))).value);
                }
            }
        };
        public static final BaseIntShader.Setter kmESun = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.KmESun)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.KmESun))).value);
                }
            }
        };
        public static final BaseIntShader.Setter kr4PI = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.Kr4PI)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.Kr4PI))).value);
                }
            }
        };
        public static final BaseIntShader.Setter km4PI = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.Km4PI)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.Km4PI))).value);
                }
            }
        };
        public static final BaseIntShader.Setter scale = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.Scale)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.Scale))).value);
                }
            }
        };
        public static final BaseIntShader.Setter scaleDepth = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.ScaleDepth)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.ScaleDepth))).value);
                }
            }
        };
        public static final BaseIntShader.Setter scaleOverScaleDepth = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.ScaleOverScaleDepth)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.ScaleOverScaleDepth))).value);
                }
            }
        };
        public static final BaseIntShader.Setter nSamples = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.nSamples)) {
                    shader.set(inputID, (int)((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.nSamples))).value);
                }
            }
        };
        public static final BaseIntShader.Setter fogDensity = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.FogDensity)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.FogDensity))).value);
                }
            }
        };
        public static final BaseIntShader.Setter fogColor = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.FogColor)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.FogColor))).value);
                }
            }
        };
        public static final BaseIntShader.Setter g = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(AtmosphereAttribute.G)) {
                    shader.set(inputID, ((AtmosphereAttribute)Objects.requireNonNull(combinedAttributes.get((int)AtmosphereAttribute.G))).value);
                }
            }
        };
        public static final BaseIntShader.Setter planetPos = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.PlanetPos)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.PlanetPos))).value);
                }
            }
        };
        public static final BaseIntShader.Setter cameraPos = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.CameraPos)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.CameraPos))).value);
                }
            }
        };
        public static final BaseIntShader.Setter lightPos = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.LightPos)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.LightPos))).value);
                }
            }
        };
        public static final BaseIntShader.Setter invWavelength = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.InvWavelength)) {
                    shader.set(inputID, ((Vector3Attribute)Objects.requireNonNull(combinedAttributes.get((int)Vector3Attribute.InvWavelength))).value);
                }
            }
        };
    }
}

