/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import gaiasky.util.Bits;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.shader.BaseIntShader;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.attribute.Attributes;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.Matrix3Attribute;
import gaiasky.util.gdx.shader.attribute.Vector3Attribute;
import gaiasky.util.gdx.shader.attribute.Vector4Attribute;
import gaiasky.util.gdx.shader.provider.ShaderProgramProvider;

public class RelativisticShader
extends DefaultIntShader {
    public final int u_vc = this.register(Inputs.vc, Setters.vc);
    public final int u_velDir = this.register(Inputs.velDir, Setters.velDir);
    public final int u_hterms = this.register(Inputs.hterms, Setters.hTerms);
    public final int u_gw = this.register(Inputs.gw, Setters.gw);
    public final int u_gwmat3 = this.register(Inputs.gwmat3, Setters.gwmat3);
    public final int u_ts = this.register(Inputs.ts, Setters.ts);
    public final int u_omgw = this.register(Inputs.omgw, Setters.omgw);

    public RelativisticShader(IntRenderable renderable) {
        this(renderable, new DefaultIntShader.Config());
    }

    public RelativisticShader(IntRenderable renderable, DefaultIntShader.Config config) {
        this(renderable, config, RelativisticShader.createPrefix(renderable, config));
    }

    public RelativisticShader(IntRenderable renderable, DefaultIntShader.Config config, String prefix) {
        this(renderable, config, prefix, config.vertexShaderCode != null ? config.vertexShaderCode : RelativisticShader.getDefaultVertexShader(), config.fragmentShaderCode != null ? config.fragmentShaderCode : RelativisticShader.getDefaultFragmentShader());
    }

    public RelativisticShader(IntRenderable renderable, DefaultIntShader.Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ExtShaderProgram(config.vertexShaderFile, config.fragmentShaderFile, ShaderProgramProvider.getShaderCode(prefix, vertexShader), ShaderProgramProvider.getShaderCode(prefix, fragmentShader)));
    }

    public RelativisticShader(IntRenderable renderable, DefaultIntShader.Config config, ExtShaderProgram shaderProgram) {
        super(renderable, config, shaderProgram);
    }

    public static String createPrefix(IntRenderable renderable, DefaultIntShader.Config config) {
        Object prefix = DefaultIntShader.createPrefix(renderable, config);
        Bits mask = renderable.material.getMask();
        if (mask.has(FloatAttribute.Vc)) {
            prefix = (String)prefix + "#define relativisticEffects\n";
        }
        if (mask.has(FloatAttribute.Omgw)) {
            prefix = (String)prefix + "#define gravitationalWaves\n";
        }
        return prefix;
    }

    public static class Inputs
    extends DefaultIntShader.Inputs {
        public static final BaseIntShader.Uniform vc = new BaseIntShader.Uniform("u_vc");
        public static final BaseIntShader.Uniform velDir = new BaseIntShader.Uniform("u_velDir");
        public static final BaseIntShader.Uniform hterms = new BaseIntShader.Uniform("u_hterms");
        public static final BaseIntShader.Uniform gw = new BaseIntShader.Uniform("u_gw");
        public static final BaseIntShader.Uniform gwmat3 = new BaseIntShader.Uniform("u_gwmat3");
        public static final BaseIntShader.Uniform ts = new BaseIntShader.Uniform("u_ts");
        public static final BaseIntShader.Uniform omgw = new BaseIntShader.Uniform("u_omgw");
    }

    public static class Setters
    extends DefaultIntShader.Setters {
        public static final BaseIntShader.Setter vc = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.Vc)) {
                    shader.set(inputID, ((FloatAttribute)combinedAttributes.get((int)FloatAttribute.Vc)).value);
                }
            }
        };
        public static final BaseIntShader.Setter velDir = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.VelDir)) {
                    shader.set(inputID, ((Vector3Attribute)combinedAttributes.get((int)Vector3Attribute.VelDir)).value);
                }
            }
        };
        public static final BaseIntShader.Setter hTerms = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector4Attribute.Hterms)) {
                    float[] val = ((Vector4Attribute)combinedAttributes.get((int)Vector4Attribute.Hterms)).value;
                    shader.set(inputID, val[0], val[1], val[2], val[3]);
                }
            }
        };
        public static final BaseIntShader.Setter gw = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Vector3Attribute.Gw)) {
                    shader.set(inputID, ((Vector3Attribute)combinedAttributes.get((int)Vector3Attribute.Gw)).value);
                }
            }
        };
        public static final BaseIntShader.Setter gwmat3 = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(Matrix3Attribute.Gwmat3)) {
                    shader.set(inputID, ((Matrix3Attribute)combinedAttributes.get((int)Matrix3Attribute.Gwmat3)).value);
                }
            }
        };
        public static final BaseIntShader.Setter ts = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.Ts)) {
                    shader.set(inputID, ((FloatAttribute)combinedAttributes.get((int)FloatAttribute.Ts)).value);
                }
            }
        };
        public static final BaseIntShader.Setter omgw = new BaseIntShader.Setter(){

            @Override
            public boolean isGlobal(BaseIntShader shader, int inputID) {
                return false;
            }

            @Override
            public void set(BaseIntShader shader, int inputID, IntRenderable renderable, Attributes combinedAttributes) {
                if (combinedAttributes.has(FloatAttribute.Omgw)) {
                    shader.set(inputID, ((FloatAttribute)combinedAttributes.get((int)FloatAttribute.Omgw)).value);
                }
            }
        };
    }
}

