/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.BufferUtils;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.i18n.I18n;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL41;

public class ShaderCache {
    private static final Logger.Log logger = Logger.getLogger(ShaderCache.class);
    private static ShaderCache instance;
    private static final String DEFAULT_SHADER_NAME = "default";
    private final boolean cacheEnabled;
    protected IntBuffer type = BufferUtils.newIntBuffer((int)1);
    protected IntBuffer len = BufferUtils.newIntBuffer((int)1);
    protected IntBuffer format = BufferUtils.newIntBuffer((int)1);
    protected IntBuffer intBuffer = BufferUtils.newIntBuffer((int)1);
    protected ByteBuffer byteBuffer = ByteBuffer.allocateDirect(56000);
    protected int program = -1;
    protected String log;
    boolean isCompiled = false;

    public static synchronized ShaderCache instance() {
        if (instance == null) {
            instance = new ShaderCache();
        }
        return instance;
    }

    public ShaderCache() {
        this.cacheEnabled = Gdx.graphics.getGLVersion().isVersionEqualToOrHigher(4, 1) && Settings.settings.program.shaderCache && !Settings.settings.program.safeMode;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public String getLog() {
        return this.log;
    }

    public int getProgram() {
        return this.program;
    }

    public void clear() {
        this.isCompiled = false;
        this.log = null;
        this.program = -1;
        this.type.rewind();
        this.len.rewind();
        this.format.rewind();
        this.intBuffer.rewind();
        this.byteBuffer.rewind();
    }

    /*
     * Exception decompiling
     */
    private int checkCache(String name, String code) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean putInCache(int program, String name, String code) {
        if (!this.cacheEnabled) {
            return false;
        }
        int hash = code.hashCode();
        Path cacheLocation = SysUtils.getShaderCacheDir();
        this.len.rewind();
        GL33.glGetProgramiv((int)program, (int)34625, (IntBuffer)this.len);
        int binaryLength = this.len.get();
        this.len.rewind();
        if (this.byteBuffer.capacity() < binaryLength) {
            this.byteBuffer = ByteBuffer.allocateDirect(binaryLength);
        } else {
            this.byteBuffer.clear();
        }
        GL41.glGetProgramBinary((int)program, (IntBuffer)this.len, (IntBuffer)this.format, (ByteBuffer)this.byteBuffer);
        int err = GL41.glGetError();
        if (err == 0) {
            int formatInt = this.format.get();
            String cacheFileName = name + "_" + hash + "_" + formatInt + ".bin";
            Path cacheFile = cacheLocation.resolve(cacheFileName);
            try (FileOutputStream fos = new FileOutputStream(cacheFile.toFile());){
                for (int remaining = this.len.get(); this.byteBuffer.hasRemaining() && remaining > 0; --remaining) {
                    fos.write(this.byteBuffer.get());
                }
            }
            catch (IOException e) {
                logger.error(e);
                return false;
            }
            return true;
        }
        String log = GL33.glGetProgramInfoLog((int)program);
        logger.error(log);
        return false;
    }

    public int[] compileShaders(String name, String vertexShader, String tessControlShader, String tessEvalShader, String fragmentShader) {
        this.clear();
        boolean logCompile = true;
        if (name == null) {
            name = DEFAULT_SHADER_NAME;
            logCompile = false;
        }
        this.program = this.checkCache(name, vertexShader + tessControlShader + tessEvalShader + fragmentShader);
        if (this.program == -1) {
            if (logCompile) {
                logger.info(I18n.msg("notif.shader.compile", name));
            }
            int vertexShaderHandle = this.loadShader(35633, vertexShader);
            int controlShaderHandle = this.loadShader(36488, tessControlShader);
            int evaluationShaderHandle = this.loadShader(36487, tessEvalShader);
            int fragmentShaderHandle = this.loadShader(35632, fragmentShader);
            logger.debug(I18n.msg("notif.shader.load.handle", vertexShaderHandle, fragmentShaderHandle));
            if (vertexShaderHandle == -1 || controlShaderHandle == -1 || evaluationShaderHandle == -1 || fragmentShaderHandle == -1) {
                this.isCompiled = false;
                return new int[]{this.program, vertexShaderHandle, controlShaderHandle, evaluationShaderHandle, fragmentShaderHandle};
            }
            this.program = this.linkProgram(this.createProgram(), vertexShaderHandle, controlShaderHandle, evaluationShaderHandle, fragmentShaderHandle);
            if (this.program == -1) {
                this.isCompiled = false;
                return new int[]{this.program, vertexShaderHandle, controlShaderHandle, evaluationShaderHandle, fragmentShaderHandle};
            }
            if (this.putInCache(this.program, name, vertexShader + controlShaderHandle + evaluationShaderHandle + fragmentShader)) {
                logger.debug("Shader " + name + " saved to cache");
            }
            this.isCompiled = true;
            return new int[]{this.program, vertexShaderHandle, controlShaderHandle, evaluationShaderHandle, fragmentShaderHandle};
        }
        logger.debug(I18n.msg("notif.shader.cache", name));
        return new int[]{this.program, 0, 0, 0, 0};
    }

    public int[] compileShaders(String name, String vertexShader, String geometryShader, String fragmentShader) {
        this.clear();
        boolean logCompile = true;
        if (name == null) {
            name = DEFAULT_SHADER_NAME;
            logCompile = false;
        }
        this.program = this.checkCache(name, vertexShader + geometryShader + fragmentShader);
        if (this.program == -1) {
            if (logCompile) {
                logger.info(I18n.msg("notif.shader.compile", name));
            }
            int vertexShaderHandle = this.loadShader(35633, vertexShader);
            int geometryShaderHandle = this.loadShader(36313, geometryShader);
            int fragmentShaderHandle = this.loadShader(35632, fragmentShader);
            logger.debug(I18n.msg("notif.shader.load.handle", vertexShaderHandle, fragmentShaderHandle));
            if (vertexShaderHandle == -1 || geometryShaderHandle == -1 || fragmentShaderHandle == -1) {
                this.isCompiled = false;
                return new int[]{this.program, vertexShaderHandle, geometryShaderHandle, fragmentShaderHandle};
            }
            this.program = this.linkProgram(this.createProgram(), vertexShaderHandle, geometryShaderHandle, fragmentShaderHandle);
            if (this.program == -1) {
                this.isCompiled = false;
                return new int[]{this.program, vertexShaderHandle, geometryShaderHandle, fragmentShaderHandle};
            }
            if (this.putInCache(this.program, name, vertexShader + geometryShader + fragmentShader)) {
                logger.debug("Shader " + name + " saved to cache");
            }
            this.isCompiled = true;
            return new int[]{this.program, vertexShaderHandle, geometryShaderHandle, fragmentShaderHandle};
        }
        logger.debug(I18n.msg("notif.shader.cache", name));
        return new int[]{this.program, 0, 0, 0};
    }

    public int[] compileShaders(String name, String vertexShader, String fragmentShader) {
        this.clear();
        boolean logCompile = true;
        if (name == null) {
            name = DEFAULT_SHADER_NAME;
            logCompile = false;
        }
        this.program = this.checkCache(name, vertexShader + fragmentShader);
        if (this.program == -1) {
            if (logCompile) {
                logger.info(I18n.msg("notif.shader.compile", name));
            }
            int vertexShaderHandle = this.loadShader(35633, vertexShader);
            int fragmentShaderHandle = this.loadShader(35632, fragmentShader);
            logger.debug(I18n.msg("notif.shader.load.handle", vertexShaderHandle, fragmentShaderHandle));
            if (vertexShaderHandle == -1 || fragmentShaderHandle == -1) {
                this.isCompiled = false;
                return new int[]{this.program, vertexShaderHandle, fragmentShaderHandle};
            }
            this.program = this.linkProgram(this.createProgram(), vertexShaderHandle, fragmentShaderHandle);
            if (this.program == -1) {
                this.isCompiled = false;
                return new int[]{this.program, vertexShaderHandle, fragmentShaderHandle};
            }
            try {
                if (this.putInCache(this.program, name, vertexShader + fragmentShader)) {
                    logger.debug("Shader " + name + " saved to cache");
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
            this.isCompiled = true;
            return new int[]{this.program, vertexShaderHandle, fragmentShaderHandle};
        }
        logger.debug(I18n.msg("notif.shader.cache", name));
        return new int[]{this.program, 0, 0};
    }

    protected int createProgram() {
        int program = GL33.glCreateProgram();
        return program != 0 ? program : -1;
    }

    private int loadShader(int type, String source) {
        int shader = GL41.glCreateShader((int)type);
        if (shader == 0) {
            return -1;
        }
        this.intBuffer.rewind();
        GL41.glShaderSource((int)shader, (CharSequence)source);
        GL41.glCompileShader((int)shader);
        GL41.glGetShaderiv((int)shader, (int)35713, (IntBuffer)this.intBuffer);
        int compiled = this.intBuffer.get(0);
        if (compiled == 0) {
            String infoLog = GL41.glGetShaderInfoLog((int)shader);
            switch (type) {
                case 35633: {
                    this.log = this.log + "Vertex shader\n";
                    break;
                }
                case 35632: {
                    this.log = this.log + "Fragment shader\n";
                    break;
                }
                case 36313: {
                    this.log = this.log + "Geometry shader\n";
                    break;
                }
                case 36488: {
                    this.log = this.log + "Tessellation control shader\n";
                    break;
                }
                case 36487: {
                    this.log = this.log + "Tessellation evaluation shader\n";
                }
            }
            this.log = this.log + infoLog;
            return -1;
        }
        return shader;
    }

    private int linkProgram(int program, int vertexShaderHandle, int fragmentShaderHandle) {
        if (program == -1) {
            return -1;
        }
        GL33.glAttachShader((int)program, (int)vertexShaderHandle);
        GL33.glAttachShader((int)program, (int)fragmentShaderHandle);
        GL33.glLinkProgram((int)program);
        GL33.glDetachShader((int)program, (int)vertexShaderHandle);
        GL33.glDetachShader((int)program, (int)fragmentShaderHandle);
        GL33.glGetProgramiv((int)program, (int)35714, (IntBuffer)this.intBuffer);
        int linked = this.intBuffer.get(0);
        if (linked == 0) {
            this.log = GL33.glGetProgramInfoLog((int)program);
            return -1;
        }
        return program;
    }

    private int linkProgram(int program, int vertexShaderHandle, int geometryShaderHandle, int fragmentShaderHandle) {
        if (program == -1) {
            return -1;
        }
        GL33.glAttachShader((int)program, (int)vertexShaderHandle);
        GL33.glAttachShader((int)program, (int)geometryShaderHandle);
        GL33.glAttachShader((int)program, (int)fragmentShaderHandle);
        GL33.glLinkProgram((int)program);
        GL33.glDetachShader((int)program, (int)vertexShaderHandle);
        GL33.glDetachShader((int)program, (int)geometryShaderHandle);
        GL33.glDetachShader((int)program, (int)fragmentShaderHandle);
        GL33.glGetProgramiv((int)program, (int)35714, (IntBuffer)this.intBuffer);
        int linked = this.intBuffer.get(0);
        if (linked == 0) {
            this.log = GL33.glGetProgramInfoLog((int)program);
            return -1;
        }
        return program;
    }

    private int linkProgram(int program, int vertexShaderHandle, int controlShaderHandle, int evaluationShaderHandle, int fragmentShaderHandle) {
        if (program == -1) {
            return -1;
        }
        GL41.glAttachShader((int)program, (int)vertexShaderHandle);
        GL41.glAttachShader((int)program, (int)controlShaderHandle);
        GL41.glAttachShader((int)program, (int)evaluationShaderHandle);
        GL41.glAttachShader((int)program, (int)fragmentShaderHandle);
        GL41.glLinkProgram((int)program);
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = tmp.asIntBuffer();
        GL41.glGetProgramiv((int)program, (int)35714, (IntBuffer)intBuffer);
        int linked = intBuffer.get(0);
        if (linked == 0) {
            this.log = GL41.glGetProgramInfoLog((int)program);
            return -1;
        }
        return program;
    }

    private static /* synthetic */ boolean lambda$checkCache$0(PathMatcher pathMatcher, Path path, BasicFileAttributes f) {
        return pathMatcher.matches(path);
    }

    public static class ShaderCacheException
    extends RuntimeException {
        public ShaderCacheException(Throwable e) {
            super(e);
        }

        public ShaderCacheException(String e) {
            super(e);
        }
    }
}

