/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import gaiasky.util.Bits;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.model.IntMeshPart;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.GroundShader;
import gaiasky.util.gdx.shader.RelativisticShader;
import gaiasky.util.gdx.shader.TessellationShaderProgram;
import gaiasky.util.gdx.shader.attribute.AtmosphereAttribute;
import gaiasky.util.gdx.shader.provider.ShaderProgramProvider;
import gaiasky.util.gdx.shader.provider.TessellationShaderProvider;

public class TessellationShader
extends GroundShader {
    public TessellationShader(IntRenderable renderable, TessellationShaderProvider.Config config, String prefix, String vertexShader, String controlShader, String evaluationShader, String fragmentShader) {
        this(renderable, config, new TessellationShaderProgram(ShaderProgramProvider.getShaderCode(prefix, vertexShader), ShaderProgramProvider.getShaderCode(prefix, controlShader), ShaderProgramProvider.getShaderCode(prefix, evaluationShader), ShaderProgramProvider.getShaderCode(prefix, fragmentShader)));
    }

    public TessellationShader(IntRenderable renderable, TessellationShaderProvider.Config config, TessellationShaderProgram shaderProgram) {
        super(renderable, (DefaultIntShader.Config)config, shaderProgram);
    }

    public TessellationShader(IntRenderable renderable, TessellationShaderProvider.Config config) {
        this(renderable, config, TessellationShader.createPrefix(renderable, config));
    }

    public TessellationShader(IntRenderable renderable, TessellationShaderProvider.Config config, String prefix) {
        this(renderable, config, prefix, config.vertexShaderCode, config.controlShader, config.evaluationShader, config.fragmentShaderCode);
    }

    public static String createPrefix(IntRenderable renderable, TessellationShaderProvider.Config config) {
        Object prefix = RelativisticShader.createPrefix(renderable, config);
        Bits mask = renderable.material.getMask();
        if (mask.has(AtmosphereAttribute.CameraHeight)) {
            prefix = (String)prefix + "#define atmosphereGround\n";
        }
        return prefix;
    }

    @Override
    public boolean canRender(IntRenderable renderable) {
        return super.canRender(renderable) && this.shadowMap == (renderable.environment.shadowMap != null);
    }

    @Override
    public void renderMesh(ExtShaderProgram program, IntMeshPart meshPart) {
        meshPart.mesh.render(program, 14, meshPart.offset, meshPart.size, false);
    }
}

