/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.render.GaiaSkyShaderCompileException;
import gaiasky.util.Logger;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.ShaderCache;
import gaiasky.util.i18n.I18n;
import org.lwjgl.opengl.GL41;

public class TessellationShaderProgram
extends ExtShaderProgram {
    private static final Logger.Log logger = Logger.getLogger(ExtShaderProgram.class);
    private static final ObjectMap<Application, Array<TessellationShaderProgram>> shaders = new ObjectMap();
    public static String prependControlCode = "";
    public static String prependEvaluationCode = "";
    private final String controlShaderSource;
    private final String evaluationShaderSource;
    protected String controlShaderFile;
    protected String evaluationShaderFile;
    private int controlShaderHandle;
    private int evaluationShaderHandle;

    public TessellationShaderProgram(String vertexShaderCode, String controlShaderCode, String evaluationShaderCode, String fragmentShaderCode) {
        this(null, null, null, null, null, vertexShaderCode, controlShaderCode, evaluationShaderCode, fragmentShaderCode, false);
    }

    public TessellationShaderProgram(String name, String vertexFile, String tessControlFile, String tessEvaluationFile, String fragmentFile, String vertexShaderCode, String controlShaderCode, String evaluationShaderCode, String fragmentShaderCode, boolean lazyLoading) {
        if (vertexShaderCode == null) {
            throw new IllegalArgumentException("vertex shader must not be null");
        }
        if (controlShaderCode == null) {
            throw new IllegalArgumentException("tess control shader must not be null");
        }
        if (evaluationShaderCode == null) {
            throw new IllegalArgumentException("tess evaluation shader must not be null");
        }
        if (fragmentShaderCode == null) {
            throw new IllegalArgumentException("fragment shader must not be null");
        }
        if (prependVertexCode != null && !prependVertexCode.isEmpty()) {
            vertexShaderCode = prependVertexCode + (String)vertexShaderCode;
        }
        if (prependControlCode != null && !prependControlCode.isEmpty()) {
            controlShaderCode = prependControlCode + (String)controlShaderCode;
        }
        if (prependEvaluationCode != null && !prependEvaluationCode.isEmpty()) {
            evaluationShaderCode = prependEvaluationCode + (String)evaluationShaderCode;
        }
        if (prependFragmentCode != null && !prependFragmentCode.isEmpty()) {
            fragmentShaderCode = prependFragmentCode + (String)fragmentShaderCode;
        }
        this.vertexShaderSource = vertexShaderCode;
        this.controlShaderSource = controlShaderCode;
        this.evaluationShaderSource = evaluationShaderCode;
        this.fragmentShaderSource = fragmentShaderCode;
        this.vertexShaderFile = vertexFile;
        this.fragmentShaderFile = fragmentFile;
        this.controlShaderFile = fragmentFile;
        this.evaluationShaderFile = fragmentFile;
        if (!lazyLoading) {
            this.compile();
        }
    }

    public void compile() {
        if (!this.isCompiled) {
            this.initializeLocalAssets();
            if (this.name != null) {
                logger.info(I18n.msg("notif.shader.compile", this.name));
            }
            if (this.vertexShaderFile != null || this.controlShaderFile != null || this.evaluationShaderFile != null || this.fragmentShaderFile != null) {
                logger.debug(I18n.msg("notif.shader.load.tess", this.vertexShaderFile, this.controlShaderFile, this.evaluationShaderFile, this.fragmentShaderFile));
            }
            this.compileShaders(this.vertexShaderSource, this.controlShaderSource, this.evaluationShaderSource, this.fragmentShaderSource);
            if (this.isCompiled()) {
                this.fetchAttributes();
                this.fetchUniforms();
                this.addManagedShader(Gdx.app, this);
            } else {
                throw new GaiaSkyShaderCompileException(this);
            }
        }
    }

    public static void invalidateAllShaderPrograms(Application app) {
        if (Gdx.gl == null) {
            return;
        }
        Array shaderArray = (Array)shaders.get((Object)app);
        if (shaderArray == null) {
            return;
        }
        for (int i = 0; i < shaderArray.size; ++i) {
            ((TessellationShaderProgram)shaderArray.get((int)i)).invalidated = true;
            ((TessellationShaderProgram)shaderArray.get(i)).checkManaged();
        }
    }

    public static void clearAllShaderPrograms(Application app) {
        shaders.remove((Object)app);
    }

    public static String getManagedStatus() {
        StringBuilder builder = new StringBuilder();
        boolean i = false;
        builder.append("Managed shaders/app: { ");
        for (Application app : shaders.keys()) {
            builder.append(((Array)TessellationShaderProgram.shaders.get((Object)app)).size);
            builder.append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    public static int getNumManagedShaderPrograms() {
        return ((Array)TessellationShaderProgram.shaders.get((Object)Gdx.app)).size;
    }

    private void compileShaders(String vShader, String tcShader, String teShader, String fShader) {
        ShaderCache cache = ShaderCache.instance();
        int[] handles = cache.compileShaders(this.name, vShader, tcShader, teShader, fShader);
        this.program = handles[0];
        this.vertexShaderHandle = handles[1];
        this.controlShaderHandle = handles[2];
        this.evaluationShaderHandle = handles[3];
        this.fragmentShaderHandle = handles[4];
        this.isCompiled = cache.isCompiled();
        this.log = cache.getLog();
    }

    private void checkManaged() {
        if (this.invalidated) {
            this.compileShaders(this.vertexShaderSource, this.controlShaderSource, this.evaluationShaderSource, this.fragmentShaderSource);
            this.invalidated = false;
        }
    }

    private void addManagedShader(Application app, TessellationShaderProgram shaderProgram) {
        Array managedResources = (Array)shaders.get((Object)app);
        if (managedResources == null) {
            managedResources = new Array();
        }
        managedResources.add((Object)shaderProgram);
        shaders.put((Object)app, (Object)managedResources);
    }

    public String getControlShaderSource() {
        return this.controlShaderSource;
    }

    public String getControlShaderFileName() {
        return this.controlShaderFile;
    }

    public String getEvaluationShaderSource() {
        return this.evaluationShaderSource;
    }

    public String getEvaluationShaderFileName() {
        return this.evaluationShaderFile;
    }

    @Override
    public void dispose() {
        if (this.isCompiled && !this.isDisposed) {
            GL41.glUseProgram((int)0);
            if (this.vertexShaderHandle != 0) {
                GL41.glDeleteShader((int)this.vertexShaderHandle);
            }
            if (this.controlShaderHandle != 0) {
                GL41.glDeleteShader((int)this.controlShaderHandle);
            }
            if (this.evaluationShaderHandle != 0) {
                GL41.glDeleteShader((int)this.evaluationShaderHandle);
            }
            if (this.fragmentShaderHandle != 0) {
                GL41.glDeleteShader((int)this.fragmentShaderHandle);
            }
            GL41.glDeleteProgram((int)this.program);
            if (shaders.get((Object)Gdx.app) != null) {
                ((Array)shaders.get((Object)Gdx.app)).removeValue((Object)this, true);
            }
            this.isDisposed = true;
        }
    }

    @Override
    public void writeShaders() {
        super.writeShaders();
        TessellationShaderProgram.writeShader(this.getControlShaderFileName(), this.getControlShaderSource());
        TessellationShaderProgram.writeShader(this.getEvaluationShaderFileName(), this.getEvaluationShaderSource());
    }
}

