/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.attribute;

import com.badlogic.gdx.utils.Array;
import gaiasky.util.Bits;

public abstract class Attribute
implements Comparable<Attribute> {
    private static final Array<String> types = new Array();
    public final Bits type = Bits.empty();
    public final int index;
    private final int typeBit;

    protected Attribute(int index) {
        this.index = index;
        this.type.set(index);
        this.typeBit = index;
    }

    protected Attribute(long oldType) {
        this(Attribute.getIndex(oldType));
    }

    protected static int getIndex(long oldType) {
        int idx = -1;
        while (oldType != 0L && ++idx < 63 && (oldType >> idx & 1L) == 0L) {
        }
        return idx;
    }

    public static Bits getAttributeType(String alias) {
        for (int i = 0; i < Attribute.types.size; ++i) {
            if (((String)types.get(i)).compareTo(alias) != 0) continue;
            Bits b = Bits.empty();
            b.set(i);
            return b;
        }
        return Bits.empty();
    }

    public static String getAttributeAlias(Bits type) {
        int idx = type.nextSetBit(0);
        return idx >= 0 && idx < Attribute.types.size ? (String)types.get(idx) : null;
    }

    public static int getAttributeIndex(Bits type) {
        return type.nextSetBit(0);
    }

    public static int getAttributeIndex(String alias) {
        for (int i = 0; i < Attribute.types.size; ++i) {
            if (((String)types.get(i)).compareTo(alias) != 0) continue;
            return i;
        }
        return -1;
    }

    protected static int register(String alias) {
        int result = Attribute.getAttributeIndex(alias);
        if (result >= 0) {
            return result;
        }
        types.add((Object)alias);
        return Attribute.types.size - 1;
    }

    public static int getNumAttributes() {
        return Attribute.types.size;
    }

    public static Array<String> getTypes() {
        return types;
    }

    public boolean has(int index) {
        return this.type.is(index);
    }

    public abstract Attribute copy();

    protected boolean equals(Attribute other) {
        return other.hashCode() == this.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.type.equals(other.type)) {
            return false;
        }
        return this.equals(other);
    }

    public String toString() {
        return Attribute.getAttributeAlias(this.type);
    }

    public int hashCode() {
        return 7489 * this.typeBit;
    }
}

