/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.attribute;

import com.badlogic.gdx.utils.Array;
import gaiasky.util.Bits;
import gaiasky.util.Logger;
import gaiasky.util.gdx.shader.attribute.Attribute;
import java.util.Comparator;
import java.util.Iterator;

public class Attributes
implements Iterable<Attribute>,
Comparator<Attribute>,
Comparable<Attributes> {
    protected final Array<Attribute> attributes;
    protected Bits mask = Bits.empty();
    protected boolean sorted = true;

    public Attributes() {
        this.attributes = new Array(Bits.DEFAULT_LENGTH);
    }

    public final void sort() {
        if (!this.sorted) {
            this.attributes.sort((Comparator)this);
            this.sorted = true;
        }
    }

    public final Bits getMask() {
        return this.mask;
    }

    public final Attribute get(int index) {
        if (this.has(index)) {
            for (int i = 0; i < this.attributes.size; ++i) {
                if (((Attribute)this.attributes.get((int)i)).index != index) continue;
                return (Attribute)this.attributes.get(i);
            }
        }
        return null;
    }

    public final <T extends Attribute> T get(Class<T> ignored, int index) {
        return (T)this.get(index);
    }

    public void clear() {
        this.mask.clear();
        this.attributes.clear();
    }

    public int size() {
        return this.attributes.size;
    }

    private void enable(Bits mask) {
        Bits ignored = this.mask.or(mask);
    }

    private void disable(Bits mask) {
        Bits ignored = this.mask.andNot(mask);
    }

    public final void set(Attribute attribute) {
        int idx = this.indexOf(attribute.index);
        if (idx < 0) {
            this.mask.set(attribute.index);
            this.attributes.add((Object)attribute);
            this.sorted = false;
        } else {
            this.attributes.set(idx, (Object)attribute);
        }
        this.sort();
    }

    public final void set(Attribute attribute1, Attribute attribute2) {
        this.set(attribute1);
        this.set(attribute2);
    }

    public final void set(Attribute attribute1, Attribute attribute2, Attribute attribute3) {
        this.set(attribute1);
        this.set(attribute2);
        this.set(attribute3);
    }

    public final void set(Attribute attribute1, Attribute attribute2, Attribute attribute3, Attribute attribute4) {
        this.set(attribute1);
        this.set(attribute2);
        this.set(attribute3);
        this.set(attribute4);
    }

    public final void set(Attribute ... attributes) {
        for (Attribute attr : attributes) {
            this.set(attr);
        }
    }

    public final void set(Iterable<Attribute> attributes) {
        for (Attribute attr : attributes) {
            this.set(attr);
        }
    }

    public final void remove(Bits mask) {
        for (int i = this.attributes.size - 1; i >= 0; --i) {
            Bits type = ((Attribute)this.attributes.get((int)i)).type;
            if (!mask.and(type).equals(type)) continue;
            this.attributes.removeIndex(i);
            this.disable(type);
            this.sorted = false;
        }
        this.sort();
    }

    public final void remove(int index) {
        if (this.mask.has(index)) {
            Attribute candidate = null;
            for (Attribute a : this.attributes) {
                if (a.index != index) continue;
                candidate = a;
                break;
            }
            if (candidate != null) {
                this.attributes.removeValue(candidate, true);
            } else {
                Logger.getLogger(Attributes.class).warn("Attribute not found: " + index);
            }
            Bits type = Bits.empty();
            type.set(index);
            this.disable(type);
            this.sorted = false;
        }
        this.sort();
    }

    public final boolean has(Bits mask) {
        return !mask.isEmpty() && this.mask.copy().and(mask).equals(mask);
    }

    public final boolean has(int index) {
        return this.mask.get(index);
    }

    protected int indexOf(int index) {
        if (this.has(index)) {
            for (int i = 0; i < this.attributes.size; ++i) {
                if (((Attribute)this.attributes.get((int)i)).index != index) continue;
                return i;
            }
        }
        return -1;
    }

    public final boolean same(Attributes other, boolean compareValues) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.mask.equals(other.mask)) {
            return false;
        }
        if (!compareValues) {
            return true;
        }
        this.sort();
        other.sort();
        for (int i = 0; i < this.attributes.size; ++i) {
            if (((Attribute)this.attributes.get(i)).equals((Attribute)other.attributes.get(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean same(Attributes other) {
        return this.same(other, false);
    }

    @Override
    public final int compare(Attribute arg0, Attribute arg1) {
        return arg0.compareTo(arg1);
    }

    @Override
    public final Iterator<Attribute> iterator() {
        return this.attributes.iterator();
    }

    public int attributesHash() {
        this.sort();
        int n = this.attributes.size;
        long result = 71 + this.mask.hashCode();
        int m = 1;
        for (int i = 0; i < n; ++i) {
            m = m * 7 & 0xFFFF;
            result += (long)this.mask.hashCode() * (long)((Attribute)this.attributes.get(i)).hashCode() * (long)m;
        }
        return (int)(result ^ result >> 32);
    }

    public int hashCode() {
        return this.attributesHash();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Attributes)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.same((Attributes)other, true);
    }

    @Override
    public int compareTo(Attributes other) {
        if (other == this) {
            return 0;
        }
        return this.mask.compareTo(other.mask);
    }
}

