/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.attribute;

import com.badlogic.gdx.graphics.Color;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRColorAttribute;
import gaiasky.util.gdx.shader.attribute.Attribute;

public class ColorAttribute
extends Attribute {
    public static final String DiffuseAlias = "diffuseColor";
    public static final int Diffuse = ColorAttribute.register("diffuseColor");
    public static final String SpecularAlias = "specularColor";
    public static final int Specular = ColorAttribute.register("specularColor");
    public static final String AmbientAlias = "ambientColor";
    public static final int Ambient = ColorAttribute.register("ambientColor");
    public static final String EmissiveAlias = "emissiveColor";
    public static final int Emissive = ColorAttribute.register("emissiveColor");
    public static final String MetallicAlias = "metallicColor";
    public static final int Metallic = ColorAttribute.register("metallicColor");
    public static final String RoughnessAlias = "roughnessColor";
    public static final int Roughness = ColorAttribute.register("roughnessColor");
    public static final String AmbientLightAlias = "ambientLightColor";
    public static final int AmbientLight = ColorAttribute.register("ambientLightColor");
    public static final String FogAlias = "fogColor";
    public static final int Fog = ColorAttribute.register("fogColor");
    public static final String DiffuseScatteringAlias = "diffuseScatteringColor";
    public static final int DiffuseScattering = ColorAttribute.register("diffuseScatteringColor");
    public final Color color = new Color();

    public ColorAttribute(int index) {
        super(index);
    }

    public ColorAttribute(com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute other) {
        super(ColorAttribute.convertType(other.type));
        this.color.set(other.color);
    }

    private static int convertType(long oldType) {
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute.Ambient) {
            return Ambient;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute.Fog) {
            return Fog;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute.Diffuse) {
            return Diffuse;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute.Emissive) {
            return Emissive;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute.AmbientLight) {
            return AmbientLight;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute.Reflection) {
            return Metallic;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute.Specular) {
            return Specular;
        }
        if (oldType == (long)PBRColorAttribute.BaseColorFactor) {
            return Diffuse;
        }
        return -1;
    }

    public ColorAttribute(int index, Color color) {
        this(index);
        if (color != null) {
            this.color.set(color);
        }
    }

    public ColorAttribute(int index, float r, float g, float b, float a) {
        this(index);
        this.color.set(r, g, b, a);
    }

    public ColorAttribute(int index, float l) {
        this(index);
        this.color.set(l, l, l, 1.0f);
    }

    public ColorAttribute(ColorAttribute copyFrom) {
        this(copyFrom.index, copyFrom.color);
    }

    public static final ColorAttribute createAmbient(Color color) {
        return new ColorAttribute(Ambient, color);
    }

    public static final ColorAttribute createAmbient(float r, float g, float b, float a) {
        return new ColorAttribute(Ambient, r, g, b, a);
    }

    public static final ColorAttribute createDiffuse(Color color) {
        return new ColorAttribute(Diffuse, color);
    }

    public static final ColorAttribute createDiffuse(float r, float g, float b, float a) {
        return new ColorAttribute(Diffuse, r, g, b, a);
    }

    public static final ColorAttribute createSpecular(Color color) {
        return new ColorAttribute(Specular, color);
    }

    public static final ColorAttribute createSpecular(float r, float g, float b, float a) {
        return new ColorAttribute(Specular, r, g, b, a);
    }

    public static final ColorAttribute createMetallic(Color color) {
        return new ColorAttribute(Metallic, color);
    }

    public static final ColorAttribute createMetallic(float r, float g, float b, float a) {
        return new ColorAttribute(Metallic, r, g, b, a);
    }

    public static final ColorAttribute createRoughness(Color color) {
        return new ColorAttribute(Roughness, color);
    }

    public static final ColorAttribute createRoughness(float r, float g, float b, float a) {
        return new ColorAttribute(Roughness, r, g, b, a);
    }

    public static final ColorAttribute createEmissive(Color color) {
        return new ColorAttribute(Emissive, color);
    }

    public static final ColorAttribute createEmissive(float r, float g, float b, float a) {
        return new ColorAttribute(Emissive, r, g, b, a);
    }

    public static final ColorAttribute createAmbientLight(Color color) {
        return new ColorAttribute(AmbientLight, color);
    }

    public static final ColorAttribute createAmbientLight(float r, float g, float b, float a) {
        return new ColorAttribute(AmbientLight, r, g, b, a);
    }

    public static final ColorAttribute createFog(Color color) {
        return new ColorAttribute(Fog, color);
    }

    public static final ColorAttribute createFog(float r, float g, float b, float a) {
        return new ColorAttribute(Fog, r, g, b, a);
    }

    @Override
    public Attribute copy() {
        return new ColorAttribute(this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 953 * result + this.color.toIntBits();
        return result;
    }

    @Override
    public int compareTo(Attribute o) {
        if (this.index != o.index) {
            return this.index - o.index;
        }
        return ((ColorAttribute)o).color.toIntBits() - this.color.toIntBits();
    }
}

