/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.attribute;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.NumberUtils;
import gaiasky.util.gdx.shader.attribute.Attribute;

public class DepthTestAttribute
extends Attribute {
    public static final String Alias = "depthStencil";
    public static final int Type = DepthTestAttribute.register("depthStencil");
    public int depthFunc;
    public float depthRangeNear;
    public float depthRangeFar;
    public boolean depthMask;

    public DepthTestAttribute() {
        this(515);
    }

    public DepthTestAttribute(boolean depthMask) {
        this(515, depthMask);
    }

    public DepthTestAttribute(int depthFunc) {
        this(depthFunc, true);
    }

    public DepthTestAttribute(int depthFunc, boolean depthMask) {
        this(depthFunc, 0.0f, 1.0f, depthMask);
    }

    public DepthTestAttribute(int depthFunc, float depthRangeNear, float depthRangeFar) {
        this(depthFunc, depthRangeNear, depthRangeFar, true);
    }

    public DepthTestAttribute(int depthFunc, float depthRangeNear, float depthRangeFar, boolean depthMask) {
        this(Type, depthFunc, depthRangeNear, depthRangeFar, depthMask);
    }

    public DepthTestAttribute(int index, int depthFunc, float depthRangeNear, float depthRangeFar, boolean depthMask) {
        super(index);
        this.depthFunc = depthFunc;
        this.depthRangeNear = depthRangeNear;
        this.depthRangeFar = depthRangeFar;
        this.depthMask = depthMask;
    }

    public DepthTestAttribute(DepthTestAttribute rhs) {
        this(rhs.index, rhs.depthFunc, rhs.depthRangeNear, rhs.depthRangeFar, rhs.depthMask);
    }

    public DepthTestAttribute(com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute other) {
        this(Type, other.depthFunc, other.depthRangeNear, other.depthRangeFar, other.depthMask);
    }

    @Override
    public Attribute copy() {
        return new DepthTestAttribute(this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 971 * result + this.depthFunc;
        result = 971 * result + NumberUtils.floatToRawIntBits((float)this.depthRangeNear);
        result = 971 * result + NumberUtils.floatToRawIntBits((float)this.depthRangeFar);
        result = 971 * result + (this.depthMask ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(Attribute o) {
        if (this.index != o.index) {
            return this.index - o.index;
        }
        DepthTestAttribute other = (DepthTestAttribute)o;
        if (this.depthFunc != other.depthFunc) {
            return this.depthFunc - other.depthFunc;
        }
        if (this.depthMask != other.depthMask) {
            return this.depthMask ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)this.depthRangeNear, (float)other.depthRangeNear)) {
            return this.depthRangeNear < other.depthRangeNear ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)this.depthRangeFar, (float)other.depthRangeFar)) {
            return this.depthRangeFar < other.depthRangeFar ? -1 : 1;
        }
        return 0;
    }
}

