/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.attribute;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.NumberUtils;
import gaiasky.util.gdx.shader.attribute.Attribute;
import net.jafama.FastMath;

public class Matrix4Attribute
extends Attribute {
    public static final String ShadowMapProjViewTransAlias = "shadowMapProjViewTrans";
    public static final int ShadowMapProjViewTrans = Matrix4Attribute.register("shadowMapProjViewTrans");
    public static final String EnvRotationAlias = "envRotation";
    public static final int EnvRotation = Matrix4Attribute.register("envRotation");
    public Matrix4 value;

    public Matrix4Attribute(int index) {
        super(index);
        this.value = new Matrix4();
    }

    public Matrix4Attribute(int index, Matrix4 value) {
        super(index);
        this.value = new Matrix4(value);
    }

    public static Matrix4Attribute createEnvRotation(float azymuthAngleDegree) {
        return new Matrix4Attribute(EnvRotation).set(azymuthAngleDegree);
    }

    public static Matrix4Attribute createEnvRotation(Matrix4 matrix) {
        return new Matrix4Attribute(EnvRotation).set(matrix);
    }

    public Matrix4Attribute set(Matrix4 value) {
        this.value.set(value);
        return this;
    }

    public Matrix4Attribute set(float azimuthAngleDegree) {
        this.value.setToRotation(Vector3.Y, azimuthAngleDegree);
        return this;
    }

    @Override
    public Attribute copy() {
        return new Matrix4Attribute(this.index, this.value);
    }

    @Override
    public int hashCode() {
        double result = FastMath.pow((double)2.0, (double)this.index);
        result = 977.0 * result + (double)NumberUtils.floatToRawIntBits((float)this.value.val[0]) + (double)NumberUtils.floatToRawIntBits((float)this.value.val[5]) + (double)NumberUtils.floatToRawIntBits((float)this.value.val[10]) + (double)NumberUtils.floatToRawIntBits((float)this.value.val[15]);
        return (int)result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int compareTo(Attribute o) {
        return 0;
    }
}

