/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.attribute;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.NumberUtils;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRTextureAttribute;
import gaiasky.util.gdx.shader.attribute.Attribute;

public class TextureAttribute
extends Attribute {
    public static final String DiffuseAlias = "diffuseTexture";
    public static final int Diffuse = TextureAttribute.register("diffuseTexture");
    public static final String SpecularAlias = "specularTexture";
    public static final int Specular = TextureAttribute.register("specularTexture");
    public static final String BumpAlias = "bumpTexture";
    public static final int Bump = TextureAttribute.register("bumpTexture");
    public static final String NormalAlias = "normalTexture";
    public static final int Normal = TextureAttribute.register("normalTexture");
    public static final String AmbientAlias = "ambientTexture";
    public static final int Ambient = TextureAttribute.register("ambientTexture");
    public static final String EmissiveAlias = "emissiveTexture";
    public static final int Emissive = TextureAttribute.register("emissiveTexture");
    public static final String MetallicAlias = "metallicTexture";
    public static final int Metallic = TextureAttribute.register("metallicTexture");
    public static final String AOAlias = "AOTexture";
    public static final int AO = TextureAttribute.register("AOTexture");
    public static final String RoughnessAlias = "roughnessTexture";
    public static final int Roughness = TextureAttribute.register("roughnessTexture");
    public static final String OcclusionMetallicRoughnessAlias = "occlusionMetallicRoughnessTexture";
    public static final int OcclusionMetallicRoughness = TextureAttribute.register("occlusionMetallicRoughnessTexture");
    public static final String Texture0Alias = "texture0";
    public static final int Texture0 = TextureAttribute.register("texture0");
    public static final String Texture1Alias = "texture1";
    public static final int Texture1 = TextureAttribute.register("texture1");
    public static final String HeightAlias = "heightTexture";
    public static final int Height = TextureAttribute.register("heightTexture");
    public static final String SvtCacheAlias = "svtCacheTexture";
    public static final int SvtCache = TextureAttribute.register("svtCacheTexture");
    public static final String SvtIndirectionDiffuseAlias = "svtIndirectionDiffuseTexture";
    public static final int SvtIndirectionDiffuse = TextureAttribute.register("svtIndirectionDiffuseTexture");
    public static final String SvtIndirectionHeightAlias = "svtIndirectionHeightTexture";
    public static final int SvtIndirectionHeight = TextureAttribute.register("svtIndirectionHeightTexture");
    public static final String SvtIndirectionNormalAlias = "svtIndirectionNormalTexture";
    public static final int SvtIndirectionNormal = TextureAttribute.register("svtIndirectionNormalTexture");
    public static final String SvtIndirectionSpecularAlias = "svtIndirectionSpecularTexture";
    public static final int SvtIndirectionSpecular = TextureAttribute.register("svtIndirectionSpecularTexture");
    public static final String SvtIndirectionRoughnessAlias = "svtIndirectionRoughnessTexture";
    public static final int SvtIndirectionRoughness = TextureAttribute.register("svtIndirectionRoughnessTexture");
    public static final String SvtIndirectionEmissiveAlias = "svtIndirectionEmissiveTexture";
    public static final int SvtIndirectionEmissive = TextureAttribute.register("svtIndirectionEmissiveTexture");
    public static final String SvtIndirectionMetallicAlias = "svtIndirectionMetallicTexture";
    public static final int SvtIndirectionMetallic = TextureAttribute.register("svtIndirectionMetallicTexture");
    public static final String SvtIndirectionAmbientOcclusionAlias = "svtIndirectionAoTexture";
    public static final int SvtIndirectionAmbientOcclusion = TextureAttribute.register("svtIndirectionAoTexture");
    public final TextureDescriptor<Texture> textureDescription;
    public float offsetU = 0.0f;
    public float offsetV = 0.0f;
    public float scaleU = 1.0f;
    public float scaleV = 1.0f;
    public int uvIndex = 0;

    public TextureAttribute(int index) {
        super(index);
        this.textureDescription = new TextureDescriptor();
    }

    public TextureAttribute(com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute other) {
        super(TextureAttribute.convertType(other.type));
        this.textureDescription = other.textureDescription;
        this.offsetU = other.offsetU;
        this.offsetV = other.offsetV;
        this.scaleU = other.scaleU;
        this.scaleV = other.scaleV;
        this.uvIndex = other.uvIndex;
    }

    protected static int convertType(long oldType) {
        if (oldType == (long)PBRTextureAttribute.BaseColorTexture) {
            return Diffuse;
        }
        if (oldType == (long)PBRTextureAttribute.EmissiveTexture) {
            return Emissive;
        }
        if (oldType == (long)PBRTextureAttribute.NormalTexture) {
            return Normal;
        }
        if (oldType == (long)PBRTextureAttribute.SpecularFactorTexture) {
            return Specular;
        }
        if (oldType == (long)PBRTextureAttribute.SpecularColorTexture) {
            return Specular;
        }
        if (oldType == (long)PBRTextureAttribute.MetallicRoughnessTexture) {
            return OcclusionMetallicRoughness;
        }
        if (oldType == (long)PBRTextureAttribute.OcclusionTexture) {
            return AO;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute.Bump) {
            return Bump;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute.Ambient) {
            return Ambient;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute.Diffuse) {
            return Diffuse;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute.Normal) {
            return Normal;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute.Emissive) {
            return Emissive;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute.Reflection) {
            return Metallic;
        }
        if (oldType == com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute.Specular) {
            return Specular;
        }
        return -1;
    }

    public <T extends Texture> TextureAttribute(int index, TextureDescriptor<T> textureDescription) {
        this(index);
        this.textureDescription.set(textureDescription);
    }

    public <T extends Texture> TextureAttribute(int index, TextureDescriptor<T> textureDescription, float offsetU, float offsetV, float scaleU, float scaleV, int uvIndex) {
        this(index, textureDescription);
        this.offsetU = offsetU;
        this.offsetV = offsetV;
        this.scaleU = scaleU;
        this.scaleV = scaleV;
        this.uvIndex = uvIndex;
    }

    public <T extends Texture> TextureAttribute(int index, TextureDescriptor<T> textureDescription, float offsetU, float offsetV, float scaleU, float scaleV) {
        this(index, textureDescription, offsetU, offsetV, scaleU, scaleV, 0);
    }

    public TextureAttribute(int index, Texture texture) {
        this(index);
        this.textureDescription.texture = texture;
    }

    public TextureAttribute(int index, TextureRegion region) {
        this(index);
        this.set(region);
    }

    public TextureAttribute(TextureAttribute copyFrom) {
        this(copyFrom.index, copyFrom.textureDescription, copyFrom.offsetU, copyFrom.offsetV, copyFrom.scaleU, copyFrom.scaleV, copyFrom.uvIndex);
    }

    public static TextureAttribute createDiffuse(Texture texture) {
        return new TextureAttribute(Diffuse, texture);
    }

    public static TextureAttribute createDiffuse(TextureRegion region) {
        return new TextureAttribute(Diffuse, region);
    }

    public static TextureAttribute createSpecular(Texture texture) {
        return new TextureAttribute(Specular, texture);
    }

    public static TextureAttribute createSpecular(TextureRegion region) {
        return new TextureAttribute(Specular, region);
    }

    public static TextureAttribute createNormal(Texture texture) {
        return new TextureAttribute(Normal, texture);
    }

    public static TextureAttribute createNormal(TextureRegion region) {
        return new TextureAttribute(Normal, region);
    }

    public static TextureAttribute createBump(Texture texture) {
        return new TextureAttribute(Bump, texture);
    }

    public static TextureAttribute createBump(TextureRegion region) {
        return new TextureAttribute(Bump, region);
    }

    public static TextureAttribute createAmbient(Texture texture) {
        return new TextureAttribute(Ambient, texture);
    }

    public static TextureAttribute createAmbient(TextureRegion region) {
        return new TextureAttribute(Ambient, region);
    }

    public static TextureAttribute createEmissive(Texture texture) {
        return new TextureAttribute(Emissive, texture);
    }

    public static TextureAttribute createEmissive(TextureRegion region) {
        return new TextureAttribute(Emissive, region);
    }

    public static TextureAttribute createMetallic(Texture texture) {
        return new TextureAttribute(Metallic, texture);
    }

    public static TextureAttribute createReflection(Texture texture) {
        return TextureAttribute.createMetallic(texture);
    }

    public static TextureAttribute createMetallic(TextureRegion region) {
        return new TextureAttribute(Metallic, region);
    }

    public static TextureAttribute createReflection(TextureRegion region) {
        return TextureAttribute.createMetallic(region);
    }

    public static TextureAttribute createHeight(Texture texture) {
        return new TextureAttribute(Height, texture);
    }

    public static TextureAttribute createHeight(TextureRegion region) {
        return new TextureAttribute(Height, region);
    }

    public void set(TextureRegion region) {
        this.textureDescription.texture = region.getTexture();
        this.offsetU = region.getU();
        this.offsetV = region.getV();
        this.scaleU = region.getU2() - this.offsetU;
        this.scaleV = region.getV2() - this.offsetV;
    }

    @Override
    public Attribute copy() {
        return new TextureAttribute(this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 991 * result + this.textureDescription.hashCode();
        result = 991 * result + NumberUtils.floatToRawIntBits((float)this.offsetU);
        result = 991 * result + NumberUtils.floatToRawIntBits((float)this.offsetV);
        result = 991 * result + NumberUtils.floatToRawIntBits((float)this.scaleU);
        result = 991 * result + NumberUtils.floatToRawIntBits((float)this.scaleV);
        result = 991 * result + this.uvIndex;
        return result;
    }

    @Override
    public int compareTo(Attribute o) {
        if (this.index != o.index) {
            return this.index < o.index ? -1 : 1;
        }
        TextureAttribute other = (TextureAttribute)o;
        int c = this.textureDescription.compareTo(other.textureDescription);
        if (c != 0) {
            return c;
        }
        if (this.uvIndex != other.uvIndex) {
            return this.uvIndex - other.uvIndex;
        }
        if (!MathUtils.isEqual((float)this.scaleU, (float)other.scaleU)) {
            return this.scaleU > other.scaleU ? 1 : -1;
        }
        if (!MathUtils.isEqual((float)this.scaleV, (float)other.scaleV)) {
            return this.scaleV > other.scaleV ? 1 : -1;
        }
        if (!MathUtils.isEqual((float)this.offsetU, (float)other.offsetU)) {
            return this.offsetU > other.offsetU ? 1 : -1;
        }
        if (!MathUtils.isEqual((float)this.offsetV, (float)other.offsetV)) {
            return this.offsetV > other.offsetV ? 1 : -1;
        }
        return 0;
    }
}

