/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.loader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import gaiasky.util.Settings;
import java.util.Scanner;

public class ShaderTemplatingLoader {
    private static final String GLSL_EXTENSION = "(glsl|glslv|glslf|vs|fs|gs|vert|frag|vsh|fsh)";
    private static final String FILE_REFERENCE_REGEXP = "[^<>]+\\.(glsl|glslv|glslf|vs|fs|gs|vert|frag|vsh|fsh)";
    private static final String FILE_REFERENCE_BRACKET_REGEXP = "<[^<>]+\\.(glsl|glslv|glslf|vs|fs|gs|vert|frag|vsh|fsh)>";
    private static final String INCLUDE_STATEMENT_REGEXP = "^\\s*#include\\s+([^<>]+\\.(glsl|glslv|glslf|vs|fs|gs|vert|frag|vsh|fsh)|<[^<>]+\\.(glsl|glslv|glslf|vs|fs|gs|vert|frag|vsh|fsh)>)\\s*$";

    public static String load(String file) {
        if (file.matches(FILE_REFERENCE_BRACKET_REGEXP)) {
            file = file.replace("<", "").replace(">", "");
        }
        FileHandle fh = file.startsWith("$data/") ? Settings.settings.data.dataFileHandle(file) : Gdx.files.internal(file);
        return ShaderTemplatingLoader.load(fh);
    }

    public static String load(FileHandle fh) {
        if (fh == null) {
            return null;
        }
        String in = fh.readString();
        return ShaderTemplatingLoader.resolveIncludes(in);
    }

    public static String resolveIncludes(String in) {
        StringBuilder stringBuilder = new StringBuilder();
        Scanner scanner = new Scanner(in);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.matches(INCLUDE_STATEMENT_REGEXP)) {
                String inc = line.substring(line.indexOf("#include") + 9);
                String incSource = ShaderTemplatingLoader.load(inc.strip());
                stringBuilder.append(incSource);
                stringBuilder.append('\n');
                continue;
            }
            if (line.isEmpty() || line.startsWith("//")) continue;
            stringBuilder.append(line);
            stringBuilder.append('\n');
        }
        scanner.close();
        return stringBuilder.toString();
    }
}

