/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.provider;

import com.badlogic.gdx.utils.Array;
import gaiasky.event.Event;
import gaiasky.event.IObserver;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.provider.IntShaderProvider;

public abstract class BaseIntShaderProvider
implements IntShaderProvider,
IObserver {
    protected Array<IntShader> shaders = new Array();

    @Override
    public IntShader getShader(IntRenderable renderable) {
        IntShader suggestedShader = renderable.shader;
        if (suggestedShader != null && suggestedShader.canRender(renderable)) {
            return suggestedShader;
        }
        for (IntShader shader : this.shaders) {
            if (!shader.canRender(renderable)) continue;
            return shader;
        }
        IntShader shader = this.createShader(renderable);
        shader.init();
        this.shaders.add((Object)shader);
        return shader;
    }

    protected abstract IntShader createShader(IntRenderable var1);

    @Override
    public void dispose() {
        for (IntShader shader : this.shaders) {
            shader.dispose();
        }
        this.shaders.clear();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.CLEAR_SHADERS) {
            this.dispose();
        }
    }
}

