/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.provider;

import com.badlogic.gdx.files.FileHandle;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.shader.DefaultIntShader;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.RelativisticShader;
import gaiasky.util.gdx.shader.loader.ShaderTemplatingLoader;
import gaiasky.util.gdx.shader.provider.DefaultIntShaderProvider;

public class RelativisticShaderProvider
extends DefaultIntShaderProvider {
    public final DefaultIntShader.Config config;

    public RelativisticShaderProvider(DefaultIntShader.Config config) {
        this.config = config == null ? new DefaultIntShader.Config() : config;
        EventManager.instance.subscribe((IObserver)this, Event.CLEAR_SHADERS);
    }

    public RelativisticShaderProvider(String vertexFile, String fragmentFile, String vertexShaderCode, String fragmentShaderCode) {
        this(new DefaultIntShader.Config(vertexFile, fragmentFile, vertexShaderCode, fragmentShaderCode));
    }

    public RelativisticShaderProvider(FileHandle vertexShader, FileHandle fragmentShader) {
        this(vertexShader.name(), fragmentShader.name(), ShaderTemplatingLoader.load(vertexShader), ShaderTemplatingLoader.load(fragmentShader));
    }

    public RelativisticShaderProvider() {
        this(null);
    }

    @Override
    protected IntShader createShader(IntRenderable renderable) {
        return new RelativisticShader(renderable, this.config);
    }
}

