/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.provider;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.Settings;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.loader.ShaderTemplatingLoader;

public class ShaderProgramProvider
extends AsynchronousAssetLoader<ExtShaderProgram, ShaderProgramParameter> {
    private String vertexFileSuffix = ".vertex.glsl";
    private String geometryFileSuffix = ".geometry.glsl";
    private String fragmentFileSuffix = ".fragment.glsl";

    public ShaderProgramProvider(FileHandleResolver resolver) {
        super(resolver);
    }

    public ShaderProgramProvider(FileHandleResolver resolver, String vertexFileSuffix, String geometryFileSuffix, String fragmentFileSuffix) {
        super(resolver);
        this.vertexFileSuffix = vertexFileSuffix;
        this.geometryFileSuffix = geometryFileSuffix;
        this.fragmentFileSuffix = fragmentFileSuffix;
    }

    public ShaderProgramProvider(FileHandleResolver resolver, String vertexFileSuffix, String fragmentFileSuffix) {
        this(resolver, vertexFileSuffix, null, fragmentFileSuffix);
    }

    public static String getShaderCode(String prefix, String code) {
        if (code == null) {
            return null;
        }
        if (prefix == null) {
            return code;
        }
        if ((code = code.trim()).startsWith("#version") && !prefix.isEmpty()) {
            int firstLineEnd = code.indexOf(10) + 1;
            String versionStr = code.substring(0, firstLineEnd);
            return versionStr + prefix + code.substring(firstLineEnd);
        }
        return prefix + code;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, ShaderProgramParameter parameter) {
        return null;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, ShaderProgramParameter parameter) {
    }

    public ExtShaderProgram loadSync(AssetManager manager, String fileName, FileHandle file, ShaderProgramParameter parameter) {
        boolean lazyLoad;
        String fragmentCode;
        Object vertFileName = null;
        String geomFileName = null;
        Object fragFileName = null;
        if (parameter != null) {
            if (parameter.vertexFile != null) {
                vertFileName = parameter.vertexFile;
            }
            if (parameter.geometryFile != null) {
                geomFileName = parameter.geometryFile;
            }
            if (parameter.fragmentFile != null) {
                fragFileName = parameter.fragmentFile;
            }
        }
        if (vertFileName == null && fileName.endsWith(this.fragmentFileSuffix)) {
            vertFileName = fileName.substring(0, fileName.length() - this.fragmentFileSuffix.length()) + this.vertexFileSuffix;
        }
        if (fragFileName == null && fileName.endsWith(this.vertexFileSuffix)) {
            fragFileName = fileName.substring(0, fileName.length() - this.vertexFileSuffix.length()) + this.fragmentFileSuffix;
        }
        FileHandle vertexFile = vertFileName == null ? file : this.resolve((String)vertFileName);
        FileHandle geometryFile = geomFileName == null ? null : this.resolve(geomFileName);
        FileHandle fragmentFile = fragFileName == null ? file : this.resolve((String)fragFileName);
        String vertexCode = ShaderTemplatingLoader.load(vertexFile);
        String geometryCode = ShaderTemplatingLoader.load(geometryFile);
        String string = fragmentCode = vertexFile.equals((Object)fragmentFile) ? vertexCode : ShaderTemplatingLoader.load(fragmentFile);
        if (parameter != null) {
            if (parameter.prependVertexCode != null) {
                vertexCode = ShaderProgramProvider.getShaderCode(parameter.prependVertexCode, vertexCode);
            }
            if (parameter.prependGeometryCode != null && geometryCode != null) {
                geometryCode = ShaderProgramProvider.getShaderCode(parameter.prependGeometryCode, geometryCode);
            }
            if (parameter.prependFragmentCode != null) {
                fragmentCode = ShaderProgramProvider.getShaderCode(parameter.prependFragmentCode, fragmentCode);
            }
        }
        boolean bl = lazyLoad = parameter != null && parameter.name != null && (parameter.name.contains("Rel") || parameter.name.contains("Grav") || parameter.name.contains("SSR") && !Settings.settings.postprocess.ssr.active);
        ExtShaderProgram shaderProgram = geometryCode != null ? new ExtShaderProgram(parameter.name, (String)vertFileName, geomFileName, (String)fragFileName, vertexCode, geometryCode, fragmentCode, lazyLoad) : new ExtShaderProgram(parameter != null ? parameter.name : null, (String)vertFileName, (String)fragFileName, vertexCode, fragmentCode, lazyLoad);
        if ((parameter == null || parameter.logOnCompileFailure) && !shaderProgram.isCompiled()) {
            manager.getLogger().error("ExtShaderProgram " + fileName + " failed to compile:\n" + shaderProgram.getLog());
        }
        return shaderProgram;
    }

    public static class ShaderProgramParameter
    extends AssetLoaderParameters<ExtShaderProgram> {
        public String name;
        public String vertexFile;
        public String geometryFile;
        public String fragmentFile;
        public boolean logOnCompileFailure = true;
        public String prependVertexCode;
        public String prependGeometryCode;
        public String prependFragmentCode;
    }
}

