/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.shader.provider;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.Settings;
import gaiasky.util.gdx.shader.TessellationShaderProgram;
import gaiasky.util.gdx.shader.loader.ShaderTemplatingLoader;

public class TessellationShaderProgramProvider
extends AsynchronousAssetLoader<TessellationShaderProgram, ShaderProgramParameter> {
    private String vertexFileSuffix = ".vertex.glsl";
    private String controlFileSuffix = ".control.glsl";
    private String evaluationFileSuffix = ".eval.glsl";
    private String fragmentFileSuffix = ".fragment.glsl";

    public TessellationShaderProgramProvider(FileHandleResolver resolver) {
        super(resolver);
    }

    public TessellationShaderProgramProvider(FileHandleResolver resolver, String vertexFileSuffix, String controlFileSuffix, String evaluationFileSuffix, String fragmentFileSuffix) {
        super(resolver);
        this.vertexFileSuffix = vertexFileSuffix;
        this.controlFileSuffix = controlFileSuffix;
        this.evaluationFileSuffix = evaluationFileSuffix;
        this.fragmentFileSuffix = fragmentFileSuffix;
    }

    public static String getShaderCode(String prefix, String code) {
        if (code == null) {
            return null;
        }
        if (prefix == null) {
            return code;
        }
        if ((code = code.trim()).startsWith("#version") && !prefix.isEmpty()) {
            int firstLineEnd = code.indexOf(10) + 1;
            String versionStr = code.substring(0, firstLineEnd);
            return versionStr + prefix + code.substring(firstLineEnd);
        }
        return prefix + code;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, ShaderProgramParameter parameter) {
        return null;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, ShaderProgramParameter parameter) {
    }

    public TessellationShaderProgram loadSync(AssetManager manager, String fileName, FileHandle file, ShaderProgramParameter parameter) {
        Object vertFileName = null;
        String controlFileName = null;
        String evaluationFileName = null;
        Object fragFileName = null;
        if (parameter != null) {
            if (parameter.vertexFile != null) {
                vertFileName = parameter.vertexFile;
            }
            if (parameter.controlFile != null) {
                controlFileName = parameter.controlFile;
            }
            if (parameter.evaluationFile != null) {
                evaluationFileName = parameter.evaluationFile;
            }
            if (parameter.fragmentFile != null) {
                fragFileName = parameter.fragmentFile;
            }
        }
        if (vertFileName == null && fileName.endsWith(this.fragmentFileSuffix)) {
            vertFileName = fileName.substring(0, fileName.length() - this.fragmentFileSuffix.length()) + this.vertexFileSuffix;
        }
        if (fragFileName == null && fileName.endsWith(this.vertexFileSuffix)) {
            fragFileName = fileName.substring(0, fileName.length() - this.vertexFileSuffix.length()) + this.fragmentFileSuffix;
        }
        FileHandle vertexFile = vertFileName == null ? file : this.resolve((String)vertFileName);
        FileHandle controlFile = controlFileName == null ? null : this.resolve(controlFileName);
        FileHandle evaluationFile = evaluationFileName == null ? null : this.resolve(evaluationFileName);
        FileHandle fragmentFile = fragFileName == null ? file : this.resolve((String)fragFileName);
        String vertexCode = ShaderTemplatingLoader.load(vertexFile);
        String controlCode = ShaderTemplatingLoader.load(controlFile);
        String evaluationCode = ShaderTemplatingLoader.load(evaluationFile);
        String fragmentCode = ShaderTemplatingLoader.load(fragmentFile);
        if (parameter != null) {
            if (parameter.prependVertexCode != null) {
                vertexCode = TessellationShaderProgramProvider.getShaderCode(parameter.prependVertexCode, vertexCode);
            }
            if (parameter.prependControlCode != null && controlCode != null) {
                controlCode = TessellationShaderProgramProvider.getShaderCode(parameter.prependControlCode, controlCode);
            }
            if (parameter.prependEvaluationCode != null && evaluationCode != null) {
                evaluationCode = TessellationShaderProgramProvider.getShaderCode(parameter.prependEvaluationCode, evaluationCode);
            }
            if (parameter.prependFragmentCode != null) {
                fragmentCode = TessellationShaderProgramProvider.getShaderCode(parameter.prependFragmentCode, fragmentCode);
            }
        }
        boolean lazyLoad = parameter != null && parameter.name != null && (parameter.name.contains("Rel") || parameter.name.contains("Grav") || parameter.name.contains("SSR") && !Settings.settings.postprocess.ssr.active);
        TessellationShaderProgram shaderProgram = new TessellationShaderProgram(parameter != null ? parameter.name : null, (String)vertFileName, controlFileName, evaluationFileName, (String)fragFileName, vertexCode, controlCode, evaluationCode, fragmentCode, lazyLoad);
        if ((parameter == null || parameter.logOnCompileFailure) && !shaderProgram.isCompiled()) {
            manager.getLogger().error("TessellationShaderProgram " + fileName + " failed to compile:\n" + shaderProgram.getLog());
        }
        return shaderProgram;
    }

    public static class ShaderProgramParameter
    extends AssetLoaderParameters<TessellationShaderProgram> {
        public String name;
        public String vertexFile;
        public String controlFile;
        public String evaluationFile;
        public String fragmentFile;
        public boolean logOnCompileFailure = true;
        public String prependVertexCode;
        public String prependControlCode;
        public String prependEvaluationCode;
        public String prependFragmentCode;
    }
}

