/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gravwaves;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Settings;
import gaiasky.util.math.Vector3D;
import gaiasky.util.time.ITimeFrameProvider;
import net.jafama.FastMath;

public class RelativisticEffectsManager
implements IObserver {
    private static RelativisticEffectsManager instance;
    private final long initime;
    private final Vector3 unitz;
    private final Vector3 screenCoords;
    private final Matrix3 eplus;
    private final Matrix3 etimes;
    private final Matrix3 auxm1;
    private final Matrix3 auxm2;
    private final Matrix3 auxm3;
    private final Matrix3 auxm4;
    private final Vector3D auxd1;
    private final Vector3D auxd2;
    private final Vector3D auxd3;
    private final Vector3D auxd4;
    private final Vector3D auxd5;
    public Vector3 velDir = new Vector3();
    public float vc;
    public Vector3 gw = new Vector3(0.0f, 0.0f, 1.0f);
    public Matrix3 gwmat3 = new Matrix3();
    public Matrix4 gwmat4 = new Matrix4();
    public float gwtime;
    public float omgw;
    public float[] hterms;

    private RelativisticEffectsManager(ITimeFrameProvider time) {
        this.initime = time.getTime().toEpochMilli();
        this.gwtime = 0.0f;
        this.hterms = new float[4];
        this.unitz = new Vector3(0.0f, 0.0f, 1.0f);
        this.eplus = new Matrix3(new float[]{1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.etimes = new Matrix3(new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.auxm1 = new Matrix3();
        this.auxm2 = new Matrix3();
        this.auxm3 = new Matrix3();
        this.auxm4 = new Matrix3();
        this.auxd1 = new Vector3D();
        this.auxd2 = new Vector3D();
        this.auxd3 = new Vector3D();
        this.auxd4 = new Vector3D();
        this.auxd5 = new Vector3D();
        this.screenCoords = new Vector3();
        EventManager.instance.subscribe((IObserver)this, Event.GRAV_WAVE_START);
    }

    public static RelativisticEffectsManager getInstance() {
        return instance;
    }

    public static void initialize(ITimeFrameProvider time) {
        instance = new RelativisticEffectsManager(time);
    }

    public boolean relAberrationOn() {
        return Settings.settings.runtime.relativisticAberration;
    }

    public boolean gravWavesOn() {
        return Settings.settings.runtime.gravitationalWaves;
    }

    public void update(ITimeFrameProvider time, ICamera camera) {
        if (Settings.settings.runtime.relativisticAberration) {
            this.vc = (float)(camera.getSpeed() / 1.079253E9);
            if (camera.getVelocity() == null || camera.getVelocity().len() == 0.0) {
                this.velDir.set(1.0f, 0.0f, 0.0f);
            } else {
                camera.getVelocity().put(this.velDir).nor();
            }
        }
        if (Settings.settings.runtime.gravitationalWaves) {
            this.gwtime = (float)((double)(time.getTime().toEpochMilli() - this.initime) / 1000.0);
            this.omgw = 0.8f;
            this.hterms[0] = 0.3f;
            this.hterms[1] = 0.0f;
            this.hterms[2] = 0.0f;
            this.hterms[3] = 0.0f;
            this.gwmat4.setToRotation(this.unitz, this.gw);
            this.gwmat3.set(this.gwmat4);
        }
    }

    public Vector3D gravitationalWavePos(Vector3D pos) {
        if (Settings.settings.runtime.gravitationalWaves) {
            float hpluscos = this.hterms[0];
            float hplussin = this.hterms[1];
            float htimescos = this.hterms[2];
            float htimessin = this.hterms[3];
            float t = this.gwtime;
            Vector3D p = this.auxd4.set(this.gw);
            Matrix3 P = this.gwmat3;
            Matrix3 PT = this.auxm1.set(this.gwmat3).transpose();
            Matrix3 pepluspt = this.auxm2.set(P).mul(this.eplus).mul(PT);
            Matrix3 petimespt = this.auxm3.set(P).mul(this.etimes).mul(PT);
            double plusphase = (double)hpluscos * FastMath.cos((double)(this.omgw * t)) + (double)hplussin * FastMath.sin((double)(this.omgw * t));
            double timesphase = (double)htimescos * FastMath.cos((double)(this.omgw * t)) + (double)htimessin * FastMath.sin((double)(this.omgw * t));
            pepluspt = this.mul(pepluspt, (float)plusphase);
            petimespt = this.mul(petimespt, (float)timesphase);
            this.auxm4.set(pepluspt);
            Matrix3 pept = this.add(this.auxm4, petimespt);
            double poslen = pos.len();
            pos.nor();
            Vector3D huu = this.auxd1.set(pos).mulRight(pept).mul(pos);
            Vector3D hu = this.auxd2.set(pos).mulRight(this.mul(pept, 0.5f));
            Vector3D deltau = this.auxd3.set(pos).add(p);
            deltau.div(this.auxd5.set(pos).mul(p).add(1.0).scl(2.0));
            deltau.mul(huu).sub(hu);
            pos.add(deltau);
            pos.nor().scl(poslen);
        }
        return pos;
    }

    private Matrix3 mul(Matrix3 m, float scl) {
        int i = 0;
        while (i < m.val.length) {
            int n = i++;
            m.val[n] = m.val[n] * scl;
        }
        return m;
    }

    private Matrix3 add(Matrix3 one, Matrix3 two) {
        for (int i = 0; i < one.val.length; ++i) {
            int n = i;
            one.val[n] = one.val[n] + two.val[i];
        }
        return one;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.GRAV_WAVE_START) {
            int x = (Integer)data[0];
            int y = (Integer)data[1];
            ICamera cam = GaiaSky.instance.getICamera();
            this.screenCoords.set((float)x, (float)y, 0.9f);
            cam.getCamera().unproject(this.screenCoords);
            this.screenCoords.nor();
            this.gw.set(this.screenCoords);
        }
    }
}

