/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.i18n;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.I18NBundle;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import java.nio.file.Path;
import java.util.Locale;
import java.util.MissingResourceException;

public class I18n {
    private static final Logger.Log logger = Logger.getLogger(I18n.class);
    public static I18NBundle messages;
    public static I18NBundle objects;
    public static Locale locale;

    public static void initialize() {
        if (!(messages != null && objects != null || I18n.forceInit(Gdx.files.internal("i18n/gsbundle"), Gdx.files.internal("i18n/objects")))) {
            logger.warn("I18n resource not found.");
        }
    }

    public static void initialize(Path main, Path objects) {
        if (I18n.forceInit(Gdx.files.absolute(main.toAbsolutePath().toString()), Gdx.files.absolute(objects.toAbsolutePath().toString()))) {
            logger.warn("I18n resource not found.");
        }
    }

    public static void initialize(FileHandle main, FileHandle objects) {
        if (!I18n.forceInit(main, objects)) {
            logger.warn("I18n resource not found.");
        }
    }

    public static boolean forceInit(FileHandle main, FileHandle objects) {
        boolean found;
        if (Settings.settings.program == null || Settings.settings.program.locale == null || Settings.settings.program.locale.isEmpty()) {
            locale = Locale.getDefault();
        } else {
            locale = I18n.getLocaleFromLanguageTag(Settings.settings.program.locale);
            Locale.setDefault(locale);
        }
        try {
            messages = I18NBundle.createBundle((FileHandle)main, (Locale)locale, (String)"UTF-8");
            found = true;
        }
        catch (MissingResourceException e) {
            logger.info(e.getLocalizedMessage());
            locale = new Locale.Builder().setLanguage("en").setRegion("GB").build();
            try {
                messages = I18NBundle.createBundle((FileHandle)main, (Locale)locale, (String)"UTF-8");
            }
            catch (Exception e2) {
                logger.error(e);
            }
            found = false;
        }
        try {
            I18n.objects = I18NBundle.createBundle((FileHandle)objects, (Locale)locale, (String)"UTF-8");
        }
        catch (MissingResourceException e) {
            logger.info(e.getLocalizedMessage());
            locale = new Locale.Builder().setLanguage("en").setRegion("GB").build();
            try {
                I18n.objects = I18NBundle.createBundle((FileHandle)objects, (Locale)locale, (String)"UTF-8");
            }
            catch (Exception e2) {
                logger.error(e);
            }
            found = false;
        }
        return found;
    }

    public static Locale getLocaleFromLanguageTag(String languageTag) {
        String[] tags = languageTag.split("-");
        if (tags.length > 1) {
            return new Locale.Builder().setLanguage(tags[0]).setRegion(tags[1]).build();
        }
        return new Locale.Builder().setLanguage(languageTag).build();
    }

    public static synchronized boolean exists(String key) {
        try {
            return messages.get(key) != null;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static synchronized String get(String key) {
        return I18n.msg(key);
    }

    public static synchronized String msg(String key) {
        return I18n.get(messages, key);
    }

    public static synchronized String msgOr(String key, String defaultValue) {
        return I18n.getOr(messages, key, defaultValue);
    }

    public static synchronized String obj(String key) {
        return I18n.get(objects, key);
    }

    public static synchronized String objOr(String key, String defaultValue) {
        return I18n.getOr(objects, key, defaultValue);
    }

    public static synchronized String msg(String key, Object ... params) {
        return messages.format(key, params);
    }

    public static synchronized String obj(String key, Object ... params) {
        return objects.format(key, params);
    }

    public static synchronized boolean hasMessage(String key) {
        return I18n.has(messages, key);
    }

    public static synchronized boolean hasObject(String key) {
        return I18n.has(objects, key);
    }

    public static boolean hasLocalizedVersion(String nameLowerCase) {
        String base = nameLowerCase.replace(' ', '_');
        return I18n.hasObject(base);
    }

    public static String localize(String name) {
        if (name == null) {
            return null;
        }
        String base = name.toLowerCase(Locale.ROOT).replace(' ', '_');
        if (I18n.hasObject(base)) {
            return I18n.obj(base);
        }
        return name;
    }

    private static String get(I18NBundle b, String key) {
        return b.get(key);
    }

    private static String getOr(I18NBundle b, String key, String defaultValue) {
        if (I18n.has(b, key)) {
            return b.get(key);
        }
        return defaultValue;
    }

    private static boolean has(I18NBundle b, String key) {
        try {
            b.get(key);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }
}

