/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.jafama.FastMath;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer byteBuffer;

    public ByteBufferInputStream() {
    }

    public ByteBufferInputStream(int bufferSize) {
        this(ByteBuffer.allocate(bufferSize));
        this.byteBuffer.flip();
    }

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int count = FastMath.min((int)this.byteBuffer.remaining(), (int)length);
        if (count == 0) {
            return -1;
        }
        this.byteBuffer.get(bytes, offset, count);
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.byteBuffer.remaining();
    }
}

