/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class GzipUtils {
    public static boolean isGZipped(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(2);
        int magic = 0;
        try {
            magic = in.read() & 0xFF | in.read() << 8 & 0xFF00;
            in.reset();
        }
        catch (IOException e) {
            try {
                in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return magic == 35615;
    }

    public static boolean isGZipped(File f) {
        int magic = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
            raf.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return magic == 35615;
    }

    public static void main(String[] args) throws FileNotFoundException {
        File gzf = new File("/tmp/1.gz");
        System.out.println(GzipUtils.isGZipped(gzf));
        System.out.println(GzipUtils.isGZipped(new FileInputStream(gzf)));
    }
}

