/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.utils.Array;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.PathDouble;
import gaiasky.util.math.VectorDouble;
import net.jafama.FastMath;

public class BSplineDouble<T extends VectorDouble<T>>
implements PathDouble<T> {
    private static final int DEFAULT_DEGREE = 3;
    private static final double d6 = 0.1666666716337204;
    public T[] controlPoints;
    public Array<T> knots;
    public int degree;
    public boolean continuous;
    public int spanCount;
    private T tmp;
    private T tmp2;
    private T tmp3;

    public BSplineDouble() {
    }

    public BSplineDouble(T[] controlPoints, boolean continuous) {
        this.set((VectorDouble[])controlPoints, 3, continuous);
    }

    public BSplineDouble(T[] controlPoints, int degree, boolean continuous) {
        this.set((VectorDouble[])controlPoints, degree, continuous);
    }

    public static <T extends VectorDouble<T>> T cubic(T out, double t, T[] points, boolean continuous, T tmp) {
        return (T)BSplineDouble.cubic_derivative(out, (double)t, points, (boolean)continuous, tmp);
    }

    public static <T extends VectorDouble<T>> T cubic_derivative(T out, double t, T[] points, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - 3;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return (T)BSplineDouble.cubic(out, (int)i, (double)(u -= (double)i), points, (boolean)continuous, tmp);
    }

    public static <T extends VectorDouble<T>> T cubic(T out, int i, double u, T[] points, boolean continuous, T tmp) {
        int n = points.length;
        double dt = 1.0 - u;
        double t2 = u * u;
        double t3 = t2 * u;
        out.set(points[i]).scl((double)((3.0 * t3 - 6.0 * t2 + 4.0) * 0.1666666716337204));
        if (continuous || i > 0) {
            out.add(tmp.set(points[(n + i - 1) % n]).scl((double)(dt * dt * dt * 0.1666666716337204)));
        }
        if (continuous || i < n - 1) {
            out.add(tmp.set(points[(i + 1) % n]).scl((double)((-3.0 * t3 + 3.0 * t2 + 3.0 * u + 1.0) * 0.1666666716337204)));
        }
        if (continuous || i < n - 2) {
            out.add(tmp.set(points[(i + 2) % n]).scl((double)(t3 * 0.1666666716337204)));
        }
        return (T)out;
    }

    public static <T extends VectorDouble<T>> T cubic_derivative(T out, int i, double u, T[] points, boolean continuous, T tmp) {
        int n = points.length;
        double dt = 1.0 - u;
        double t2 = u * u;
        double t3 = t2 * u;
        out.set(points[i]).scl((double)(1.5 * t2 - 2.0 * u));
        if (continuous || i > 0) {
            out.add(tmp.set(points[(n + i - 1) % n]).scl((double)(-0.5 * dt * dt)));
        }
        if (continuous || i < n - 1) {
            out.add(tmp.set(points[(i + 1) % n]).scl((double)(-1.5 * t2 + u + 0.5)));
        }
        if (continuous || i < n - 2) {
            out.add(tmp.set(points[(i + 2) % n]).scl((double)(0.5 * t2)));
        }
        return (T)out;
    }

    public static <T extends VectorDouble<T>> T calculate(T out, double t, T[] points, int degree, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - degree;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return (T)BSplineDouble.calculate(out, (int)i, (double)(u -= (double)i), points, (int)degree, (boolean)continuous, tmp);
    }

    public static <T extends VectorDouble<T>> T derivative(T out, double t, T[] points, int degree, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - degree;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return (T)BSplineDouble.derivative(out, (int)i, (double)(u -= (double)i), points, (int)degree, (boolean)continuous, tmp);
    }

    public static <T extends VectorDouble<T>> T calculate(T out, int i, double u, T[] points, int degree, boolean continuous, T tmp) {
        if (degree == 3) {
            return (T)BSplineDouble.cubic(out, (int)i, (double)u, points, (boolean)continuous, tmp);
        }
        return out;
    }

    public static <T extends VectorDouble<T>> T derivative(T out, int i, double u, T[] points, int degree, boolean continuous, T tmp) {
        if (degree == 3) {
            return (T)BSplineDouble.cubic_derivative(out, (int)i, (double)u, points, (boolean)continuous, tmp);
        }
        return out;
    }

    public BSplineDouble set(T[] controlPoints, int degree, boolean continuous) {
        if (this.tmp == null) {
            this.tmp = controlPoints[0].cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = controlPoints[0].cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = controlPoints[0].cpy();
        }
        this.controlPoints = controlPoints;
        this.degree = degree;
        this.continuous = continuous;
        int n = this.spanCount = continuous ? controlPoints.length : controlPoints.length - degree;
        if (this.knots == null) {
            this.knots = new Array(false, this.spanCount);
        } else {
            this.knots.clear();
            this.knots.ensureCapacity(this.spanCount);
        }
        for (int i = 0; i < this.spanCount; ++i) {
            this.knots.add((Object)BSplineDouble.calculate(controlPoints[0].cpy(), (int)(continuous ? i : (int)((double)i + 0.5 * (double)degree)), (double)0.0, controlPoints, (int)degree, (boolean)continuous, this.tmp));
        }
        return this;
    }

    @Override
    public T valueAt(T out, double t) {
        int n = this.spanCount;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return this.valueAt(out, i, u -= (double)i);
    }

    public T valueAt(T out, int span, double u) {
        return (T)BSplineDouble.calculate(out, (int)(this.continuous ? span : span + (int)((double)this.degree * 0.5)), (double)u, this.controlPoints, (int)this.degree, (boolean)this.continuous, this.tmp);
    }

    @Override
    public T derivativeAt(T out, double t) {
        int n = this.spanCount;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return this.derivativeAt(out, i, u -= (double)i);
    }

    public T derivativeAt(T out, int span, double u) {
        return (T)BSplineDouble.derivative(out, (int)(this.continuous ? span : span + (int)((double)this.degree * 0.5)), (double)u, this.controlPoints, (int)this.degree, (boolean)this.continuous, this.tmp);
    }

    public int nearest(T in) {
        return this.nearest(in, 0, this.spanCount);
    }

    public int nearest(T in, int start, int count) {
        while (start < 0) {
            start += this.spanCount;
        }
        int result = start % this.spanCount;
        double dst = in.dst2((VectorDouble)((VectorDouble)this.knots.get(result)));
        for (int i = 1; i < count; ++i) {
            int idx = (start + i) % this.spanCount;
            double d = in.dst2((VectorDouble)((VectorDouble)this.knots.get(idx)));
            if (!(d < dst)) continue;
            dst = d;
            result = idx;
        }
        return result;
    }

    @Override
    public double approximate(T v) {
        return this.approximate(v, this.nearest(v));
    }

    public double approximate(T in, int start, int count) {
        return this.approximate(in, this.nearest(in, start, count));
    }

    public double approximate(T in, int near) {
        VectorDouble P3;
        VectorDouble P2;
        VectorDouble P1;
        int n = near;
        VectorDouble nearest = (VectorDouble)this.knots.get(n);
        VectorDouble previous = (VectorDouble)this.knots.get(n > 0 ? n - 1 : this.spanCount - 1);
        VectorDouble next = (VectorDouble)this.knots.get((n + 1) % this.spanCount);
        double dstPrev2 = in.dst2((VectorDouble)previous);
        double dstNext2 = in.dst2((VectorDouble)next);
        if (dstNext2 < dstPrev2) {
            P1 = nearest;
            P2 = next;
            P3 = in;
        } else {
            P1 = previous;
            P2 = nearest;
            P3 = in;
            n = n > 0 ? n - 1 : this.spanCount - 1;
        }
        double L1Sqr = P1.dst2(P2);
        double L2Sqr = P3.dst2((VectorDouble)P2);
        double L3Sqr = P3.dst2((VectorDouble)P1);
        double L1 = FastMath.sqrt((double)L1Sqr);
        double s = (L2Sqr + L1Sqr - L3Sqr) / (2.0 * L1);
        double u = MathUtilsDouble.clamp((L1 - s) / L1, 0.0, 1.0);
        return ((double)n + u) / (double)this.spanCount;
    }

    @Override
    public double locate(T v) {
        return this.approximate(v);
    }

    @Override
    public double approxLength(int samples) {
        double tempLength = 0.0;
        for (int i = 0; i < samples; ++i) {
            this.tmp2.set(this.tmp3);
            this.valueAt(this.tmp3, (double)i / ((double)samples - 1.0));
            if (i <= 0) continue;
            tempLength += this.tmp2.dst(this.tmp3);
        }
        return tempLength;
    }
}

