/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.collision.BoundingBox;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import java.io.Serializable;
import java.util.List;
import net.jafama.FastMath;

public class BoundingBoxDouble
implements Serializable {
    private static final long serialVersionUID = -1286036817192127343L;
    private static final Vector3D tmpVector = new Vector3D();
    public final Vector3D min = new Vector3D();
    public final Vector3D max = new Vector3D();
    private final Vector3D cnt = new Vector3D();
    private final Vector3D dim = new Vector3D();
    @Deprecated
    private Vector3D[] corners;

    public BoundingBoxDouble() {
        this.clr();
    }

    public BoundingBoxDouble(BoundingBoxDouble bounds) {
        this.set(bounds);
    }

    public BoundingBoxDouble(Vector3D minimum, Vector3D maximum) {
        this.set(minimum, maximum);
    }

    static double min(double a, double b) {
        return FastMath.min((double)a, (double)b);
    }

    static double max(double a, double b) {
        return FastMath.max((double)a, (double)b);
    }

    @Deprecated
    public Vector3D getCenter() {
        return this.cnt;
    }

    public Vector3D getCenter(Vector3D out) {
        return out.set(this.cnt);
    }

    public double getCenterX() {
        return this.cnt.x;
    }

    public double getCenterY() {
        return this.cnt.y;
    }

    public double getCenterZ() {
        return this.cnt.z;
    }

    @Deprecated
    protected void updateCorners() {
    }

    @Deprecated
    public Vector3D[] getCorners() {
        if (this.corners == null) {
            this.corners = new Vector3D[8];
            for (int i = 0; i < 8; ++i) {
                this.corners[i] = new Vector3D();
            }
        }
        this.corners[0].set(this.min.x, this.min.y, this.min.z);
        this.corners[1].set(this.max.x, this.min.y, this.min.z);
        this.corners[2].set(this.max.x, this.max.y, this.min.z);
        this.corners[3].set(this.min.x, this.max.y, this.min.z);
        this.corners[4].set(this.min.x, this.min.y, this.max.z);
        this.corners[5].set(this.max.x, this.min.y, this.max.z);
        this.corners[6].set(this.max.x, this.max.y, this.max.z);
        this.corners[7].set(this.min.x, this.max.y, this.max.z);
        return this.corners;
    }

    public Vector3D getCorner000(Vector3D out) {
        return out.set(this.min.x, this.min.y, this.min.z);
    }

    public Vector3D getCorner001(Vector3D out) {
        return out.set(this.min.x, this.min.y, this.max.z);
    }

    public Vector3D getCorner010(Vector3D out) {
        return out.set(this.min.x, this.max.y, this.min.z);
    }

    public Vector3D getCorner011(Vector3D out) {
        return out.set(this.min.x, this.max.y, this.max.z);
    }

    public Vector3D getCorner100(Vector3D out) {
        return out.set(this.max.x, this.min.y, this.min.z);
    }

    public Vector3D getCorner101(Vector3D out) {
        return out.set(this.max.x, this.min.y, this.max.z);
    }

    public Vector3D getCorner110(Vector3D out) {
        return out.set(this.max.x, this.max.y, this.min.z);
    }

    public Vector3D getCorner111(Vector3D out) {
        return out.set(this.max.x, this.max.y, this.max.z);
    }

    @Deprecated
    public Vector3D getDimensions() {
        return this.dim;
    }

    public Vector3D getDimensions(Vector3D out) {
        return out.set(this.dim);
    }

    public double getVolume() {
        return this.dim.x * this.dim.y * this.dim.z;
    }

    public double getWidth() {
        return this.dim.x;
    }

    public double getHeight() {
        return this.dim.y;
    }

    public double getDepth() {
        return this.dim.z;
    }

    public double getGreatestDim() {
        return FastMath.max((double)Math.max(this.getWidth(), this.getHeight()), (double)this.getDepth());
    }

    @Deprecated
    public Vector3D getMin() {
        return this.min;
    }

    public Vector3D getMin(Vector3D out) {
        return out.set(this.min);
    }

    @Deprecated
    public Vector3D getMax() {
        return this.max;
    }

    public Vector3D getMax(Vector3D out) {
        return out.set(this.max);
    }

    public BoundingBoxDouble set(BoundingBoxDouble bounds) {
        return this.set(bounds.min, bounds.max);
    }

    public BoundingBox put(BoundingBox bounds) {
        return bounds.set(this.min.toVector3(), this.max.toVector3());
    }

    public BoundingBoxDouble set(Vector3D minimum, Vector3D maximum) {
        this.min.set(minimum.x < maximum.x ? minimum.x : maximum.x, minimum.y < maximum.y ? minimum.y : maximum.y, minimum.z < maximum.z ? minimum.z : maximum.z);
        this.max.set(minimum.x > maximum.x ? minimum.x : maximum.x, minimum.y > maximum.y ? minimum.y : maximum.y, minimum.z > maximum.z ? minimum.z : maximum.z);
        this.cnt.set(this.min).add(this.max).scl(0.5);
        this.dim.set(this.max).sub(this.min);
        return this;
    }

    public BoundingBoxDouble set(Vector3D[] points) {
        this.inf();
        for (Vector3D l_point : points) {
            this.ext(l_point);
        }
        return this;
    }

    public BoundingBoxDouble set(List<Vector3D> points) {
        this.inf();
        for (Vector3D l_point : points) {
            this.ext(l_point);
        }
        return this;
    }

    public BoundingBoxDouble inf() {
        this.min.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.max.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.cnt.set(0.0, 0.0, 0.0);
        this.dim.set(0.0, 0.0, 0.0);
        return this;
    }

    public BoundingBoxDouble ext(Vector3D point) {
        return this.set(this.min.set(BoundingBoxDouble.min(this.min.x, point.x), BoundingBoxDouble.min(this.min.y, point.y), BoundingBoxDouble.min(this.min.z, point.z)), this.max.set(Math.max(this.max.x, point.x), FastMath.max((double)this.max.y, (double)point.y), FastMath.max((double)this.max.z, (double)point.z)));
    }

    public BoundingBoxDouble clr() {
        return this.set(this.min.set(0.0, 0.0, 0.0), this.max.set(0.0, 0.0, 0.0));
    }

    public boolean isValid() {
        return this.min.x < this.max.x && this.min.y < this.max.y && this.min.z < this.max.z;
    }

    public BoundingBoxDouble ext(BoundingBoxDouble a_bounds) {
        return this.set(this.min.set(BoundingBoxDouble.min(this.min.x, a_bounds.min.x), BoundingBoxDouble.min(this.min.y, a_bounds.min.y), BoundingBoxDouble.min(this.min.z, a_bounds.min.z)), this.max.set(BoundingBoxDouble.max(this.max.x, a_bounds.max.x), BoundingBoxDouble.max(this.max.y, a_bounds.max.y), BoundingBoxDouble.max(this.max.z, a_bounds.max.z)));
    }

    public BoundingBoxDouble ext(BoundingBoxDouble bounds, Matrix4D transform) {
        this.ext(tmpVector.set(bounds.min.x, bounds.min.y, bounds.min.z).mul(transform));
        this.ext(tmpVector.set(bounds.min.x, bounds.min.y, bounds.max.z).mul(transform));
        this.ext(tmpVector.set(bounds.min.x, bounds.max.y, bounds.min.z).mul(transform));
        this.ext(tmpVector.set(bounds.min.x, bounds.max.y, bounds.max.z).mul(transform));
        this.ext(tmpVector.set(bounds.max.x, bounds.min.y, bounds.min.z).mul(transform));
        this.ext(tmpVector.set(bounds.max.x, bounds.min.y, bounds.max.z).mul(transform));
        this.ext(tmpVector.set(bounds.max.x, bounds.max.y, bounds.min.z).mul(transform));
        this.ext(tmpVector.set(bounds.max.x, bounds.max.y, bounds.max.z).mul(transform));
        return this;
    }

    public BoundingBoxDouble mul(Matrix4D transform) {
        double x0 = this.min.x;
        double y0 = this.min.y;
        double z0 = this.min.z;
        double x1 = this.max.x;
        double y1 = this.max.y;
        double z1 = this.max.z;
        this.inf();
        this.ext(tmpVector.set(x0, y0, z0).mul(transform));
        this.ext(tmpVector.set(x0, y0, z1).mul(transform));
        this.ext(tmpVector.set(x0, y1, z0).mul(transform));
        this.ext(tmpVector.set(x0, y1, z1).mul(transform));
        this.ext(tmpVector.set(x1, y0, z0).mul(transform));
        this.ext(tmpVector.set(x1, y0, z1).mul(transform));
        this.ext(tmpVector.set(x1, y1, z0).mul(transform));
        this.ext(tmpVector.set(x1, y1, z1).mul(transform));
        return this;
    }

    public boolean contains(BoundingBoxDouble b) {
        return !this.isValid() || this.min.x <= b.min.x && this.min.y <= b.min.y && this.min.z <= b.min.z && this.max.x >= b.max.x && this.max.y >= b.max.y && this.max.z >= b.max.z;
    }

    public boolean intersects(BoundingBoxDouble b) {
        if (!this.isValid()) {
            return false;
        }
        double lx = FastMath.abs((double)(this.cnt.x - b.cnt.x));
        double sumx = this.dim.x / 2.0 + b.dim.x / 2.0;
        double ly = FastMath.abs((double)(this.cnt.y - b.cnt.y));
        double sumy = this.dim.y / 2.0 + b.dim.y / 2.0;
        double lz = FastMath.abs((double)(this.cnt.z - b.cnt.z));
        double sumz = this.dim.z / 2.0 + b.dim.z / 2.0;
        return lx <= sumx && ly <= sumy && lz <= sumz;
    }

    public boolean contains(Vector3D v) {
        return this.min.x <= v.x && this.max.x >= v.x && this.min.y <= v.y && this.max.y >= v.y && this.min.z <= v.z && this.max.z >= v.z;
    }

    public boolean contains(double x, double y, double z) {
        return this.min.x <= x && this.max.x >= x && this.min.y <= y && this.max.y >= y && this.min.z <= z && this.max.z >= z;
    }

    public String toString() {
        return "[" + String.valueOf(this.min) + "|" + String.valueOf(this.max) + "]";
    }

    public BoundingBoxDouble ext(double x, double y, double z) {
        return this.set(this.min.set(BoundingBoxDouble.min(this.min.x, x), BoundingBoxDouble.min(this.min.y, y), BoundingBoxDouble.min(this.min.z, z)), this.max.set(BoundingBoxDouble.max(this.max.x, x), BoundingBoxDouble.max(this.max.y, y), BoundingBoxDouble.max(this.max.z, z)));
    }
}

