/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.MathUtils;
import gaiasky.util.math.PathDouble;
import gaiasky.util.math.VectorDouble;
import net.jafama.FastMath;

public class CatmullRomSplineDouble<T extends VectorDouble<T>>
implements PathDouble<T> {
    public T[] controlPoints;
    public boolean continuous;
    public int spanCount;
    private T tmp;
    private T tmp2;
    private T tmp3;

    public CatmullRomSplineDouble() {
    }

    public CatmullRomSplineDouble(T[] controlPoints, boolean continuous) {
        this.set((VectorDouble[])controlPoints, continuous);
    }

    public static <T extends VectorDouble<T>> T calculate(T out, double t, T[] points, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - 3;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return (T)CatmullRomSplineDouble.calculate(out, (int)i, (double)(u -= (double)i), points, (boolean)continuous, tmp);
    }

    public static <T extends VectorDouble<T>> T calculate(T out, int i, double u, T[] points, boolean continuous, T tmp) {
        int n = points.length;
        double u2 = u * u;
        double u3 = u2 * u;
        out.set(points[i]).scl((double)(1.5 * u3 - 2.5 * u2 + 1.0));
        if (continuous || i > 0) {
            out.add(tmp.set(points[(n + i - 1) % n]).scl((double)(-0.5 * u3 + u2 - 0.5 * u)));
        }
        if (continuous || i < n - 1) {
            out.add(tmp.set(points[(i + 1) % n]).scl((double)(-1.5 * u3 + 2.0 * u2 + 0.5 * u)));
        }
        if (continuous || i < n - 2) {
            out.add(tmp.set(points[(i + 2) % n]).scl((double)(0.5 * u3 - 0.5 * u2)));
        }
        return (T)out;
    }

    public static <T extends VectorDouble<T>> T derivative(T out, double t, T[] points, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - 3;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return (T)CatmullRomSplineDouble.derivative(out, (int)i, (double)(u -= (double)i), points, (boolean)continuous, tmp);
    }

    public static <T extends VectorDouble<T>> T derivative(T out, int i, double u, T[] points, boolean continuous, T tmp) {
        int n = points.length;
        double u2 = u * u;
        out.set(points[i]).scl((double)(-u * 5.0 + u2 * 4.5));
        if (continuous || i > 0) {
            out.add(tmp.set(points[(n + i - 1) % n]).scl((double)(-0.5 + u * 2.0 - u2 * 1.5)));
        }
        if (continuous || i < n - 1) {
            out.add(tmp.set(points[(i + 1) % n]).scl((double)(0.5 + u * 4.0 - u2 * 4.5)));
        }
        if (continuous || i < n - 2) {
            out.add(tmp.set(points[(i + 2) % n]).scl((double)(-u + u2 * 1.5)));
        }
        return (T)out;
    }

    public CatmullRomSplineDouble set(T[] controlPoints, boolean continuous) {
        if (this.tmp == null) {
            this.tmp = controlPoints[0].cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = controlPoints[0].cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = controlPoints[0].cpy();
        }
        this.controlPoints = controlPoints;
        this.continuous = continuous;
        this.spanCount = continuous ? controlPoints.length : controlPoints.length - 3;
        return this;
    }

    @Override
    public T valueAt(T out, double t) {
        int n = this.spanCount;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return this.valueAt(out, i, u -= (double)i);
    }

    public T valueAt(T out, int span, double u) {
        return (T)CatmullRomSplineDouble.calculate(out, (int)(this.continuous ? span : span + 1), (double)u, this.controlPoints, (boolean)this.continuous, this.tmp);
    }

    @Override
    public T derivativeAt(T out, double t) {
        int n = this.spanCount;
        double u = t * (double)n;
        int i = t >= 1.0 ? n - 1 : (int)u;
        return this.derivativeAt(out, i, u -= (double)i);
    }

    public T derivativeAt(T out, int span, double u) {
        return (T)CatmullRomSplineDouble.derivative(out, (int)(this.continuous ? span : span + 1), (double)u, this.controlPoints, (boolean)this.continuous, this.tmp);
    }

    public int nearest(T in) {
        return this.nearest(in, 0, this.spanCount);
    }

    public int nearest(T in, int start, int count) {
        while (start < 0) {
            start += this.spanCount;
        }
        int result = start % this.spanCount;
        double dst = in.dst2(this.controlPoints[result]);
        for (int i = 1; i < count; ++i) {
            int idx = (start + i) % this.spanCount;
            double d = in.dst2(this.controlPoints[idx]);
            if (!(d < dst)) continue;
            dst = d;
            result = idx;
        }
        return result;
    }

    @Override
    public double approximate(T v) {
        return this.approximate(v, this.nearest(v));
    }

    public double approximate(T in, int start, int count) {
        return this.approximate(in, this.nearest(in, start, count));
    }

    public double approximate(T in, int near) {
        T P3;
        T P2;
        T P1;
        int n = near;
        T nearest = this.controlPoints[n];
        T previous = this.controlPoints[n > 0 ? n - 1 : this.spanCount - 1];
        T next = this.controlPoints[(n + 1) % this.spanCount];
        double dstPrev2 = in.dst2(previous);
        double dstNext2 = in.dst2(next);
        if (dstNext2 < dstPrev2) {
            P1 = nearest;
            P2 = next;
            P3 = in;
        } else {
            P1 = previous;
            P2 = nearest;
            P3 = in;
            n = n > 0 ? n - 1 : this.spanCount - 1;
        }
        double L1Sqr = P1.dst2(P2);
        double L2Sqr = P3.dst2(P2);
        double L3Sqr = P3.dst2(P1);
        double L1 = FastMath.sqrt((double)L1Sqr);
        double s = (L2Sqr + L1Sqr - L3Sqr) / (2.0 * L1);
        double u = MathUtils.clamp((double)((L1 - s) / L1), (double)0.0, (double)1.0);
        return ((double)n + u) / (double)this.spanCount;
    }

    @Override
    public double locate(T v) {
        return this.approximate(v);
    }

    @Override
    public double approxLength(int samples) {
        double tempLength = 0.0;
        for (int i = 0; i < samples; ++i) {
            this.tmp2.set(this.tmp3);
            this.valueAt(this.tmp3, (double)i / ((double)samples - 1.0));
            if (i <= 0) continue;
            tempLength += this.tmp2.dst(this.tmp3);
        }
        return tempLength;
    }
}

