/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import gaiasky.util.math.BoundingBoxDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.PlaneDouble;
import gaiasky.util.math.Vector3D;

public class FrustumDouble {
    protected static final Vector3D[] clipSpacePlanePoints = new Vector3D[]{new Vector3D(-1.0, -1.0, -1.0), new Vector3D(1.0, -1.0, -1.0), new Vector3D(1.0, 1.0, -1.0), new Vector3D(-1.0, 1.0, -1.0), new Vector3D(-1.0, -1.0, 1.0), new Vector3D(1.0, -1.0, 1.0), new Vector3D(1.0, 1.0, 1.0), new Vector3D(-1.0, 1.0, 1.0)};
    protected static final double[] clipSpacePlanePointsArray = new double[24];
    private static final Vector3D tmpV = new Vector3D();
    public final PlaneDouble[] planes = new PlaneDouble[6];
    public final Vector3D[] planePoints = new Vector3D[]{new Vector3D(), new Vector3D(), new Vector3D(), new Vector3D(), new Vector3D(), new Vector3D(), new Vector3D(), new Vector3D()};
    protected final double[] planePointsArray = new double[24];

    public FrustumDouble() {
        for (int i = 0; i < 6; ++i) {
            this.planes[i] = new PlaneDouble(new Vector3D(), 0.0);
        }
    }

    public void update(Matrix4D inverseProjectionView) {
        System.arraycopy(clipSpacePlanePointsArray, 0, this.planePointsArray, 0, clipSpacePlanePointsArray.length);
        Matrix4D.prj(inverseProjectionView.val, this.planePointsArray, 0, 8, 3);
        int j = 0;
        for (int i = 0; i < 8; ++i) {
            Vector3D v = this.planePoints[i];
            v.x = this.planePointsArray[j++];
            v.y = this.planePointsArray[j++];
            v.z = this.planePointsArray[j++];
        }
        this.planes[0].set(this.planePoints[1], this.planePoints[0], this.planePoints[2]);
        this.planes[1].set(this.planePoints[4], this.planePoints[5], this.planePoints[7]);
        this.planes[2].set(this.planePoints[0], this.planePoints[4], this.planePoints[3]);
        this.planes[3].set(this.planePoints[5], this.planePoints[1], this.planePoints[6]);
        this.planes[4].set(this.planePoints[2], this.planePoints[3], this.planePoints[6]);
        this.planes[5].set(this.planePoints[4], this.planePoints[0], this.planePoints[1]);
    }

    public boolean pointInFrustum(Vector3D point) {
        for (int i = 0; i < this.planes.length; ++i) {
            PlaneDouble.PlaneSide result = this.planes[i].testPoint(point);
            if (result != PlaneDouble.PlaneSide.Back) continue;
            return false;
        }
        return true;
    }

    public boolean pointInFrustum(float x, float y, float z) {
        for (int i = 0; i < this.planes.length; ++i) {
            PlaneDouble.PlaneSide result = this.planes[i].testPoint(x, y, z);
            if (result != PlaneDouble.PlaneSide.Back) continue;
            return false;
        }
        return true;
    }

    public boolean sphereInFrustum(Vector3D center, float radius) {
        for (int i = 0; i < 6; ++i) {
            if (!(this.planes[i].normal.x * center.x + this.planes[i].normal.y * center.y + this.planes[i].normal.z * center.z < (double)(-radius) - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean sphereInFrustum(float x, float y, float z, float radius) {
        for (int i = 0; i < 6; ++i) {
            if (!(this.planes[i].normal.x * (double)x + this.planes[i].normal.y * (double)y + this.planes[i].normal.z * (double)z < (double)(-radius) - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean sphereInFrustumWithoutNearFar(Vector3D center, float radius) {
        for (int i = 2; i < 6; ++i) {
            if (!(this.planes[i].normal.x * center.x + this.planes[i].normal.y * center.y + this.planes[i].normal.z * center.z < (double)(-radius) - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean sphereInFrustumWithoutNearFar(float x, float y, float z, float radius) {
        for (int i = 2; i < 6; ++i) {
            if (!(this.planes[i].normal.x * (double)x + this.planes[i].normal.y * (double)y + this.planes[i].normal.z * (double)z < (double)(-radius) - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean boundsInFrustum(BoundingBoxDouble bounds) {
        int len2 = this.planes.length;
        for (int i = 0; i < len2; ++i) {
            if (this.planes[i].testPoint(bounds.getCorner000(tmpV)) != PlaneDouble.PlaneSide.Back || this.planes[i].testPoint(bounds.getCorner001(tmpV)) != PlaneDouble.PlaneSide.Back || this.planes[i].testPoint(bounds.getCorner010(tmpV)) != PlaneDouble.PlaneSide.Back || this.planes[i].testPoint(bounds.getCorner011(tmpV)) != PlaneDouble.PlaneSide.Back || this.planes[i].testPoint(bounds.getCorner100(tmpV)) != PlaneDouble.PlaneSide.Back || this.planes[i].testPoint(bounds.getCorner101(tmpV)) != PlaneDouble.PlaneSide.Back || this.planes[i].testPoint(bounds.getCorner110(tmpV)) != PlaneDouble.PlaneSide.Back || this.planes[i].testPoint(bounds.getCorner111(tmpV)) != PlaneDouble.PlaneSide.Back) continue;
            return false;
        }
        return true;
    }

    public boolean boundsInFrustum(Vector3D center, Vector3D dimensions) {
        return this.boundsInFrustum(center.x, center.y, center.z, dimensions.x / 2.0, dimensions.y / 2.0, dimensions.z / 2.0);
    }

    public boolean boundsInFrustum(double x, double y, double z, double halfWidth, double halfHeight, double halfDepth) {
        for (PlaneDouble plane : this.planes) {
            if (plane.testPoint(x + halfWidth, y + halfHeight, z + halfDepth) != PlaneDouble.PlaneSide.Back || plane.testPoint(x + halfWidth, y + halfHeight, z - halfDepth) != PlaneDouble.PlaneSide.Back || plane.testPoint(x + halfWidth, y - halfHeight, z + halfDepth) != PlaneDouble.PlaneSide.Back || plane.testPoint(x + halfWidth, y - halfHeight, z - halfDepth) != PlaneDouble.PlaneSide.Back || plane.testPoint(x - halfWidth, y + halfHeight, z + halfDepth) != PlaneDouble.PlaneSide.Back || plane.testPoint(x - halfWidth, y + halfHeight, z - halfDepth) != PlaneDouble.PlaneSide.Back || plane.testPoint(x - halfWidth, y - halfHeight, z + halfDepth) != PlaneDouble.PlaneSide.Back || plane.testPoint(x - halfWidth, y - halfHeight, z - halfDepth) != PlaneDouble.PlaneSide.Back) continue;
            return false;
        }
        return true;
    }

    static {
        int j = 0;
        for (Vector3D v : clipSpacePlanePoints) {
            FrustumDouble.clipSpacePlanePointsArray[j++] = v.x;
            FrustumDouble.clipSpacePlanePointsArray[j++] = v.y;
            FrustumDouble.clipSpacePlanePointsArray[j++] = v.z;
        }
    }
}

