/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import gaiasky.util.math.MathUtilsDouble;
import net.jafama.FastMath;

public abstract class InterpolationDouble {
    public static final InterpolationDouble linear = new InterpolationDouble(){

        @Override
        public double apply(double a) {
            return a;
        }
    };
    public static final InterpolationDouble smooth = new InterpolationDouble(){

        @Override
        public double apply(double a) {
            return a * a * (3.0 - 2.0 * a);
        }
    };
    public static final InterpolationDouble smooth2 = new InterpolationDouble(){

        @Override
        public double apply(double a) {
            a = a * a * (3.0 - 2.0 * a);
            return a * a * (3.0 - 2.0 * a);
        }
    };
    public static final InterpolationDouble smoother;
    public static final InterpolationDouble fade;
    public static final Pow pow2;
    public static final PowIn pow2In;
    public static final PowIn slowFast;
    public static final PowOut pow2Out;
    public static final PowOut fastSlow;
    public static final InterpolationDouble pow2InInverse;
    public static final InterpolationDouble pow2OutInverse;
    public static final Pow pow3;
    public static final PowIn pow3In;
    public static final PowOut pow3Out;
    public static final InterpolationDouble pow3InInverse;
    public static final InterpolationDouble pow3OutInverse;
    public static final Pow pow4;
    public static final PowIn pow4In;
    public static final PowOut pow4Out;
    public static final Pow pow5;
    public static final PowIn pow5In;
    public static final PowOut pow5Out;
    public static final InterpolationDouble sine;
    public static final InterpolationDouble sineIn;
    public static final InterpolationDouble sineOut;
    public static final Exp exp10;
    public static final ExpIn exp10In;
    public static final ExpOut exp10Out;
    public static final Exp exp5;
    public static final ExpIn exp5In;
    public static final ExpOut exp5Out;
    public static final InterpolationDouble circle;
    public static final InterpolationDouble circleIn;
    public static final InterpolationDouble circleOut;
    public static final Elastic elastic;
    public static final ElasticIn elasticIn;
    public static final ElasticOut elasticOut;
    public static final Swing swing;
    public static final SwingIn swingIn;
    public static final SwingOut swingOut;
    public static final Bounce bounce;
    public static final BounceIn bounceIn;
    public static final BounceOut bounceOut;

    public abstract double apply(double var1);

    public double apply(double start, double end, double a) {
        return start + (end - start) * this.apply(a);
    }

    static {
        fade = smoother = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return a * a * a * (a * (a * 6.0 - 15.0) + 10.0);
            }
        };
        pow2 = new Pow(2);
        slowFast = pow2In = new PowIn(2);
        fastSlow = pow2Out = new PowOut(2);
        pow2InInverse = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return FastMath.sqrt((double)a);
            }
        };
        pow2OutInverse = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return 1.0 - FastMath.sqrt((double)(-(a - 1.0)));
            }
        };
        pow3 = new Pow(3);
        pow3In = new PowIn(3);
        pow3Out = new PowOut(3);
        pow3InInverse = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return FastMath.cbrt((double)a);
            }
        };
        pow3OutInverse = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return 1.0 - FastMath.cbrt((double)(-(a - 1.0)));
            }
        };
        pow4 = new Pow(4);
        pow4In = new PowIn(4);
        pow4Out = new PowOut(4);
        pow5 = new Pow(5);
        pow5In = new PowIn(5);
        pow5Out = new PowOut(5);
        sine = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return (1.0 - MathUtilsDouble.cos(a * Math.PI)) / 2.0;
            }
        };
        sineIn = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return 1.0 - MathUtilsDouble.cos(a * Math.PI / 2.0);
            }
        };
        sineOut = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return MathUtilsDouble.sin(a * Math.PI / 2.0);
            }
        };
        exp10 = new Exp(2.0, 10.0);
        exp10In = new ExpIn(2.0, 10.0);
        exp10Out = new ExpOut(2.0, 10.0);
        exp5 = new Exp(2.0, 5.0);
        exp5In = new ExpIn(2.0, 5.0);
        exp5Out = new ExpOut(2.0, 5.0);
        circle = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                if (a <= 0.5) {
                    return (1.0 - FastMath.sqrt((double)(1.0 - (a *= 2.0) * a))) / 2.0;
                }
                a -= 1.0;
                return (Math.sqrt(1.0 - (a *= 2.0) * a) + 1.0) / 2.0;
            }
        };
        circleIn = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return 1.0 - FastMath.sqrt((double)(1.0 - a * a));
            }
        };
        circleOut = new InterpolationDouble(){

            @Override
            public double apply(double a) {
                return FastMath.sqrt((double)(1.0 - (a -= 1.0) * a));
            }
        };
        elastic = new Elastic(2.0, 10.0, 7, 1.0);
        elasticIn = new ElasticIn(2.0, 10.0, 6, 1.0);
        elasticOut = new ElasticOut(2.0, 10.0, 7, 1.0);
        swing = new Swing(1.5);
        swingIn = new SwingIn(2.0);
        swingOut = new SwingOut(2.0);
        bounce = new Bounce(4);
        bounceIn = new BounceIn(4);
        bounceOut = new BounceOut(4);
    }

    public static class Pow
    extends InterpolationDouble {
        final int power;

        public Pow(int power) {
            this.power = power;
        }

        @Override
        public double apply(double a) {
            if (a <= 0.5) {
                return FastMath.pow((double)(a * 2.0), (double)this.power) / 2.0;
            }
            return FastMath.pow((double)((a - 1.0) * 2.0), (double)this.power) / (double)(this.power % 2 == 0 ? -2 : 2) + 1.0;
        }
    }

    public static class PowIn
    extends Pow {
        public PowIn(int power) {
            super(power);
        }

        @Override
        public double apply(double a) {
            return FastMath.pow((double)a, (double)this.power);
        }
    }

    public static class PowOut
    extends Pow {
        public PowOut(int power) {
            super(power);
        }

        @Override
        public double apply(double a) {
            return FastMath.pow((double)(a - 1.0), (double)this.power) * (double)(this.power % 2 == 0 ? -1 : 1) + 1.0;
        }
    }

    public static class Exp
    extends InterpolationDouble {
        final double value;
        final double power;
        final double min;
        final double scale;

        public Exp(double value, double power) {
            this.value = value;
            this.power = power;
            this.min = FastMath.pow((double)value, (double)(-power));
            this.scale = 1.0 / (1.0 - this.min);
        }

        @Override
        public double apply(double a) {
            if (a <= 0.5) {
                return (Math.pow(this.value, this.power * (a * 2.0 - 1.0)) - this.min) * this.scale / 2.0;
            }
            return (2.0 - (Math.pow(this.value, -this.power * (a * 2.0 - 1.0)) - this.min) * this.scale) / 2.0;
        }
    }

    public static class ExpIn
    extends Exp {
        public ExpIn(double value, double power) {
            super(value, power);
        }

        @Override
        public double apply(double a) {
            return (Math.pow(this.value, this.power * (a - 1.0)) - this.min) * this.scale;
        }
    }

    public static class ExpOut
    extends Exp {
        public ExpOut(double value, double power) {
            super(value, power);
        }

        @Override
        public double apply(double a) {
            return 1.0 - (Math.pow(this.value, -this.power * a) - this.min) * this.scale;
        }
    }

    public static class Elastic
    extends InterpolationDouble {
        final double value;
        final double power;
        final double scale;
        final double bounces;

        public Elastic(double value, double power, int bounces, double scale) {
            this.value = value;
            this.power = power;
            this.scale = scale;
            this.bounces = (double)bounces * Math.PI * (double)(bounces % 2 == 0 ? 1 : -1);
        }

        @Override
        public double apply(double a) {
            if (a <= 0.5) {
                return FastMath.pow((double)this.value, (double)(this.power * ((a *= 2.0) - 1.0))) * MathUtilsDouble.sin(a * this.bounces) * this.scale / 2.0;
            }
            a = 1.0 - a;
            return 1.0 - FastMath.pow((double)this.value, (double)(this.power * ((a *= 2.0) - 1.0))) * MathUtilsDouble.sin(a * this.bounces) * this.scale / 2.0;
        }
    }

    public static class ElasticIn
    extends Elastic {
        public ElasticIn(double value, double power, int bounces, double scale) {
            super(value, power, bounces, scale);
        }

        @Override
        public double apply(double a) {
            if (a >= 0.99) {
                return 1.0;
            }
            return FastMath.pow((double)this.value, (double)(this.power * (a - 1.0))) * MathUtilsDouble.sin(a * this.bounces) * this.scale;
        }
    }

    public static class ElasticOut
    extends Elastic {
        public ElasticOut(double value, double power, int bounces, double scale) {
            super(value, power, bounces, scale);
        }

        @Override
        public double apply(double a) {
            if (a == 0.0) {
                return 0.0;
            }
            a = 1.0 - a;
            return 1.0 - FastMath.pow((double)this.value, (double)(this.power * (a - 1.0))) * MathUtilsDouble.sin(a * this.bounces) * this.scale;
        }
    }

    public static class Swing
    extends InterpolationDouble {
        private final double scale;

        public Swing(double scale) {
            this.scale = scale * 2.0;
        }

        @Override
        public double apply(double a) {
            if (a <= 0.5) {
                return (a *= 2.0) * a * ((this.scale + 1.0) * a - this.scale) / 2.0;
            }
            a -= 1.0;
            return (a *= 2.0) * a * ((this.scale + 1.0) * a + this.scale) / 2.0 + 1.0;
        }
    }

    public static class SwingIn
    extends InterpolationDouble {
        private final double scale;

        public SwingIn(double scale) {
            this.scale = scale;
        }

        @Override
        public double apply(double a) {
            return a * a * ((this.scale + 1.0) * a - this.scale);
        }
    }

    public static class SwingOut
    extends InterpolationDouble {
        private final double scale;

        public SwingOut(double scale) {
            this.scale = scale;
        }

        @Override
        public double apply(double a) {
            return (a -= 1.0) * a * ((this.scale + 1.0) * a + this.scale) + 1.0;
        }
    }

    public static class Bounce
    extends BounceOut {
        public Bounce(double[] widths, double[] heights) {
            super(widths, heights);
        }

        public Bounce(int bounces) {
            super(bounces);
        }

        private double out(double a) {
            double test = a + this.widths[0] / 2.0;
            if (test < this.widths[0]) {
                return test / (this.widths[0] / 2.0) - 1.0;
            }
            return super.apply(a);
        }

        @Override
        public double apply(double a) {
            if (a <= 0.5) {
                return (1.0 - this.out(1.0 - a * 2.0)) / 2.0;
            }
            return this.out(a * 2.0 - 1.0) / 2.0 + 0.5;
        }
    }

    public static class BounceIn
    extends BounceOut {
        public BounceIn(double[] widths, double[] heights) {
            super(widths, heights);
        }

        public BounceIn(int bounces) {
            super(bounces);
        }

        @Override
        public double apply(double a) {
            return 1.0 - super.apply(1.0 - a);
        }
    }

    public static class BounceOut
    extends InterpolationDouble {
        final double[] widths;
        final double[] heights;

        public BounceOut(double[] widths, double[] heights) {
            if (widths.length != heights.length) {
                throw new IllegalArgumentException("Must be the same number of widths and heights.");
            }
            this.widths = widths;
            this.heights = heights;
        }

        public BounceOut(int bounces) {
            if (bounces < 2 || bounces > 5) {
                throw new IllegalArgumentException("bounces cannot be < 2 or > 5: " + bounces);
            }
            this.widths = new double[bounces];
            this.heights = new double[bounces];
            this.heights[0] = 1.0;
            switch (bounces) {
                case 2: {
                    this.widths[0] = 0.6;
                    this.widths[1] = 0.4;
                    this.heights[1] = 0.33;
                    break;
                }
                case 3: {
                    this.widths[0] = 0.4;
                    this.widths[1] = 0.4;
                    this.widths[2] = 0.2;
                    this.heights[1] = 0.33;
                    this.heights[2] = 0.1;
                    break;
                }
                case 4: {
                    this.widths[0] = 0.34;
                    this.widths[1] = 0.34;
                    this.widths[2] = 0.2;
                    this.widths[3] = 0.15;
                    this.heights[1] = 0.26;
                    this.heights[2] = 0.11;
                    this.heights[3] = 0.03;
                    break;
                }
                case 5: {
                    this.widths[0] = 0.3;
                    this.widths[1] = 0.3;
                    this.widths[2] = 0.2;
                    this.widths[3] = 0.1;
                    this.widths[4] = 0.1;
                    this.heights[1] = 0.45;
                    this.heights[2] = 0.3;
                    this.heights[3] = 0.15;
                    this.heights[4] = 0.06;
                }
            }
            this.widths[0] = this.widths[0] * 2.0;
        }

        @Override
        public double apply(double a) {
            if (a == 1.0) {
                return 1.0;
            }
            a += this.widths[0] / 2.0;
            double width = 0.0;
            double height = 0.0;
            int n = this.widths.length;
            for (int i = 0; i < n; ++i) {
                width = this.widths[i];
                if (a <= width) {
                    height = this.heights[i];
                    break;
                }
                a -= width;
            }
            double z = 4.0 / width * height * (a /= width);
            return 1.0 - (z - z * a) * width;
        }
    }
}

