/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.math.RayDouble;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class IntersectorDouble {
    private static final Vector3D auxd1 = new Vector3D();
    private static final Vector3D auxd2 = new Vector3D();
    private static final Vector3D auxd3 = new Vector3D();

    public static boolean intersectRayBoundsFast(RayDouble ray, Vector3D center, Vector3D dimensions) {
        double maxz;
        double minz;
        double maxy;
        double miny;
        double divX = 1.0 / ray.direction.x;
        double divY = 1.0 / ray.direction.y;
        double divZ = 1.0 / ray.direction.z;
        double minx = (center.x - dimensions.x * 0.5 - ray.origin.x) * divX;
        double maxx = (center.x + dimensions.x * 0.5 - ray.origin.x) * divX;
        if (minx > maxx) {
            double t = minx;
            minx = maxx;
            maxx = t;
        }
        if ((miny = (center.y - dimensions.y * 0.5 - ray.origin.y) * divY) > (maxy = (center.y + dimensions.y * 0.5 - ray.origin.y) * divY)) {
            double t = miny;
            miny = maxy;
            maxy = t;
        }
        if ((minz = (center.z - dimensions.z * 0.5 - ray.origin.z) * divZ) > (maxz = (center.z + dimensions.z * 0.5 - ray.origin.z) * divZ)) {
            double t = minz;
            minz = maxz;
            maxz = t;
        }
        double min = FastMath.max((double)Math.max(minx, miny), (double)minz);
        double max = FastMath.min((double)Math.min(maxx, maxy), (double)maxz);
        return max >= 0.0 && max >= min;
    }

    public static boolean checkIntersectRaySpehre(Vector3D linePoint0, Vector3D linePoint1, Vector3D sphereCenter, double sphereRadius) {
        return IntersectorDouble.checkIntersectRaySpehre(linePoint0.x, linePoint0.y, linePoint0.z, linePoint1.x, linePoint1.y, linePoint1.z, sphereCenter.x, sphereCenter.y, sphereCenter.z, sphereRadius);
    }

    public static boolean checkIntersectRaySpehre(Vector3 linePoint0, Vector3 linePoint1, Vector3D sphereCenter, double sphereRadius) {
        return IntersectorDouble.checkIntersectRaySpehre(linePoint0.x, linePoint0.y, linePoint0.z, linePoint1.x, linePoint1.y, linePoint1.z, sphereCenter.x, sphereCenter.y, sphereCenter.z, sphereRadius);
    }

    public static boolean checkIntersectRaySpehre(double px, double py, double pz, double vx, double vy, double vz, double cx, double cy, double cz, double sphereRadius) {
        double B = 2.0 * (px * vx + py * vy + pz * vz - vx * cx - vy * cy - vz * cz);
        double A = vx * vx + vy * vy + vz * vz;
        double C = px * px - 2.0 * px * cx + cx * cx + py * py - 2.0 * py * cy + cy * cy + pz * pz - 2.0 * pz * cz + cz * cz - sphereRadius * sphereRadius;
        double D = B * B - 4.0 * A * C;
        return D >= 0.0;
    }

    public static synchronized Array<Vector3D> intersectRaySphere(Vector3D linePoint0, Vector3D linePoint1, Vector3D sphereCenter, double sphereRadius) {
        double cx = sphereCenter.x;
        double cy = sphereCenter.y;
        double cz = sphereCenter.z;
        double px = linePoint0.x;
        double py = linePoint0.y;
        double pz = linePoint0.z;
        double vx = linePoint1.x - px;
        double vy = linePoint1.y - py;
        double vz = linePoint1.z - pz;
        double A = vx * vx + vy * vy + vz * vz;
        double B = 2.0 * (px * vx + py * vy + pz * vz - vx * cx - vy * cy - vz * cz);
        double C = px * px - 2.0 * px * cx + cx * cx + py * py - 2.0 * py * cy + cy * cy + pz * pz - 2.0 * pz * cz + cz * cz - sphereRadius * sphereRadius;
        double D = B * B - 4.0 * A * C;
        Array result = new Array(false, 2);
        if (D < 0.0) {
            return result;
        }
        double t1 = (-B - FastMath.sqrt((double)D)) / (2.0 * A);
        Vector3D solution1 = auxd1.set(linePoint0.x * (1.0 - t1) + t1 * linePoint1.x, linePoint0.y * (1.0 - t1) + t1 * linePoint1.y, linePoint0.z * (1.0 - t1) + t1 * linePoint1.z);
        if (D == 0.0) {
            result.add((Object)solution1);
            return result;
        }
        double t2 = (-B + FastMath.sqrt((double)D)) / (2.0 * A);
        Vector3D solution2 = auxd2.set(linePoint0.x * (1.0 - t2) + t2 * linePoint1.x, linePoint0.y * (1.0 - t2) + t2 * linePoint1.y, linePoint0.z * (1.0 - t2) + t2 * linePoint1.z);
        if (Math.abs(t1 - 0.5) < FastMath.abs((double)(t2 - 0.5))) {
            result.add((Object)solution1);
            result.add((Object)solution2);
            return result;
        }
        result.add((Object)solution2);
        result.add((Object)solution1);
        return result;
    }

    public static boolean checkIntersectSegmentSphere(Vector3D linePoint0, Vector3D linePoint1, Vector3D sphereCenter, double sphereRadius) {
        Array<Vector3D> solutions = IntersectorDouble.intersectRaySphere(linePoint0, linePoint1, sphereCenter, sphereRadius);
        int n = solutions.size;
        for (int i = 0; i < n; ++i) {
            if (!IntersectorDouble.isBetween(linePoint0, linePoint1, (Vector3D)solutions.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isBetween(Vector3D a, Vector3D b, Vector3D c) {
        double cb;
        double ac;
        double value;
        double ab = a.dst(b);
        double epsilon = ab * 1.0E-6 / 2.0;
        return -epsilon < (value = (ac = a.dst(c)) + (cb = c.dst(b)) - ab) && value < epsilon;
    }

    public static synchronized double distanceLinePoint(Vector3D x1, Vector3D x2, Vector3D x0) {
        Vector3D aux1 = auxd2.set(x0).sub(x2);
        double nominator = auxd1.set(x0).sub(x1).crs(aux1).len();
        double denominator = aux1.set(x2).sub(x1).len();
        return nominator / denominator;
    }

    public static synchronized double distanceSegmentPoint(Vector3D a, Vector3D b, Vector3D v) {
        Vector3D ab = auxd1.set(b).sub(a);
        double ablen = ab.len();
        Vector3D av = auxd2.set(v).sub(a);
        double avlen = av.len();
        if (av.dot(ab) <= 0.0) {
            return avlen;
        }
        Vector3D bv = auxd3.set(v).sub(b);
        double bvlen = bv.len();
        if (bv.dot(ab) >= 0.0) {
            return bvlen;
        }
        return ab.crs(av).len() / ablen;
    }

    public static void lineIntersection(Vector3D planePoint, Vector3D planeNormal, Vector3D linePoint, Vector3D lineDirection, Vector3D out) {
        if (planeNormal.dot(lineDirection.nor()) == 0.0) {
            return;
        }
        double t = (planeNormal.dot(planePoint) - planeNormal.dot(linePoint)) / planeNormal.dot(lineDirection.nor());
        out.set(linePoint).add(lineDirection.nor().scl(t));
    }

    public static double distancePointPlane(Vector3D point, Vector3D planeNormal, Vector3D planePoint) {
        double a = planeNormal.x;
        double b = planeNormal.y;
        double c = planeNormal.z;
        double d = -a * planePoint.x - b * planePoint.y - c * planePoint.z;
        return IntersectorDouble.distancePointPlane(point.x, point.y, point.z, a, b, c, d);
    }

    public static double distancePointPlane(double pointX, double pointY, double pointZ, double a, double b, double c, double d) {
        double denom = FastMath.sqrt((double)(a * a + b * b + c * c));
        return (a * pointX + b * pointY + c * pointZ + d) / denom;
    }

    public static boolean intersectLineSegmentPlane(Vector3D p0, Vector3D p1, Vector3D planeNormal, Vector3D planePoint, Vector3D intersectionPoint) {
        double a = planeNormal.x;
        double b = planeNormal.y;
        double c = planeNormal.z;
        double d = -a * planePoint.x - b * planePoint.y - c * planePoint.z;
        return IntersectorDouble.intersectLineSegmentPlane(p0.x, p0.y, p0.z, p1.x, p1.y, p1.z, a, b, c, d, intersectionPoint);
    }

    public static boolean intersectLineSegmentPlane(double p0X, double p0Y, double p0Z, double p1X, double p1Y, double p1Z, double a, double b, double c, double d, Vector3D intersectionPoint) {
        double dirX = p1X - p0X;
        double dirY = p1Y - p0Y;
        double dirZ = p1Z - p0Z;
        double denominator = a * dirX + b * dirY + c * dirZ;
        double t = -(a * p0X + b * p0Y + c * p0Z + d) / denominator;
        if (t >= 0.0 && t <= 1.0) {
            intersectionPoint.x = p0X + t * dirX;
            intersectionPoint.y = p0Y + t * dirY;
            intersectionPoint.z = p0Z + t * dirZ;
            return true;
        }
        return false;
    }
}

