/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import gaiasky.util.math.InterpolationDouble;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.PathDouble;
import gaiasky.util.math.VectorDouble;
import net.jafama.FastMath;

public class LinearDouble<T extends VectorDouble<T>>
implements PathDouble<T> {
    public T[] controlPoints;

    public LinearDouble(T[] controlPoints) {
        this.set((VectorDouble[])controlPoints);
    }

    public LinearDouble<T> set(T[] controlPoints) {
        this.controlPoints = controlPoints;
        return this;
    }

    @Override
    public T derivativeAt(T out, double t) {
        return null;
    }

    @Override
    public T valueAt(T out, double t) {
        if (MathUtilsDouble.fuzzyEquals(t, 0.0, 1.0E-9)) {
            out.set(this.controlPoints[0]);
            return this.controlPoints[0];
        }
        if (MathUtilsDouble.fuzzyEquals(t, 1.0, 1.0E-9)) {
            out.set(this.controlPoints[this.controlPoints.length - 1]);
            return this.controlPoints[this.controlPoints.length - 1];
        }
        int n = this.controlPoints.length;
        double step = 1.0 / ((double)n - 1.0);
        int i0 = (int)FastMath.floor((double)(t / step));
        int i1 = i0 + 1;
        double alpha = t / step - (double)i0;
        T p0 = this.controlPoints[i0];
        T p1 = this.controlPoints[i1];
        out.set(p0);
        return out.interpolate(p1, alpha, InterpolationDouble.linear);
    }

    @Override
    public double approximate(T v) {
        return 0.0;
    }

    @Override
    public double locate(T v) {
        return 0.0;
    }

    @Override
    public double approxLength(int samples) {
        return 0.0;
    }
}

