/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import gaiasky.util.math.MathUtilsDouble;

public class LinearInterpolator {
    private final double[] x;
    private final double[] y;
    private final int length;

    public LinearInterpolator(double[] x, double[] y) {
        if (x == null || y == null) {
            throw new RuntimeException("Interpolation points can't be null");
        }
        if (x.length == 0 || y.length == 0) {
            throw new RuntimeException("Interpolation points can't be empty");
        }
        if (x.length != y.length) {
            throw new RuntimeException("Lengths of x and y must be the same");
        }
        this.x = x;
        this.y = y;
        this.length = x.length;
    }

    public double value(double v) {
        if (this.x[0] > v || this.x[this.length - 1] < v) {
            throw new RuntimeException("Value out of range: " + v + " not in [" + this.x[0] + "," + this.x[this.length - 1] + "]");
        }
        int i0 = -1;
        int i1 = -1;
        int first = 1;
        int last = this.length - 1;
        int mid = (first + last) / 2;
        while (first <= last) {
            if (v >= this.x[mid - 1] && v <= this.x[mid]) {
                i0 = mid - 1;
                i1 = mid;
                break;
            }
            if (v < this.x[mid - 1]) {
                last = mid - 1;
            } else {
                first = mid + 1;
            }
            mid = (first + last) / 2;
        }
        return MathUtilsDouble.lint(v, this.x[i0], this.x[i1], this.y[i0], this.y[i1]);
    }
}

