/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.RandomXS128;
import gaiasky.util.math.Vector3D;
import java.util.Random;
import net.jafama.FastMath;

public final class MathUtilsDouble {
    public static final double FLOAT_ROUNDING_ERROR = 1.0E-6;
    public static final double PI = Math.PI;
    public static final double PI2 = Math.PI * 2;
    public static final double radiansToDegrees = 57.29577951308232;
    public static final double radDeg = 57.29577951308232;
    public static final double degreesToRadians = Math.PI / 180;
    public static final double degRad = Math.PI / 180;
    private static final double degFull = 360.0;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final double degToIndex = 45.51111111111111;
    private static final double radFull = Math.PI * 2;
    private static final double radToIndex = 2607.5945876176133;
    public static Random random = new RandomXS128();
    static Vector3D aux0 = new Vector3D();
    static Vector3D aux1 = new Vector3D();
    static Vector3D aux2 = new Vector3D();
    static Vector3D aux3 = new Vector3D();
    static Vector3D aux4 = new Vector3D();
    static Vector3D aux5 = new Vector3D();

    public static double sin(double radians) {
        return Sin.table[(int)(radians * 2607.5945876176133) & 0x3FFF];
    }

    public static double cos(double radians) {
        return Sin.table[(int)((radians + 1.5707963267948966) * 2607.5945876176133) & 0x3FFF];
    }

    public static double sinDeg(double degrees) {
        return Sin.table[(int)(degrees * 45.51111111111111) & 0x3FFF];
    }

    public static double cosDeg(double degrees) {
        return Sin.table[(int)((degrees + 90.0) * 45.51111111111111) & 0x3FFF];
    }

    public static double atan2(double y, double x) {
        if (x == 0.0) {
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y == 0.0) {
                return 0.0;
            }
            return -1.5707963267948966;
        }
        double z = y / x;
        if (Math.abs(z) < 1.0) {
            double atan = z / (1.0 + 0.28 * z * z);
            if (x < 0.0) {
                return atan + (y < 0.0 ? -Math.PI : Math.PI);
            }
            return atan;
        }
        double atan = 1.5707963267948966 - z / (z * z + 0.28);
        return y < 0.0 ? atan - Math.PI : atan;
    }

    public static int random(int range) {
        return random.nextInt(range + 1);
    }

    public static int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static long random(long range) {
        return (long)(random.nextDouble() * (double)range);
    }

    public static long random(long start, long end) {
        return start + (long)(random.nextDouble() * (double)(end - start));
    }

    public static double random() {
        return random.nextDouble();
    }

    public static double random(double range) {
        return random.nextDouble() * range;
    }

    public static double random(double start, double end) {
        return start + random.nextDouble() * (end - start);
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return FastMath.min((int)value, (int)max);
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        return FastMath.min((long)value, (long)max);
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return FastMath.min((float)value, (float)max);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return FastMath.min((double)value, (double)max);
    }

    public static double max(double ... values) {
        double max = Double.MIN_VALUE;
        for (double v : values) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static float max(float ... values) {
        float max = Float.MIN_VALUE;
        for (float v : values) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static int max(int ... values) {
        int max = Integer.MIN_VALUE;
        for (int v : values) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public static double min(double ... values) {
        double max = Double.MAX_VALUE;
        for (double v : values) {
            if (!(v < max)) continue;
            max = v;
        }
        return max;
    }

    public static float min(float ... values) {
        float max = Float.MAX_VALUE;
        for (float v : values) {
            if (!(v < max)) continue;
            max = v;
        }
        return max;
    }

    public static int min(int ... values) {
        int max = Integer.MAX_VALUE;
        for (int v : values) {
            if (v >= max) continue;
            max = v;
        }
        return max;
    }

    public static boolean isZero(double value) {
        return FastMath.abs((double)value) <= 1.0E-6;
    }

    public static boolean isZero(double value, double tolerance) {
        return FastMath.abs((double)value) <= tolerance;
    }

    public static boolean isEqual(double a, double b) {
        return FastMath.abs((double)(a - b)) <= 1.0E-6;
    }

    public static boolean isEqual(double a, double b, double tolerance) {
        return FastMath.abs((double)(a - b)) <= tolerance;
    }

    public static double sqrt(double value) {
        double sqrt = Double.longBitsToDouble((Double.doubleToLongBits(value) - 0x10000000000000L >> 1) + 0x2000000000000000L);
        return (sqrt + value / sqrt) / 2.0;
    }

    public static double mix(double x, double y, double a) {
        return x * (1.0 - a) + y * a;
    }

    public static double softMin(double a, double b, double weight) {
        return MathUtilsDouble.lerp(a, FastMath.min((double)a, (double)b), weight);
    }

    public static double lerp(double a, double b, double t) {
        return a + t * (b - a);
    }

    public static double flint(double x, double x0, double x1, double y0, double y1) {
        if (x < x0) {
            return y0;
        }
        if (x > x1) {
            return y1;
        }
        return y0 + (y1 - y0) * (x - x0) / (x1 - x0);
    }

    public static double lint(double x, double x0, double x1, double y0, double y1) {
        double rx0 = x0;
        double rx1 = x1;
        if (x0 > x1) {
            rx0 = x1;
            rx1 = x0;
        }
        if (x < rx0) {
            return y0;
        }
        if (x > rx1) {
            return y1;
        }
        return y0 + (y1 - y0) * (x - rx0) / (rx1 - rx0);
    }

    public static float lint(float x, float x0, float x1, float y0, float y1) {
        float rx0 = x0;
        float rx1 = x1;
        if (x0 > x1) {
            rx0 = x1;
            rx1 = x0;
        }
        if (x < rx0) {
            return y0;
        }
        if (x > rx1) {
            return y1;
        }
        return y0 + (y1 - y0) * (x - rx0) / (rx1 - rx0);
    }

    public static float lint(long x, long x0, long x1, float y0, float y1) {
        double rx0 = x0;
        double rx1 = x1;
        if (x0 > x1) {
            rx0 = x1;
            rx1 = x0;
        }
        if ((double)x < rx0) {
            return y0;
        }
        if ((double)x > rx1) {
            return y1;
        }
        return (float)((double)y0 + (double)(y1 - y0) * ((double)x - rx0) / (rx1 - rx0));
    }

    public static double distancePointSegment(double x1, double y1, double z1, double x2, double y2, double z2, double x0, double y0, double z0) {
        Vector3D v = aux0.set(x1, y1, z1);
        Vector3D w = aux1.set(x2, y2, z2);
        Vector3D p = aux2.set(x0, y0, z0);
        aux3.set(p).sub(v);
        aux4.set(w).sub(v);
        double l2 = v.dst2(w);
        if (l2 == 0.0) {
            return p.dst(v);
        }
        double t = aux3.dot(aux4) / l2;
        if (t < 0.0) {
            return p.dst(v);
        }
        if (t > 1.0) {
            return p.dst(w);
        }
        Vector3D projection = v.add(aux4.scl(t));
        return p.dst(projection);
    }

    public static Vector3D getClosestPoint2(double x1, double y1, double z1, double x2, double y2, double z2, double x0, double y0, double z0, Vector3D result) {
        Vector3D p1 = aux0.set(x1, y1, z1);
        Vector3D p2 = aux1.set(x0, y0, z0);
        Vector3D v = aux2.set(x2 - x1, y2 - y1, z2 - z1);
        double nomin = aux3.set(p2).sub(p1).dot(v);
        double denom = v.dot(v);
        Vector3D frac = aux4.set(v).scl(nomin / denom);
        result.set(p1).add(frac);
        return result;
    }

    public static double roundAvoid(double value, int places) {
        double scale = FastMath.pow((double)10.0, (double)places);
        return (double)FastMath.round((double)(value * scale)) / scale;
    }

    public static double normalizeAngle(double a, double center) {
        return a - Math.PI * 2 * FastMath.floor((double)((a + Math.PI - center) / (Math.PI * 2)));
    }

    public static boolean fuzzyEquals(Double a, Double b, double epsilon) {
        double absA = FastMath.abs((double)a);
        double absB = FastMath.abs((double)b);
        double diff = FastMath.abs((double)(a - b));
        if (a.equals(b)) {
            return true;
        }
        if (a == 0.0 || b == 0.0 || absA + absB < Double.MIN_NORMAL) {
            return diff < epsilon * Double.MIN_NORMAL;
        }
        return diff / FastMath.min((double)(absA + absB), (double)Double.MAX_VALUE) < epsilon;
    }

    public static double lowPass(double newValue, double smoothedValue, double smoothing) {
        if (smoothing > 0.0) {
            smoothedValue += (newValue - smoothedValue) / smoothing;
            return smoothedValue;
        }
        return newValue;
    }

    public static float lowPass(float newValue, float smoothedValue, float smoothing) {
        if (smoothing > 0.0f) {
            smoothedValue += (newValue - smoothedValue) / smoothing;
            return smoothedValue;
        }
        return newValue;
    }

    public static double logit(double x) {
        return FastMath.log((double)(x / (1.0 - x)));
    }

    public static double logisticSigmoid(double x, double span) {
        x = x * span - span * 0.5;
        return FastMath.exp((double)x) / (1.0 + FastMath.exp((double)x));
    }

    private static class Sin {
        static final double[] table;

        private Sin() {
        }

        static {
            int i;
            table = new double[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = FastMath.sin((double)(((double)i + 0.5) / 16384.0 * (Math.PI * 2)));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((double)i * 45.51111111111111) & 0x3FFF] = FastMath.sin((double)((double)i * (Math.PI / 180)));
            }
        }
    }
}

