/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import java.io.Serializable;

public class Matrix3D
implements Serializable {
    private static final long serialVersionUID = 7907569533774959788L;
    public static final int M00 = 0;
    public static final int M01 = 3;
    public static final int M02 = 6;
    public static final int M10 = 1;
    public static final int M11 = 4;
    public static final int M12 = 7;
    public static final int M20 = 2;
    public static final int M21 = 5;
    public static final int M22 = 8;
    public double[] val = new double[9];
    private final double[] tmp = new double[9];

    public Matrix3D() {
        this.tmp[8] = 1.0;
        this.idt();
    }

    public Matrix3D(Matrix3D matrix) {
        this.tmp[8] = 1.0;
        this.set(matrix);
    }

    public Matrix3D(double[] values) {
        this.tmp[8] = 1.0;
        this.set(values);
    }

    public Matrix3D idt() {
        double[] val = this.val;
        val[0] = 1.0;
        val[1] = 0.0;
        val[2] = 0.0;
        val[3] = 0.0;
        val[4] = 1.0;
        val[5] = 0.0;
        val[6] = 0.0;
        val[7] = 0.0;
        val[8] = 1.0;
        return this;
    }

    public Matrix3D mul(Matrix3D m) {
        double[] val = this.val;
        double v00 = val[0] * m.val[0] + val[3] * m.val[1] + val[6] * m.val[2];
        double v01 = val[0] * m.val[3] + val[3] * m.val[4] + val[6] * m.val[5];
        double v02 = val[0] * m.val[6] + val[3] * m.val[7] + val[6] * m.val[8];
        double v10 = val[1] * m.val[0] + val[4] * m.val[1] + val[7] * m.val[2];
        double v11 = val[1] * m.val[3] + val[4] * m.val[4] + val[7] * m.val[5];
        double v12 = val[1] * m.val[6] + val[4] * m.val[7] + val[7] * m.val[8];
        double v20 = val[2] * m.val[0] + val[5] * m.val[1] + val[8] * m.val[2];
        double v21 = val[2] * m.val[3] + val[5] * m.val[4] + val[8] * m.val[5];
        double v22 = val[2] * m.val[6] + val[5] * m.val[7] + val[8] * m.val[8];
        val[0] = v00;
        val[1] = v10;
        val[2] = v20;
        val[3] = v01;
        val[4] = v11;
        val[5] = v21;
        val[6] = v02;
        val[7] = v12;
        val[8] = v22;
        return this;
    }

    public Matrix3D mulLeft(Matrix3D m) {
        double[] val = this.val;
        double v00 = m.val[0] * val[0] + m.val[3] * val[1] + m.val[6] * val[2];
        double v01 = m.val[0] * val[3] + m.val[3] * val[4] + m.val[6] * val[5];
        double v02 = m.val[0] * val[6] + m.val[3] * val[7] + m.val[6] * val[8];
        double v10 = m.val[1] * val[0] + m.val[4] * val[1] + m.val[7] * val[2];
        double v11 = m.val[1] * val[3] + m.val[4] * val[4] + m.val[7] * val[5];
        double v12 = m.val[1] * val[6] + m.val[4] * val[7] + m.val[7] * val[8];
        double v20 = m.val[2] * val[0] + m.val[5] * val[1] + m.val[8] * val[2];
        double v21 = m.val[2] * val[3] + m.val[5] * val[4] + m.val[8] * val[5];
        double v22 = m.val[2] * val[6] + m.val[5] * val[7] + m.val[8] * val[8];
        val[0] = v00;
        val[1] = v10;
        val[2] = v20;
        val[3] = v01;
        val[4] = v11;
        val[5] = v21;
        val[6] = v02;
        val[7] = v12;
        val[8] = v22;
        return this;
    }

    public Matrix3D setToRotation(double degrees) {
        return this.setToRotationRad(0.01745329238474369 * degrees);
    }

    public Matrix3D setToRotationRad(double radians) {
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double[] val = this.val;
        val[0] = cos;
        val[1] = sin;
        val[2] = 0.0;
        val[3] = -sin;
        val[4] = cos;
        val[5] = 0.0;
        val[6] = 0.0;
        val[7] = 0.0;
        val[8] = 1.0;
        return this;
    }

    public Matrix3D setToRotation(Vector3D axis, double degrees) {
        return this.setToRotation(axis, MathUtilsDouble.cosDeg(degrees), MathUtilsDouble.sinDeg(degrees));
    }

    public Matrix3D setToRotation(Vector3D axis, double cos, double sin) {
        double[] val = this.val;
        double oc = 1.0 - cos;
        val[0] = oc * axis.x * axis.x + cos;
        val[3] = oc * axis.x * axis.y - axis.z * sin;
        val[6] = oc * axis.z * axis.x + axis.y * sin;
        val[1] = oc * axis.x * axis.y + axis.z * sin;
        val[4] = oc * axis.y * axis.y + cos;
        val[7] = oc * axis.y * axis.z - axis.x * sin;
        val[2] = oc * axis.z * axis.x - axis.y * sin;
        val[5] = oc * axis.y * axis.z + axis.x * sin;
        val[8] = oc * axis.z * axis.z + cos;
        return this;
    }

    public Matrix3D setToTranslation(double x, double y) {
        double[] val = this.val;
        val[0] = 1.0;
        val[1] = 0.0;
        val[2] = 0.0;
        val[3] = 0.0;
        val[4] = 1.0;
        val[5] = 0.0;
        val[6] = x;
        val[7] = y;
        val[8] = 1.0;
        return this;
    }

    public Matrix3D setToTranslation(Vector2 translation) {
        double[] val = this.val;
        val[0] = 1.0;
        val[1] = 0.0;
        val[2] = 0.0;
        val[3] = 0.0;
        val[4] = 1.0;
        val[5] = 0.0;
        val[6] = translation.x;
        val[7] = translation.y;
        val[8] = 1.0;
        return this;
    }

    public Matrix3D setToScaling(double scaleX, double scaleY) {
        double[] val = this.val;
        val[0] = scaleX;
        val[1] = 0.0;
        val[2] = 0.0;
        val[3] = 0.0;
        val[4] = scaleY;
        val[5] = 0.0;
        val[6] = 0.0;
        val[7] = 0.0;
        val[8] = 1.0;
        return this;
    }

    public Matrix3D setToScaling(Vector2 scale) {
        double[] val = this.val;
        val[0] = scale.x;
        val[1] = 0.0;
        val[2] = 0.0;
        val[3] = 0.0;
        val[4] = scale.y;
        val[5] = 0.0;
        val[6] = 0.0;
        val[7] = 0.0;
        val[8] = 1.0;
        return this;
    }

    public String toString() {
        double[] val = this.val;
        return "[" + val[0] + "|" + val[3] + "|" + val[6] + "]\n[" + val[1] + "|" + val[4] + "|" + val[7] + "]\n[" + val[2] + "|" + val[5] + "|" + val[8] + "]";
    }

    public double det() {
        double[] val = this.val;
        return val[0] * val[4] * val[8] + val[3] * val[7] * val[2] + val[6] * val[1] * val[5] - val[0] * val[7] * val[5] - val[3] * val[1] * val[8] - val[6] * val[4] * val[2];
    }

    public Matrix3D inv() {
        double det = this.det();
        if (det == 0.0) {
            throw new GdxRuntimeException("Can't invert a singular matrix");
        }
        double inv_det = 1.0 / det;
        double[] val = this.val;
        double v00 = val[4] * val[8] - val[5] * val[7];
        double v10 = val[2] * val[7] - val[1] * val[8];
        double v20 = val[1] * val[5] - val[2] * val[4];
        double v01 = val[5] * val[6] - val[3] * val[8];
        double v11 = val[0] * val[8] - val[2] * val[6];
        double v21 = val[2] * val[3] - val[0] * val[5];
        double v02 = val[3] * val[7] - val[4] * val[6];
        double v12 = val[1] * val[6] - val[0] * val[7];
        double v22 = val[0] * val[4] - val[1] * val[3];
        val[0] = inv_det * v00;
        val[1] = inv_det * v10;
        val[2] = inv_det * v20;
        val[3] = inv_det * v01;
        val[4] = inv_det * v11;
        val[5] = inv_det * v21;
        val[6] = inv_det * v02;
        val[7] = inv_det * v12;
        val[8] = inv_det * v22;
        return this;
    }

    public Matrix3D set(Matrix3D mat) {
        System.arraycopy(mat.val, 0, this.val, 0, this.val.length);
        return this;
    }

    public Matrix3D set(Affine2 affine) {
        double[] val = this.val;
        val[0] = affine.m00;
        val[1] = affine.m10;
        val[2] = 0.0;
        val[3] = affine.m01;
        val[4] = affine.m11;
        val[5] = 0.0;
        val[6] = affine.m02;
        val[7] = affine.m12;
        val[8] = 1.0;
        return this;
    }

    public Matrix3D set(Matrix4 mat) {
        double[] val = this.val;
        val[0] = mat.val[0];
        val[1] = mat.val[1];
        val[2] = mat.val[2];
        val[3] = mat.val[4];
        val[4] = mat.val[5];
        val[5] = mat.val[6];
        val[6] = mat.val[8];
        val[7] = mat.val[9];
        val[8] = mat.val[10];
        return this;
    }

    public Matrix3D set(double[] values) {
        System.arraycopy(values, 0, this.val, 0, this.val.length);
        return this;
    }

    public Matrix3D trn(Vector2 vector) {
        this.val[6] = this.val[6] + (double)vector.x;
        this.val[7] = this.val[7] + (double)vector.y;
        return this;
    }

    public Matrix3D trn(double x, double y) {
        this.val[6] = this.val[6] + x;
        this.val[7] = this.val[7] + y;
        return this;
    }

    public Matrix3D trn(Vector3 vector) {
        this.val[6] = this.val[6] + (double)vector.x;
        this.val[7] = this.val[7] + (double)vector.y;
        return this;
    }

    public Matrix3D translate(double x, double y) {
        double[] tmp = this.tmp;
        tmp[0] = 1.0;
        tmp[1] = 0.0;
        tmp[3] = 0.0;
        tmp[4] = 1.0;
        tmp[6] = x;
        tmp[7] = y;
        Matrix3D.mul(this.val, tmp);
        return this;
    }

    public Matrix3D translate(Vector2 translation) {
        double[] tmp = this.tmp;
        tmp[0] = 1.0;
        tmp[1] = 0.0;
        tmp[3] = 0.0;
        tmp[4] = 1.0;
        tmp[6] = translation.x;
        tmp[7] = translation.y;
        Matrix3D.mul(this.val, tmp);
        return this;
    }

    public Matrix3D rotate(double degrees) {
        return this.rotateRad(0.01745329238474369 * degrees);
    }

    public Matrix3D rotateRad(double radians) {
        if (radians == 0.0) {
            return this;
        }
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double[] tmp = this.tmp;
        tmp[0] = cos;
        tmp[1] = sin;
        tmp[3] = -sin;
        tmp[4] = cos;
        tmp[6] = 0.0;
        tmp[7] = 0.0;
        Matrix3D.mul(this.val, tmp);
        return this;
    }

    public Matrix3D scale(double scaleX, double scaleY) {
        double[] tmp = this.tmp;
        tmp[0] = scaleX;
        tmp[1] = 0.0;
        tmp[3] = 0.0;
        tmp[4] = scaleY;
        tmp[6] = 0.0;
        tmp[7] = 0.0;
        Matrix3D.mul(this.val, tmp);
        return this;
    }

    public Matrix3D scale(Vector2 scale) {
        double[] tmp = this.tmp;
        tmp[0] = scale.x;
        tmp[1] = 0.0;
        tmp[3] = 0.0;
        tmp[4] = scale.y;
        tmp[6] = 0.0;
        tmp[7] = 0.0;
        Matrix3D.mul(this.val, tmp);
        return this;
    }

    public double[] getValues() {
        return this.val;
    }

    public Vector2D getTranslation(Vector2D position) {
        position.x = this.val[6];
        position.y = this.val[7];
        return position;
    }

    public Vector2D getScale(Vector2D scale) {
        double[] val = this.val;
        scale.x = Math.sqrt(val[0] * val[0] + val[3] * val[3]);
        scale.y = Math.sqrt(val[1] * val[1] + val[4] * val[4]);
        return scale;
    }

    public double getRotation() {
        return 57.2957763671875 * Math.atan2(this.val[1], this.val[0]);
    }

    public double getRotationRad() {
        return Math.atan2(this.val[1], this.val[0]);
    }

    public Matrix3D scl(double scale) {
        this.val[0] = this.val[0] * scale;
        this.val[4] = this.val[4] * scale;
        return this;
    }

    public Matrix3D scl(Vector2 scale) {
        this.val[0] = this.val[0] * (double)scale.x;
        this.val[4] = this.val[4] * (double)scale.y;
        return this;
    }

    public Matrix3D scl(Vector3 scale) {
        this.val[0] = this.val[0] * (double)scale.x;
        this.val[4] = this.val[4] * (double)scale.y;
        return this;
    }

    public Matrix3D transpose() {
        double[] val = this.val;
        double v01 = val[1];
        double v02 = val[2];
        double v10 = val[3];
        double v12 = val[5];
        double v20 = val[6];
        double v21 = val[7];
        val[3] = v01;
        val[6] = v02;
        val[1] = v10;
        val[7] = v12;
        val[2] = v20;
        val[5] = v21;
        return this;
    }

    private static void mul(double[] mata, double[] matb) {
        double v00 = mata[0] * matb[0] + mata[3] * matb[1] + mata[6] * matb[2];
        double v01 = mata[0] * matb[3] + mata[3] * matb[4] + mata[6] * matb[5];
        double v02 = mata[0] * matb[6] + mata[3] * matb[7] + mata[6] * matb[8];
        double v10 = mata[1] * matb[0] + mata[4] * matb[1] + mata[7] * matb[2];
        double v11 = mata[1] * matb[3] + mata[4] * matb[4] + mata[7] * matb[5];
        double v12 = mata[1] * matb[6] + mata[4] * matb[7] + mata[7] * matb[8];
        double v20 = mata[2] * matb[0] + mata[5] * matb[1] + mata[8] * matb[2];
        double v21 = mata[2] * matb[3] + mata[5] * matb[4] + mata[8] * matb[5];
        double v22 = mata[2] * matb[6] + mata[5] * matb[7] + mata[8] * matb[8];
        mata[0] = v00;
        mata[1] = v10;
        mata[2] = v20;
        mata[3] = v01;
        mata[4] = v11;
        mata[5] = v21;
        mata[6] = v02;
        mata[7] = v12;
        mata[8] = v22;
    }
}

