/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.io.Serializable;
import net.jafama.FastMath;

public class Matrix4D
implements Serializable {
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    public static final double[] stmp = new double[16];
    static final Vector3D l_vez = new Vector3D();
    static final Vector3D l_vex = new Vector3D();
    static final Vector3D l_vey = new Vector3D();
    static final Vector3Q l_vezb = new Vector3Q();
    static final Vector3Q l_vexb = new Vector3Q();
    static final Vector3Q l_veyb = new Vector3Q();
    static final Vector3D tmpVec = new Vector3D();
    static final Vector3Q tmpVecb = new Vector3Q();
    static final Matrix4D tmpMat = new Matrix4D();
    static final Vector3D right = new Vector3D();
    static final Vector3D tmpForward = new Vector3D();
    static final Vector3D tmpUp = new Vector3D();
    private static final long serialVersionUID = -2717655254359579617L;
    static QuaternionDouble quat = new QuaternionDouble();
    public final double[] tmp = new double[16];
    public final double[] val = new double[16];

    public Matrix4D() {
        this.val[0] = 1.0;
        this.val[5] = 1.0;
        this.val[10] = 1.0;
        this.val[15] = 1.0;
    }

    public Matrix4D(Matrix4D matrix) {
        this.set(matrix);
    }

    public Matrix4D(double[] values) {
        this.set(values);
    }

    public Matrix4D(float[] values) {
        this.set(values);
    }

    public Matrix4D(QuaternionDouble quaternion) {
        this.set(quaternion);
    }

    public Matrix4D(Vector3D position, QuaternionDouble rotation, Vector3D scale) {
        this.set(position, rotation, scale);
    }

    public static boolean inv(double[] values) {
        return Matrix4D.matrix4_inv(values);
    }

    public static void prj(double[] mat, double[] vec) {
        Matrix4D.matrix4_proj(mat, vec, 0);
    }

    public static void prj(double[] mat, double[] vecs, int offset, int numVecs, int stride) {
        for (int i = 0; i < numVecs; ++i) {
            Matrix4D.matrix4_proj(mat, vecs, offset);
            offset += stride;
        }
    }

    static void matrix4_mul(double[] mata, double[] matb) {
        Matrix4D.stmp[0] = mata[0] * matb[0] + mata[4] * matb[1] + mata[8] * matb[2] + mata[12] * matb[3];
        Matrix4D.stmp[4] = mata[0] * matb[4] + mata[4] * matb[5] + mata[8] * matb[6] + mata[12] * matb[7];
        Matrix4D.stmp[8] = mata[0] * matb[8] + mata[4] * matb[9] + mata[8] * matb[10] + mata[12] * matb[11];
        Matrix4D.stmp[12] = mata[0] * matb[12] + mata[4] * matb[13] + mata[8] * matb[14] + mata[12] * matb[15];
        Matrix4D.stmp[1] = mata[1] * matb[0] + mata[5] * matb[1] + mata[9] * matb[2] + mata[13] * matb[3];
        Matrix4D.stmp[5] = mata[1] * matb[4] + mata[5] * matb[5] + mata[9] * matb[6] + mata[13] * matb[7];
        Matrix4D.stmp[9] = mata[1] * matb[8] + mata[5] * matb[9] + mata[9] * matb[10] + mata[13] * matb[11];
        Matrix4D.stmp[13] = mata[1] * matb[12] + mata[5] * matb[13] + mata[9] * matb[14] + mata[13] * matb[15];
        Matrix4D.stmp[2] = mata[2] * matb[0] + mata[6] * matb[1] + mata[10] * matb[2] + mata[14] * matb[3];
        Matrix4D.stmp[6] = mata[2] * matb[4] + mata[6] * matb[5] + mata[10] * matb[6] + mata[14] * matb[7];
        Matrix4D.stmp[10] = mata[2] * matb[8] + mata[6] * matb[9] + mata[10] * matb[10] + mata[14] * matb[11];
        Matrix4D.stmp[14] = mata[2] * matb[12] + mata[6] * matb[13] + mata[10] * matb[14] + mata[14] * matb[15];
        Matrix4D.stmp[3] = mata[3] * matb[0] + mata[7] * matb[1] + mata[11] * matb[2] + mata[15] * matb[3];
        Matrix4D.stmp[7] = mata[3] * matb[4] + mata[7] * matb[5] + mata[11] * matb[6] + mata[15] * matb[7];
        Matrix4D.stmp[11] = mata[3] * matb[8] + mata[7] * matb[9] + mata[11] * matb[10] + mata[15] * matb[11];
        Matrix4D.stmp[15] = mata[3] * matb[12] + mata[7] * matb[13] + mata[11] * matb[14] + mata[15] * matb[15];
        System.arraycopy(stmp, 0, mata, 0, 16);
    }

    static double matrix4_det(double[] val) {
        return val[3] * val[6] * val[9] * val[12] - val[2] * val[7] * val[9] * val[12] - val[3] * val[5] * val[10] * val[12] + val[1] * val[7] * val[10] * val[12] + val[2] * val[5] * val[11] * val[12] - val[1] * val[6] * val[11] * val[12] - val[3] * val[6] * val[8] * val[13] + val[2] * val[7] * val[8] * val[13] + val[3] * val[4] * val[10] * val[13] - val[0] * val[7] * val[10] * val[13] - val[2] * val[4] * val[11] * val[13] + val[0] * val[6] * val[11] * val[13] + val[3] * val[5] * val[8] * val[14] - val[1] * val[7] * val[8] * val[14] - val[3] * val[4] * val[9] * val[14] + val[0] * val[7] * val[9] * val[14] + val[1] * val[4] * val[11] * val[14] - val[0] * val[5] * val[11] * val[14] - val[2] * val[5] * val[8] * val[15] + val[1] * val[6] * val[8] * val[15] + val[2] * val[4] * val[9] * val[15] - val[0] * val[6] * val[9] * val[15] - val[1] * val[4] * val[10] * val[15] + val[0] * val[5] * val[10] * val[15];
    }

    static boolean matrix4_inv(double[] val) {
        double[] tmp = new double[16];
        double l_det = Matrix4D.matrix4_det(val);
        if (l_det == 0.0) {
            return false;
        }
        Matrix4D.stmp[0] = val[9] * val[14] * val[7] - val[13] * val[10] * val[7] + val[13] * val[6] * val[11] - val[5] * val[14] * val[11] - val[9] * val[6] * val[15] + val[5] * val[10] * val[15];
        Matrix4D.stmp[4] = val[12] * val[10] * val[7] - val[8] * val[14] * val[7] - val[12] * val[6] * val[11] + val[4] * val[14] * val[11] + val[8] * val[6] * val[15] - val[4] * val[10] * val[15];
        Matrix4D.stmp[8] = val[8] * val[13] * val[7] - val[12] * val[9] * val[7] + val[12] * val[5] * val[11] - val[4] * val[13] * val[11] - val[8] * val[5] * val[15] + val[4] * val[9] * val[15];
        Matrix4D.stmp[12] = val[12] * val[9] * val[6] - val[8] * val[13] * val[6] - val[12] * val[5] * val[10] + val[4] * val[13] * val[10] + val[8] * val[5] * val[14] - val[4] * val[9] * val[14];
        Matrix4D.stmp[1] = val[13] * val[10] * val[3] - val[9] * val[14] * val[3] - val[13] * val[2] * val[11] + val[1] * val[14] * val[11] + val[9] * val[2] * val[15] - val[1] * val[10] * val[15];
        Matrix4D.stmp[5] = val[8] * val[14] * val[3] - val[12] * val[10] * val[3] + val[12] * val[2] * val[11] - val[0] * val[14] * val[11] - val[8] * val[2] * val[15] + val[0] * val[10] * val[15];
        Matrix4D.stmp[9] = val[12] * val[9] * val[3] - val[8] * val[13] * val[3] - val[12] * val[1] * val[11] + val[0] * val[13] * val[11] + val[8] * val[1] * val[15] - val[0] * val[9] * val[15];
        Matrix4D.stmp[13] = val[8] * val[13] * val[2] - val[12] * val[9] * val[2] + val[12] * val[1] * val[10] - val[0] * val[13] * val[10] - val[8] * val[1] * val[14] + val[0] * val[9] * val[14];
        Matrix4D.stmp[2] = val[5] * val[14] * val[3] - val[13] * val[6] * val[3] + val[13] * val[2] * val[7] - val[1] * val[14] * val[7] - val[5] * val[2] * val[15] + val[1] * val[6] * val[15];
        Matrix4D.stmp[6] = val[12] * val[6] * val[3] - val[4] * val[14] * val[3] - val[12] * val[2] * val[7] + val[0] * val[14] * val[7] + val[4] * val[2] * val[15] - val[0] * val[6] * val[15];
        Matrix4D.stmp[10] = val[4] * val[13] * val[3] - val[12] * val[5] * val[3] + val[12] * val[1] * val[7] - val[0] * val[13] * val[7] - val[4] * val[1] * val[15] + val[0] * val[5] * val[15];
        Matrix4D.stmp[14] = val[12] * val[5] * val[2] - val[4] * val[13] * val[2] - val[12] * val[1] * val[6] + val[0] * val[13] * val[6] + val[4] * val[1] * val[14] - val[0] * val[5] * val[14];
        Matrix4D.stmp[3] = val[9] * val[6] * val[3] - val[5] * val[10] * val[3] - val[9] * val[2] * val[7] + val[1] * val[10] * val[7] + val[5] * val[2] * val[11] - val[1] * val[6] * val[11];
        Matrix4D.stmp[7] = val[4] * val[10] * val[3] - val[8] * val[6] * val[3] + val[8] * val[2] * val[7] - val[0] * val[10] * val[7] - val[4] * val[2] * val[11] + val[0] * val[6] * val[11];
        Matrix4D.stmp[11] = val[8] * val[5] * val[3] - val[4] * val[9] * val[3] - val[8] * val[1] * val[7] + val[0] * val[9] * val[7] + val[4] * val[1] * val[11] - val[0] * val[5] * val[11];
        Matrix4D.stmp[15] = val[4] * val[9] * val[2] - val[8] * val[5] * val[2] + val[8] * val[1] * val[6] - val[0] * val[9] * val[6] - val[4] * val[1] * val[10] + val[0] * val[5] * val[10];
        double inv_det = 1.0 / l_det;
        val[0] = stmp[0] * inv_det;
        val[4] = stmp[4] * inv_det;
        val[8] = stmp[8] * inv_det;
        val[12] = stmp[12] * inv_det;
        val[1] = stmp[1] * inv_det;
        val[5] = stmp[5] * inv_det;
        val[9] = stmp[9] * inv_det;
        val[13] = stmp[13] * inv_det;
        val[2] = stmp[2] * inv_det;
        val[6] = stmp[6] * inv_det;
        val[10] = stmp[10] * inv_det;
        val[14] = stmp[14] * inv_det;
        val[3] = stmp[3] * inv_det;
        val[7] = stmp[7] * inv_det;
        val[11] = stmp[11] * inv_det;
        val[15] = stmp[15] * inv_det;
        return true;
    }

    static void matrix4_mulVec(double[] mat, double[] vec, int offset) {
        double x = vec[offset] * mat[0] + vec[offset + 1] * mat[4] + vec[offset + 2] * mat[8] + mat[12];
        double y = vec[offset] * mat[1] + vec[offset + 1] * mat[5] + vec[offset + 2] * mat[9] + mat[13];
        double z = vec[offset] * mat[2] + vec[offset + 1] * mat[6] + vec[offset + 2] * mat[10] + mat[14];
        vec[offset] = x;
        vec[offset + 1] = y;
        vec[offset + 2] = z;
    }

    static void matrix4_proj(double[] mat, double[] vec, int offset) {
        double inv_w = 1.0 / (vec[offset] * mat[3] + vec[offset + 1] * mat[7] + vec[offset + 2] * mat[11] + mat[15]);
        double x = (vec[offset] * mat[0] + vec[offset + 1] * mat[4] + vec[offset + 2] * mat[8] + mat[12]) * inv_w;
        double y = (vec[offset] * mat[1] + vec[offset + 1] * mat[5] + vec[offset + 2] * mat[9] + mat[13]) * inv_w;
        double z = (vec[offset] * mat[2] + vec[offset + 1] * mat[6] + vec[offset + 2] * mat[10] + mat[14]) * inv_w;
        vec[offset] = x;
        vec[offset + 1] = y;
        vec[offset + 2] = z;
    }

    static void matrix4_rot(double[] mat, double[] vec, int offset) {
        double x = vec[offset] * mat[0] + vec[offset + 1] * mat[4] + vec[offset + 2] * mat[8];
        double y = vec[offset] * mat[1] + vec[offset + 1] * mat[5] + vec[offset + 2] * mat[9];
        double z = vec[offset] * mat[2] + vec[offset + 1] * mat[6] + vec[offset + 2] * mat[10];
        vec[offset] = x;
        vec[offset + 1] = y;
        vec[offset + 2] = z;
    }

    public static void mul(double[] mata, double[] matb) {
        Matrix4D.matrix4_mul(mata, matb);
    }

    public static Matrix4D changeOfBasis(Vector3D x, Vector3D y, Vector3D z) {
        double[] vals = new double[]{x.x, y.x, z.x, 0.0, x.y, y.y, z.y, 0.0, x.z, y.z, z.z, 0.0, 0.0, 0.0, 0.0, 1.0};
        Matrix4D c = new Matrix4D(vals);
        return c.tra();
    }

    public static Matrix4D changeOfBasis(double[] x, double[] y, double[] z) {
        double[] vals = new double[]{x[0], y[0], z[0], 0.0, x[1], y[1], z[1], 0.0, x[2], y[2], z[2], 0.0, 0.0, 0.0, 0.0, 1.0};
        Matrix4D c = new Matrix4D(vals);
        return c.tra();
    }

    public Matrix4D set(Matrix4D matrix) {
        return this.set(matrix.val);
    }

    public Matrix4D set(Matrix4 matrix) {
        return this.set(matrix.val);
    }

    public Matrix4D set(double[] values) {
        System.arraycopy(values, 0, this.val, 0, this.val.length);
        return this;
    }

    public Matrix4D set(float[] values) {
        for (int i = 0; i < this.val.length; ++i) {
            this.val[i] = values[i];
        }
        return this;
    }

    public Matrix4D set(QuaternionDouble quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Matrix4D set(double quaternionX, double quaternionY, double quaternionZ, double quaternionW) {
        return this.set(0.0, 0.0, 0.0, quaternionX, quaternionY, quaternionZ, quaternionW);
    }

    public Matrix4D set(Vector3D position, QuaternionDouble orientation) {
        return this.set(position.x, position.y, position.z, orientation.x, orientation.y, orientation.z, orientation.w);
    }

    public Matrix4D set(double translationX, double translationY, double translationZ, double quaternionX, double quaternionY, double quaternionZ, double quaternionW) {
        double xs = quaternionX * 2.0;
        double ys = quaternionY * 2.0;
        double zs = quaternionZ * 2.0;
        double wx = quaternionW * xs;
        double wy = quaternionW * ys;
        double wz = quaternionW * zs;
        double xx = quaternionX * xs;
        double xy = quaternionX * ys;
        double xz = quaternionX * zs;
        double yy = quaternionY * ys;
        double yz = quaternionY * zs;
        double zz = quaternionZ * zs;
        this.val[0] = 1.0 - (yy + zz);
        this.val[4] = xy - wz;
        this.val[8] = xz + wy;
        this.val[12] = translationX;
        this.val[1] = xy + wz;
        this.val[5] = 1.0 - (xx + zz);
        this.val[9] = yz - wx;
        this.val[13] = translationY;
        this.val[2] = xz - wy;
        this.val[6] = yz + wx;
        this.val[10] = 1.0 - (xx + yy);
        this.val[14] = translationZ;
        this.val[3] = 0.0;
        this.val[7] = 0.0;
        this.val[11] = 0.0;
        this.val[15] = 1.0;
        return this;
    }

    public Matrix4D set(Vector3D position, QuaternionDouble orientation, Vector3D scale) {
        return this.set(position.x, position.y, position.z, orientation.x, orientation.y, orientation.z, orientation.w, scale.x, scale.y, scale.z);
    }

    public Matrix4D set(double translationX, double translationY, double translationZ, double quaternionX, double quaternionY, double quaternionZ, double quaternionW, double scaleX, double scaleY, double scaleZ) {
        double xs = quaternionX * 2.0;
        double ys = quaternionY * 2.0;
        double zs = quaternionZ * 2.0;
        double wx = quaternionW * xs;
        double wy = quaternionW * ys;
        double wz = quaternionW * zs;
        double xx = quaternionX * xs;
        double xy = quaternionX * ys;
        double xz = quaternionX * zs;
        double yy = quaternionY * ys;
        double yz = quaternionY * zs;
        double zz = quaternionZ * zs;
        this.val[0] = scaleX * (1.0 - (yy + zz));
        this.val[4] = scaleY * (xy - wz);
        this.val[8] = scaleZ * (xz + wy);
        this.val[12] = translationX;
        this.val[1] = scaleX * (xy + wz);
        this.val[5] = scaleY * (1.0 - (xx + zz));
        this.val[9] = scaleZ * (yz - wx);
        this.val[13] = translationY;
        this.val[2] = scaleX * (xz - wy);
        this.val[6] = scaleY * (yz + wx);
        this.val[10] = scaleZ * (1.0 - (xx + yy));
        this.val[14] = translationZ;
        this.val[3] = 0.0;
        this.val[7] = 0.0;
        this.val[11] = 0.0;
        this.val[15] = 1.0;
        return this;
    }

    public Matrix4D set(Vector3D xAxis, Vector3D yAxis, Vector3D zAxis, Vector3D pos) {
        this.val[0] = xAxis.x;
        this.val[4] = xAxis.y;
        this.val[8] = xAxis.z;
        this.val[1] = yAxis.x;
        this.val[5] = yAxis.y;
        this.val[9] = yAxis.z;
        this.val[2] = -zAxis.x;
        this.val[6] = -zAxis.y;
        this.val[10] = -zAxis.z;
        this.val[12] = pos.x;
        this.val[13] = pos.y;
        this.val[14] = pos.z;
        this.val[3] = 0.0;
        this.val[7] = 0.0;
        this.val[11] = 0.0;
        this.val[15] = 1.0;
        return this;
    }

    public Matrix4D cpy() {
        return new Matrix4D(this);
    }

    public Matrix4D trn(Vector3D vector) {
        this.val[12] = this.val[12] + vector.x;
        this.val[13] = this.val[13] + vector.y;
        this.val[14] = this.val[14] + vector.z;
        return this;
    }

    public Matrix4D trn(double x, double y, double z) {
        this.val[12] = this.val[12] + x;
        this.val[13] = this.val[13] + y;
        this.val[14] = this.val[14] + z;
        return this;
    }

    public double[] getValues() {
        return this.val;
    }

    public float[] getValuesFloat() {
        float[] res = new float[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            res[i] = (float)this.val[i];
        }
        return res;
    }

    public Matrix4D mul(Matrix4D matrix) {
        Matrix4D.matrix4_mul(this.val, matrix.val);
        return this;
    }

    public Matrix4D mulLeft(Matrix4D matrix) {
        tmpMat.set(matrix);
        tmpMat.mul(this);
        return this.set(tmpMat);
    }

    public Matrix4D tra() {
        this.tmp[0] = this.val[0];
        this.tmp[4] = this.val[1];
        this.tmp[8] = this.val[2];
        this.tmp[12] = this.val[3];
        this.tmp[1] = this.val[4];
        this.tmp[5] = this.val[5];
        this.tmp[9] = this.val[6];
        this.tmp[13] = this.val[7];
        this.tmp[2] = this.val[8];
        this.tmp[6] = this.val[9];
        this.tmp[10] = this.val[10];
        this.tmp[14] = this.val[11];
        this.tmp[3] = this.val[12];
        this.tmp[7] = this.val[13];
        this.tmp[11] = this.val[14];
        this.tmp[15] = this.val[15];
        return this.set(this.tmp);
    }

    public Matrix4D idt() {
        this.val[0] = 1.0;
        this.val[4] = 0.0;
        this.val[8] = 0.0;
        this.val[12] = 0.0;
        this.val[1] = 0.0;
        this.val[5] = 1.0;
        this.val[9] = 0.0;
        this.val[13] = 0.0;
        this.val[2] = 0.0;
        this.val[6] = 0.0;
        this.val[10] = 1.0;
        this.val[14] = 0.0;
        this.val[3] = 0.0;
        this.val[7] = 0.0;
        this.val[11] = 0.0;
        this.val[15] = 1.0;
        return this;
    }

    public Matrix4D inv() {
        Matrix4D.matrix4_inv(this.val);
        return this;
    }

    public double det() {
        return this.val[3] * this.val[6] * this.val[9] * this.val[12] - this.val[2] * this.val[7] * this.val[9] * this.val[12] - this.val[3] * this.val[5] * this.val[10] * this.val[12] + this.val[1] * this.val[7] * this.val[10] * this.val[12] + this.val[2] * this.val[5] * this.val[11] * this.val[12] - this.val[1] * this.val[6] * this.val[11] * this.val[12] - this.val[3] * this.val[6] * this.val[8] * this.val[13] + this.val[2] * this.val[7] * this.val[8] * this.val[13] + this.val[3] * this.val[4] * this.val[10] * this.val[13] - this.val[0] * this.val[7] * this.val[10] * this.val[13] - this.val[2] * this.val[4] * this.val[11] * this.val[13] + this.val[0] * this.val[6] * this.val[11] * this.val[13] + this.val[3] * this.val[5] * this.val[8] * this.val[14] - this.val[1] * this.val[7] * this.val[8] * this.val[14] - this.val[3] * this.val[4] * this.val[9] * this.val[14] + this.val[0] * this.val[7] * this.val[9] * this.val[14] + this.val[1] * this.val[4] * this.val[11] * this.val[14] - this.val[0] * this.val[5] * this.val[11] * this.val[14] - this.val[2] * this.val[5] * this.val[8] * this.val[15] + this.val[1] * this.val[6] * this.val[8] * this.val[15] + this.val[2] * this.val[4] * this.val[9] * this.val[15] - this.val[0] * this.val[6] * this.val[9] * this.val[15] - this.val[1] * this.val[4] * this.val[10] * this.val[15] + this.val[0] * this.val[5] * this.val[10] * this.val[15];
    }

    public double det3x3() {
        return this.val[0] * this.val[5] * this.val[10] + this.val[4] * this.val[9] * this.val[2] + this.val[8] * this.val[1] * this.val[6] - this.val[0] * this.val[9] * this.val[6] - this.val[4] * this.val[1] * this.val[10] - this.val[8] * this.val[5] * this.val[2];
    }

    public Matrix4D setToProjection(double near, double far, double fov, double aspectRatio) {
        this.idt();
        double l_fd = 1.0 / FastMath.tan((double)(fov * (Math.PI / 180) / 2.0));
        double l_a1 = (far + near) / (near - far);
        double l_a2 = 2.0 * far * near / (near - far);
        this.val[0] = l_fd / aspectRatio;
        this.val[1] = 0.0;
        this.val[2] = 0.0;
        this.val[3] = 0.0;
        this.val[4] = 0.0;
        this.val[5] = l_fd;
        this.val[6] = 0.0;
        this.val[7] = 0.0;
        this.val[8] = 0.0;
        this.val[9] = 0.0;
        this.val[10] = l_a1;
        this.val[11] = -1.0;
        this.val[12] = 0.0;
        this.val[13] = 0.0;
        this.val[14] = l_a2;
        this.val[15] = 0.0;
        return this;
    }

    public Matrix4D setToOrtho2D(double x, double y, double width, double height) {
        this.setToOrtho(x, x + width, y, y + height, 0.0, 1.0);
        return this;
    }

    public Matrix4D setToOrtho2D(double x, double y, double width, double height, double near, double far) {
        this.setToOrtho(x, x + width, y, y + height, near, far);
        return this;
    }

    public Matrix4D setToOrtho(double left, double right, double bottom, double top, double near, double far) {
        this.idt();
        double x_orth = 2.0 / (right - left);
        double y_orth = 2.0 / (top - bottom);
        double z_orth = -2.0 / (far - near);
        double tx = -(right + left) / (right - left);
        double ty = -(top + bottom) / (top - bottom);
        double tz = -(far + near) / (far - near);
        this.val[0] = x_orth;
        this.val[1] = 0.0;
        this.val[2] = 0.0;
        this.val[3] = 0.0;
        this.val[4] = 0.0;
        this.val[5] = y_orth;
        this.val[6] = 0.0;
        this.val[7] = 0.0;
        this.val[8] = 0.0;
        this.val[9] = 0.0;
        this.val[10] = z_orth;
        this.val[11] = 0.0;
        this.val[12] = tx;
        this.val[13] = ty;
        this.val[14] = tz;
        this.val[15] = 1.0;
        return this;
    }

    public Matrix4D setTranslation(double x, double y, double z) {
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
        return this;
    }

    public Matrix4D setToTranslation(Vector3D vector) {
        this.idt();
        this.val[12] = vector.x;
        this.val[13] = vector.y;
        this.val[14] = vector.z;
        return this;
    }

    public Matrix4D setToTranslation(Vector3 vector) {
        this.idt();
        this.val[12] = vector.x;
        this.val[13] = vector.y;
        this.val[14] = vector.z;
        return this;
    }

    public Matrix4D setToTranslation(double x, double y, double z) {
        this.idt();
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
        return this;
    }

    public Matrix4D setToTranslationAndScaling(Vector3D translation, Vector3D scaling) {
        this.idt();
        this.val[12] = translation.x;
        this.val[13] = translation.y;
        this.val[14] = translation.z;
        this.val[0] = scaling.x;
        this.val[5] = scaling.y;
        this.val[10] = scaling.z;
        return this;
    }

    public Matrix4D setToTranslationAndScaling(double translationX, double translationY, double translationZ, double scalingX, double scalingY, double scalingZ) {
        this.idt();
        this.val[12] = translationX;
        this.val[13] = translationY;
        this.val[14] = translationZ;
        this.val[0] = scalingX;
        this.val[5] = scalingY;
        this.val[10] = scalingZ;
        return this;
    }

    public Matrix4D setToRotation(Vector3D axis, double degrees) {
        if (degrees == 0.0) {
            this.idt();
            return this;
        }
        return this.set(quat.set(axis, degrees));
    }

    public Matrix4D setToRotationRad(Vector3D axis, double radians) {
        if (radians == 0.0) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxisRad(axis, radians));
    }

    public Matrix4D setToRotation(double axisX, double axisY, double axisZ, double degrees) {
        if (degrees == 0.0) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxis(axisX, axisY, axisZ, degrees));
    }

    public Matrix4D setToRotationRad(double axisX, double axisY, double axisZ, double radians) {
        if (radians == 0.0) {
            this.idt();
            return this;
        }
        return this.set(quat.setFromAxisRad(axisX, axisY, axisZ, radians));
    }

    public Matrix4D setToRotation(Vector3D v1, Vector3D v2) {
        return this.set(quat.setFromCross(v1, v2));
    }

    public Matrix4D setToRotation(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.set(quat.setFromCross(x1, y1, z1, x2, y2, z2));
    }

    public Matrix4D setFromEulerAngles(double yaw, double pitch, double roll) {
        quat.setEulerAngles(yaw, pitch, roll);
        return this.set(quat);
    }

    public Matrix4D setToScaling(Vector3D vector) {
        this.idt();
        this.val[0] = vector.x;
        this.val[5] = vector.y;
        this.val[10] = vector.z;
        return this;
    }

    public Matrix4D setToScaling(double x, double y, double z) {
        this.idt();
        this.val[0] = x;
        this.val[5] = y;
        this.val[10] = z;
        return this;
    }

    public Matrix4D setToLookAt(Vector3D direction, Vector3D up) {
        l_vez.set(direction).nor();
        l_vex.set(direction).nor();
        l_vex.crs(up).nor();
        l_vey.set(l_vex).crs(l_vez).nor();
        this.idt();
        this.val[0] = Matrix4D.l_vex.x;
        this.val[4] = Matrix4D.l_vex.y;
        this.val[8] = Matrix4D.l_vex.z;
        this.val[1] = Matrix4D.l_vey.x;
        this.val[5] = Matrix4D.l_vey.y;
        this.val[9] = Matrix4D.l_vey.z;
        this.val[2] = -Matrix4D.l_vez.x;
        this.val[6] = -Matrix4D.l_vez.y;
        this.val[10] = -Matrix4D.l_vez.z;
        return this;
    }

    public Matrix4D setToLookAt(Vector3Q direction, Vector3Q up) {
        l_vezb.set(direction).nor();
        l_vexb.set(direction).nor();
        l_vexb.crs(up).nor();
        l_veyb.set(l_vexb).crs(l_vezb).nor();
        this.idt();
        this.val[0] = Matrix4D.l_vexb.x.doubleValue();
        this.val[4] = Matrix4D.l_vexb.y.doubleValue();
        this.val[8] = Matrix4D.l_vexb.z.doubleValue();
        this.val[1] = Matrix4D.l_veyb.x.doubleValue();
        this.val[5] = Matrix4D.l_veyb.y.doubleValue();
        this.val[9] = Matrix4D.l_veyb.z.doubleValue();
        this.val[2] = -Matrix4D.l_vezb.x.doubleValue();
        this.val[6] = -Matrix4D.l_vezb.y.doubleValue();
        this.val[10] = -Matrix4D.l_vezb.z.doubleValue();
        return this;
    }

    public Matrix4D setToLookAt(Vector3D position, Vector3D target, Vector3D up) {
        tmpVec.set(target).sub(position);
        this.setToLookAt(tmpVec, up);
        this.mul(tmpMat.setToTranslation(-position.x, -position.y, -position.z));
        return this;
    }

    public Matrix4D setToLookAt(Vector3Q position, Vector3Q target, Vector3Q up) {
        tmpVecb.set(target).sub(position);
        this.setToLookAt(tmpVecb, up);
        this.mul(tmpMat.setToTranslation(-position.x.doubleValue(), -position.y.doubleValue(), -position.z.doubleValue()));
        return this;
    }

    public Matrix4D setToWorld(Vector3D position, Vector3D forward, Vector3D up) {
        tmpForward.set(forward).nor();
        right.set(tmpForward).crs(up).nor();
        tmpUp.set(right).crs(tmpForward).nor();
        this.set(right, tmpUp, tmpForward, position);
        return this;
    }

    public String toString() {
        return "[" + this.val[0] + "|" + this.val[4] + "|" + this.val[8] + "|" + this.val[12] + "]\n[" + this.val[1] + "|" + this.val[5] + "|" + this.val[9] + "|" + this.val[13] + "]\n[" + this.val[2] + "|" + this.val[6] + "|" + this.val[10] + "|" + this.val[14] + "]\n[" + this.val[3] + "|" + this.val[7] + "|" + this.val[11] + "|" + this.val[15] + "]\n";
    }

    public Matrix4D lerp(Matrix4D matrix, double alpha) {
        for (int i = 0; i < 16; ++i) {
            this.val[i] = this.val[i] * (1.0 - alpha) + matrix.val[i] * alpha;
        }
        return this;
    }

    public Matrix4D set(Matrix3 mat) {
        this.val[0] = mat.val[0];
        this.val[1] = mat.val[1];
        this.val[2] = mat.val[2];
        this.val[3] = 0.0;
        this.val[4] = mat.val[3];
        this.val[5] = mat.val[4];
        this.val[6] = mat.val[5];
        this.val[7] = 0.0;
        this.val[8] = 0.0;
        this.val[9] = 0.0;
        this.val[10] = 1.0;
        this.val[11] = 0.0;
        this.val[12] = mat.val[6];
        this.val[13] = mat.val[7];
        this.val[14] = 0.0;
        this.val[15] = mat.val[8];
        return this;
    }

    public Matrix4D scl(Vector3D scale) {
        this.val[0] = this.val[0] * scale.x;
        this.val[5] = this.val[5] * scale.y;
        this.val[10] = this.val[10] * scale.z;
        return this;
    }

    public Matrix4D scl(double x, double y, double z) {
        this.val[0] = this.val[0] * x;
        this.val[5] = this.val[5] * y;
        this.val[10] = this.val[10] * z;
        return this;
    }

    public Matrix4D scl(double scale) {
        this.val[0] = this.val[0] * scale;
        this.val[5] = this.val[5] * scale;
        this.val[10] = this.val[10] * scale;
        return this;
    }

    public Vector3D getTranslation(Vector3D position) {
        position.x = this.val[12];
        position.y = this.val[13];
        position.z = this.val[14];
        return position;
    }

    public Vector3 getTranslationf(Vector3 position) {
        position.x = (float)this.val[12];
        position.y = (float)this.val[13];
        position.z = (float)this.val[14];
        return position;
    }

    public double[] getTranslation() {
        return new double[]{this.val[12], this.val[13], this.val[14]};
    }

    public Matrix4D setTranslation(Vector3D vector) {
        this.val[12] = vector.x;
        this.val[13] = vector.y;
        this.val[14] = vector.z;
        return this;
    }

    public float[] getTranslationf() {
        return new float[]{(float)this.val[12], (float)this.val[13], (float)this.val[14]};
    }

    public void getTranslationf(float[] vec) {
        vec[0] = (float)this.val[12];
        vec[1] = (float)this.val[13];
        vec[2] = (float)this.val[14];
    }

    public Vector3D addTranslationTo(Vector3D position) {
        position.x += this.val[12];
        position.y += this.val[13];
        position.z += this.val[14];
        return position;
    }

    public QuaternionDouble getRotation(QuaternionDouble rotation, boolean normalizeAxes) {
        return rotation.setFromMatrix(normalizeAxes, this);
    }

    public QuaternionDouble getRotation(QuaternionDouble rotation) {
        return rotation.setFromMatrix(this);
    }

    public double getScaleXSquared() {
        return this.val[0] * this.val[0] + this.val[4] * this.val[4] + this.val[8] * this.val[8];
    }

    public double getScaleYSquared() {
        return this.val[1] * this.val[1] + this.val[5] * this.val[5] + this.val[9] * this.val[9];
    }

    public double getScaleZSquared() {
        return this.val[2] * this.val[2] + this.val[6] * this.val[6] + this.val[10] * this.val[10];
    }

    public double getScaleX() {
        return MathUtilsDouble.isZero(this.val[4]) && MathUtilsDouble.isZero(this.val[8]) ? this.val[0] : FastMath.sqrt((double)this.getScaleXSquared());
    }

    public double getScaleY() {
        return MathUtilsDouble.isZero(this.val[1]) && MathUtilsDouble.isZero(this.val[9]) ? this.val[5] : FastMath.sqrt((double)this.getScaleYSquared());
    }

    public double getScaleZ() {
        return MathUtilsDouble.isZero(this.val[2]) && MathUtilsDouble.isZero(this.val[6]) ? this.val[10] : FastMath.sqrt((double)this.getScaleZSquared());
    }

    public Vector3D getScale(Vector3D scale) {
        return scale.set(this.getScaleX(), this.getScaleY(), this.getScaleZ());
    }

    public Matrix4D toNormalMatrix() {
        this.val[12] = 0.0;
        this.val[13] = 0.0;
        this.val[14] = 0.0;
        return this.inv().tra();
    }

    public Matrix4D translate(Vector3D translation) {
        return this.translate(translation.x, translation.y, translation.z);
    }

    public Matrix4D translate(double[] translation) {
        return this.translate(translation[0], translation[1], translation[2]);
    }

    public Matrix4D translate(double x, double y, double z) {
        this.tmp[0] = 1.0;
        this.tmp[4] = 0.0;
        this.tmp[8] = 0.0;
        this.tmp[12] = x;
        this.tmp[1] = 0.0;
        this.tmp[5] = 1.0;
        this.tmp[9] = 0.0;
        this.tmp[13] = y;
        this.tmp[2] = 0.0;
        this.tmp[6] = 0.0;
        this.tmp[10] = 1.0;
        this.tmp[14] = z;
        this.tmp[3] = 0.0;
        this.tmp[7] = 0.0;
        this.tmp[11] = 0.0;
        this.tmp[15] = 1.0;
        Matrix4D.matrix4_mul(this.val, this.tmp);
        return this;
    }

    public Matrix4D rotate(Vector3D axis, double degrees) {
        if (degrees == 0.0) {
            return this;
        }
        quat.set(axis, degrees);
        return this.rotate(quat);
    }

    public Matrix4D rotateRad(Vector3D axis, double radians) {
        if (radians == 0.0) {
            return this;
        }
        quat.setFromAxisRad(axis, radians);
        return this.rotate(quat);
    }

    public Matrix4D rotate(double axisX, double axisY, double axisZ, double degrees) {
        if (degrees == 0.0) {
            return this;
        }
        quat.setFromAxis(axisX, axisY, axisZ, degrees);
        return this.rotate(quat);
    }

    public Matrix4D rotateRad(double axisX, double axisY, double axisZ, double radians) {
        if (radians == 0.0) {
            return this;
        }
        quat.setFromAxisRad(axisX, axisY, axisZ, radians);
        return this.rotate(quat);
    }

    public Matrix4D rotate(QuaternionDouble rotation) {
        rotation.toMatrix(this.tmp);
        Matrix4D.matrix4_mul(this.val, this.tmp);
        return this;
    }

    public Matrix4D rotate(Vector3D v1, Vector3D v2) {
        return this.rotate(quat.setFromCross(v1, v2));
    }

    public Matrix4D scale(double scaleX, double scaleY, double scaleZ) {
        this.tmp[0] = scaleX;
        this.tmp[4] = 0.0;
        this.tmp[8] = 0.0;
        this.tmp[12] = 0.0;
        this.tmp[1] = 0.0;
        this.tmp[5] = scaleY;
        this.tmp[9] = 0.0;
        this.tmp[13] = 0.0;
        this.tmp[2] = 0.0;
        this.tmp[6] = 0.0;
        this.tmp[10] = scaleZ;
        this.tmp[14] = 0.0;
        this.tmp[3] = 0.0;
        this.tmp[7] = 0.0;
        this.tmp[11] = 0.0;
        this.tmp[15] = 1.0;
        Matrix4D.matrix4_mul(this.val, this.tmp);
        return this;
    }

    public void extract4x3Matrix(double[] dst) {
        dst[0] = this.val[0];
        dst[1] = this.val[1];
        dst[2] = this.val[2];
        dst[3] = this.val[4];
        dst[4] = this.val[5];
        dst[5] = this.val[6];
        dst[6] = this.val[8];
        dst[7] = this.val[9];
        dst[8] = this.val[10];
        dst[9] = this.val[12];
        dst[10] = this.val[13];
        dst[11] = this.val[14];
    }

    public Matrix4 putIn(Matrix4 aux) {
        float[] auxVal = aux.val;
        for (int i = 0; i < this.val.length; ++i) {
            auxVal[i] = (float)this.val[i];
        }
        return aux;
    }
}

