/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import gaiasky.util.math.Vector3D;
import java.io.Serializable;

public class PlaneDouble
implements Serializable {
    private static final long serialVersionUID = -1240652082930747866L;
    public final Vector3D normal = new Vector3D();
    public double d = 0.0;

    public PlaneDouble() {
    }

    public PlaneDouble(Vector3D normal, double d) {
        this.normal.set(normal).nor();
        this.d = d;
    }

    public PlaneDouble(Vector3D normal, Vector3D point) {
        this.normal.set(normal).nor();
        this.d = -this.normal.dot(point);
    }

    public PlaneDouble(Vector3D point1, Vector3D point2, Vector3D point3) {
        this.set(point1, point2, point3);
    }

    public void set(Vector3D point1, Vector3D point2, Vector3D point3) {
        this.normal.set(point1).sub(point2).crs(point2.x - point3.x, point2.y - point3.y, point2.z - point3.z).nor();
        this.d = -point1.dot(this.normal);
    }

    public void set(double nx, double ny, double nz, double d) {
        this.normal.set(nx, ny, nz);
        this.d = d;
    }

    public double distance(Vector3D point) {
        return this.normal.dot(point) + this.d;
    }

    public PlaneSide testPoint(Vector3D point) {
        double dist = this.normal.dot(point) + this.d;
        if (dist == 0.0) {
            return PlaneSide.OnPlane;
        }
        if (dist < 0.0) {
            return PlaneSide.Back;
        }
        return PlaneSide.Front;
    }

    public PlaneSide testPoint(double x, double y, double z) {
        double dist = this.normal.dot(x, y, z) + this.d;
        if (dist == 0.0) {
            return PlaneSide.OnPlane;
        }
        if (dist < 0.0) {
            return PlaneSide.Back;
        }
        return PlaneSide.Front;
    }

    public boolean isFrontFacing(Vector3D direction) {
        double dot = this.normal.dot(direction);
        return dot <= 0.0;
    }

    public Vector3D getNormal() {
        return this.normal;
    }

    public double getD() {
        return this.d;
    }

    public void set(Vector3D point, Vector3D normal) {
        this.normal.set(normal);
        this.d = -point.dot(normal);
    }

    public void set(double pointX, double pointY, double pointZ, double norX, double norY, double norZ) {
        this.normal.set(norX, norY, norZ);
        this.d = -(pointX * norX + pointY * norY + pointZ * norZ);
    }

    public void set(PlaneDouble plane) {
        this.normal.set(plane.normal);
        this.d = plane.d;
    }

    public String toString() {
        return String.valueOf(this.normal) + ", " + this.d;
    }

    public static enum PlaneSide {
        OnPlane,
        Back,
        Front;

    }
}

