/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import gaiasky.util.math.Quadruple;

public final class QuadrupleMath {
    public static final Quadruple PI = Quadruple.pi();

    private QuadrupleMath() {
    }

    public static Quadruple pi() {
        return Quadruple.pi();
    }

    public static Quadruple pi2() {
        return QuadrupleMath.pi().multiply(2.0);
    }

    public static Quadruple piOver2() {
        return QuadrupleMath.pi().divide(2.0);
    }

    public static Quadruple atan(Quadruple x) {
        double dv = x.doubleValue();
        double ad = Math.atan(dv);
        return Quadruple.from(Double.toString(ad));
    }

    public static Quadruple atan2(Quadruple y, Quadruple x) {
        double dy = y.doubleValue();
        double dx = x.doubleValue();
        double ad = Math.atan2(dy, dx);
        return Quadruple.from(Double.toString(ad));
    }
}

