/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.math;

import gaiasky.util.math.Quadruple;
import gaiasky.util.math.QuadrupleImmutable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuadrupleParser {
    private static final long[] BUFFER_4x32_A = new long[4];
    private static final long[] BUFFER_4x64_A = new long[4];
    private static final long[] BUFFER_4x64_B = new long[4];
    private static final long[] BUFFER_6x32_A = new long[6];
    private static final long[] BUFFER_6x32_B = new long[6];
    private static final long[] BUFFER_6x32_C = new long[6];
    private static final long[] BUFFER_10x32_A = new long[10];
    private static final long[] BUFFER_12x32 = new long[12];
    public static final int EXPONENT_OF_INFINITY = -1;
    public static final int EXPONENT_BIAS = Integer.MAX_VALUE;
    private static final int SIGNIFICANT_DIGITS = 40;
    private static final char[] ZEROS = "0000000000000000000000000000000000000000".toCharArray();
    private static final long LOWER_32_BITS = 0xFFFFFFFFL;
    private static final long HIGHER_32_BITS = -4294967296L;
    private static final long POW_2_31_L = 0x80000000L;
    private static final long[] MIN_NORMAL_QUASIDEC = new long[]{-646456992L, 4188602952521478410L, 9087954152512382021L, -7537029582339684997L};
    private static final long[][] POS_POWERS_OF_2 = new long[][]{{1L, 0x1999999999999999L, -7378697629483820647L, -7378697629483820646L}, {1L, 0x3333333333333333L, 0x3333333333333333L, 0x3333333333333334L}, {1L, 0x6666666666666666L, 0x6666666666666666L, 0x6666666666666667L}, {2L, 2951479051793528258L, -8116567392432202712L, -737869762948382064L}, {3L, 4722366482869645213L, -5607810198407703692L, -4869940435459321626L}, {5L, -6357485877563259869L, 1139270913992301907L, -3612610359395278588L}, {10L, 7922816251426433759L, 6537434485812897421L, -7503133875254028946L}, {20L, 3402823669209384634L, -6756192433053155999L, 434502812078806219L}, {39L, 6277101735386680763L, -3029150484284406771L, 4980338030897529499L}, {78L, 2135987035920910082L, 7286864317269821293L, 1470929914900401402L}, {155L, 2473304014731045340L, -7285998863072907808L, -1249119937827942864L}, {309L, 3316158518186977171L, 1610101194367568473L, 2505321366944869367L}, {617L, 5961435402259919231L, 8541288306462491492L, -5529160668814206377L}, {1234L, 1926557440885621868L, -8115982853534937961L, 4973663491106771606L}, {2467L, 2012075170664720308L, 5203521067837755057L, 4252902708988064798L}, {4933L, 2194667241128661798L, -8448831084921001245L, 2882452207710407228L}, {9865L, 2611064738599533141L, 4667649273809606933L, 5480838552042273826L}, {19729L, 3695860387023220540L, -6828522718492124016L, -2703632626649942104L}, {39457L, 7404766904006053691L, -6286299805622229989L, 5501995613499181412L}, {78914L, 2972371312984624324L, -8515209585904876538L, 3934513978629065883L}, {157827L, 4789458338529041696L, 8874761816389274466L, -1112034990949293556L}, {315653L, -6011535407699982084L, 53738705337609241L, 5451751215914427447L}, {631306L, 8382748410739091470L, 5595760811601129281L, 5808897528453025485L}, {0x134414L, 3809369861530133413L, 7258727891356815428L, -5747969065174052023L}, {2525223L, 7866590810795563528L, -6871261120780735632L, 1738499114246505760L}, {5050446L, 3354697757892663011L, 3122677384963859433L, 1903788099230575219L}, {10100891L, 6100804023648459231L, -2859688978956919665L, -5978941681206512582L}, {20201782L, 2017689928707321463L, -7045750258458453972L, -2789149055805603761L}, {40403563L, 2206932904874568912L, -8359968077355088794L, 7871099721466003992L}, {80807125L, 2640331988754402584L, -952243349123318951L, -6373590220505338551L}, {161614249L, 3779178039757925203L, 4593549380955514492L, 2162745452984644395L}, {323228497L, 7742388900241556266L, 8212051283157458959L, -8084637243747679988L}, {646456994L, 3249602512132054904L, 4645955491659115631L, 2401850457105738694L}};
    private static final long[][] NEG_POWERS_OF_2 = new long[][]{{1L, 0x1999999999999999L, -7378697629483820647L, -7378697629483820646L}, {0L, Long.MIN_VALUE, 0L, 0L}, {0L, 0x4000000000000000L, 0L, 1L}, {-1L, -6917529027641081856L, 0L, 0L}, {-2L, 0x6400000000000000L, 0L, 0L}, {-4L, 2814749767106560000L, 0L, 1L}, {-9L, 4294967296000000000L, 0L, 1L}, {-19L, -8446744073709551616L, 0L, 0L}, {-38L, 5421010862427522170L, 687399551400673280L, 1L}, {-77L, -2515824962385028846L, 5327493063679123134L, -6154033176549089278L}, {-154L, -4688533805412153853L, -6126209340986631942L, 6675599427733050225L}, {-308L, -8185402070463610993L, 6273243709394548296L, 6440670082096085128L}, {-616L, 5708060961156115120L, -9119784724436679254L, -4052321278278386442L}, {-1233L, -784028200337326125L, -2428617583397857188L, 5356816969625239316L}, {-2466L, -1534733435035406345L, 1614368466976504750L, 8601533998869527035L}, {-4932L, -2941780016108734772L, -1721516453171399403L, -4395877029324825139L}, {-9864L, -5414421975734615332L, -3129711901346405067L, 6308761762498734157L}, {-19728L, 9207121787276552771L, 2686637268731583271L, 6864278666688451401L}, {-39456L, 4595450084145690875L, 7667683976197477395L, 449294573396472465L}, {-78913L, -6998565798188067393L, 3110751028328854690L, 1120171678522345134L}, {-157826L, 7104819436125367673L, -3455495517457938314L, -1625794586193017604L}, {-315652L, 2736442757499254003L, 4679685605244421446L, -6715649259643878554L}, {-631305L, 4059317424879466168L, 1990423776449209129L, -4390560725205416457L}, {-1262611L, 8932773117080711014L, 7396631747502695834L, -6799072885061151787L}, {-2525222L, 4325665019387541401L, -3786588569225635136L, 5763493405214599753L}, {-5050445L, -8303285810730435686L, 7822744214343089676L, 1615945487545495999L}, {-10100890L, 5577664281657086504L, 2124849129118726579L, 8904011362647467789L}, {-20201781L, -1581795595776273107L, -5148536553832158111L, -8267332123526187041L}, {-40403562L, -3027953308963650998L, -6337049666019854160L, -6402029622670676866L}, {-80807124L, -5558881169716582511L, -3931439961203463912L, 320416584029509902L}, {-161614248L, 9004136966850474441L, 7308686012685280919L, 1358577080284203015L}, {-323228496L, 4395056503947017296L, -4699306296890259343L, -2196499394335464780L}, {-646456993L, -7975236692405855590L, 4273141307571403437L, -395829882139660876L}};
    private static final int MAX_EXP10 = 646456993;
    private static final int MIN_EXP10 = -646457032;
    private static final double LOG2_10 = Math.log(10.0) / Math.log(2.0);
    private static final double LOG2_E = 1.0 / Math.log(2.0);
    private static final Quadruple MIN_VALUE = new Quadruple().assignMinValue();
    private static final Quadruple MAX_VALUE = new Quadruple().assignMaxValue();
    private static final Quadruple MIN_NORMAL = new Quadruple().assignMinNormal();
    private static final Quadruple NaN = new Quadruple().assignNaN();
    private static final Quadruple NEGATIVE_INFINITY = new Quadruple().assignNegativeInfinity();
    private static final Quadruple POSITIVE_INFINITY = new Quadruple().assignPositiveInfinity();

    public static Quadruple parse(String source, Quadruple owner) {
        return NumberParser.parse(source, owner);
    }

    public static String toString(Quadruple q) {
        return QuadrupleParser.toString(q.isNegative(), q.exponent(), q.mantHi(), q.mantLo());
    }

    public static String toString(QuadrupleImmutable f) {
        return QuadrupleParser.toString(f.negative(), f.exponent(), f.mantHi(), f.mantLo());
    }

    public static String toString(boolean negative, int exponent, long mantHi, long mantLo) {
        if (exponent == -1) {
            return (mantHi | mantLo) != 0L ? "NaN" : (negative ? "-Infinity" : "Infinity");
        }
        if (((long)exponent | mantHi | mantLo) == 0L) {
            return negative ? "-0.0" : "0.0";
        }
        int exp2 = exponent - Integer.MAX_VALUE;
        long[] mant10 = BUFFER_4x64_A;
        mant10 = exponent == 0 ? QuadrupleParser.multMantByMinNormal(mant10, mantHi, mantLo) : QuadrupleParser.multMantByPowerOfTwo(QuadrupleParser.powerOfTwo(exp2), mant10, exponent, mantHi, mantLo);
        StringBuilder mantStr = QuadrupleParser.decimalMantToString(mant10);
        int exp10 = (int)mant10[0] - 1;
        mantStr.insert(1, '.');
        mantStr.append("e").append(String.format("%+03d", exp10));
        if (negative) {
            mantStr.insert(0, '-');
        }
        return mantStr.toString();
    }

    private static StringBuilder decimalMantToString(long[] qdNumber) {
        long[] multBuffer = BUFFER_6x32_A;
        StringBuilder sb = QuadrupleParser.convertMantToString(qdNumber, multBuffer);
        if ((multBuffer[0] & 0x80000000L) != 0L && QuadrupleParser.addCarry(sb) == 1) {
            qdNumber[0] = qdNumber[0] + 1L;
        }
        if (sb.length() < 40) {
            sb.append(ZEROS, 0, 40 - sb.length());
        }
        return sb;
    }

    private static int addCarry(StringBuilder sb) {
        for (int i = sb.length() - 1; i >= 0; --i) {
            char c = sb.charAt(i);
            if (c != '9') {
                sb.setCharAt(i, (char)(c + '\u0001'));
                return 0;
            }
            sb.setCharAt(i, '0');
        }
        sb.insert(0, '1');
        sb.deleteCharAt(sb.length() - 1);
        return 1;
    }

    private static StringBuilder convertMantToString(long[] qdNumber, long[] multBuffer) {
        StringBuilder sb = new StringBuilder(40);
        QuadrupleParser.unpack_3x64_to_6x32(qdNumber, multBuffer);
        int charCount = 0;
        do {
            QuadrupleParser.multBuffBy10(multBuffer);
            sb.append(Character.forDigit((int)(multBuffer[0] >>> 32), 10));
        } while (++charCount < 40 && !QuadrupleParser.isEmpty(multBuffer));
        return sb;
    }

    private static long[] multMantByMinNormal(long[] product_4x64, long mantHi, long mantLo) {
        long[] factor_6x32 = BUFFER_6x32_A;
        QuadrupleParser.unpack_3x64_to_6x32(MIN_NORMAL_QUASIDEC, factor_6x32);
        long decimalExpOfPow2 = MIN_NORMAL_QUASIDEC[0];
        long[] buffer_10x32 = BUFFER_10x32_A;
        Arrays.fill(buffer_10x32, 0L);
        return QuadrupleParser.multMantBy192bits(factor_6x32, decimalExpOfPow2, product_4x64, buffer_10x32, 0, mantHi, mantLo);
    }

    private static long[] multMantByPowerOfTwo(long[] pow2, long[] product_4x64, int exponent, long mantHi, long mantLo) {
        long[] factor_6x32 = BUFFER_6x32_A;
        QuadrupleParser.unpack_3x64_to_6x32(pow2, factor_6x32);
        long decimalExpOfPow2 = pow2[0];
        long[] buffer_10x32 = BUFFER_10x32_A;
        Arrays.fill(buffer_10x32, 0L);
        System.arraycopy(factor_6x32, 0, buffer_10x32, 0, 6);
        return QuadrupleParser.multMantBy192bits(factor_6x32, decimalExpOfPow2, product_4x64, buffer_10x32, exponent, mantHi, mantLo);
    }

    private static long[] multMantBy192bits(long[] factor_6x32, long decimalExpOfPow2, long[] product_4x64, long[] buffer_10x32, int exponent, long mantHi, long mantLo) {
        int i;
        QuadrupleParser.unpackQuadToBuff(mantHi, mantLo);
        for (i = 5; i >= 0; --i) {
            for (int j = 3; j >= 0; --j) {
                long product = factor_6x32[i] * BUFFER_4x32_A[j];
                int n = j + i + 1;
                buffer_10x32[n] = buffer_10x32[n] + (product & 0xFFFFFFFFL);
                int n2 = j + i;
                buffer_10x32[n2] = buffer_10x32[n2] + (product >>> 32);
            }
        }
        i = 9;
        while (i > 0) {
            int n = i - 1;
            buffer_10x32[n] = buffer_10x32[n] + (buffer_10x32[i] >>> 32);
            int n3 = i--;
            buffer_10x32[n3] = buffer_10x32[n3] & 0xFFFFFFFFL;
        }
        int expCorrection = exponent == 0 ? QuadrupleParser.correctPossibleUnderflow(buffer_10x32) : QuadrupleParser.correctPossibleOverflow(buffer_10x32);
        QuadrupleParser.pack_10x32_to_3x64(buffer_10x32, product_4x64);
        product_4x64[0] = decimalExpOfPow2 + (long)expCorrection;
        return product_4x64;
    }

    private static int correctPossibleUnderflow(long[] buffer_10x32) {
        int expCorr = 0;
        while (QuadrupleParser.isLessThanOne(buffer_10x32)) {
            QuadrupleParser.multBuffBy10(buffer_10x32);
            --expCorr;
        }
        return expCorr;
    }

    private static boolean isLessThanOne(long[] buffer) {
        if (buffer[0] < 0x19999999L) {
            return true;
        }
        if (buffer[0] > 0x19999999L) {
            return false;
        }
        for (int i = 1; i < buffer.length; ++i) {
            if (buffer[i] < 0x99999999L) {
                return true;
            }
            if (buffer[i] <= 0x99999999L) continue;
            return false;
        }
        return false;
    }

    private static int correctPossibleOverflow(long[] buffer_10x32) {
        int expCorr = 0;
        if ((buffer_10x32[0] & 0xFFFFFFFF00000000L) != 0L) {
            QuadrupleParser.divBuffBy10(buffer_10x32);
            expCorr = 1;
        }
        return expCorr;
    }

    private static void unpackQuadToBuff(long mantHi, long mantLo) {
        QuadrupleParser.BUFFER_4x32_A[0] = mantHi >>> 32;
        QuadrupleParser.BUFFER_4x32_A[1] = mantHi & 0xFFFFFFFFL;
        QuadrupleParser.BUFFER_4x32_A[2] = mantLo >>> 32;
        QuadrupleParser.BUFFER_4x32_A[3] = mantLo & 0xFFFFFFFFL;
    }

    private static void multBuffBy10(long[] buffer) {
        int maxIdx = buffer.length - 1;
        buffer[0] = buffer[0] & 0xFFFFFFFFL;
        int n = maxIdx;
        buffer[n] = buffer[n] * 10L;
        for (int i = maxIdx - 1; i >= 0; --i) {
            buffer[i] = buffer[i] * 10L + (buffer[i + 1] >>> 32);
            int n2 = i + 1;
            buffer[n2] = buffer[n2] & 0xFFFFFFFFL;
        }
    }

    private static void divBuffBy10(long[] buffer) {
        int maxIdx = buffer.length - 1;
        for (int i = 0; i <= maxIdx; ++i) {
            long r = Long.remainderUnsigned(buffer[i], 10L);
            buffer[i] = Long.divideUnsigned(buffer[i], 10L);
            if (i >= maxIdx) continue;
            int n = i + 1;
            buffer[n] = buffer[n] + (r << 32);
        }
    }

    private static long[] powerOfTwo(long exp) {
        if (exp == 0L) {
            return POS_POWERS_OF_2[0];
        }
        long[][] powers = POS_POWERS_OF_2;
        if (exp < 0L) {
            exp = -exp;
            powers = NEG_POWERS_OF_2;
        }
        long currPowOf2 = 0x80000000L;
        int idx = powers.length - 1;
        long[] power = null;
        while (exp > 0L) {
            if (exp >= currPowOf2) {
                power = power == null ? powers[idx] : QuadrupleParser.multPacked3x64_AndAdjustExponent(power, powers[idx]);
                exp -= currPowOf2;
            }
            --idx;
            currPowOf2 >>>= 1;
        }
        return power;
    }

    private static void pack_10x32_to_3x64(long[] unpackedQDMant, long[] packedQDValue) {
        packedQDValue[1] = (unpackedQDMant[0] << 32) + unpackedQDMant[1];
        packedQDValue[2] = (unpackedQDMant[2] << 32) + unpackedQDMant[3];
        packedQDValue[3] = (unpackedQDMant[4] << 32) + unpackedQDMant[5];
    }

    private static void pack_12x32_to_3x64(long[] result) {
        result[1] = (BUFFER_12x32[0] << 32) + BUFFER_12x32[1];
        result[2] = (BUFFER_12x32[2] << 32) + BUFFER_12x32[3];
        result[3] = (BUFFER_12x32[4] << 32) + BUFFER_12x32[5];
    }

    private static void unpack_3x64_to_6x32(long[] qd192, long[] buff_6x32) {
        buff_6x32[0] = qd192[1] >>> 32;
        buff_6x32[1] = qd192[1] & 0xFFFFFFFFL;
        buff_6x32[2] = qd192[2] >>> 32;
        buff_6x32[3] = qd192[2] & 0xFFFFFFFFL;
        buff_6x32[4] = qd192[3] >>> 32;
        buff_6x32[5] = qd192[3] & 0xFFFFFFFFL;
    }

    private static long[] multPacked3x64_AndAdjustExponent(long[] factor1, long[] factor2) {
        QuadrupleParser.multPacked3x64_simply(factor1, factor2);
        int expCorr = QuadrupleParser.correctPossibleUnderflow(BUFFER_12x32);
        long[] result = BUFFER_4x64_B;
        QuadrupleParser.pack_12x32_to_3x64(result);
        result[0] = factor1[0] + factor2[0] + (long)expCorr;
        return result;
    }

    private static void multPacked3x64_simply(long[] factor1, long[] factor2) {
        int i;
        Arrays.fill(BUFFER_12x32, 0L);
        QuadrupleParser.unpack_3x64_to_6x32(factor1, BUFFER_6x32_A);
        QuadrupleParser.unpack_3x64_to_6x32(factor2, BUFFER_6x32_B);
        for (i = 5; i >= 0; --i) {
            for (int j = 5; j >= 0; --j) {
                long part = BUFFER_6x32_A[i] * BUFFER_6x32_B[j];
                int n = j + i + 1;
                BUFFER_12x32[n] = BUFFER_12x32[n] + (part & 0xFFFFFFFFL);
                int n2 = j + i;
                BUFFER_12x32[n2] = BUFFER_12x32[n2] + (part >>> 32);
            }
        }
        i = 11;
        while (i > 0) {
            int n = i - 1;
            BUFFER_12x32[n] = BUFFER_12x32[n] + (BUFFER_12x32[i] >>> 32);
            int n3 = i--;
            BUFFER_12x32[n3] = BUFFER_12x32[n3] & 0xFFFFFFFFL;
        }
    }

    private static boolean isEmpty(long[] buffer) {
        for (long l : buffer) {
            if (l == 0L) continue;
            return false;
        }
        return true;
    }

    private static class NumberParser {
        private static final Pattern LEADING_ZEROES_PTRN = Pattern.compile("(^0+)(\\d*)");
        private static final int MAX_MANTISSA_LENGTH = 59;
        static Quadruple owner;
        private static final Map<String, Quadruple> QUADRUPLE_CONSTANTS;
        static final NumberParts PARTS;
        private static final double TWO_POW_63_DIV_10 = 9.223372036854776E17;

        private NumberParser() {
        }

        public static Quadruple parse(String source, Quadruple owner) {
            Quadruple qConst = QUADRUPLE_CONSTANTS.get(source = source.trim().toLowerCase(Locale.ROOT));
            if (qConst != null) {
                return owner.assign(qConst);
            }
            source = source.replaceAll("_", "");
            NumberParser.owner = owner;
            NumberParser.buildQuadruple(PARTS.decompose(source));
            return owner;
        }

        private static void buildQuadruple(NumberParts parts) {
            owner.setNegative(parts.negative);
            long exp10 = parts.exp10;
            int exp10Corr = NumberParser.parseMantissa(parts);
            if (exp10Corr == 0 && QuadrupleParser.isEmpty(BUFFER_6x32_C)) {
                owner.assignZero(false);
                return;
            }
            if (NumberParser.exceedsAcceptableExponentRange(exp10 += (long)exp10Corr)) {
                return;
            }
            long exp2 = NumberParser.findBinaryExponent(exp10);
            NumberParser.findBinaryMantissa((int)exp10, exp2);
        }

        private static int parseMantissa(NumberParts parts) {
            if (parts.mantStr.isEmpty()) {
                Arrays.fill(BUFFER_6x32_C, 0L);
                return 0;
            }
            return NumberParser.parseMantString(parts.mantStr) + parts.expCorrection;
        }

        private static int parseMantString(String mantStr) {
            int expCorr = 0;
            StringBuilder sb = new StringBuilder(mantStr);
            if (sb.length() > 59) {
                boolean carry = sb.charAt(59) >= '5';
                sb.delete(59, sb.length());
                if (carry) {
                    expCorr += QuadrupleParser.addCarry(sb);
                }
            }
            NumberParser.findNumericMantValue(sb);
            return expCorr;
        }

        private static void findNumericMantValue(StringBuilder sb) {
            Arrays.fill(BUFFER_6x32_C, 0L);
            for (int i = sb.length() - 1; i >= 0; --i) {
                BUFFER_6x32_C[0] = BUFFER_6x32_C[0] | (long)Character.digit(sb.charAt(i), 10) << 32;
                QuadrupleParser.divBuffBy10(BUFFER_6x32_C);
            }
        }

        private static boolean exceedsAcceptableExponentRange(long exp10) {
            if (exp10 < -646457032L) {
                owner.assignZero(false);
                return true;
            }
            if (exp10 > 646456993L) {
                owner.assignInfinity(false);
                return true;
            }
            return false;
        }

        private static long findBinaryExponent(long exp10) {
            long mant10 = BUFFER_6x32_C[0] << 31 | BUFFER_6x32_C[1] >>> 1;
            double mant10d = (double)mant10 / 9.223372036854776E17;
            return (long)Math.floor((double)exp10 * LOG2_10 + NumberParser.log2(mant10d));
        }

        private static double log2(double x) {
            return LOG2_E * Math.log(x);
        }

        private static void findBinaryMantissa(int exp10, long exp2) {
            long[] powerOf2 = QuadrupleParser.powerOfTwo(-exp2);
            long[] product = BUFFER_12x32;
            NumberParser.multUnpacked6x32bydPacked(powerOf2, product);
            QuadrupleParser.multBuffBy10(product);
            if (powerOf2[0] != (long)(-exp10)) {
                QuadrupleParser.multBuffBy10(product);
            }
            exp2 += (long)NumberParser.normalizeMant(product);
            if ((exp2 += Integer.MAX_VALUE) <= 0L) {
                if (product[4] == 0xFFFFFFFFL && (product[5] & 0xFFFFFFE0L) == 0xFFFFFFE0L) {
                    exp2 += (long)NumberParser.roundUp(product);
                }
                NumberParser.fillOwnerMantissaFrom(product);
                if (exp2 <= 0L) {
                    exp2 = owner.makeSubnormal(exp2);
                }
            } else {
                exp2 += (long)NumberParser.roundUp(product);
                NumberParser.fillOwnerMantissaFrom(product);
            }
            owner.setExponent((int)exp2);
            if (owner.exponent() == -1) {
                owner.setMantHi(0L);
                owner.setMantLo(0L);
            }
        }

        private static void multUnpacked6x32bydPacked(long[] factor2, long[] product) {
            int maxFactIdx;
            int i;
            Arrays.fill(product, 0L);
            QuadrupleParser.unpack_3x64_to_6x32(factor2, BUFFER_6x32_B);
            factor2 = BUFFER_6x32_B;
            for (i = maxFactIdx = BUFFER_6x32_C.length - 1; i >= 0; --i) {
                for (int j = maxFactIdx; j >= 0; --j) {
                    long part = BUFFER_6x32_C[i] * factor2[j];
                    int n = j + i + 1;
                    product[n] = product[n] + (part & 0xFFFFFFFFL);
                    int n2 = j + i;
                    product[n2] = product[n2] + (part >>> 32);
                }
            }
            i = 11;
            while (i > 0) {
                int n = i - 1;
                product[n] = product[n] + (product[i] >>> 32);
                int n3 = i--;
                product[n3] = product[n3] & 0xFFFFFFFFL;
            }
        }

        private static void fillOwnerMantissaFrom(long[] mantissa) {
            owner.setMantHi((mantissa[0] << 32) + mantissa[1]);
            owner.setMantLo((mantissa[2] << 32) + mantissa[3]);
        }

        private static int normalizeMant(long[] mantissa) {
            int expCorr = 31 - Long.numberOfLeadingZeros(mantissa[0]);
            if (expCorr != 0) {
                NumberParser.divBuffByPower2(mantissa, expCorr);
            }
            return expCorr;
        }

        private static int roundUp(long[] mantissa) {
            NumberParser.addToBuff(mantissa, 5, 100L);
            NumberParser.addToBuff(mantissa, 4, 0x80000000L);
            if ((mantissa[0] & 0xFFFFFFFE00000000L) != 0L) {
                NumberParser.divBuffByPower2(mantissa, 1);
                return 1;
            }
            return 0;
        }

        private static void addToBuff(long[] buff, int idx, long summand) {
            int maxIdx;
            int n = maxIdx = idx;
            buff[n] = buff[n] + summand;
            for (int i = maxIdx; i > 0 && (buff[i] & 0xFFFFFFFF00000000L) != 0L; --i) {
                int n2 = i;
                buff[n2] = buff[n2] & 0xFFFFFFFFL;
                int n3 = i - 1;
                buff[n3] = buff[n3] + 1L;
            }
        }

        private static void divBuffByPower2(long[] buffer, int exp2) {
            int maxIdx = buffer.length - 1;
            int backShift = 32 - Math.abs(exp2);
            if (exp2 > 0) {
                for (int i = maxIdx; i > 0; --i) {
                    buffer[i] = buffer[i] >>> exp2 | buffer[i - 1] << backShift & 0xFFFFFFFFL;
                }
                buffer[0] = buffer[0] >>> exp2;
            } else if (exp2 < 0) {
                exp2 = -exp2;
                buffer[0] = buffer[0] << exp2 | buffer[1] >> backShift;
                for (int i = 1; i < maxIdx; ++i) {
                    buffer[i] = buffer[i] << exp2 & 0xFFFFFFFFL | buffer[i + 1] >> backShift;
                }
                buffer[maxIdx] = buffer[maxIdx] << exp2 & 0xFFFFFFFFL;
            }
        }

        static {
            QUADRUPLE_CONSTANTS = new HashMap<String, Quadruple>(){
                {
                    this.put("quadruple.min_value", MIN_VALUE);
                    this.put("min_value", MIN_VALUE);
                    this.put("quadruple.max_value", MAX_VALUE);
                    this.put("max_value", MAX_VALUE);
                    this.put("quadruple.min_normal", MIN_NORMAL);
                    this.put("min_normal", MIN_NORMAL);
                    this.put("quadruple.nan", NaN);
                    this.put("nan", NaN);
                    this.put("quadruple.negative_infinity", NEGATIVE_INFINITY);
                    this.put("negative_infinity", NEGATIVE_INFINITY);
                    this.put("-infinity", NEGATIVE_INFINITY);
                    this.put("quadruple.positive_infinity", POSITIVE_INFINITY);
                    this.put("positive_infinity", POSITIVE_INFINITY);
                    this.put("infinity", POSITIVE_INFINITY);
                    this.put("+infinity", POSITIVE_INFINITY);
                }
            };
            PARTS = new NumberParts();
        }

        private static class NumberParts {
            private long exp10;
            private boolean negative;
            private String mantStr;
            private int expCorrection;
            private String sourceStr;
            private static final Pattern EXP_STR_PTRN = Pattern.compile("e([+\\-])?(\\d+)");

            private NumberParts() {
            }

            private NumberParts decompose(String source) {
                this.sourceStr = source;
                FPStringRegex.match(source);
                this.negative = FPStringRegex.negative();
                this.exp10 = NumberParts.extractExp10(FPStringRegex.expString());
                this.expCorrection = this.buildMantString(FPStringRegex.intPartString(), FPStringRegex.fractPartString());
                return this;
            }

            private int buildMantString(String intPartString, String fractPartString) {
                int expCorrection = this.uniteMantString(intPartString, fractPartString);
                Matcher m2 = LEADING_ZEROES_PTRN.matcher(this.mantStr);
                if (m2.find()) {
                    this.mantStr = m2.group(2);
                    expCorrection -= m2.group(1).length();
                }
                this.mantStr = this.mantStr.replaceFirst("0*$", "");
                return expCorrection;
            }

            private int uniteMantString(String intPartString, String fractPartString) {
                if (intPartString == null) {
                    intPartString = fractPartString;
                    fractPartString = "";
                }
                if ((intPartString = intPartString.replaceFirst("\\.$", "")).isEmpty() && fractPartString.isEmpty()) {
                    throw new NumberFormatException("Invalid number: " + this.sourceStr);
                }
                this.mantStr = intPartString + fractPartString;
                return intPartString.length() - 1;
            }

            private static long extractExp10(String expString) {
                Matcher m;
                long exp10 = 0L;
                if (expString != null && (m = EXP_STR_PTRN.matcher(expString)).find()) {
                    exp10 = NumberParts.parseLong(m.group(2));
                    if ("-".equals(m.group(1))) {
                        exp10 = -exp10;
                    }
                }
                return exp10;
            }

            private static long parseLong(String longString) {
                if (longString.length() > 18) {
                    return Long.MAX_VALUE;
                }
                return Long.parseLong(longString);
            }

            private static class FPStringRegex {
                private static final Pattern FP_STRING_PTRN = Pattern.compile("^([+\\-])?((\\d*\\.)?(\\d*))(e([+\\-])?0*(\\d+))?$", 2);
                private static Matcher m;

                private FPStringRegex() {
                }

                private static void match(String source) {
                    m = FP_STRING_PTRN.matcher(source);
                    if (!m.find()) {
                        throw new NumberFormatException("Invalid number: '" + source + "'");
                    }
                }

                private static boolean negative() {
                    return "-".equals(m.group(1));
                }

                private static String expString() {
                    return m.group(5);
                }

                private static String intPartString() {
                    return m.group(3);
                }

                private static String fractPartString() {
                    return m.group(4);
                }
            }
        }
    }
}

